/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman;

import Preferences.Preferences;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Help.Url;
import UI_Script.Rib.RibHelp;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.Ris21RibStrings;
import Utilities.FileUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class RenderInfo {
    public static boolean _setActiveRender = false;
    public static boolean INSERT_TEXTURE_PATH;
    public static final String PIXAR = "pixar";
    public static final String BMRT = "bmrt";
    public static final String AIR = "air";
    public static final String DELIGHT = "3delight";
    public static final String PIXIE = "pixie";
    public static final String AQSIS = "aqsis";
    public static final String CUSTOM = "";
    public static final String TMP_RIB = "tmp.rib";
    public static String PRMAN;
    public static String SHADER;
    public static String RENDRIB;
    public static String SLC;
    public static String AIR_RENDER;
    public static String SHADED;
    public static String SLOINFO;
    public static String SLCTELL;
    public static String SLBTELL;
    public static String RENDERDL;
    public static String SHADERDL;
    public static String SHADERINFO;
    public static String PIXIE_RNDR;
    public static String PIXIE_SDRC;
    public static String PIXIE_SHADERINFO;
    public static String PIXIE_TEXMAKE;
    public static String PIXIE_PRECOMP;
    public static String AQSIS_RENDER;
    public static String AQSIS_SHADER;
    public static String AQSIS_SLTELL;
    public static String AQSIS_TEX;
    private static RenderInfo prmanRender;
    private static RenderInfo bmrtRender;
    private static RenderInfo airRender;
    private static RenderInfo delightRender;
    private static RenderInfo pixieRender;
    private static RenderInfo aqsisRender;
    private static RenderInfo customRender;
    public static RenderInfo activeRender;
    private String name = "pixar";
    private String toRenderer = PRMAN;
    private String toCompiler = SHADER;
    private String toShaderInfo = SLOINFO;
    private String binPath = "";
    private String shaderPath = "";
    private String rmsShaderPath = "";
    private String texturePath = "";
    private String framesPath = "";
    private String userShaderPath = "";
    private String userTexturePath = "";
    private String userPointcloudPath = "";
    private String userBrickmapPath = "";
    private String userPhotonmapPath = "";
    private String shaderExtension = "";
    private Vector<String> defaultCompileFlags = new Vector();
    private Vector<String> defaultRenderFlags = new Vector();
    private Vector<String> userCompileFlags = new Vector();
    private boolean userCompileFlagsEnabled = true;
    private Vector<String> userRenderFlags = new Vector();
    private boolean userRenderFlagsEnabled = true;
    private static boolean deferRender;
    public static boolean generateSlimAppearance;
    public static boolean doCopySloShader;
    public static String sloShaderCopyPath;
    public static boolean addRmsShadersToMenu;
    public static boolean autoReloadShaders;
    public static boolean autoSetRenderer;
    public static boolean autoSetVendorRibOption;
    public static final int PLATFORM = 1;
    public static final int NAME = 2;
    public static final int DO_RENDER = 3;
    public static final int DO_COMPILE = 4;
    public static final int DO_SLOINFO = 5;
    public static final int SYS_BIN_PATH = 6;
    public static final int SYS_SHADER_PATH = 7;
    public static final int TEXTURE_PATH = 8;
    public static final int COMPILER_FLAGS = 9;
    public static final int RENDER_FLAGS = 10;
    public static final int SHADER_EXTENSION = 11;
    public static final int USER_FRAMES_PATH = 12;
    public static final int USER_SHADER_PATH = 13;
    public static final int USER_TEXTURES_PATH = 14;
    public static final int SYS_DOCS_SHADERS_PATH = 15;
    public static final int SYS_DOCS_SHADERS_EXT = 16;
    public static final int SYS_DOCS_SHADERS_TOC = 17;
    public static final int DATATYPE_DECLARATION = 18;
    public static final int RMS_SHADER_PATH = 19;
    public static final int USER_ARCHIVES_PATH = 20;
    public static final int USER_COMPILE_FLAGS_ENABLED = 21;
    public static final int USER_RENDER_FLAGS_ENABLED = 22;
    public static final int USER_POINTCLOUD_PATH = 23;
    public static final int USER_BRICKMAP_PATH = 24;
    public static final int USER_PHOTONMAP_PATH = 25;
    public static final int USER_PLUGINS_PATH = 26;
    public static final int USER_OSL_SHADERS = 27;
    public static final String IGNORE_DATATYPE = "omit";
    public static final String INLINE_DATATYPE = "inline";
    public static final String DECLARE_DATATYPE = "declare";
    public static final String SLIM_STYLE_RMS = "RMS";
    public static final String SLIM_STYLE_RAT = "RAT";
    private static String dataTypeStyle;
    private static String slimAppearanceStyle;
    public static TextureData textureData;
    private static Vector<RenderInfoListener> listOfListeners;
    private static Hashtable tableOfSystemShaders;
    private static boolean isSystemShaderWarning;
    private static boolean inited;

    public static boolean isSystemShader(String name) {
        return RenderInfo.isSystemShader(name, true);
    }

    public static boolean isSystemShader(String name, boolean showWarning) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (tableOfSystemShaders.size() == 0 && showWarning && !isSystemShaderWarning) {
            isSystemShaderWarning = true;
            JOptionPane.showMessageDialog(KDesktop.desktopPane, "The shaders for the rendering system \"" + RenderInfo.activeRender.name + "\"\nhave not been read by Rman Tools. The shaders\ncan be read by choosing,\n       Rman Tools->Shaders->Reload Shaders\nHowever, not all rendering systems provide html\ndocumentation about their system shaders!\n\n", "Unable to Lookup Documentation", 1);
            return false;
        }
        return tableOfSystemShaders.containsKey(name);
    }

    public static void init() {
        prmanRender = new RenderInfo(PIXAR, PRMAN, SHADER, SLOINFO);
        bmrtRender = new RenderInfo(BMRT, RENDRIB, SLC, SLCTELL);
        airRender = new RenderInfo(AIR, AIR_RENDER, SHADED, SLBTELL);
        pixieRender = new RenderInfo(PIXIE, PIXIE_RNDR, PIXIE_SDRC, PIXIE_SHADERINFO);
        delightRender = new RenderInfo(DELIGHT, Preferences.get(Preferences.EXE_3DELIGHT_RENDER), Preferences.get(Preferences.EXE_3DELIGHT_COMPILE), Preferences.get(Preferences.EXE_3DELIGHT_SHADER_INFO));
        aqsisRender = new RenderInfo(AQSIS, Preferences.get(Preferences.EXE_AQSIS_RENDER), Preferences.get(Preferences.EXE_AQSIS_COMPILE), Preferences.get(Preferences.EXE_AQSIS_SHADER_INFO));
        customRender = Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME).length() > 0 ? new RenderInfo(Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME), Preferences.get(Preferences.EXE_RENDERER_CUSTOM_RENDER), Preferences.get(Preferences.EXE_RENDERER_CUSTOM_COMPILE), Preferences.get(Preferences.EXE_RENDERER_CUSTOM_SHADER_INFO)) : new RenderInfo("undefined", "undefined", "undefined", "undefined");
        RenderInfo.setActiveRender(Preferences.get(Preferences.RENDERER_DEFAULT));
    }

    public static RenderInfo getActiveRender() {
        return activeRender;
    }

    public static void setActiveRender(String name) {
        if (name == null || name.length() == 0) {
            activeRender = prmanRender;
        } else if (name.equalsIgnoreCase(PIXAR)) {
            activeRender = prmanRender;
        } else if (name.equalsIgnoreCase(BMRT)) {
            activeRender = bmrtRender;
        } else if (name.equalsIgnoreCase(AIR)) {
            activeRender = airRender;
        } else if (name.equalsIgnoreCase(DELIGHT)) {
            activeRender = delightRender;
        } else if (name.equalsIgnoreCase(PIXIE)) {
            activeRender = pixieRender;
        } else if (name.equalsIgnoreCase(AQSIS)) {
            activeRender = aqsisRender;
        } else if (name.equalsIgnoreCase(Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME))) {
            activeRender = customRender;
            Cutter.setLog("    Info:RenderInfo.setActiveRender() using a custom renderer called " + name);
        } else {
            activeRender = prmanRender;
            Cutter.setLog("    Error: RenderInfo.setActiveRender() cannot match a renderer called " + name + ".\nUsing prman as the default renderer");
        }
        RenderInfo.notifyListeners(activeRender);
        RibHelp.initPaths();
        if (_setActiveRender) {
            Cutter.setLog("RenderInfo.setActiveRender() = " + name);
            Cutter.setLog("    - renderer = " + RenderInfo.activeRender.toRenderer);
            Cutter.setLog("    - compile = " + RenderInfo.activeRender.toCompiler);
            Cutter.setLog("    - shader info = " + RenderInfo.activeRender.toShaderInfo);
        }
    }

    private RenderInfo(String name, String toRenderer, String toCompiler, String toShaderInfo) {
        if (textureData == null) {
            textureData = new TextureData();
        }
        this.name = name;
        this.toRenderer = toRenderer;
        this.toCompiler = toCompiler;
        this.toShaderInfo = toShaderInfo;
        RenderInfo.setPaths(this);
        RenderInfo.setFlags(this);
    }

    private static void setFlags(RenderInfo ri2) {
        if (ri2 == null) {
            return;
        }
        String userCompile = CUSTOM;
        String userRender = CUSTOM;
        String userCompileEnabled = "true";
        String userRenderEnabled = "true";
        if (ri2.name.equalsIgnoreCase(PIXAR)) {
            userCompile = Preferences.get(Preferences.PIXAR_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.PIXAR_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.PIXAR_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.PIXAR_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        } else if (ri2.name.equalsIgnoreCase(BMRT)) {
            userCompile = Preferences.get(Preferences.BMRT_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.BMRT_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.BMRT_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.BMRT_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        } else if (ri2.name.equalsIgnoreCase(DELIGHT)) {
            userCompile = Preferences.get(Preferences.DELIGHT_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.DELIGHT_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.DELIGHT_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.DELIGHT_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-d");
        } else if (ri2.name.equalsIgnoreCase(AIR)) {
            userCompile = Preferences.get(Preferences.AIR_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.AIR_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.AIR_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.AIR_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        } else if (ri2.name.equalsIgnoreCase(PIXIE)) {
            userCompile = Preferences.get(Preferences.PIXIE_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.PIXIE_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.PIXIE_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.PIXIE_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        } else if (ri2.name.equalsIgnoreCase(AQSIS)) {
            userCompile = Preferences.get(Preferences.AQSIS_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.AQSIS_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.AQSIS_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.AQSIS_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        } else if (ri2.name.equalsIgnoreCase(Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME))) {
            userCompile = Preferences.get(Preferences.RENDERMAN_CUSTOM_COMPILER_FLAGS_USER);
            userRender = Preferences.get(Preferences.RENDERMAN_CUSTOM_RENDER_FLAGS_USER);
            userCompileEnabled = Preferences.get(Preferences.RENDERMAN_CUSTOM_COMPILER_FLAGS_USER_ENABLED);
            userRenderEnabled = Preferences.get(Preferences.RENDERMAN_CUSTOM_RENDER_FLAGS_USER_ENABLED);
            ri2.defaultCompileFlags.addElement("-o");
        }
        ri2.userCompileFlags = VectorUtils.spacedStringToVector(userCompile);
        ri2.userRenderFlags = VectorUtils.spacedStringToVector(userRender);
        ri2.userCompileFlagsEnabled = userCompileEnabled.equals("true");
        ri2.userRenderFlagsEnabled = userRenderEnabled.equals("true");
    }

    public static String getRendererDataTypeStyle() {
        dataTypeStyle = Preferences.get(Preferences.RENDERER_SHADER_DATATYPE);
        return dataTypeStyle;
    }

    public static void setDataTypeStyle(String type) {
        dataTypeStyle = !type.equals(IGNORE_DATATYPE) && !type.equals(INLINE_DATATYPE) && !type.equals(DECLARE_DATATYPE) ? INLINE_DATATYPE : type;
    }

    public static String getDataTypeStyle() {
        return dataTypeStyle;
    }

    public static void setSlimAppearanceStyle(String style) {
        slimAppearanceStyle = style;
    }

    public static String getSlimAppearanceStyle() {
        return slimAppearanceStyle;
    }

    public static Vector<String> getAllFlags(int field) {
        return RenderInfo.getAllFlags(activeRender, field);
    }

    public static Vector<String> getAllFlags(RenderInfo ri2, int field) {
        Vector<String> def = RenderInfo.getDefaultFlags(ri2, field);
        Vector<String> usr = RenderInfo.getUserFlags(ri2, field);
        return VectorUtils.combine(def, usr);
    }

    public static Vector<String> getDefaultFlags(int field) {
        return RenderInfo.getDefaultFlags(activeRender, field);
    }

    public static Vector<String> getDefaultFlags(RenderInfo ri2, int field) {
        Vector<String> vector = null;
        switch (field) {
            case 9: {
                vector = VectorUtils.copyStrings(ri2.defaultCompileFlags);
                break;
            }
            case 10: {
                vector = VectorUtils.copyStrings(ri2.defaultRenderFlags);
            }
        }
        return VectorUtils.uniquefy(vector);
    }

    public static Vector<String> getUserFlags(int field) {
        return RenderInfo.getUserFlags(activeRender, field);
    }

    public static Vector<String> getUserFlags(RenderInfo ri2, int field) {
        Vector<String> vector = new Vector<String>();
        switch (field) {
            case 9: {
                if (!ri2.userCompileFlagsEnabled) break;
                vector = VectorUtils.copyStrings(ri2.userCompileFlags);
                break;
            }
            case 10: {
                if (!ri2.userRenderFlagsEnabled) break;
                vector = VectorUtils.copyStrings(ri2.userRenderFlags);
            }
        }
        String temp = VectorUtils.vectorToSpacedString(vector);
        String[] flags = VectorUtils.consolidatAsFlags(temp);
        return VectorUtils.toVector(flags);
    }

    public static void setUserFlags(int field, String[] flags, boolean enabled) {
        switch (field) {
            case 9: {
                RenderInfo.activeRender.userCompileFlags.clear();
                RenderInfo.activeRender.userCompileFlagsEnabled = enabled;
                break;
            }
            case 10: {
                RenderInfo.activeRender.userRenderFlags.clear();
                RenderInfo.activeRender.userRenderFlagsEnabled = enabled;
            }
        }
        if (flags != null && flags.length > 0) {
            for (int n = 0; n < flags.length; ++n) {
                RenderInfo.addUserFlag(field, flags[n].trim());
            }
        }
        RenderInfo.saveFlagsToPrefs(activeRender, field, enabled);
    }

    private static void addUserFlag(int field, String flag) {
        if (activeRender == null) {
            RenderInfo.init();
        }
        boolean doAdd = true;
        switch (field) {
            case 9: {
                for (int n = 0; n < RenderInfo.activeRender.userCompileFlags.size(); ++n) {
                    String str = RenderInfo.activeRender.userCompileFlags.elementAt(n);
                    if (!str.trim().equalsIgnoreCase(flag.trim())) continue;
                    doAdd = false;
                    break;
                }
                if (!doAdd) break;
                Cutter.setLog("    Info:RenderInfo.addUserFlag(COMPILER_FLAGS) - adding flag \"" + flag + "\"");
                RenderInfo.activeRender.userCompileFlags.addElement(" " + flag.trim() + " ");
                break;
            }
            case 10: {
                for (int n = 0; n < RenderInfo.activeRender.userRenderFlags.size(); ++n) {
                    String str = RenderInfo.activeRender.userRenderFlags.elementAt(n);
                    if (!str.trim().equalsIgnoreCase(flag.trim())) continue;
                    doAdd = false;
                    break;
                }
                if (!doAdd) break;
                Cutter.setLog("    Info:RenderInfo.addUserFlag(RENDER_FLAGS) - adding flag \"" + flag + "\"");
                RenderInfo.activeRender.userRenderFlags.addElement(" " + flag.trim() + " ");
            }
        }
    }

    private static RenderInfo getRIForVendor(String name) {
        if (name.equalsIgnoreCase(PIXAR)) {
            return prmanRender;
        }
        if (name.equalsIgnoreCase(BMRT)) {
            return bmrtRender;
        }
        if (name.equalsIgnoreCase(AIR)) {
            return airRender;
        }
        if (name.equalsIgnoreCase(DELIGHT)) {
            return delightRender;
        }
        if (name.equalsIgnoreCase(PIXIE)) {
            return pixieRender;
        }
        if (name.equalsIgnoreCase(AQSIS)) {
            return aqsisRender;
        }
        if (name.equalsIgnoreCase(Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME))) {
            return customRender;
        }
        return null;
    }

    public static void saveFlagsToPrefs(String vendor, int field, boolean enabled) {
        RenderInfo ri2 = RenderInfo.getRIForVendor(vendor);
        if (ri2 != null) {
            RenderInfo.saveFlagsToPrefs(ri2, field, enabled);
        }
    }

    public static void saveFlagsToPrefs(RenderInfo ri2, int field, boolean enabled) {
        Vector<String> flags = RenderInfo.getUserFlags(ri2, field);
        String str = VectorUtils.vectorToSpacedString(flags);
        String isEnabled = enabled ? "true" : "false";
        switch (field) {
            case 9: {
                if (ri2.name.equals(PIXAR)) {
                    Preferences.write(Preferences.PIXAR_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.PIXAR_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(BMRT)) {
                    Preferences.write(Preferences.BMRT_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.BMRT_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(AIR)) {
                    Preferences.write(Preferences.AIR_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.AIR_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(DELIGHT)) {
                    Preferences.write(Preferences.DELIGHT_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.DELIGHT_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(PIXIE)) {
                    Preferences.write(Preferences.PIXIE_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.PIXIE_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(AQSIS)) {
                    Preferences.write(Preferences.AQSIS_COMPILER_FLAGS_USER, str);
                    Preferences.write(Preferences.AQSIS_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (!ri2.name.equals(CUSTOM)) break;
                Preferences.write(Preferences.RENDERMAN_CUSTOM_COMPILER_FLAGS_USER, str);
                Preferences.write(Preferences.RENDERMAN_CUSTOM_COMPILER_FLAGS_USER_ENABLED, isEnabled);
                break;
            }
            case 10: {
                if (ri2.name.equals(PIXAR)) {
                    Preferences.write(Preferences.PIXAR_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.PIXAR_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(BMRT)) {
                    Preferences.write(Preferences.BMRT_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.BMRT_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(AIR)) {
                    Preferences.write(Preferences.AIR_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.AIR_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(DELIGHT)) {
                    Preferences.write(Preferences.DELIGHT_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.DELIGHT_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(PIXIE)) {
                    Preferences.write(Preferences.PIXIE_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.PIXIE_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (ri2.name.equals(AQSIS)) {
                    Preferences.write(Preferences.AQSIS_RENDER_FLAGS_USER, str);
                    Preferences.write(Preferences.AQSIS_RENDER_FLAGS_USER_ENABLED, isEnabled);
                    break;
                }
                if (!ri2.name.equals(CUSTOM)) break;
                Preferences.write(Preferences.RENDERMAN_CUSTOM_RENDER_FLAGS_USER, str);
                Preferences.write(Preferences.RENDERMAN_CUSTOM_RENDER_FLAGS_USER_ENABLED, isEnabled);
            }
        }
    }

    public static void clearAllUserFlags(int field) {
        switch (field) {
            case 9: {
                RenderInfo.activeRender.userCompileFlags.clear();
                Cutter.setLog("    Info:RenderInfo.clearAllUserFlags() - removing all user compiler flags");
                break;
            }
            case 10: {
                RenderInfo.activeRender.userRenderFlags.clear();
                Cutter.setLog("    Info:RenderInfo.clearAllUserFlags() - removing all user renderer flags");
            }
        }
    }

    private static void setPaths(RenderInfo info) {
        info.framesPath = Preferences.get(Preferences.PATH_USER_FRAMES);
        info.userShaderPath = Preferences.get(Preferences.PATH_USER_SHADERS);
        info.userTexturePath = Preferences.get(Preferences.PATH_USER_TEXTURES);
        info.userPointcloudPath = Preferences.get(Preferences.PATH_USER_PTC);
        info.userBrickmapPath = Preferences.get(Preferences.PATH_USER_BKM);
        info.userPhotonmapPath = Preferences.get(Preferences.PATH_USER_CPM);
        if (info.name.equalsIgnoreCase(PIXAR)) {
            String rpsPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
            info.binPath = new File(rpsPath, "bin").getPath();
            info.shaderPath = new File(rpsPath, "lib").getPath();
            info.shaderPath = new File(info.shaderPath, "shaders").getPath();
            info.texturePath = new File(rpsPath, "lib").getPath();
            info.texturePath = new File(info.texturePath, "textures").getPath();
            info.shaderExtension = ".slo";
            info.rmsShaderPath = Preferences.get(Preferences.PATH_PIXAR_RMS) + Url.ratShader.slo_path;
        } else if (info.name.equalsIgnoreCase(BMRT)) {
            info.binPath = Preferences.get(Preferences.PATH_BMRT_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_BMRT_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_BMRT_TEXTURES);
            info.shaderExtension = ".slc";
        } else if (info.name.equalsIgnoreCase(AIR)) {
            info.binPath = Preferences.get(Preferences.PATH_AIR_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_AIR_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_AIR_TEXTURES);
            info.shaderExtension = ".slb";
        } else if (info.name.equalsIgnoreCase(DELIGHT)) {
            info.binPath = Preferences.get(Preferences.PATH_3DELIGHT_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_3DELIGHT_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_3DELIGHT_TEXTURES);
            info.shaderExtension = ".sdl";
        } else if (info.name.equalsIgnoreCase(PIXIE)) {
            info.binPath = Preferences.get(Preferences.PATH_PIXIE_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_PIXIE_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_PIXIE_TEXTURES);
            info.shaderExtension = ".sdr";
        } else if (info.name.equalsIgnoreCase(AQSIS)) {
            info.binPath = Preferences.get(Preferences.PATH_AQSIS_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_AQSIS_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_AQSIS_TEXTURES);
            info.shaderExtension = ".slx";
        } else if (info.name.equalsIgnoreCase(Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME))) {
            info.binPath = Preferences.get(Preferences.PATH_RENDERER_CUSTOM_BIN);
            info.shaderPath = Preferences.get(Preferences.PATH_RENDERER_CUSTOM_SHADERS);
            info.texturePath = Preferences.get(Preferences.PATH_RENDERER_CUSTOM_TEXTURES);
            info.shaderExtension = Preferences.get(Preferences.EXTENSION_RENDERER_CUSTOM_SHADER);
        }
        info.binPath = FileUtils.removeTrailingSeparator(info.binPath, '\\', '/');
        info.shaderPath = FileUtils.removeTrailingSeparator(info.shaderPath, '\\', '/');
        info.texturePath = FileUtils.removeTrailingSeparator(info.texturePath, '\\', '/');
        info.binPath = FileUtils.applyFileSeparator(info.binPath);
        info.shaderPath = info.shaderPath.replace('\\', '/');
        info.texturePath = info.texturePath.replace('\\', '/');
    }

    public static String getBinPath() {
        return RenderInfo.activeRender.binPath;
    }

    public static boolean activeRendererIs(String name) {
        return name.compareTo(RenderInfo.activeRender.name) == 0;
    }

    public static boolean activeNameOfRendererIs(String cmd) {
        String str = RenderInfo.get(3);
        if (str.equals(RENDERDL)) {
            str = DELIGHT;
        }
        return str.equals(cmd);
    }

    public static String activeNameOfRenderer() {
        String str = RenderInfo.get(3);
        if (str.equals(RENDERDL)) {
            str = DELIGHT;
        }
        if (str.equals(PIXIE_RNDR)) {
            str = PIXIE;
        }
        if (str.equals(RENDRIB)) {
            str = BMRT;
        }
        if (str.equals(PRMAN)) {
            str = PIXAR;
        }
        return str;
    }

    public static String[] getNames() {
        String custom = Preferences.get(Preferences.PATH_RENDERER_CUSTOM_NAME);
        String[] out = new String[]{PIXAR, DELIGHT, PIXIE, AQSIS, AIR, BMRT, custom != null && custom.length() > 0 ? custom : "undefined"};
        return out;
    }

    public static String get(int field) {
        if (activeRender == null) {
            RenderInfo.init();
        }
        switch (field) {
            case 2: {
                return RenderInfo.activeRender.name;
            }
            case 3: {
                return RenderInfo.activeRender.toRenderer;
            }
            case 4: {
                return RenderInfo.activeRender.toCompiler;
            }
            case 5: {
                return RenderInfo.activeRender.toShaderInfo;
            }
            case 6: {
                return RenderInfo.activeRender.binPath;
            }
            case 7: {
                return RenderInfo.activeRender.shaderPath;
            }
            case 19: {
                return RenderInfo.activeRender.rmsShaderPath;
            }
            case 8: {
                return RenderInfo.activeRender.texturePath;
            }
            case 11: {
                return RenderInfo.activeRender.shaderExtension;
            }
            case 12: {
                return RenderInfo.activeRender.framesPath.trim().equals(CUSTOM) ? "./" : RenderInfo.activeRender.framesPath;
            }
            case 13: {
                return RenderInfo.activeRender.userShaderPath.trim().equals(CUSTOM) ? "./" : RenderInfo.activeRender.userShaderPath;
            }
            case 26: {
                return Preferences.get(Preferences.PATH_USER_PLUGINS).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_PLUGINS);
            }
            case 27: {
                return Preferences.get(Preferences.PATH_USER_OSL_SHADERS).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_OSL_SHADERS);
            }
            case 14: {
                return Preferences.get(Preferences.PATH_USER_TEXTURES).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_TEXTURES);
            }
            case 20: {
                return Preferences.get(Preferences.PATH_USER_ARCHIVES).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_ARCHIVES);
            }
            case 23: {
                return Preferences.get(Preferences.PATH_USER_PTC).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_PTC);
            }
            case 24: {
                return Preferences.get(Preferences.PATH_USER_BKM).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_BKM);
            }
            case 25: {
                return Preferences.get(Preferences.PATH_USER_CPM).trim().equals(CUSTOM) ? "./" : Preferences.get(Preferences.PATH_USER_CPM);
            }
            case 22: {
                return RenderInfo.activeRender.userRenderFlagsEnabled ? "true" : "false";
            }
            case 21: {
                return RenderInfo.activeRender.userCompileFlagsEnabled ? "true" : "false";
            }
            case 15: {
                if (RenderInfo.activeRender.name.equals(PIXAR)) {
                    String rpsDocsPath = RibHelp.getRPSDocsRoot();
                    if (rpsDocsPath == null) {
                        return CUSTOM;
                    }
                    if (rpsDocsPath.trim().length() == 0) {
                        return CUSTOM;
                    }
                    return Url.join(rpsDocsPath, CUSTOM);
                }
                if (RenderInfo.activeRender.name.equals(BMRT)) {
                    return Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS);
                }
                if (RenderInfo.activeRender.name.equals(AIR)) {
                    return Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS);
                }
                if (RenderInfo.activeRender.name.equals(DELIGHT)) {
                    return Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS);
                }
                if (RenderInfo.activeRender.name.equals(PIXIE)) {
                    return Preferences.get(Preferences.PATH_PIXIE_DOCS_SHADERS);
                }
                if (RenderInfo.activeRender.name.equals(AQSIS)) {
                    return Preferences.get(Preferences.PATH_AQSIS_DOCS_SHADERS);
                }
                return CUSTOM;
            }
            case 16: {
                if (RenderInfo.activeRender.name.equals(PIXAR)) {
                    return Preferences.get(Preferences.PATH_PIXAR_DOCS_SHADERS_EXT);
                }
                if (RenderInfo.activeRender.name.equals(BMRT)) {
                    return Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS_EXT);
                }
                if (RenderInfo.activeRender.name.equals(AIR)) {
                    return Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS_EXT);
                }
                if (RenderInfo.activeRender.name.equals(DELIGHT)) {
                    return Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS_EXT);
                }
                if (RenderInfo.activeRender.name.equals(PIXIE)) {
                    return Preferences.get(Preferences.PATH_PIXIE_DOCS_SHADERS_EXT);
                }
                if (RenderInfo.activeRender.name.equals(AQSIS)) {
                    return Preferences.get(Preferences.PATH_AQSIS_DOCS_SHADERS_EXT);
                }
                return CUSTOM;
            }
            case 17: {
                if (RenderInfo.activeRender.name.equals(PIXAR)) {
                    return Preferences.get(Preferences.PATH_PIXAR_DOCS_SHADERS_TOC);
                }
                if (RenderInfo.activeRender.name.equals(BMRT)) {
                    return Preferences.get(Preferences.PATH_BMRT_DOCS_SHADERS_TOC);
                }
                if (RenderInfo.activeRender.name.equals(AIR)) {
                    return Preferences.get(Preferences.PATH_AIR_DOCS_SHADERS_TOC);
                }
                if (RenderInfo.activeRender.name.equals(DELIGHT)) {
                    return Preferences.get(Preferences.PATH_3DELIGHT_DOCS_SHADERS_TOC);
                }
                if (RenderInfo.activeRender.name.equals(PIXIE)) {
                    return Preferences.get(Preferences.PATH_PIXIE_DOCS_SHADERS_TOC);
                }
                if (RenderInfo.activeRender.name.equals(AQSIS)) {
                    return Preferences.get(Preferences.PATH_AQSIS_DOCS_SHADERS_TOC);
                }
                return CUSTOM;
            }
            case 18: {
                return dataTypeStyle;
            }
        }
        return CUSTOM;
    }

    public static String getOption(String token, String value) {
        StringBuffer out = new StringBuffer();
        if (token.equalsIgnoreCase("ribparse")) {
            return "Option \"ribparse\" \"string varsubst\" [\"$\"]\n";
        }
        if (token.equalsIgnoreCase("searchpath") && value.equals("rixplugin")) {
            String line = "Option \"searchpath\" \"rixplugin\" [\"${RMSTREE}/lib/shaders:";
            String userPluginPath = Preferences.get(Preferences.PATH_USER_PLUGINS);
            if (userPluginPath != null && userPluginPath.trim().length() > 0) {
                return line + userPluginPath + ":@\"]\n";
            }
            return line + "@\"]\n";
        }
        if (token.equalsIgnoreCase("searchpath")) {
            out.append("Option \"searchpath\" ");
            if (value.equalsIgnoreCase("shader")) {
                if (RenderInfo.get(2).equals(AQSIS_RENDER)) {
                    out.append("\"shader\"    ").append('\"');
                    out.append(RenderInfo.get(7)).append(":");
                } else if (!(RenderInfo.get(2).equals(PIXAR) || RenderInfo.get(2).equals(BMRT) || RenderInfo.get(2).equals(AIR) || RenderInfo.get(2).equals(DELIGHT) || RenderInfo.get(2).equals(PIXIE))) {
                    out.append("\"shader\"    [").append('\"');
                    out.append(RenderInfo.get(7)).append(":");
                } else {
                    out.append("\"shader\"    [\"");
                }
                if (addRmsShadersToMenu) {
                    String ratShadersPath = Preferences.get(Preferences.PATH_PIXAR_RMS) + Url.ratShader.slo_path;
                    File ratShadersDir = new File(ratShadersPath);
                    if (ratShadersDir == null || !ratShadersDir.exists()) {
                        Cutter.setLog("    Error:RenderInfo.getOption() - cannot add rat shader directory");
                        Cutter.setLog("          to the Options \"searchpath\" because the path,");
                        Cutter.setLog("          " + ratShadersDir.getPath());
                        Cutter.setLog("          does not be found.");
                    } else {
                        out.append(ratShadersDir.getPath()).append(":");
                    }
                }
                String s = RenderInfo.get(13);
                File f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), s);
                out.append(f.exists() ? s : FileUtils.getPWD());
                out.append(":@\"]\n");
            } else if (value.equalsIgnoreCase("texture")) {
                out.append("\"texture\"   ").append("[\"");
                String s = RenderInfo.get(14);
                File f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), s);
                out.append(f.exists() ? s : FileUtils.getPWD());
                out.append(":@\"]\n");
            } else if (value.equalsIgnoreCase("archive")) {
                out.append("\"archive\"   [");
                out.append('\"');
                String s = RenderInfo.get(20);
                File f = FileUtils.resolveRelativePath(FileUtils.getPWDFile(), s);
                out.append(f.exists() ? s : FileUtils.getPWD());
                out.append(":Cutter_Help/templates/Rib:custom_templates/Rib\"]\n");
            }
        }
        return out.toString().replace(File.separatorChar, '/');
    }

    public static void addListener(RenderInfoListener item) {
        listOfListeners.addElement(item);
    }

    public static void notifyListeners(RenderInfo ri2) {
        if (listOfListeners == null || listOfListeners.size() == 0) {
            return;
        }
        for (int n = 0; n < listOfListeners.size(); ++n) {
            RenderInfoListener item = listOfListeners.elementAt(n);
            if (item == null) continue;
            item.renderInfoChanged(ri2);
        }
    }

    public static void setDeferRender(boolean flag) {
        deferRender = flag;
    }

    public static boolean getDeferRender() {
        if (Cutter.input.deferRender) {
            return true;
        }
        return deferRender;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String prmanVersion() {
        File preferredDir;
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        File rmsDir = new File(rmspath);
        String rpspath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        File rpsDir = new File(rpspath);
        if (!rpsDir.exists()) {
            if (!rmsDir.exists()) {
                Cutter.setLog("    Debug:RenderInfo.prmanVersion() - neither RPS or RMS Root is valid.");
                Cutter.setLog("    Debug:Assuming version 23.5 is being used!");
                return "23.5";
            }
            preferredDir = rmsDir;
        } else {
            preferredDir = rpsDir;
        }
        String tail = preferredDir.getName();
        String[] tokens = TextUtils.tokenize(tail, "-");
        if (tokens == null || tokens.length < 2) {
            Cutter.setLog("    Debug:RenderInfo.prmanVersion() - cannot get version from \"" + tail + "\".");
            Cutter.setLog("    Debug:Assuming version 19.0 is being used!");
            return "22.0";
        }
        String prman_version = tokens[1];
        StringBuffer buf = new StringBuffer();
        int n = 0;
        while (n < prman_version.length()) {
            char c = prman_version.charAt(n);
            if (Character.isLetter(c)) {
                return buf.toString();
            }
            buf.append(c);
            ++n;
        }
        return buf.toString();
    }

    public static String getRPSPath() {
        return Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
    }

    public static String getRPSBinPath() {
        String binPath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        binPath = new File(binPath, "bin").getPath();
        return binPath;
    }

    public static String rfmVersion() {
        char c;
        File preferredDir;
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        File rmsDir = new File(rmspath);
        String rpspath = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        File rpsDir = new File(rpspath);
        if (rmsDir.exists()) {
            preferredDir = rmsDir;
        } else {
            Cutter.setLog("    Debug:RenderInfo.rfmVersion() - \"" + rmsDir.getPath() + "\" does not exist.");
            if (rpsDir.exists()) {
                preferredDir = rpsDir;
            } else {
                Cutter.setLog("    Debug:RenderInfo.rfmVersion() - neither RPS or RMS Root is valid.");
                Cutter.setLog("    Debug:Assuming version 22.0 is being used!");
                return "22.0";
            }
        }
        String tail = preferredDir.getName();
        String[] tokens = TextUtils.tokenize(tail, "-");
        if (tokens == null || tokens.length < 2) {
            Cutter.setLog("    Debug:RenderInfo.rfmVersion() - cannot get version from \"" + tail + "\".");
            Cutter.setLog("    Debug:Assuming version 22.0 is being used!");
            return "22.0";
        }
        String rfm_version = tokens[1];
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < rfm_version.length() && !Character.isLetter(c = rfm_version.charAt(n)); ++n) {
            buf.append(c);
        }
        return buf.toString();
    }

    public static int rfmMajorVersionNumber() {
        String versionStr = RenderInfo.rfmVersion();
        String[] parts = TextUtils.tokenize(versionStr, ".");
        String majorVersionStr = "22";
        int majorVersion = 22;
        if (parts != null && parts.length > 1) {
            majorVersionStr = parts[0];
        }
        try {
            majorVersion = (int)NumberUtils.strToFloat(majorVersionStr);
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:RenderInfo.rfmMajorVersionNumber() - cannot get major version from \"" + majorVersionStr + "\"");
            Cutter.setLog(ex.toString());
        }
        return majorVersion;
    }

    public static String getRMSPath() {
        return Preferences.get(Preferences.PATH_PIXAR_RMS);
    }

    public static String getRMSBinPath() {
        String binPath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        binPath = new File(binPath, "bin").getPath();
        return binPath;
    }

    public static String getRMSrmantreeBinPath() {
        String binPath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        binPath = new File(binPath, "rmantree").getPath();
        binPath = new File(binPath, "bin").getPath();
        return binPath;
    }

    public static int prmanMajorVersionNumber() {
        String versionStr = RenderInfo.prmanVersion();
        String[] parts = TextUtils.tokenize(versionStr, ".");
        String majorVersionStr = "19";
        int majorVersion = 19;
        if (parts != null && parts.length > 1) {
            majorVersionStr = parts[0];
        }
        try {
            majorVersion = (int)NumberUtils.strToFloat(majorVersionStr);
        }
        catch (NumberFormatException ex) {
            Cutter.setLog("    Exception:RenderInfo.prmanMajorVersionNumber() - cannot get major version from \"" + majorVersionStr + "\"");
            Cutter.setLog(ex.toString());
        }
        return majorVersion;
    }

    public static String getSharedOptions() {
        String options = Ris21RibStrings.basicOptions;
        String rmspath = Preferences.get(Preferences.PATH_PIXAR_RMS);
        if (rmspath.trim().length() > 0) {
            rmspath = rmspath.replace('\\', '/');
            rmspath = TextUtils.trimTrailingChar(rmspath, '/');
            options = options.replaceAll("(__RMSTREE__)", rmspath);
        }
        String path = RenderInfo.get(27);
        options = options.replaceAll("(__OSL_SHADERS__)", path);
        path = RenderInfo.get(26);
        options = options.replaceAll("(__RIXPLUGINS__)", path);
        path = RenderInfo.get(14);
        options = options.replaceAll("(__TEXTURES__)", path);
        path = RenderInfo.get(20);
        options = options.replaceAll("(__ARCHIVES__)", path);
        return options;
    }

    public static void saveSelf() {
    }

    static {
        try {
            Field[] fields = new Field[]{RenderInfo.class.getDeclaredField("_setActiveRender")};
            Cutter.addDebug(RenderInfo.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: RenderInfo.static - " + ex.toString());
        }
        INSERT_TEXTURE_PATH = false;
        PRMAN = "prman";
        SHADER = "shader";
        RENDRIB = "rendrib";
        SLC = "slc";
        AIR_RENDER = AIR;
        SHADED = "shaded";
        SLOINFO = "sloinfo";
        SLCTELL = "slctell";
        SLBTELL = "slbtell";
        RENDERDL = Preferences.get(Preferences.EXE_3DELIGHT_RENDER);
        SHADERDL = Preferences.get(Preferences.EXE_3DELIGHT_COMPILE);
        SHADERINFO = "shaderinfo";
        PIXIE_RNDR = "rndr";
        PIXIE_SDRC = "sdrc";
        PIXIE_SHADERINFO = "sdrinfo";
        PIXIE_TEXMAKE = "texmake";
        PIXIE_PRECOMP = "precomp";
        AQSIS_RENDER = AQSIS;
        AQSIS_SHADER = "aqsl";
        AQSIS_SLTELL = "aqsltell";
        AQSIS_TEX = "teqset";
        activeRender = null;
        deferRender = false;
        generateSlimAppearance = true;
        doCopySloShader = false;
        sloShaderCopyPath = CUSTOM;
        addRmsShadersToMenu = false;
        autoReloadShaders = false;
        autoSetRenderer = true;
        autoSetVendorRibOption = true;
        dataTypeStyle = Preferences.get(Preferences.RENDERER_SHADER_DATATYPE);
        slimAppearanceStyle = SLIM_STYLE_RMS;
        textureData = null;
        listOfListeners = new Vector();
        tableOfSystemShaders = new Hashtable();
        isSystemShaderWarning = false;
        inited = false;
    }

    public class TextureData {
        private Vector<Item> listOfItems = new Vector();

        public void set(String name, int param, String value) {
            block11: for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                if (item.name.compareTo(name) != 0) continue;
                switch (param) {
                    case 0: {
                        item.type = value;
                        continue block11;
                    }
                    case 1: {
                        item.name = value;
                        continue block11;
                    }
                    case 3: {
                        item.srcDir = value;
                        continue block11;
                    }
                    case 4: {
                        item.destDir = value;
                        continue block11;
                    }
                    case 5: {
                        item.swrap = value;
                        continue block11;
                    }
                    case 6: {
                        item.twrap = value;
                        continue block11;
                    }
                    case 7: {
                        item.filter = value;
                        continue block11;
                    }
                    case 8: {
                        item.width = Integer.parseInt(value);
                        continue block11;
                    }
                    case 10: {
                        item.overwrite = value.equalsIgnoreCase("true");
                    }
                }
            }
        }

        public boolean remove(String name) {
            for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                if (item.name.compareTo(name) != 0) continue;
                this.listOfItems.removeElementAt(n);
                return true;
            }
            return false;
        }

        public void add(String maptype, String name, String srcDir, String destDir, String s, String t, String f, int w, boolean write) {
            for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                if (item.name.compareTo(name) != 0) continue;
                return;
            }
            name = TextUtils.removeQuotes(name);
            srcDir = TextUtils.removeQuotes(srcDir);
            destDir = TextUtils.removeQuotes(destDir);
            s = TextUtils.removeQuotes(s);
            t = TextUtils.removeQuotes(t);
            f = TextUtils.removeQuotes(f);
            Item item = new Item(maptype, name, srcDir, destDir, s, t, f, w, write);
            this.listOfItems.addElement(item);
        }

        public void clear() {
            this.listOfItems.removeAllElements();
        }

        public int count() {
            return this.listOfItems.size();
        }

        public String[][] get() {
            if (this.listOfItems.size() == 0) {
                return null;
            }
            String[][] out = new String[this.listOfItems.size()][11];
            for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                out[n][0] = item.type + RenderInfo.CUSTOM;
                out[n][1] = item.name;
                out[n][2] = TextUtils.removeExtension(item.name) + ".tx";
                out[n][3] = item.srcDir;
                out[n][4] = item.destDir;
                out[n][5] = item.swrap;
                out[n][6] = item.twrap;
                out[n][7] = item.filter;
                out[n][8] = item.width + RenderInfo.CUSTOM;
                out[n][9] = item.width + RenderInfo.CUSTOM;
                out[n][10] = item.overwrite + RenderInfo.CUSTOM;
            }
            return out;
        }

        public String[] get(String name) {
            String[] out = new String[11];
            for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                if (item.name.compareTo(name) != 0) continue;
                out[0] = item.type + RenderInfo.CUSTOM;
                out[1] = item.name;
                out[2] = TextUtils.removeExtension(item.name) + ".tx";
                out[3] = item.srcDir;
                out[4] = item.destDir;
                out[5] = item.swrap;
                out[6] = item.twrap;
                out[7] = item.filter;
                out[8] = item.width + RenderInfo.CUSTOM;
                out[9] = item.width + RenderInfo.CUSTOM;
                out[10] = item.overwrite + RenderInfo.CUSTOM;
                return out;
            }
            return null;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            for (int n = 0; n < this.listOfItems.size(); ++n) {
                Item item = this.listOfItems.elementAt(n);
                buff.append("Item " + n + ": " + item.type + " " + item.name + " " + item.srcDir + " " + item.destDir + item.swrap + " " + item.twrap + " " + item.filter + " " + item.width + " " + item.overwrite);
                buff.append('\n');
            }
            return buff.toString();
        }

        private class Item {
            public String name = "";
            public String filter = "";
            public String swrap = "";
            public String twrap = "";
            public String type = "";
            public boolean overwrite = true;
            public int width = 2;
            public String srcDir = "";
            public String destDir = "";

            public Item(String type, String name, String srcDir, String destDir, String s, String t, String f, int w, boolean write) {
                this.type = type;
                this.name = name;
                this.srcDir = srcDir;
                this.destDir = destDir;
                this.swrap = s;
                this.twrap = t;
                this.filter = f;
                this.width = w;
                this.overwrite = write;
            }
        }
    }

    public static class Texture {
        public static final int TYPE = 0;
        public static final int SRCNAME = 1;
        public static final int TXNAME = 2;
        public static final int SRCDIR = 3;
        public static final int DESTDIR = 4;
        public static final int SWRAP = 5;
        public static final int TWRAP = 6;
        public static final int FILTER = 7;
        public static final int WIDTH = 8;
        public static final int OVERWRITE = 10;
    }
}

