/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import Utilities.FileUtils;
import Utilities.PluginArgsUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import kernal.Tokenizers.Tokenizer;

public class Ris20PluginArgsReader {
    ImageIcon rgbIcon = ResourceUtils.getIconResource("/resources/rgb.png");
    ImageIcon rgbaIcon = ResourceUtils.getIconResource("/resources/rgb_a.png");
    ImageIcon floatIcon = ResourceUtils.getIconResource("/resources/float.png");
    ImageIcon vectIcon = ResourceUtils.getIconResource("/resources/vector.png");
    ImageIcon intIcon = ResourceUtils.getIconResource("/resources/int.png");
    ImageIcon manIcon = ResourceUtils.getIconResource("/resources/manifold.png");
    public static Vector<PluginArgsDB> rpsBxdfs = new Vector();
    public static Vector<PluginArgsDB> rpsPatts = new Vector();
    public static Vector<PluginArgsDB> mayaPatts = new Vector();
    private static Vector<PluginArgsDB> usrPlugins = new Vector();
    static String rps_root = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
    static String usr_root = Preferences.get(Preferences.PATH_USER_PLUGINS);
    static String userArgsPath = Preferences.get(Preferences.PATH_USER_ARGS);
    static File userArgsDir = new File(userArgsPath);
    private static File rpsLibDir = new File(rps_root, "lib");
    private static File rpsRisDir = new File(rpsLibDir, "RIS");
    private static File rpsBxdfDir = new File(rpsRisDir, "bxdf");
    private static File rpsBxdfArgsDir = new File(rpsBxdfDir, "Args");
    private static File rpsPattDir = new File(rpsRisDir, "pattern");
    private static File rpsPattArgsDir = new File(rpsPattDir, "Args");
    static String rms_root = Preferences.get(Preferences.PATH_PIXAR_RMS);
    private static File mayaLibDir = new File(rms_root, "lib");
    private static File mayaRfmDir = new File(mayaLibDir, "rfm");
    private static File mayaRisDir = new File(mayaRfmDir, "ris");
    private static File mayaNodesDir = new File(mayaRisDir, "mayaNodes");
    private static final String[] TOBE_EXCLUDED = new String[]{"PxrDiffuse.args", "PxrGlass.args", "PxrSkin.args"};
    private static int MAX_MENU_ITEMS = 22;

    static void updatePluginLocations() {
        rps_root = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        usr_root = Preferences.get(Preferences.PATH_USER_PLUGINS);
        userArgsDir = !usr_root.endsWith("Args") && !usr_root.endsWith("args") ? new File(usr_root, "Args") : new File(usr_root);
        rpsLibDir = new File(rps_root, "lib");
        rpsRisDir = new File(rpsLibDir, "RIS");
        rpsBxdfDir = new File(rpsRisDir, "bxdf");
        rpsBxdfArgsDir = new File(rpsBxdfDir, "Args");
        rpsPattDir = new File(rpsRisDir, "pattern");
        rpsPattArgsDir = new File(rpsPattDir, "Args");
    }

    public Ris20PluginArgsReader() {
        this.resetDatabase();
        this.readDirectories();
    }

    public void addBxdfMenuItems(JMenu bxdfMenu) {
        this.addItemsTo(bxdfMenu, rpsBxdfs);
    }

    public void addPatternMenuItems(JMenu patternsMenu) {
        this.addItemsTo(patternsMenu, rpsPatts);
    }

    public void addMayaMenuItems(JMenu mayaMenu) {
        this.addItemsTo(mayaMenu, mayaPatts);
    }

    public void addUserPluginItems(JMenu userMenu) {
        this.addItemsTo(userMenu, usrPlugins);
    }

    private void addItemsTo(JMenu menu, Vector<PluginArgsDB> plugins) {
        this.addItemsTo(menu, plugins, null);
    }

    private void addItemsTo(JMenu menu, Vector<PluginArgsDB> plugins, final String pathToPlugin) {
        menu.removeAll();
        JMenu activeMenu = menu;
        int itemCount = 0;
        for (int n = 0; n < plugins.size(); ++n) {
            final PluginArgsDB plugin = plugins.elementAt(n);
            Object icon = null;
            KMenuItem item = new KMenuItem(plugin.name);
            String[] types = plugin.getAllOutputTypes();
            boolean b_rgb = false;
            boolean b_float = false;
            boolean b_vector = false;
            boolean b_int = false;
            boolean b_manifold = false;
            b_manifold = TextUtils.isInList(types, "manifold");
            b_rgb = TextUtils.isInList(types, "color");
            b_float = TextUtils.isInList(types, "float");
            b_vector = TextUtils.isInList(types, "vector");
            b_vector = TextUtils.isInList(types, "normal");
            boolean bl = b_int = TextUtils.isInList(types, "int");
            if (b_manifold) {
                item = new KMenuItem(plugin.name, this.manIcon);
            } else if (b_rgb && b_float) {
                item = new KMenuItem(plugin.name, this.rgbaIcon);
            } else if (b_rgb) {
                item = new KMenuItem(plugin.name, this.rgbIcon);
            } else if (b_float) {
                item = new KMenuItem(plugin.name, this.floatIcon);
            } else if (b_vector) {
                item = new KMenuItem(plugin.name, this.vectIcon);
            } else if (b_int) {
                item = new KMenuItem(plugin.name, this.intIcon);
            }
            item.setToolTipText(plugin.description, true);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int mod = evt.getModifiers();
                    if ((mod & 8) == 0 && (mod & 2) == 0 && (mod & 4) == 0) {
                        int tabs = BBxt.countLineTabs();
                        if (pathToPlugin != null) {
                            plugin.pathToPlugin(pathToPlugin);
                        }
                        BBxt.paste(plugin.getRibStatement(tabs));
                    } else if ((mod & 8) != 0 || (mod & 2) != 0 || (mod & 4) != 0) {
                        BBxt.newDocument(plugin.srcArgFile);
                    }
                }
            };
            item.addActionListener(action);
            if (itemCount < MAX_MENU_ITEMS) {
                activeMenu.add(item);
                ++itemCount;
                continue;
            }
            if (n >= plugins.size() - 1) continue;
            JMenu temp = new JMenu("remainder...");
            activeMenu.add(temp);
            activeMenu = temp;
            itemCount = 0;
        }
    }

    public void resetDatabase() {
        Ris20PluginArgsReader.updatePluginLocations();
        rpsBxdfs.clear();
        rpsPatts.clear();
        mayaPatts.clear();
        usrPlugins.clear();
    }

    private String[] removeNonProduction(String[] input) {
        if (input == null || input.length == 0) {
            return input;
        }
        Vector<String> output = new Vector<String>();
        for (int n = 0; n < input.length; ++n) {
            boolean insert = true;
            for (int i = 0; i < TOBE_EXCLUDED.length; ++i) {
                if (!input[n].equals(TOBE_EXCLUDED[i])) continue;
                insert = false;
            }
            if (!insert) continue;
            output.add(input[n]);
        }
        return VectorUtils.toStringArray(output);
    }

    public void readDirectories() {
        int n;
        Vector<File> files = new Vector<File>();
        String[] names = FileUtils.getListOfFileNames(rpsBxdfArgsDir, ".args");
        if ((names = this.removeNonProduction(names)) != null) {
            for (n = 0; n < names.length; ++n) {
                files.add(new File(rpsBxdfArgsDir, names[n]));
            }
            if (files != null && files.size() > 0) {
                this.parsePlugins("Bxdf", rpsBxdfs, files, false);
            }
            files.clear();
        }
        if ((names = FileUtils.getListOfFileNames(rpsPattArgsDir, ".args")) != null) {
            for (n = 0; n < names.length; ++n) {
                files.add(new File(rpsPattArgsDir, names[n]));
            }
            if (files != null && files.size() > 0) {
                this.parsePlugins("Pattern", rpsPatts, files, true);
            }
            files.clear();
        }
        if ((names = FileUtils.getListOfFileNames(mayaNodesDir, ".args")) != null) {
            for (n = 0; n < names.length; ++n) {
                files.add(new File(mayaNodesDir, names[n]));
            }
            if (files != null && files.size() > 0) {
                this.parsePlugins("Pattern", mayaPatts, files, true);
            }
            files.clear();
        }
        names = FileUtils.getListOfFileNames(userArgsDir, ".args");
        Cutter.setLog("    Debug: PluginArgsReader.readDirectories() - users args directory is");
        Cutter.setLog("          \"" + userArgsDir + "\"");
        if (names != null) {
            for (n = 0; n < names.length; ++n) {
                files.add(new File(userArgsDir, names[n]));
            }
            if (files != null && files.size() > 0) {
                this.parsePlugins("Pattern", usrPlugins, files, true);
            }
            files.clear();
        }
    }

    private void parsePlugins(String type, Vector<PluginArgsDB> listOfPlugins, Vector<File> listOfFiles, boolean doSort) {
        for (int n = 0; n < listOfFiles.size(); ++n) {
            File f = listOfFiles.elementAt(n);
            String text = FileUtils.read(f);
            if (text == null || text.trim().length() == 0) continue;
            String[] lines = PluginArgsUtils.convertTagsToLines(text);
            if ((lines = PluginArgsUtils.conformParamTags(lines)) == null) continue;
            lines = PluginArgsUtils.conformOutputTags(lines);
            lines = PluginArgsUtils.conformHelpTags(lines);
            lines = PluginArgsUtils.convertInfoToHelpTags(lines);
            boolean doIgnore = false;
            if (type.equals("Pattern")) {
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (!line.startsWith("<tag") || !line.endsWith("bxdf\"/>")) continue;
                    doIgnore = true;
                }
            }
            if (doIgnore) {
                Cutter.setLog("    Debug: PluginArgsReader.parsePlugins() - ignoring \"" + f.getName() + "\"");
                continue;
            }
            PluginArgsDB plugin = new PluginArgsDB(type, f);
            PluginArg arg = null;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.startsWith("<_help>") && arg == null) {
                    String str = line.substring(7, line.length() - 8).trim();
                    if (str.length() == 0) continue;
                    plugin.description = str;
                    continue;
                }
                if (this.isParamBegin(line)) {
                    arg = new PluginArg(true);
                }
                if (this.isParamEnd(line) && arg != null) {
                    plugin.add(arg);
                    arg = null;
                }
                if (this.isOutputBegin(line)) {
                    arg = new PluginArg(false);
                }
                if (this.isOutputEnd(line) && arg != null) {
                    plugin.add(arg);
                    arg = null;
                }
                if (arg == null) continue;
                if (arg.isInput) {
                    this.readParam(line, arg);
                    continue;
                }
                this.readOutput(line, arg);
            }
            listOfPlugins.add(plugin);
        }
        if (!doSort) {
            return;
        }
        Hashtable<String, PluginArgsDB> table = new Hashtable<String, PluginArgsDB>();
        Vector<String> names = new Vector<String>();
        int numPlugins = listOfPlugins.size();
        for (int n = 0; n < numPlugins; ++n) {
            PluginArgsDB plugin = listOfPlugins.elementAt(n);
            table.put(plugin.name, plugin);
            names.add(plugin.name);
        }
        listOfPlugins.clear();
        String[] sorted = TextUtils.sortByAlpha(VectorUtils.toStringArray(names));
        for (int n = 0; n < sorted.length; ++n) {
            String name = sorted[n];
            listOfPlugins.add((PluginArgsDB)table.get(name));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < rpsPatts.size(); ++n) {
            PluginArgsDB p = rpsPatts.elementAt(n);
            buf.append(p.toString());
        }
        return buf.toString();
    }

    private boolean isParamBegin(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length >= 2 && tokens[0].equalsIgnoreCase("param");
    }

    private boolean isParamEnd(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length > 0 && tokens[0].startsWith("/param");
    }

    private void readParam(String str, PluginArg arg) {
        if (str == null || str.trim().length() == 0 || arg == null) {
            return;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        while (!s.equals("")) {
            if ((s.equalsIgnoreCase("name") || s.equalsIgnoreCase("type") || s.equalsIgnoreCase("default") || s.equalsIgnoreCase("tag")) && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                String value = tok.getNextStr();
                if (!value.equals("")) {
                    arg.set(s, value);
                }
            }
            s = tok.getNextStr();
        }
    }

    private void readOutput(String str, PluginArg arg) {
        if (str == null || str.trim().length() == 0 || arg == null) {
            return;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        if (s.equalsIgnoreCase("output") || s.equalsIgnoreCase("tag")) {
            s = tok.getNextStr();
        }
        while (!s.equals("")) {
            String value;
            if (s.equalsIgnoreCase("tag") && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                value = tok.getNextStr();
                String[] values = TextUtils.tokenize(value, '|');
                values = TextUtils.removeQuotes(values);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        arg.set("value", values[i]);
                    }
                }
            } else if ((s.equalsIgnoreCase("name") || s.equalsIgnoreCase("value")) && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                value = tok.getNextStr();
                if (!value.equals("")) {
                    arg.set(s, value);
                }
            }
            s = tok.getNextStr();
        }
    }

    private boolean isOutputBegin(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length >= 2 && tokens[0].equalsIgnoreCase("output");
    }

    private boolean isOutputEnd(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length > 0 && tokens[0].startsWith("/output");
    }

    public class PluginArgsDB {
        public String name = "";
        public String type = "";
        int handleCount = 1;
        File srcArgFile = null;
        String description = "no description";
        String pathToPlugin = null;
        public Vector<PluginArg> inputs = new Vector();
        public Vector<PluginArg> outputs = new Vector();

        public PluginArgsDB(String type, File argfile) {
            this.type = type;
            this.name = TextUtils.removeExtension(argfile.getName());
            this.srcArgFile = argfile;
            if (type.equals("Bxdf") && (this.name.equals("PxrLMLayer") || this.name.equals("PxrLMMixer"))) {
                this.type = "Pattern";
            }
        }

        public void add(PluginArg arg) {
            if (arg != null && arg.isInput) {
                this.inputs.add(arg);
            } else {
                this.outputs.add(arg);
            }
        }

        public String[] getAllOutputTypes() {
            Vector<String> out = new Vector<String>();
            for (int n = 0; n < this.outputs.size(); ++n) {
                PluginArg arg = this.outputs.elementAt(n);
                for (int i = 0; i < arg.out_types.size(); ++i) {
                    out.add(arg.out_types.elementAt(i));
                }
            }
            return VectorUtils.toStringArray(out);
        }

        public void pathToPlugin(String path) {
            this.pathToPlugin = path;
        }

        public String getRibStatement(int tabs) {
            int n;
            Vector<PluginArg> temp = new Vector<PluginArg>();
            PluginArg manifoldArg = null;
            for (int n2 = 0; n2 < this.inputs.size(); ++n2) {
                PluginArg arg = this.inputs.elementAt(n2);
                if (arg.datatype.equalsIgnoreCase("struct")) {
                    Cutter.setLog("    Debug:PluginArgsReader.getRibStatement() - found struct name " + arg.name);
                }
                if (arg.name.equalsIgnoreCase("manifold")) {
                    manifoldArg = arg;
                    continue;
                }
                temp.add(arg);
            }
            if (manifoldArg != null) {
                temp.add(manifoldArg);
            }
            this.inputs = temp;
            StringBuffer buf = new StringBuffer();
            if (this.type.equals("Pattern") && (this.name.equals("PxrTexture") || this.name.equals("PxrMayaFile"))) {
                String texdir = Preferences.get(Preferences.PATH_USER_TEXTURES);
                buf.append("# txmake -mode periodic ../tiffs/name.tif ").append(texdir).append("/name.tex\n");
            }
            String ribname = " \"" + this.name + "\" ";
            if (this.pathToPlugin != null && this.pathToPlugin.length() > 0) {
                ribname = this.pathToPlugin.endsWith("/") ? " \"" + this.pathToPlugin + this.name + "\" " : " \"" + this.pathToPlugin + "/" + this.name + "\" ";
            }
            String handle = "\"" + this.name + this.handleCount + "\"\n";
            buf.append(this.type).append(ribname).append(handle);
            for (n = 0; n < this.inputs.size(); ++n) {
                String cmntChar = "";
                String preCmnt = "";
                String postCmnt = "";
                PluginArg arg = this.inputs.elementAt(n);
                String defaultValue = arg.dvalue;
                if (arg.datatype.equals("string") && defaultValue.equals("")) {
                    defaultValue = "\"\"";
                } else if (defaultValue.endsWith("f") || defaultValue.endsWith("F")) {
                    defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                } else if (arg.datatype.equals("float") && defaultValue.endsWith(".")) {
                    defaultValue = defaultValue + "0";
                } else if (arg.datatype.equals("float") && defaultValue.startsWith(".")) {
                    defaultValue = "0" + defaultValue;
                } else {
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("manifold")) {
                        preCmnt = "\t\t# Examples manifold connection\n\t\t#\"reference struct manifold\" [\"PxrManifold2D1:result\"]\n\t\t#\"reference struct manifold\" [\"PxrManifold3D1:result\"]\n\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("lmlayer")) {
                        preCmnt = "\t\t# Examples of mixer and layer connections\n\t\t#\"reference struct lmlayer\" [\"PxrLMMixer1:result\"]\n\t\t#\"reference struct lmlayer\" [\"PxrLMLayer1:result\"]\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("manifoldN")) {
                        preCmnt = "\t\t# Example 3dmanifold connection\n\t\t#\"reference struct manifoldN\" [\"PxrManifold3DN1:result\"]\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct")) {
                        cmntChar = "# ";
                    }
                }
                String arg_decl = preCmnt + cmntChar + "\"" + arg.datatype + " " + arg.name + "\" [";
                if (!arg.datatype.equals("string")) {
                    StringBuffer b = new StringBuffer();
                    for (int j = 0; j < defaultValue.length(); ++j) {
                        if (defaultValue.charAt(j) == 'f') continue;
                        b.append(defaultValue.charAt(j));
                    }
                    defaultValue = b.toString();
                }
                if (arg.datatype.equals("string") && defaultValue.length() > 0) {
                    if (!defaultValue.startsWith("\"")) {
                        defaultValue = "\"" + defaultValue;
                    }
                    if (!defaultValue.endsWith("\"")) {
                        defaultValue = defaultValue + "\"";
                    }
                }
                buf.append("\t\t").append(arg_decl).append(defaultValue).append("]" + postCmnt + "\n");
            }
            for (n = 0; n < this.outputs.size(); ++n) {
                PluginArg arg = this.outputs.elementAt(n);
                String types = this.formatOutTypes(arg);
                buf.append("\t\t# \"").append(this.name + this.handleCount + ":").append(arg.name).append("\"    uses->").append(types).append(" \n");
            }
            ++this.handleCount;
            return buf.toString();
        }

        private String formatOutTypes(PluginArg arg) {
            if (arg == null) {
                return "ERROR";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("|");
            for (int n = 0; n < arg.out_types.size(); ++n) {
                buf.append(arg.out_types.elementAt(n)).append("|");
            }
            return buf.toString();
        }
    }

    private class PluginArg {
        public String name = "";
        public String dvalue = "";
        public String datatype = "";
        public Vector<String> out_types = new Vector();
        public boolean isInput = true;

        public PluginArg(boolean isInput) {
            this.isInput = isInput;
        }

        public void set(String item, String itemValue) {
            if (!this.isInput) {
                // empty if block
            }
            itemValue = TextUtils.removeQuotes(itemValue);
            if (item.equals("name")) {
                if (this.name.trim().length() == 0) {
                    this.name = itemValue.trim();
                }
            } else if (item.equals("default")) {
                if (this.dvalue.trim().length() == 0) {
                    this.dvalue = itemValue.trim();
                }
            } else if (item.equals("type")) {
                this.datatype = itemValue.trim();
            }
            if (item.equals("value") && !this.isInput) {
                this.out_types.add(itemValue.trim());
            }
        }
    }

    private class PMenuItem
    extends JMenuItem {
        private MultiLineToolTip tip;

        public PMenuItem(String s) {
            super(s);
            this.tip = null;
        }

        @Override
        public JToolTip createToolTip() {
            return this.tip;
        }

        @Override
        public void setToolTipText(String tipText) {
            super.setToolTipText(tipText);
            this.tip = new MultiLineToolTip(tipText);
        }
    }
}

