/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.KMenuItem;
import UI_Components.ToolTip.MultiLineToolTip;
import UI_Desktop.Cutter;
import UI_Script.Args.ArgsTokenizer;
import UI_Tools.Rman.Ris21RibStrings;
import Utilities.FileUtils;
import Utilities.PluginArgsUtils;
import Utilities.ResourceUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import kernal.Tokenizers.Tokenizer;

public class Ris21PluginArgsReader {
    ImageIcon rgbIcon = ResourceUtils.getIconResource("/resources/rgb.png");
    ImageIcon rgbaIcon = ResourceUtils.getIconResource("/resources/rgb_a.png");
    ImageIcon floatIcon = ResourceUtils.getIconResource("/resources/float.png");
    ImageIcon vectIcon = ResourceUtils.getIconResource("/resources/vector.png");
    ImageIcon intIcon = ResourceUtils.getIconResource("/resources/int.png");
    ImageIcon manIcon = ResourceUtils.getIconResource("/resources/manifold.png");
    public static Vector<PluginArgsDB> rpsBxdfs = new Vector();
    public static Vector<PluginArgsDB> rpsPatts = new Vector();
    public static Vector<PluginArgsDB> rpsDisps = new Vector();
    public static Vector<PluginArgsDB> rpsLites = new Vector();
    public static Vector<PluginArgsDB> rpsIntgs = new Vector();
    public static Vector<PluginArgsDB> rpsProjs = new Vector();
    public static Vector<PluginArgsDB> rpsDspFilters = new Vector();
    public static Vector<PluginArgsDB> mayaPatts = new Vector();
    private static Vector<PluginArgsDB> usrPlugins = new Vector();
    static String rps_root = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
    static String usr_plugins = Preferences.get(Preferences.PATH_USER_PLUGINS);
    static String userArgsPath = Preferences.get(Preferences.PATH_USER_ARGS);
    static File userArgsDir = new File(userArgsPath);
    private static File rpsLibDir = new File(rps_root, "lib");
    private static File rpsPluginsDir = new File(rpsLibDir, "plugins");
    private static File rpsArgsDir = new File(rpsPluginsDir, "Args");
    static String rms_root = Preferences.get(Preferences.PATH_PIXAR_RMS);
    private static File rfmLibDir = new File(rms_root, "lib");
    private static File rfmRfmDir = new File(rfmLibDir, "rfm");
    private static File rfmRisDir = new File(rfmRfmDir, "ris");
    private static File rfmArgsDir = new File(rfmRisDir, "mayaNodes");
    private static File pwd = FileUtils.getPWDFile();
    private static File cutterHelpDir = new File(pwd, "Cutter_Help");
    private static File risDir = new File(cutterHelpDir, "ris");
    private static File intermediateDir = new File(risDir, "Intermediate");
    private static File basicDir = new File(risDir, "Basic");
    private static File intermediateSurfArgs = new File(intermediateDir, "PxrSurface.args");
    public static File basicSurfArgs = new File(basicDir, "PxrSurface.args");
    private static final String[] TOBE_EXCLUDED = new String[]{"PxrLMDiffuse.args", "PxrLMGlass.args", "PxrLMSubsurface.args", "PxrLMMetal.args", "PxrLMPlastic.args", "PxrDisney.args", "PxrHair.args", "PxrLightEmission.args", "PxrDiffuse.args", "PxrSkin.args", "PxrGlass.args", "PxrPortalLight.args"};
    private static PluginArgsDB[] allPlugins = null;
    private static int MAX_MENU_ITEMS = 22;

    public static void updatePluginLocations() {
        rps_root = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        usr_plugins = Preferences.get(Preferences.PATH_USER_PLUGINS);
        userArgsDir = !usr_plugins.endsWith("Args") && !usr_plugins.endsWith("args") ? new File(usr_plugins, "Args") : new File(usr_plugins);
        rps_root = Preferences.get(Preferences.PATH_PIXAR_PROSERVER);
        usr_plugins = Preferences.get(Preferences.PATH_USER_PLUGINS);
        rpsLibDir = new File(rps_root, "lib");
        rpsPluginsDir = new File(rpsLibDir, "plugins");
        rpsArgsDir = new File(rpsPluginsDir, "Args");
        rms_root = Preferences.get(Preferences.PATH_PIXAR_RMS);
        rfmLibDir = new File(rms_root, "lib");
        rfmRfmDir = new File(rfmLibDir, "rfm");
        rfmRisDir = new File(rfmRfmDir, "ris");
        rfmArgsDir = new File(rfmRisDir, "mayaNodes");
    }

    public void resetDatabase() {
        Ris21PluginArgsReader.updatePluginLocations();
        rpsDspFilters.clear();
        rpsBxdfs.clear();
        rpsPatts.clear();
        rpsDisps.clear();
        rpsLites.clear();
        rpsIntgs.clear();
        rpsProjs.clear();
        mayaPatts.clear();
        usrPlugins.clear();
    }

    public Ris21PluginArgsReader() {
        this.resetDatabase();
        this.readAllArgFiles();
    }

    public static PluginArgsDB[] getAllPlugins() {
        int n;
        if (allPlugins != null) {
            return allPlugins;
        }
        int totalNum = rpsDspFilters.size();
        totalNum += rpsBxdfs.size();
        totalNum += rpsPatts.size();
        totalNum += rpsDisps.size();
        totalNum += rpsLites.size();
        totalNum += rpsIntgs.size();
        totalNum += rpsProjs.size();
        allPlugins = new PluginArgsDB[totalNum += usrPlugins.size()];
        int count = 0;
        for (n = 0; n < rpsDspFilters.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsDspFilters.elementAt(n);
        }
        for (n = 0; n < rpsBxdfs.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsBxdfs.elementAt(n);
        }
        for (n = 0; n < rpsPatts.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsPatts.elementAt(n);
        }
        for (n = 0; n < rpsDisps.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsDisps.elementAt(n);
        }
        for (n = 0; n < rpsLites.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsLites.elementAt(n);
        }
        for (n = 0; n < rpsIntgs.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsIntgs.elementAt(n);
        }
        for (n = 0; n < rpsProjs.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = rpsProjs.elementAt(n);
        }
        for (n = 0; n < usrPlugins.size(); ++n) {
            Ris21PluginArgsReader.allPlugins[count++] = usrPlugins.elementAt(n);
        }
        return allPlugins;
    }

    public void addBxdfMenuItems(JMenu bxdfMenu) {
        int n;
        Vector<PluginArgsDB> LMxxx = new Vector<PluginArgsDB>();
        Vector<PluginArgsDB> notLM = new Vector<PluginArgsDB>();
        for (n = 0; n < rpsBxdfs.size(); ++n) {
            PluginArgsDB db = rpsBxdfs.elementAt(n);
            if (db.name.equals("PxrLMLayer") || db.name.equals("PxrLMMixer")) {
                LMxxx.add(db);
                continue;
            }
            notLM.add(db);
        }
        rpsBxdfs.clear();
        for (n = 0; n < notLM.size(); ++n) {
            rpsBxdfs.add((PluginArgsDB)notLM.elementAt(n));
        }
        rpsBxdfs.add(new PluginArgsDB("-", null));
        Vector<PluginArgsDB> basicPxrSurface = new Vector<PluginArgsDB>();
        Vector<File> listOfFiles1 = new Vector<File>();
        listOfFiles1.add(basicSurfArgs);
        this.parsePlugins("Bxdf", basicPxrSurface, listOfFiles1, true);
        if (basicPxrSurface.size() > 0) {
            basicPxrSurface.elementAt((int)0).menuName = "Basic PxrSurface";
            rpsBxdfs.add(basicPxrSurface.elementAt(0));
        }
        Vector<PluginArgsDB> intermediatePxrSurface = new Vector<PluginArgsDB>();
        Vector<File> listOfFiles2 = new Vector<File>();
        listOfFiles2.add(intermediateSurfArgs);
        this.parsePlugins("Bxdf", intermediatePxrSurface, listOfFiles2, true);
        if (intermediatePxrSurface.size() > 0) {
            intermediatePxrSurface.elementAt((int)0).menuName = "Intermediate PxrSurface";
            rpsBxdfs.add(intermediatePxrSurface.elementAt(0));
        }
        this.addItemsTo(bxdfMenu, rpsBxdfs);
    }

    public void addIntegratorMenuItems(JMenu intMenu) {
        this.addItemsTo(intMenu, rpsIntgs);
    }

    public void addProjectionMenuItems(JMenu projMenu) {
        this.addItemsTo(projMenu, rpsProjs);
    }

    public void addDisplayFilterMenuItems(JMenu displayMenu) {
        this.addItemsTo(displayMenu, rpsDspFilters);
    }

    public void addLightMenuItems(JMenu liteMenu) {
        this.addItemsTo(liteMenu, rpsLites);
    }

    public void addDisplacementMenuItems(JMenu dispMenu) {
        this.addItemsTo(dispMenu, rpsDisps);
    }

    public void addPatternMenuItems(JMenu patternsMenu) {
        this.addItemsTo(patternsMenu, rpsPatts);
    }

    public void addMayaMenuItems(JMenu mayaMenu) {
        this.addItemsTo(mayaMenu, mayaPatts);
    }

    public void addUserPluginItems(JMenu userMenu) {
        this.addItemsTo(userMenu, usrPlugins);
    }

    private void addItemsTo(JMenu menu, Vector<PluginArgsDB> plugins) {
        this.addItemsTo(menu, plugins, null);
    }

    private void addItemsTo(JMenu menu, Vector<PluginArgsDB> plugins, final String pathToPlugin) {
        menu.removeAll();
        JMenu activeMenu = menu;
        int itemCount = 0;
        for (int n = 0; n < plugins.size(); ++n) {
            final PluginArgsDB plugin = plugins.elementAt(n);
            if (plugin.useAsSeparator) {
                menu.addSeparator();
                continue;
            }
            Object icon = null;
            String menuName = plugin.getMenuName();
            KMenuItem item = new KMenuItem(menuName);
            String[] types = plugin.getAllOutputTypes();
            boolean b_rgb = false;
            boolean b_float = false;
            boolean b_vector = false;
            boolean b_int = false;
            boolean b_manifold = false;
            b_manifold = TextUtils.isInList(types, "manifold");
            b_rgb = TextUtils.isInList(types, "color");
            b_float = TextUtils.isInList(types, "float");
            b_vector = TextUtils.isInList(types, "vector");
            b_vector = TextUtils.isInList(types, "normal");
            boolean bl = b_int = TextUtils.isInList(types, "int");
            if (b_manifold) {
                item = new KMenuItem(menuName, this.manIcon);
            } else if (b_rgb && b_float) {
                item = new KMenuItem(menuName, this.rgbaIcon);
            } else if (b_rgb) {
                item = new KMenuItem(menuName, this.rgbIcon);
            } else if (b_float) {
                item = new KMenuItem(menuName, this.floatIcon);
            } else if (b_vector) {
                item = new KMenuItem(menuName, this.vectIcon);
            } else if (b_int) {
                item = new KMenuItem(menuName, this.intIcon);
            }
            item.setToolTipText(plugin.description, true);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int mod = evt.getModifiers();
                    if ((mod & 8) == 0 && (mod & 2) == 0 && (mod & 4) == 0) {
                        int tabs = BBxt.countLineTabs();
                        if (pathToPlugin != null) {
                            plugin.pathToPlugin(pathToPlugin);
                        }
                        if (plugin.type.equals("Light")) {
                            String rib = plugin.getRibStatement(tabs);
                            String attrBlock = plugin.name.equals("PxrEnvDayLight") ? Ris21RibStrings.DaylightAttributeBlock : (plugin.name.equals("PxrDomeLight") ? Ris21RibStrings.DomelightAttributeBlock : (plugin.name.equals("PxrSphereLight") ? Ris21RibStrings.SpherelightAttributeBlock : (plugin.name.equals("PxrMeshLight") ? Ris21RibStrings.MeshLightAttributeBlock : (plugin.name.equals("PxrDistantLight") ? Ris21RibStrings.DistantLightAttributeBlock : Ris21RibStrings.LightAttributeBlock))));
                            rib = attrBlock.replaceAll("(__PXR_LIGHT__)", rib);
                            BBxt.paste(rib);
                        } else {
                            BBxt.paste(plugin.getRibStatement(tabs));
                        }
                    } else if ((mod & 8) != 0 || (mod & 2) != 0 || (mod & 4) != 0) {
                        BBxt.newDocument(plugin.srcArgFile);
                    }
                }
            };
            item.addActionListener(action);
            if (itemCount < MAX_MENU_ITEMS) {
                activeMenu.add(item);
                ++itemCount;
                continue;
            }
            if (n >= plugins.size() - 1) continue;
            JMenu temp = new JMenu("remainder...");
            activeMenu.add(temp);
            activeMenu = temp;
            itemCount = 0;
        }
    }

    private static String[] removeNonProduction(String[] input) {
        if (input == null || input.length == 0) {
            return input;
        }
        Vector<String> output = new Vector<String>();
        for (int n = 0; n < input.length; ++n) {
            boolean insert = true;
            for (int i = 0; i < TOBE_EXCLUDED.length; ++i) {
                if (!input[n].equalsIgnoreCase(TOBE_EXCLUDED[i])) continue;
                insert = false;
            }
            if (!insert) continue;
            output.add(input[n]);
        }
        return VectorUtils.toStringArray(output);
    }

    public void readAllArgFiles() {
        File f;
        ArgsTokenizer tok = new ArgsTokenizer();
        Vector<File> bxdfFiles = new Vector<File>();
        Vector<File> pattFiles = new Vector<File>();
        Vector<File> dispFiles = new Vector<File>();
        Vector<File> liteFiles = new Vector<File>();
        Vector<File> intgFiles = new Vector<File>();
        Vector<File> projFiles = new Vector<File>();
        Vector<File> dspFilterFiles = new Vector<File>();
        String[] names = FileUtils.getListOfFileNames(rpsArgsDir, ".args");
        if ((names = Ris21PluginArgsReader.removeNonProduction(names)) != null) {
            for (int n = 0; n < names.length; ++n) {
                f = new File(rpsArgsDir, names[n]);
                tok.setBuffer(FileUtils.read(f));
                tok.filepath = f.getPath();
                tok.setBufferIndex(0);
                tok.ignoreTags = false;
                String nodetype = tok.getShaderType();
                if (nodetype == null) {
                    Cutter.setLog("    Warning:Ris21PluginArgsReader.readDirectories().");
                    Cutter.setLog("         Cannot find shaderType for \"" + names[n] + "\"");
                    continue;
                }
                if (nodetype.equals("bxdf")) {
                    bxdfFiles.add(f);
                    continue;
                }
                if (nodetype.equals("displayfilter")) {
                    dspFilterFiles.add(f);
                    continue;
                }
                if (nodetype.equals("pattern")) {
                    if (names[n].startsWith("PxrLMLayer") || names[n].startsWith("PxrLMMixer")) {
                        bxdfFiles.add(f);
                        continue;
                    }
                    pattFiles.add(f);
                    continue;
                }
                if (nodetype.equals("displacement")) {
                    dispFiles.add(f);
                    continue;
                }
                if (nodetype.equals("light")) {
                    liteFiles.add(f);
                    continue;
                }
                if (nodetype.equals("integrator")) {
                    intgFiles.add(f);
                    continue;
                }
                if (!nodetype.equals("projection")) continue;
                projFiles.add(f);
            }
            bxdfFiles = FileUtils.sortFilesByName(bxdfFiles);
            pattFiles = FileUtils.sortFilesByName(pattFiles);
            dispFiles = FileUtils.sortFilesByName(dispFiles);
            liteFiles = FileUtils.sortFilesByName(liteFiles);
            intgFiles = FileUtils.sortFilesByName(intgFiles);
            projFiles = FileUtils.sortFilesByName(projFiles);
            dspFilterFiles = FileUtils.sortFilesByName(dspFilterFiles);
            this.parsePlugins("Bxdf", rpsBxdfs, bxdfFiles, false);
            this.parsePlugins("Pattern", rpsPatts, pattFiles, false);
            this.parsePlugins("Displace", rpsDisps, dispFiles, false);
            this.parsePlugins("Light", rpsLites, liteFiles, false);
            this.parsePlugins("Integrator", rpsIntgs, intgFiles, false);
            this.parsePlugins("Projection", rpsProjs, projFiles, false);
            this.parsePlugins("DisplayFilter", rpsDspFilters, dspFilterFiles, false);
        }
        Vector<File> files = new Vector<File>();
        names = FileUtils.getListOfFileNames(rfmArgsDir, ".args");
        if (names != null) {
            for (int n = 0; n < names.length; ++n) {
                f = new File(rfmArgsDir, names[n]);
                files.add(f);
            }
            files = FileUtils.sortFilesByName(files);
            this.parsePlugins("Pattern", mayaPatts, files, true);
            files.clear();
        }
        if ((names = FileUtils.getListOfFileNames(userArgsDir, ".args")) != null) {
            for (int n = 0; n < names.length; ++n) {
                f = new File(userArgsDir, names[n]);
                tok.setBuffer(FileUtils.read(f));
                String nodetype = tok.getShaderType();
                if (nodetype == null) continue;
                files.add(f);
            }
            files = FileUtils.sortFilesByName(files);
            this.parsePlugins("", usrPlugins, files, true);
            files.clear();
        }
    }

    public void parsePlugins(String type, Vector<PluginArgsDB> listOfPlugins, Vector<File> listOfFiles, boolean doSort) {
        if (listOfFiles.size() == 0) {
            return;
        }
        for (int n = 0; n < listOfFiles.size(); ++n) {
            File f = listOfFiles.elementAt(n);
            String text = FileUtils.read(f);
            if (text == null || text.trim().length() == 0) continue;
            String[] lines = PluginArgsUtils.convertTagsToLines(text);
            if ((lines = PluginArgsUtils.conformParamTags(lines)) == null) continue;
            lines = PluginArgsUtils.conformOutputTags(lines);
            lines = PluginArgsUtils.conformHelpTags(lines);
            lines = PluginArgsUtils.convertInfoToHelpTags(lines);
            boolean doIgnore = false;
            if (type.equals("Pattern")) {
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (!line.startsWith("<tag") || !line.endsWith("bxdf\"/>")) continue;
                    doIgnore = true;
                }
            }
            if (doIgnore) {
                Cutter.setLog("    Debug: PluginArgsReader.parsePlugins() - ignoring \"" + f.getName() + "\"");
                continue;
            }
            PluginArgsDB plugin = new PluginArgsDB(type, f);
            if (type.equals("")) {
                ArgsTokenizer tok = new ArgsTokenizer();
                tok.setBuffer(text);
                String shaderType = tok.getShaderType();
                if (shaderType == null) {
                    String stype = "Pattern";
                } else {
                    String stype = shaderType.equals("integrator") ? "Integrator" : (shaderType.equals("projection") ? "Projection" : (shaderType.equals("displayfilter") ? "DisplayFilter" : (shaderType.equals("samplefilter") ? "SampleFilter" : (shaderType.equals("lightfilter") ? "LightFilter" : (shaderType.equals("bxdf") ? "Bxdf" : (shaderType.equals("displacememt") ? "Displace" : (shaderType.equals("light") ? "Light" : (shaderType.equals("pattern") ? "Pattern" : "unknown"))))))));
                    plugin = new PluginArgsDB(stype, f);
                }
            }
            PluginArg arg = null;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.startsWith("<_help>") && arg == null) {
                    String str = line.substring(7, line.length() - 8).trim();
                    if (str.length() == 0) continue;
                    plugin.description = str;
                    continue;
                }
                if (this.isParamBegin(line)) {
                    arg = new PluginArg(true);
                }
                if (this.isParamEnd(line) && arg != null) {
                    plugin.add(arg);
                    arg = null;
                }
                if (this.isOutputBegin(line)) {
                    arg = new PluginArg(false);
                }
                if (this.isOutputEnd(line) && arg != null) {
                    plugin.add(arg);
                    arg = null;
                }
                if (arg == null) continue;
                if (arg.isInput) {
                    this.readParam(line, arg);
                    continue;
                }
                this.readOutput(line, arg);
            }
            listOfPlugins.add(plugin);
        }
        if (!doSort) {
            return;
        }
        Hashtable<String, PluginArgsDB> table = new Hashtable<String, PluginArgsDB>();
        Vector<String> names = new Vector<String>();
        int numPlugins = listOfPlugins.size();
        for (int n = 0; n < numPlugins; ++n) {
            PluginArgsDB plugin = listOfPlugins.elementAt(n);
            table.put(plugin.name, plugin);
            names.add(plugin.name);
        }
        listOfPlugins.clear();
        String[] sorted = TextUtils.sortByAlpha(VectorUtils.toStringArray(names));
        if (sorted == null) {
            return;
        }
        for (int n = 0; n < sorted.length; ++n) {
            String name = sorted[n];
            listOfPlugins.add((PluginArgsDB)table.get(name));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < rpsPatts.size(); ++n) {
            PluginArgsDB p = rpsPatts.elementAt(n);
            buf.append(p.toString());
        }
        return buf.toString();
    }

    private boolean isParamBegin(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length >= 2 && tokens[0].equalsIgnoreCase("param");
    }

    private boolean isParamEnd(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length > 0 && tokens[0].startsWith("/param");
    }

    private void readParam(String str, PluginArg arg) {
        if (str == null || str.trim().length() == 0 || arg == null) {
            return;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        while (!s.equals("")) {
            if ((s.equalsIgnoreCase("name") || s.equalsIgnoreCase("type") || s.equalsIgnoreCase("default") || s.equalsIgnoreCase("tag")) && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                String value = tok.getNextStr();
                if (!value.equals("")) {
                    arg.set(s, value);
                }
            }
            s = tok.getNextStr();
        }
    }

    private void readOutput(String str, PluginArg arg) {
        if (str == null || str.trim().length() == 0 || arg == null) {
            return;
        }
        Tokenizer tok = new Tokenizer();
        tok.setDefaultDelimitors();
        str = str.replace('<', ' ');
        str = str.replace('>', ' ');
        str = str.replace('/', ' ');
        str = TextUtils.replace(str, "=", " = ");
        tok.setBuffer(str);
        tok.addQuotation("\"", "\"", '\\');
        tok.setSyntaxLength(2);
        String s = tok.getNextStr();
        if (s.equalsIgnoreCase("output") || s.equalsIgnoreCase("tag")) {
            s = tok.getNextStr();
        }
        while (!s.equals("")) {
            String value;
            if (s.equalsIgnoreCase("tag") && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                value = tok.getNextStr();
                String[] values = TextUtils.tokenize(value, '|');
                values = TextUtils.removeQuotes(values);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        arg.set("value", values[i]);
                    }
                }
            } else if ((s.equalsIgnoreCase("name") || s.equalsIgnoreCase("value")) && tok.peekNextStr().equals("=")) {
                tok.getNextStr();
                value = tok.getNextStr();
                if (!value.equals("")) {
                    arg.set(s, value);
                }
            }
            s = tok.getNextStr();
        }
    }

    private boolean isOutputBegin(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length >= 2 && tokens[0].equalsIgnoreCase("output");
    }

    private boolean isOutputEnd(String str) {
        String[] tokens = TextUtils.tokenize(str, "< =");
        return tokens.length > 0 && tokens[0].startsWith("/output");
    }

    public class PluginArgsDB {
        public String menuName = "";
        public String name = "";
        public String type = "";
        int handleCount = 1;
        File srcArgFile = null;
        String description = "no help in .args file";
        String pathToPlugin = null;
        public boolean useAsSeparator = false;
        public Vector<PluginArg> inputs = new Vector();
        public Vector<PluginArg> outputs = new Vector();

        public String getMenuName() {
            return this.menuName.equals("") ? this.name : this.menuName;
        }

        public PluginArgsDB(String type, File argfile) {
            this.type = type;
            if (type.equals("-")) {
                this.useAsSeparator = true;
            } else {
                this.name = TextUtils.removeExtension(argfile.getName());
                this.srcArgFile = argfile;
            }
        }

        public void add(PluginArg arg) {
            if (arg != null && arg.isInput) {
                this.inputs.add(arg);
            } else {
                this.outputs.add(arg);
            }
        }

        public String[] getAllOutputTypes() {
            Vector<String> out = new Vector<String>();
            for (int n = 0; n < this.outputs.size(); ++n) {
                PluginArg arg = this.outputs.elementAt(n);
                for (int i = 0; i < arg.out_types.size(); ++i) {
                    out.add(arg.out_types.elementAt(i));
                }
            }
            return VectorUtils.toStringArray(out);
        }

        public void pathToPlugin(String path) {
            this.pathToPlugin = path;
        }

        public String getRibStatement(int tabs) {
            int n;
            String texdir;
            String tab = "";
            for (int n2 = 0; n2 < tabs; ++n2) {
                tab = tab + "\t";
            }
            Vector<PluginArg> temp = new Vector<PluginArg>();
            PluginArg manifoldArg = null;
            for (int n3 = 0; n3 < this.inputs.size(); ++n3) {
                PluginArg arg = this.inputs.elementAt(n3);
                if (arg.datatype.equalsIgnoreCase("struct")) {
                    Cutter.setLog("    Debug:Ris21PluginArgsReader.getRibStatement() - found struct name " + arg.name);
                }
                if (arg.name.equalsIgnoreCase("manifold")) {
                    manifoldArg = arg;
                    continue;
                }
                temp.add(arg);
            }
            if (manifoldArg != null) {
                temp.add(manifoldArg);
            }
            this.inputs = temp;
            StringBuffer buf = new StringBuffer();
            if (this.type.equals("Displace")) {
                buf.append("Attribute \"displacementbound\" \"float sphere\" [0.1]\n");
            }
            if (this.type.equals("Pattern") && (this.name.equals("PxrTexture") || this.name.equals("PxrMayaFile"))) {
                texdir = Preferences.get(Preferences.PATH_USER_TEXTURES);
                buf.append("# txmake -mode periodic ../tiffs/name.tif ").append(texdir).append("/name.tex\n");
            }
            if (this.type.equals("Light") && this.name.equals("PxrDomeLight")) {
                texdir = Preferences.get(Preferences.PATH_USER_TEXTURES);
                buf.append("# txmake -envlatl ../tiffs/name.hdr ").append(texdir).append("/name.env.tex\n");
            }
            String ribname = " \"" + this.name + "\" ";
            if (this.pathToPlugin != null && this.pathToPlugin.length() > 0) {
                ribname = this.pathToPlugin.endsWith("/") ? " \"" + this.pathToPlugin + this.name + "\" " : " \"" + this.pathToPlugin + "/" + this.name + "\" ";
            }
            String handle = "\"" + this.name + this.handleCount + "\"\n";
            buf.append(tab).append(this.type).append(ribname).append(handle);
            for (n = 0; n < this.inputs.size(); ++n) {
                String cmntChar = "";
                String preCmnt = "";
                String postCmnt = "";
                PluginArg arg = this.inputs.elementAt(n);
                String defaultValue = arg.dvalue;
                if (arg.datatype.equals("string") && defaultValue.equals("")) {
                    if (arg.name.equals("notes")) continue;
                    defaultValue = "\"\"";
                } else if (arg.datatype.equals("float")) {
                    if (arg.name.equals("inputMaterial") && defaultValue.trim().length() == 0) {
                        buf.append("\t\t#\"float inputMaterial\" []\n");
                        continue;
                    }
                    if (defaultValue.endsWith("f") || defaultValue.endsWith("F")) {
                        defaultValue = defaultValue.substring(0, defaultValue.length() - 1);
                    } else if (defaultValue.endsWith(".")) {
                        defaultValue = defaultValue + "0";
                    } else if (defaultValue.startsWith(".")) {
                        defaultValue = "0" + defaultValue;
                    }
                } else {
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("manifold")) {
                        preCmnt = "\t\t# Examples manifold connection\n\t\t#\"reference struct manifold\" [\"PxrManifold2D1:result\"]\n\t\t#\"reference struct manifold\" [\"PxrManifold3D1:result\"]\n\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("lmlayer")) {
                        preCmnt = "\t\t# Examples of mixer and layer connections\n\t\t#\"reference struct lmlayer\" [\"PxrLMMixer1:result\"]\n\t\t#\"reference struct lmlayer\" [\"PxrLMLayer1:result\"]\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct") && arg.name.equalsIgnoreCase("manifoldN")) {
                        preCmnt = "\t\t# Example 3dmanifold connection\n\t\t#\"reference struct manifoldN\" [\"PxrManifold3DN1:result\"]\n";
                        buf.append(preCmnt);
                        continue;
                    }
                    if (arg.datatype.equals("struct")) {
                        cmntChar = "# ";
                    }
                }
                String arg_decl = preCmnt + cmntChar + "\"" + arg.datatype + " " + arg.name + "\" [";
                if (!arg.datatype.equals("string")) {
                    StringBuffer b = new StringBuffer();
                    for (int j = 0; j < defaultValue.length(); ++j) {
                        if (defaultValue.charAt(j) == 'f') continue;
                        b.append(defaultValue.charAt(j));
                    }
                    defaultValue = b.toString();
                }
                if (arg.datatype.equals("string") && defaultValue.length() > 0) {
                    if (!defaultValue.startsWith("\"")) {
                        defaultValue = "\"" + defaultValue;
                    }
                    if (!defaultValue.endsWith("\"")) {
                        defaultValue = defaultValue + "\"";
                    }
                }
                buf.append("\t\t").append(arg_decl).append(defaultValue).append("]" + postCmnt + "\n");
            }
            for (n = 0; n < this.outputs.size(); ++n) {
                PluginArg arg = this.outputs.elementAt(n);
                String types = this.formatOutTypes(arg);
                buf.append("\t\t# \"").append(this.name + this.handleCount + ":").append(arg.name).append("\"    uses->").append(types).append(" \n");
            }
            ++this.handleCount;
            return buf.toString();
        }

        private String formatOutTypes(PluginArg arg) {
            if (arg == null) {
                return "ERROR";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("|");
            for (int n = 0; n < arg.out_types.size(); ++n) {
                buf.append(arg.out_types.elementAt(n)).append("|");
            }
            return buf.toString();
        }
    }

    private class PluginArg {
        public String name = "";
        public String dvalue = "";
        public String datatype = "";
        public Vector<String> out_types = new Vector();
        public boolean isInput = true;

        public PluginArg(boolean isInput) {
            this.isInput = isInput;
        }

        public void set(String item, String itemValue) {
            if (!this.isInput) {
                // empty if block
            }
            itemValue = TextUtils.removeQuotes(itemValue);
            if (item.equals("name")) {
                if (this.name.trim().length() == 0) {
                    this.name = itemValue.trim();
                }
            } else if (item.equals("default")) {
                if (this.dvalue.trim().length() == 0) {
                    this.dvalue = itemValue.trim();
                }
            } else if (item.equals("type")) {
                this.datatype = itemValue.trim();
            }
            if (item.equals("value") && !this.isInput) {
                this.out_types.add(itemValue.trim());
            }
        }
    }

    private class PMenuItem
    extends JMenuItem {
        private MultiLineToolTip tip;

        public PMenuItem(String s) {
            super(s);
            this.tip = null;
        }

        @Override
        public JToolTip createToolTip() {
            return this.tip;
        }

        @Override
        public void setToolTipText(String tipText) {
            super.setToolTipText(tipText);
            this.tip = new MultiLineToolTip(tipText);
        }
    }
}

