/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Rib.RibScriptHandler;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.RmanMenus;
import UI_Tools.Rman.Tabs.Options.DevkitOptionsTabPanel;
import UI_Tools.Rman.Tabs.Options.RibOptionsTabPanel;
import UI_Tools.Rman.Tabs.Osl.OslTabPanel;
import UI_Tools.Rman.Tabs.Rib.RibTabPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DesktopManager;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class RmanTool
extends RmanMenus
implements RenderInfoListener {
    private static boolean NOLINT = false;
    public static int LEFT = 5;
    private static final String UNKNOWNTAB = "unknown";
    private static final String RIBTAB = "Rib";
    private static final String OSLTAB = "Osl";
    private static final String ENVTAB = "Options";
    private static final String ENV_RIB_TAB_NAME = "Rendering";
    private static final String ENV_DEVKIT_TAB_NAME = "Devkit";
    private static final int UNKNOWNTAB_INDEX = -1;
    private static final int RIB_TAB_INDEX = 0;
    private static final int SHAD_LANG_TAB_INDEX = 1;
    private static final int ENV_TAB_INDEX = 2;
    private static final int ENV_RIB_TAB_INDEX = 3;
    private static final int ENV_RSL_TAB_INDEX = 4;
    private static KTabbedPane tabbedPane = new KTabbedPane();
    private static KTabbedPane optionsTab = new KTabbedPane();
    private static DevkitOptionsTabPanel shadingOptionsTabPanel = new DevkitOptionsTabPanel();
    private static RibOptionsTabPanel ribOptionsTabPanel = new RibOptionsTabPanel();
    private static RibTabPanel ribTabPanel;
    private static OslTabPanel oslTabPanel;
    public static boolean init;
    public static RmanTool tool;
    public static String RENDER_MODE_RIS;
    public static String RENDER_MODE_REYES;
    private static String renderMode;
    private static String RMAN_TOOL;
    private static boolean RMSROOTNotSetWarningShown;

    @Override
    public JMenu getMenuWithName(String name) {
        return super.getMenuWithName(name);
    }

    public static RmanTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new RmanTool(menuItem);
        return tool;
    }

    public static RmanTool getTool() {
        return tool;
    }

    private RmanTool(JMenuItem menuItem) {
        super(RMAN_TOOL, menuItem, Preferences.TOOL_RENDERMAN);
        String rend = RenderInfo.activeNameOfRenderer();
        if (RenderInfo.activeNameOfRendererIs(RenderInfo.PRMAN)) {
            rend = rend + " " + RenderInfo.prmanVersion();
        }
        if (rend != null && rend.trim().length() > 0) {
            this.setTitle(RMAN_TOOL + " [" + rend + "]");
        }
        ribTabPanel = new RibTabPanel();
        oslTabPanel = new OslTabPanel();
        this.setVisible(false);
        RenderInfo.addListener(this);
        Dimension paneSize = KAbstractDesktop.desktopPane.getSize();
        DesktopManager manager = KAbstractDesktop.desktopPane.getDesktopManager();
        manager.setBoundsForFrame(this, paneSize.width - 230, 0, 100, 400);
        tabbedPane.addTab(RIBTAB, ribTabPanel);
        boolean usingRIS = true;
        tabbedPane.addTab(OSLTAB, oslTabPanel);
        tabbedPane.addTab(ENVTAB, optionsTab);
        optionsTab.addTab(ENV_RIB_TAB_NAME, ribOptionsTabPanel);
        optionsTab.addTab(ENV_DEVKIT_TAB_NAME, shadingOptionsTabPanel);
        this.contentPane.add((Component)tabbedPane, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.adjustUI(0);
        this.pack();
        String rismode = "true";
        RmanTool.updateUI(rismode.equals("true") ? RENDER_MODE_RIS : RENDER_MODE_REYES);
        init = true;
        this.setInitialPosition();
        this.setVisible(false);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
                int index = tabbedPane.getSelectedIndex();
                RmanTool.this.adjustUI(index);
            }
        });
        optionsTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JTabbedPane optionsTab = (JTabbedPane)e.getSource();
                int index = optionsTab.getSelectedIndex();
                RmanTool.this.adjustUI(index + 3);
            }
        });
    }

    public static void updateUI(String render_mode) {
        renderMode = render_mode;
    }

    public void setRslTab() {
        this.adjustUI(1);
        tabbedPane.setSelectedIndex(2);
    }

    public void setOslTab() {
        this.adjustUI(1);
        tabbedPane.setSelectedIndex(2);
    }

    @Override
    protected void adjustUI(int tabIndex) {
        boolean callapsed;
        block12: {
            if (tabbedPane.getTabCount() == 1) {
                return;
            }
            callapsed = this.isCallapsed();
            if (callapsed) {
                tabbedPane.setVisible(false);
            }
            boolean usingRIS = true;
            try {
                switch (tabIndex) {
                    case 0: {
                        tabbedPane.setComponentAt(1, new JPanel());
                        tabbedPane.setComponentAt(2, new JPanel());
                        tabbedPane.setComponentAt(0, ribTabPanel);
                        RibTabPanel.setRenderButtonLabel(RenderInfo.get(3));
                        tabbedPane.setSelectedIndex(tabIndex);
                        break;
                    }
                    case 1: {
                        tabbedPane.setComponentAt(0, new JPanel());
                        tabbedPane.setComponentAt(2, new JPanel());
                        tabbedPane.setComponentAt(1, oslTabPanel);
                        tabbedPane.setTitleAt(1, OSLTAB);
                        tabbedPane.setSelectedIndex(tabIndex);
                        break;
                    }
                    case 2: {
                        tabbedPane.setComponentAt(1, new JPanel());
                        tabbedPane.setComponentAt(0, new JPanel());
                        tabbedPane.setComponentAt(2, optionsTab);
                        tabbedPane.setSelectedIndex(tabIndex);
                        break;
                    }
                    case 3: {
                        optionsTab.setComponentAt(1, new JPanel());
                        optionsTab.setComponentAt(0, ribOptionsTabPanel);
                        optionsTab.setSelectedIndex(0);
                        break;
                    }
                    case 4: {
                        optionsTab.setComponentAt(0, new JPanel());
                        optionsTab.setComponentAt(1, shadingOptionsTabPanel);
                        optionsTab.setSelectedIndex(1);
                    }
                }
                tabbedPane.setVisible(true);
                this.pack();
            }
            catch (Exception ex) {
                if (!Cutter.input.debug) break block12;
                Cutter.setLog("    Exception:RmanTool.adjustUI() - " + ex.toString());
            }
        }
        if (callapsed) {
            this.callapseWindow(true);
        }
    }

    @Override
    protected void saveSelf() {
        ribOptionsTabPanel.saveSelf();
        shadingOptionsTabPanel.saveSelf();
        super.saveSelf();
    }

    public boolean isRenderFlagsActive() {
        return ribOptionsTabPanel.isRenderFlagsActive();
    }

    public String getRenderFlags() {
        return ribOptionsTabPanel.getRenderFlags();
    }

    @Override
    protected void initDynamicDesktopPosition() {
        this.dynamicDesktopPosition = 1;
    }

    @Override
    protected void setBounds(DesktopManager manager, Dimension desk, Dimension tool) {
        manager.setBoundsForFrame(this, desk.width - tool.width, 0, tool.width, tool.height);
    }

    public static String getNameOfActiveTab() {
        if (tabbedPane.getSelectedComponent() == ribTabPanel) {
            return RIBTAB;
        }
        return UNKNOWNTAB;
    }

    @Override
    protected void toolSelectionHappened() {
        this.grabFocus();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String _docname) {
        if (tool != null && (_docname.endsWith(".sl") || _docname.endsWith(".rib"))) {
            RibTabPanel.renderButton.setEnabled(true);
        } else {
            RibTabPanel.renderButton.setEnabled(false);
        }
        boolean usingRIS = true;
        if (_docname.endsWith(".sl") && tool != null && !usingRIS) {
            this.adjustUI(1);
            return;
        }
        if (_docname.endsWith(".osl") && tool != null && usingRIS) {
            this.adjustUI(1);
            return;
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    Cutter.setLog("    Exception:RmanTools.adjustUI() - " + e.toString());
                }
                String docname = BBxt.getWindowTitle();
                if (!docname.endsWith(".rib") && !docname.endsWith(".key") || tool == null) {
                    return;
                }
                String[] data = RibScriptHandler.getDisplayDriver();
                boolean rendererChanged = false;
                if (data == null) {
                    if (RenderInfo.autoSetRenderer) {
                        // empty if block
                    }
                    RmanTool.this.adjustUI(0);
                    return;
                }
                String imgName = data[0];
                String driver = data[1];
                if (driver.equals("shadow")) {
                    RmanTool.this.adjustUI(0);
                    return;
                }
                if (driver.equals("dsm") || driver.equals("idisplay")) {
                    RmanTool.autoSetRenderer("3delight", false);
                    RmanTool.this.adjustUI(0);
                } else if (driver.equals("it")) {
                    RmanTool.autoSetRenderer("pixar", false);
                    RmanTool.this.adjustUI(0);
                } else {
                    RmanTool.autoSetRenderer(Preferences.RENDERER_DEFAULT, false);
                    RmanTool.this.adjustUI(0);
                }
            }
        };
        runner.start();
    }

    public static void autoSetRenderer(int rendererID, boolean force) {
        RmanTool.autoSetRenderer(Preferences.get(rendererID), force);
    }

    public static void autoSetRenderer(String rendererStr, boolean force) {
        if (!force && !RenderInfo.autoSetRenderer) {
            return;
        }
        if (RenderInfo.activeRendererIs(rendererStr)) {
            return;
        }
        Cutter.setLog("    Info:RmanTools.setRenderer() - setting " + rendererStr);
        RenderInfo.init();
        RenderInfo.setActiveRender(rendererStr);
        String style = RenderInfo.getRendererDataTypeStyle();
        RenderInfo.setDataTypeStyle(style);
        RenderInfo ri2 = RenderInfo.getActiveRender();
        RenderInfo.notifyListeners(ri2);
    }

    private static void RMSROOTNotSetWarning() {
        if (RMSROOTNotSetWarningShown) {
            return;
        }
        JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The rib file you are rendering references an environment\nvariable named \"RMSTREE\" that has not been set on this\ncomputer.\nLinux/OSX\n    Add the following line to your Cutter startup file\n    (generally named run.sh).\n        RMSTREE=RENDERMAN_FOR_MAYA_PATH (bash shell)\n        set RMSTREE=RENDERMAN_FOR_MAYA_PATH (tcsh shell)\n        java -classpath .:cutter.jar Cutter\nWindows\n    Add the following line to your Cutter startup\n    file (generally named run.bat)\n        set RMSTREE RENDERMAN_FOR_MAYA_PATH\n        java -classpath .;cutter.jar Cutter\n\nThis message will only appear once.\n\n", "RMSTREE Environment Variable Not Set", 2);
        RMSROOTNotSetWarningShown = true;
    }

    @Override
    public void renderInfoChanged(RenderInfo info) {
        if (info == null) {
            return;
        }
        String rend = RenderInfo.activeNameOfRenderer();
        if (RenderInfo.activeNameOfRendererIs(RenderInfo.PRMAN)) {
            rend = rend + " " + RenderInfo.prmanVersion();
        }
        this.setTitle(RMAN_TOOL + " [" + rend + "]");
    }

    static {
        init = false;
        tool = null;
        RENDER_MODE_RIS = "RIS";
        RENDER_MODE_REYES = "Reyes";
        renderMode = "";
        RMAN_TOOL = "Rman Tool";
        RMSROOTNotSetWarningShown = false;
    }
}

