/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Options;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RmanTool;
import UI_Tools.Rman.Tabs.Options.subpanels.DatatypePanel;
import UI_Tools.Rman.Tabs.Options.subpanels.RenderFlagsPanel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;

public class RibOptionsTabPanel
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    private KTitledPanel keyframerPanel = new KTitledPanel(" KeyFramer ", "RmanTool.KeyframerPanel.info");
    private KTitledPanel shadowPanel = new KTitledPanel(" Shadow Options ", "RmanTool.ShadowPanel.info");
    private JRadioButton singleRibButton = new JRadioButton("single multi-frame rib");
    private JRadioButton multiRibsButton = new JRadioButton("multiple numbered ribs");
    private ButtonGroup ribTypeGroup = new ButtonGroup();
    private KTitledComboBox shadowSizeCombo = new KTitledComboBox("map size ", 2);
    private boolean linuxOnly_ignoreItemEvent_SELECTED = true;
    public JButton renderButton = new JButton(RenderInfo.get(3));
    private RenderFlagsPanel renderFlagsPanel = new RenderFlagsPanel();
    private DatatypePanel dataTypePanel = new DatatypePanel();

    public RibOptionsTabPanel() {
        this.contentPanel.add(this.renderFlagsPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(this.keyframerPanel, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(this.dataTypePanel, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, 0, 2, 0)));
        this.contentPanel.add(this.shadowPanel, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, 0, 5, 0)));
        this.keyframerPanel.add(this.singleRibButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT, -2, 0)));
        this.keyframerPanel.add(this.multiRibsButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(-2, RmanTool.LEFT, 0, 0)));
        this.ribTypeGroup.add(this.singleRibButton);
        this.ribTypeGroup.add(this.multiRibsButton);
        this.singleRibButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.KEYFRAMER_RIB_SINGLE, "true");
            }
        });
        this.multiRibsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.write(Preferences.KEYFRAMER_RIB_SINGLE, "false");
            }
        });
        String singleStr = Preferences.get(Preferences.KEYFRAMER_RIB_SINGLE);
        if (singleStr.equals("true")) {
            this.singleRibButton.setSelected(true);
        } else {
            this.multiRibsButton.setSelected(true);
        }
        String[] mapSize = new String[]{"32", "64", "128", "256", "512", "1024", "2048", "4096", "8192"};
        this.shadowSizeCombo.addItem(mapSize);
        this.shadowSizeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RmanTool.init) {
                    return;
                }
                String str = RibOptionsTabPanel.this.shadowSizeCombo.getSelectedItem().toString();
                Preferences.write(Preferences.RENDERER_SHADOW_SIZE, str);
            }
        });
        String str = Preferences.get(Preferences.RENDERER_SHADOW_SIZE);
        int index = 1;
        if (!str.equals("") && Integer.parseInt(str) > 4096) {
            for (int n = 13; n <= 15; ++n) {
                if (Math.abs((int)Math.pow(2.0, n) - Integer.parseInt(str)) >= 768) continue;
                this.shadowSizeCombo.addItem((int)Math.pow(2.0, n) + "");
                index = 5;
                this.shadowSizeCombo.combo.setSelectedIndex(index);
            }
        } else if (!str.equals("")) {
            for (int n = 0; n < mapSize.length; ++n) {
                if (mapSize[n].compareTo(str) != 0) continue;
                index = n;
            }
            this.shadowSizeCombo.combo.setSelectedIndex(index);
        }
        this.shadowSizeCombo.combo.setPreferredSize(new Dimension(70, 20));
        this.shadowPanel.add(this.shadowSizeCombo, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, RmanTool.LEFT + 5, 2, 0)));
    }

    public boolean isRenderFlagsActive() {
        return this.renderFlagsPanel.flagsGui.checkbox.isSelected();
    }

    public String getRenderFlags() {
        return this.renderFlagsPanel.flagsGui.textfield.getText();
    }

    public void saveSelf() {
        Preferences.write(Preferences.KEYFRAMER_RIB_SINGLE, this.singleRibButton.isSelected() ? "true" : "false");
        this.dataTypePanel.saveSelf();
        this.renderFlagsPanel.saveSelf();
    }

    @Override
    public String getName() {
        return "RibOptionsTabPanel";
    }
}

