/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Options.subpanels;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.RmanTool;
import Utilities.NumberUtils;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class DatatypePanel
extends KTitledPanel
implements RenderInfoListener {
    private static final long serialVersionUID = 1L;
    private JRadioButton dataTypeDeclareButton = new JRadioButton("declare datatypes");
    private JRadioButton dataTypeInlineButton = new JRadioButton("inline datatypes");
    private JRadioButton dataTypeIgnoreButton = new JRadioButton("omit datatypes");
    private ButtonGroup dataTypeGroup = new ButtonGroup();
    private KTitledComboBox decimalCombo = new KTitledComboBox("decimal accuracy ", 2);

    public DatatypePanel() {
        super(" Datatypes & Precision ", "RmanTool.OptionsPanel.info");
        RenderInfo.addListener(this);
        this.decimalCombo.combo.setPreferredSize(new Dimension(50, 20));
        this.decimalCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RmanTool.init) {
                    return;
                }
                String str = DatatypePanel.this.decimalCombo.getSelectedItem().toString();
                NumberUtils.decimalPlaces = Integer.parseInt(str);
                Preferences.write(Preferences.TOOL_RENDERMAN_PRECISION_DECIMALPLACES, str);
            }
        });
        this.decimalCombo.addItem(new String[]{"2", "3", "4", "5", "6"});
        this.decimalCombo.setSelectedItem(Preferences.get(Preferences.TOOL_RENDERMAN_PRECISION_DECIMALPLACES));
        this.add(this.dataTypeInlineButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT, -2, 0)));
        this.add(this.dataTypeDeclareButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(-2, RmanTool.LEFT, -2, 0)));
        this.add(this.dataTypeIgnoreButton, new GBC(0, 2, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(-2, RmanTool.LEFT, 5, 0)));
        this.add(this.decimalCombo, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT + 5, 2, 35)));
        this.dataTypeInlineButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderInfo.setDataTypeStyle("inline");
                Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "inline");
            }
        });
        this.dataTypeDeclareButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderInfo.setDataTypeStyle("declare");
                Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "declare");
            }
        });
        this.dataTypeIgnoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderInfo.setDataTypeStyle("omit");
                Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "omit");
            }
        });
        String dataTypeStyle = Preferences.get(Preferences.RENDERER_SHADER_DATATYPE);
        RenderInfo.setDataTypeStyle(dataTypeStyle);
        this.dataTypeGroup.add(this.dataTypeInlineButton);
        this.dataTypeGroup.add(this.dataTypeDeclareButton);
        this.dataTypeGroup.add(this.dataTypeIgnoreButton);
        if (RenderInfo.getDataTypeStyle().equals("omit")) {
            this.dataTypeIgnoreButton.setSelected(true);
        } else if (RenderInfo.getDataTypeStyle().equals("declare")) {
            this.dataTypeDeclareButton.setSelected(true);
        } else {
            this.dataTypeInlineButton.setSelected(true);
        }
    }

    @Override
    public void updateUI() {
    }

    @Override
    public void renderInfoChanged(RenderInfo info) {
        if (info == null) {
            return;
        }
        if (RenderInfo.getDataTypeStyle().equals("omit")) {
            this.dataTypeIgnoreButton.setSelected(true);
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "omit");
        } else if (RenderInfo.getDataTypeStyle().equals("declare")) {
            this.dataTypeDeclareButton.setSelected(true);
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "declare");
        } else {
            this.dataTypeInlineButton.setSelected(true);
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "inline");
        }
    }

    public void saveSelf() {
        if (this.dataTypeInlineButton.isSelected()) {
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "inline");
        } else if (this.dataTypeDeclareButton.isSelected()) {
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "declare");
        } else {
            Preferences.write(Preferences.RENDERER_SHADER_DATATYPE, "omit");
        }
    }
}

