/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Options.subpanels;

import Preferences.Preferences;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Rman.RmanTool;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class OsoDuplicationPanel
extends KTitledPanel
implements ItemListener {
    private CopyToCB copyToCB = new CopyToCB();

    public OsoDuplicationPanel() {
        super(" Osl Shader Duplication ", "RmanTool.OslDupShdPanel.info");
        this.copyToCB.checkbox.addItemListener(this);
        this.add(this.copyToCB, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT, 0, 3)));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!RmanTool.init) {
            return;
        }
        int state = e.getStateChange();
        Object src = e.getSource();
        if (src == this.copyToCB.checkbox) {
            if (state != 1) {
                this.copyToCB.textfield.setEnabled(false);
                return;
            }
            this.copyToCB.textfield.setEnabled(true);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenFileDialog openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
                    File oldPrevFile = openFileDialog.getPrevFile();
                    File newPrevFile = null;
                    String dirPath = ((OsoDuplicationPanel)OsoDuplicationPanel.this).copyToCB.textfield.getText();
                    File tmp = FileUtils.getParentDirFromPath(dirPath);
                    newPrevFile = dirPath.trim().length() == 0 ? FileUtils.getPWDFile() : (tmp != null && tmp.exists() ? tmp : FileUtils.getExistingParent(tmp));
                    if (newPrevFile == null) {
                        newPrevFile = FileUtils.getPWDFile();
                    }
                    openFileDialog.setCurrentDirectory(newPrevFile);
                    File[] files = openFileDialog.showSelf(null, "Choose Directory", 1);
                    openFileDialog.setPrevFile(oldPrevFile);
                    if (files == null) {
                        return;
                    }
                    File f = FileUtils.getExistingParent(files[0]);
                    ((OsoDuplicationPanel)OsoDuplicationPanel.this).copyToCB.textfield.setText(FileUtils.applyFileSeparator(f.getPath()));
                }
            });
        }
    }

    public void saveSelf() {
        Preferences.write(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION, this.copyToCB.checkbox.isSelected() ? "true" : "false");
        String path = this.copyToCB.textfield.getText();
        Preferences.write(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH, path);
    }

    private class CopyToCB
    extends JPanel {
        public JCheckBox checkbox = new JCheckBox("dest ");
        public KTextField textfield = new KTextField("", 10);

        public CopyToCB() {
            this.textfield.usesModelDialog = true;
            this.setLayout(new GridBagLayout());
            this.add((Component)this.checkbox, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(-1, 0, 0, 2)));
            this.add((Component)this.textfield, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(-1, 5, 0, 0)));
            String b = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION);
            this.checkbox.setSelected(b.equals("true"));
            String path = Preferences.get(Preferences.TOOL_RENDERMAN_OSO_DUPLICATION_PATH);
            this.textfield.setText(path);
            this.textfield.setEnabled(this.checkbox.isSelected());
            this.textfield.setUsesModelDialog(true);
            if (!this.checkbox.isSelected()) {
                this.textfield.setEnabled(false);
            }
        }
    }
}

