/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Options.subpanels;

import UI_Components.GBC;
import UI_Components.KTextField.KTextField;
import UI_Components.KTitledPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.RmanTool;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class RenderFlagsPanel
extends KTitledPanel
implements ItemListener,
RenderInfoListener {
    private static final long serialVersionUID = 1L;
    public FlagsGui flagsGui = new FlagsGui();
    private JCheckBox deferRenderCB = new JCheckBox("defer rendering");

    public RenderFlagsPanel() {
        super(" Renderer ", "RmanTool.RendererPanel.info");
        this.flagsGui.checkbox.addItemListener(this);
        this.deferRenderCB.addItemListener(this);
        this.deferRenderCB.setEnabled(true);
        this.add(this.flagsGui, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT, 0, 0)));
        this.add(this.deferRenderCB, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 2, new Insets(0, RmanTool.LEFT, 3, 0)));
        RenderInfo.addListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!RmanTool.init) {
            return;
        }
        int state = e.getStateChange();
        Object src = e.getSource();
        if (src == this.deferRenderCB) {
            RenderInfo.setDeferRender(state == 1);
        } else if (src == this.flagsGui.checkbox) {
            boolean enabled = this.flagsGui.checkbox.isSelected();
            this.flagsGui.textfield.setEnabled(enabled);
            RenderInfo.setUserFlags(10, TextUtils.tokenize(this.flagsGui.textfield.getText()), enabled);
        }
    }

    public void saveSelf() {
    }

    @Override
    public void renderInfoChanged(RenderInfo info) {
        Vector<String> flags = RenderInfo.getUserFlags(10);
        String str = VectorUtils.vectorToSpacedString(flags);
        this.flagsGui.textfield.setText(str);
        String s = RenderInfo.get(22);
        this.flagsGui.checkbox.setSelected(s.equals("true"));
    }

    public class FlagsGui
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JCheckBox checkbox = new JCheckBox("flags");
        public KTextField textfield = new KTextField(11);

        public FlagsGui() {
            this.textfield.usesModelDialog = true;
            this.setLayout(new GridBagLayout());
            this.add((Component)this.checkbox, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(-1, 0, 0, 4)));
            this.add((Component)this.textfield, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(-1, 13, 0, 0)));
            String f = RenderInfo.get(22);
            this.checkbox.setSelected(f.equals("true"));
            this.textfield.setEnabled(this.checkbox.isSelected());
            Vector<String> v = RenderInfo.getUserFlags(10);
            if (v != null && v.size() > 0) {
                this.textfield.setText(VectorUtils.vectorToSpacedString(v));
            }
            this.textfield.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    RenderInfo.setUserFlags(10, TextUtils.tokenize(FlagsGui.this.textfield.getText()), FlagsGui.this.checkbox.isSelected());
                }
            });
        }
    }
}

