/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Osl;

import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButtonBorder;
import UI_Components.KComboItem;
import UI_Components.KTitledKComboItemBox;
import UI_Desktop.Cutter;
import UI_Script.ScriptHandler;
import UI_Script.ScriptRegistry;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.Resources.OSLToolTips;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;

public class OslTabPanel
extends PrefsPanel
implements RenderInfoListener {
    public static int LEFT = 10;
    private static ResourceBundle oslRsrc;
    public static JButton compileButton;

    public OslTabPanel() {
        String[] popupnames = TextUtils.tokenize(KTools.getResourceString(oslRsrc, "popupnames"));
        int n = 0;
        for (n = 0; n < popupnames.length && n < 20; ++n) {
            String name = KTools.getResourceString(oslRsrc, popupnames[n]);
            KTitledKComboItemBox combo = new KTitledKComboItemBox(popupnames[n]);
            combo.addActionListener(combo);
            String[] items = TextUtils.tokenize(name);
            for (int i = 0; i < items.length; ++i) {
                int index;
                String actionText = KTools.getResourceString(oslRsrc, items[i]);
                if (actionText == null) {
                    Cutter.setLog("    Error:OslTabPanel.OslTabPanel() - got null for " + name + " item " + i);
                    actionText = "";
                }
                String string = actionText = (index = actionText.indexOf("/")) == -1 ? actionText : actionText.substring(0, index);
                if (!actionText.endsWith("\n")) {
                    actionText = actionText + "\n";
                }
                KComboItem combo_item = new KComboItem(items[i], actionText);
                combo.addItem(combo_item);
            }
            combo.setMaximumRowCount(items.length);
            this.contentPanel.add(combo, new GBC(0, n, 1, 1, 1.0, 1.0, 1, 0, 18, 2, new Insets(0, 0, 1, 5)));
            String[] tips = OSLToolTips.getStringsFor(popupnames[n]);
            if (tips == null) continue;
            String[] formatted = new String[tips.length];
            for (int k = 0; k < tips.length; ++k) {
                formatted[k] = TextUtils.formatAsHtml(tips[k], 40, 100);
            }
            combo.addToolTips(tips);
        }
        compileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                KAbstractWindow window = BBxt.frontWindow();
                if (window == null) {
                    return;
                }
                if (window.getTouched() || window.getFile() == null) {
                    window.saveFile();
                    if (window.getFile() == null) {
                        Cutter.setLog("    Warning:OslTabPanel.compileButton.addActionListener() - cannot compile an unsaved rsl document.");
                        return;
                    }
                }
                if (window instanceof KTextWindow) {
                    File f = window.getFile();
                    ScriptHandler handler = ScriptRegistry.getHandlerForFile(f);
                    if (handler == null) {
                        Cutter.setLog("    Error: OslTabPanel.compileButton.actionPerformed() - cannot get script handler");
                        return;
                    }
                    handler.execute(f);
                } else {
                    Cutter.setLog("    Error: RmanTools.OSL compileButton.actionPerformed() - front window is not a KTextWindow?");
                }
            }
        });
        KButtonBorder.addBorderTo(compileButton, 3, 10, 3, 10);
        this.buttonPanel.add((Component)compileButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 1, 1, 10, 0, new Insets(15, 17, 10, 0)));
        this.contentPanel.add(this.buttonPanel, new GBC(0, n, 1, 1, 1.0, 1.0, 1, 1, 18, 2, new Insets(5, 0, 1, 5)));
    }

    public static void setCompileButtonLabel(String str) {
        compileButton.setText(str);
    }

    @Override
    public String getName() {
        return "OslTabPanel";
    }

    @Override
    public void focusDefaultField() {
        compileButton.grabFocus();
    }

    @Override
    public void renderInfoChanged(RenderInfo info) {
    }

    static {
        try {
            oslRsrc = ResourceBundle.getBundle("UI_Tools.Rman.Resources.OSLMenuItemsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Exception:OslTabPanel: the menus resource file is missing --> " + mre);
        }
        compileButton = new JButton("oslc");
    }
}

