/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Rib;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_BBXT.BBxt;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Script.Rib.Animation.MultiFramer;
import UI_Script.Rib.RibDocGenerator;
import UI_Script.Rib.RibScriptHandler;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Preferences.PrefsTool;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RmanTool;
import UI_Window.KWindow.KTextWindow;
import Utilities.DialogUtils;
import Utilities.FileSaver;
import Utilities.FileUtils;
import Utilities.MultiRibUtils;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.io.File;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.text.Segment;

public class RenderManager
implements ProcListener {
    private static RenderManager instance = null;
    public static long MAX_COUNT = 100000L;
    public static long f_count = 0L;
    public static float f_min = 1000000.0f;
    public static float f_max = -1000000.0f;
    public static float f_gross = 0.0f;
    private static float[] c_min = new float[]{100000.0f, 100000.0f, 100000.0f};
    private static float[] c_max = new float[]{-100000.0f, -100000.0f, -100000.0f};
    private static float[] c_gross = new float[]{0.0f, 0.0f, 0.0f};
    private static long c_count = 0L;
    private static int scriptType = 0;
    private static String initialMessage = "";
    public static String RENDERING_STANDARD_SHADOW = "Rendering standard shadow pass\n";
    public static String RENDERING_DEEP_SHADOW = "Rendering deep shadow pass\n";
    private static String preRibPath = null;
    private int count = 1;

    public static RenderManager getInstance() {
        if (instance == null) {
            new RenderManager();
        }
        return instance;
    }

    private RenderManager() {
        instance = this;
    }

    public static void doRender(File file) {
        Segment segment;
        String rpspath = RenderInfo.getRPSPath();
        String rmspath = RenderInfo.getRMSPath();
        if (rpspath.trim().length() == 0 || rmspath.trim().length() == 0) {
            PrefsTool.init();
            KTools tool = KTools.getToolWithName("Preferences Tool");
            if (tool != null && tool instanceof PrefsTool) {
                PrefsTool prefsTool = (PrefsTool)tool;
                prefsTool.setVisible(true);
                prefsTool.selectPanel(PrefsTool.rmanTab, "pixar panel");
                String[] msg = new String[]{"The paths to,", "    RPS root (\"RenderManProServer\")", "    RfM root (\"RenderManForMaya\")", "must be set in Preferences.   "};
                DialogUtils.showInfoMessage("Pixar Paths Not Set", msg);
                return;
            }
        }
        if (RenderInfo.autoSetVendorRibOption) {
            RibScriptHandler.setUserOptionVendor(file);
        }
        if ((segment = BBxt.getWindowText(null)) == null) {
            return;
        }
        MultiFramer multiframer = new MultiFramer();
        multiframer.setBuffer(segment);
        RibScriptHandler.checkSearchPaths(file);
        preRibPath = RibScriptHandler.getUserOption(file, "string", "preamble");
        if (preRibPath != null) {
            File preRibFile = null;
            preRibFile = preRibPath.startsWith(".") ? FileUtils.resolveRelativePath(FileUtils.getPWDFile(), preRibPath) : new File(preRibPath);
            preRibPath = preRibFile.getPath();
            if (!preRibFile.exists()) {
                Cutter.setLog("    Error:RenderManager.doRender() - the Option \"user\" \"string preamble\" [\"" + preRibPath + "\"] has been found\n             but the path does not exist. Will not use preamble.\n");
                preRibPath = null;
            } else {
                Cutter.setLog("    Info:RenderManager.doRender() - will use the \"preamble\"\n             " + preRibPath);
            }
        }
        if ((scriptType = multiframer.scriptIsTypeOf()) == 2) {
            File[] files;
            String path = RenderInfo.get(12);
            if (path.trim().equals("")) {
                JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "A \"location\" for your rendered frames has not been specified in\n    Preferences->Rman->User->Rendered Frames->location\n\nEdit your Preferences and try again.\n", "Frames Directory Not Specified Error", 0);
                return;
            }
            File framesDir = new File(path);
            if (!framesDir.exists()) {
                Cutter.setLog("    Info:RenderManager.doRender() - framesDir \"" + framesDir.getPath() + "\"");
                if (!FileUtils.makeDirectories(framesDir)) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "Cutter cannot find a directory called \"frames\" located at\n\"" + RenderInfo.get(12) + "\"\n\nCreate the directory and try again.\n", "Cannot Make Frames Error", 0);
                    return;
                }
                Cutter.setLog("    Info:RenderManager.doRender() - made the frames directory at\n    \"" + framesDir + "\"");
            }
            if ((files = multiframer.generateSequence()) == null) {
                Cutter.setLog("    Error:RenderManager.doRender() - AnimParser.generateAnimation() failed to create a file.");
                return;
            }
            if (RenderInfo.getDeferRender() && files != null && files.length == 1) {
                KTextWindow.addWindow(files[0], true, true, true, true);
                return;
            }
            if (multiframer.usesITDisplayDriver()) {
                // empty if block
            }
            if (files != null && files.length == 1) {
                RenderManager.renderFile(files[0]);
            } else if (files != null && files.length > 1) {
                File scriptDir = files[0].getParentFile();
                RenderManager.renderBatch(files, scriptDir);
            }
            return;
        }
        if ((file == null || BBxt.getFrontWindowFile() == file) && BBxt.isRibDocument()) {
            boolean replaced;
            JEditorPane textpane = BBxt.getTextPane(BBxt.frontWindow());
            if (textpane == null) {
                return;
            }
            if (textpane instanceof KTextPane && (replaced = RibDocGenerator.replaceOptions((KTextPane)textpane))) {
                BBxt.save();
            }
        }
        if ((file == null || BBxt.getFrontWindowFile() == file) && BBxt.getSelectionLength() > 0) {
            StringBuffer buffer = new StringBuffer(BBxt.getSelection());
            buffer.append('\n');
            File tmp = new File("tmp.rib");
            FileSaver ribwriter = new FileSaver(tmp, buffer);
            ribwriter.start();
            RenderManager.renderFile(tmp);
            return;
        }
        RenderManager.renderFile(file);
    }

    public static void renderFile(File file) {
        RenderManager.renderFile(file, "", true, true);
    }

    public static void renderFile(File file, String msg, boolean addToHistory, boolean useIT) {
        boolean isRMSRib;
        String[] flags;
        Monitor monitor = Monitor.getInstance();
        if (addToHistory) {
            BBxt.addToHistory();
        }
        RenderManager.clearInitialMessage();
        RenderManager.setInitialMessage(msg);
        String[] arr = null;
        String[] userFlags = null;
        if (RmanTool.tool.isRenderFlagsActive()) {
            userFlags = TextUtils.tokenize(RmanTool.tool.getRenderFlags());
        }
        int flagsLen = (flags = userFlags) == null ? 0 : flags.length;
        arr = preRibPath == null ? new String[flagsLen + 2] : new String[flagsLen + 3];
        String path = FileUtils.toUnixPath(RenderInfo.get(6));
        arr[0] = path + RenderInfo.get(3);
        if (flags != null) {
            for (int n = 0; n < flags.length; ++n) {
                arr[n + 1] = flags[n];
            }
        }
        if (preRibPath != null) {
            arr[arr.length - 2] = preRibPath;
        }
        arr[arr.length - 1] = file.getPath();
        RenderManager.initStatistics();
        ProcessManager fp = new ProcessManager("RIB Renderer");
        boolean doLog = Preferences.get(Preferences.TOOL_RENDERMAN_LOG_FILE).equals("true");
        File rmsProjectRoot = FileUtils.isRMSRibFile(file);
        boolean bl = isRMSRib = rmsProjectRoot != null;
        if (isRMSRib) {
            Cutter.setLog("    Info: RenderManager.renderFile() - rmsProjectRoot is \"" + rmsProjectRoot.getPath() + "\"");
        }
        String[] envVars = null;
        if (isRMSRib) {
            Vector<String> v = VectorUtils.toVector(arr);
            v.insertElementAt(rmsProjectRoot.getPath(), 1);
            v.insertElementAt("-cwd", 1);
            arr = VectorUtils.toStringArray(v);
            if (Cutter.input.debug) {
                Cutter.setLog(arr);
            }
            fp.launch(arr, envVars, rmsProjectRoot, true, RenderManager.getInstance(), false, false);
        } else {
            fp.launch(arr, envVars, null, true, RenderManager.getInstance(), false, false);
        }
    }

    public static boolean renderBatch(File[] files, File scriptDir) {
        Monitor monitor = Monitor.getInstance();
        Vector<String> list = RenderInfo.getUserFlags(10);
        String[] flags = VectorUtils.toStringArray(list);
        String cmdPath = RenderInfo.get(6).length() == 0 ? RenderInfo.get(3) : RenderInfo.get(6) + File.separatorChar + RenderInfo.get(3);
        BBxt.addToHistory();
        final File batch_script = MultiRibUtils.makeBatchRenderFile(cmdPath, files, scriptDir, null);
        if (batch_script == null || !batch_script.exists()) {
            Cutter.setLog("    Error: RmanTools.renderBatch() MultiRibUtils.makeBatchRenderFile() return null or non-existing script");
            return false;
        }
        if (!RenderInfo.getDeferRender()) {
            Thread thread = new Thread("batch thread"){

                @Override
                public void run() {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {
                        Cutter.setLog("    Exception:RenderManager.renderBatch() - " + e.toString());
                    }
                    MultiRibUtils.renderBatch(batch_script);
                }
            };
            thread.start();
        } else {
            String msg = "Warning:\nRman Tools->Options->KeyFramer is set to \"multiple numbered ribs\". The\nrib files and a batch render script named \"" + batch_script.getName() + "\" have been\nsaved in a directory called \"" + "Cutter_Keyframing" + "\" - it can be found in\nthe same directory as cutter.jar.\n\nRman Tools->Options->Rib Options is set to \"defer rendering\". Run the\nbatch render script to render the ribs or switch off \"defer rendering\"\nand render the animation script again.";
            Monitor.setPanelText("RIB Renderer", "");
            Monitor.appendPanelText("RIB Renderer", msg);
        }
        return true;
    }

    private static void initStatistics() {
        f_min = 1000000.0f;
        f_max = -1000000.0f;
        f_gross = 0.0f;
        f_count = 0L;
        RenderManager.c_min[0] = 100000.0f;
        RenderManager.c_min[1] = 100000.0f;
        RenderManager.c_min[2] = 100000.0f;
        RenderManager.c_max[0] = -100000.0f;
        RenderManager.c_max[1] = -100000.0f;
        RenderManager.c_max[2] = -100000.0f;
        c_count = 0L;
        RenderManager.c_gross[0] = 0.0f;
        RenderManager.c_gross[1] = 0.0f;
        RenderManager.c_gross[2] = 0.0f;
    }

    private static void setInitialMessage(String msg) {
        if (msg != null && msg.length() > 0) {
            initialMessage = msg;
        }
    }

    private static void clearInitialMessage() {
        initialMessage = "";
    }

    @Override
    public void processSentString(String procName, String str) {
        float z;
        float y;
        float x;
        float temp;
        if (f_count > MAX_COUNT || c_count > MAX_COUNT) {
            return;
        }
        String[] tokens = TextUtils.tokenize(str);
        if (tokens == null || tokens.length == 0) {
            return;
        }
        if (str.startsWith("X00004")) {
            try {
                if (tokens.length >= 6) {
                    if (tokens[3].startsWith("[<")) {
                        temp = Float.parseFloat(tokens[2]);
                        f_gross += temp;
                        if (temp < f_min) {
                            f_min = temp;
                        }
                        if (temp > f_max) {
                            f_max = temp;
                        }
                        ++f_count;
                    }
                    if (tokens[5].startsWith("[<")) {
                        x = Float.parseFloat(tokens[2]);
                        y = Float.parseFloat(tokens[3]);
                        z = Float.parseFloat(tokens[4]);
                        c_gross[0] = c_gross[0] + x;
                        c_gross[1] = c_gross[1] + y;
                        c_gross[2] = c_gross[2] + z;
                        RenderManager.c_min[0] = x < c_min[0] ? x : c_min[0];
                        RenderManager.c_min[1] = y < c_min[1] ? y : c_min[1];
                        RenderManager.c_min[2] = z < c_min[2] ? z : c_min[2];
                        RenderManager.c_max[0] = x > c_max[0] ? x : c_max[0];
                        RenderManager.c_max[1] = y > c_max[1] ? y : c_max[1];
                        RenderManager.c_max[2] = z > c_max[2] ? z : c_max[2];
                        ++c_count;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (str.startsWith("S20001")) {
            try {
                if (tokens.length >= 6) {
                    if (tokens[4].startsWith("[<")) {
                        temp = Float.parseFloat(tokens[3]);
                        f_gross += temp;
                        if (temp < f_min) {
                            f_min = temp;
                        }
                        if (temp > f_max) {
                            f_max = temp;
                        }
                        ++f_count;
                    }
                    if (tokens[6].startsWith("[<")) {
                        x = Float.parseFloat(tokens[3]);
                        y = Float.parseFloat(tokens[4]);
                        z = Float.parseFloat(tokens[5]);
                        c_gross[0] = c_gross[0] + x;
                        c_gross[1] = c_gross[1] + y;
                        c_gross[2] = c_gross[2] + z;
                        RenderManager.c_min[0] = x < c_min[0] ? x : c_min[0];
                        RenderManager.c_min[1] = y < c_min[1] ? y : c_min[1];
                        RenderManager.c_min[2] = z < c_min[2] ? z : c_min[2];
                        RenderManager.c_max[0] = x > c_max[0] ? x : c_max[0];
                        RenderManager.c_max[1] = y > c_max[1] ? y : c_max[1];
                        RenderManager.c_max[2] = z > c_max[2] ? z : c_max[2];
                        ++c_count;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
        if (initialMessage != null && initialMessage.length() > 0) {
            Monitor.appendPanelText("RIB Renderer", initialMessage);
        }
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("RIB Renderer", "Render Completed:\n");
        if (progarray == null || f_count == 0L && c_count == 0L) {
            return;
        }
        String ribpath = progarray[progarray.length - 1];
        if (ribpath == null) {
            return;
        }
        Monitor.setPanelText("Statistics", "");
        String ribname = new File(ribpath).getName();
        StringBuffer buff = new StringBuffer();
        if (f_count > 0L) {
            buff.append("  \n  ").append(f_count).append(" values were generated by one or more shaders\n");
            buff.append("  used by \"").append(ribname).append("\". Cutter collected the\n");
            buff.append("  following statistics:\n\n");
            buff.append("     min value = ").append(f_min).append("\n");
            buff.append("     max value = ").append(f_max).append("\n");
            buff.append("     average = ").append(f_gross / (float)f_count).append("\n\n");
            f_count = 0L;
        }
        if (c_count > 0L) {
            buff.append("  \n  ").append(c_count).append(" triple values were generated by one or more shaders\n");
            buff.append("  used by \"").append(ribname).append("\". Cutter collected the\n");
            buff.append("  following statistics:\n\n");
            buff.append("     triple min = ").append(c_min[0]).append(" ").append(c_min[1]).append(" ").append(c_min[2]).append("\n");
            buff.append("     triple max = ").append(c_max[0]).append(" ").append(c_max[1]).append(" ").append(c_max[2]).append("\n");
            buff.append("     triple ave = ").append(NumberUtils.clip(c_gross[0] / (float)c_count, 3)).append(" ").append(NumberUtils.clip(c_gross[1] / (float)c_count, 3)).append(" ").append(NumberUtils.clip(c_gross[2] / (float)c_count, 3)).append("\n\n");
            c_count = 0L;
        }
        if (buff.length() > 0) {
            Monitor.appendPanelText("Statistics", buff.toString());
        }
    }
}

