/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Rman.Tabs.Rib;

import UI_Actions.ColorEditAction;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButtonBorder;
import UI_Components.KComboItem;
import UI_Components.KTitledKComboItemBox;
import UI_Desktop.Cutter;
import UI_Desktop.KDesktop;
import UI_Script.Rib.Animation.RibIterator;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Rman.RenderInfo;
import UI_Tools.Rman.RenderInfoListener;
import UI_Tools.Rman.RmanTool;
import UI_Tools.Rman.Tabs.Rib.RenderManager;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class RibTabPanel
extends PrefsPanel
implements RenderInfoListener {
    private static ResourceBundle riRes;
    public static JButton renderButton;

    public RibTabPanel() {
        String[] popupnames = TextUtils.tokenize(KTools.getResourceString(riRes, "popupnames"));
        int n = 0;
        for (n = 0; n < popupnames.length && n < 20; ++n) {
            String name = KTools.getResourceString(riRes, popupnames[n]);
            final KTitledKComboItemBox combo = new KTitledKComboItemBox(popupnames[n]);
            if (popupnames[n].equalsIgnoreCase("Options")) {
                combo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (combo.ignoreActionEvent) {
                            combo.ignoreActionEvent = false;
                            return;
                        }
                        RibTabPanel.this.doOptions(e);
                    }
                });
            } else if (popupnames[n].equalsIgnoreCase("Utilities")) {
                combo.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (combo.ignoreActionEvent) {
                            combo.ignoreActionEvent = false;
                            return;
                        }
                        RibTabPanel.this.doUtilities(e);
                    }
                });
            } else {
                combo.addActionListener(combo);
            }
            String[] items = TextUtils.tokenize(name);
            for (int i = 0; i < items.length; ++i) {
                combo.addItem(new KComboItem(items[i], KTools.getResourceString(riRes, items[i])));
            }
            combo.setMaximumRowCount(items.length);
            this.contentPanel.add(combo, new GBC(0, n, 1, 1, 1.0, 1.0, 1, 0, 18, 2, new Insets(0, 0, 1, 5)));
        }
        renderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                KAbstractWindow window = BBxt.frontWindow();
                if (window == null) {
                    return;
                }
                if ((window.getTouched() || window.getFile() == null) && BBxt.getSelectionLength() == 0) {
                    window.saveFile();
                    if (window.getFile() == null) {
                        Cutter.setLog("RmanTools.renderButton.addActionListener() Cannot render an unsaved document");
                        return;
                    }
                }
                if (window instanceof KTextWindow) {
                    RenderManager.doRender(window.getFile());
                } else {
                    Cutter.setLog("    Error: RmanTools.renderButton.actionPerformed() - front window is not a KTextWindow?");
                }
            }
        });
        JLabel label = new JLabel("Compiled: " + Cutter.compiled);
        label.setFont(new Font(Cutter.defaultFont.name, 0, 10));
        label.setForeground(new Color(136, 129, 155));
        KButtonBorder.addBorderTo(renderButton, 3, 10, 3, 10);
        this.buttonPanel.add((Component)renderButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 10, 0, new Insets(15, 8, 10, 0)));
        this.contentPanel.add(this.buttonPanel, new GBC(0, n, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(5, 0, 1, 5)));
    }

    public static void setRenderButtonLabel(String str) {
        renderButton.setText(str);
    }

    private void doOptions(ActionEvent e) {
        if (!RmanTool.init) {
            return;
        }
        if (e == null || e.getSource() == null) {
            Cutter.setLog("    Error:RmanTool.doOptions() - ActionEvent e == null");
            return;
        }
        JComboBox combo = (JComboBox)e.getSource();
        if (combo.getSelectedItem() instanceof KComboItem) {
            KComboItem item = (KComboItem)combo.getSelectedItem();
            if (item == null) {
                Cutter.setLog("    Error:RmanTool.doUtilities() - combo.getSelectedItem() returned null");
                return;
            }
            String msg = item.tiptext;
            if (msg == null) {
                Cutter.setLog("    Error:RmanTool.doUtilities() - item.message is null");
                return;
            }
            if (msg.equalsIgnoreCase("choose_xmlfile")) {
                StringBuffer buf = new StringBuffer();
                buf.append(RibIterator.stats[RibIterator.END_OF_FRAME]);
                buf.append(RibIterator.stats[RibIterator.FILENAME]);
                buf.append(RibIterator.stats[RibIterator.XML_PATH_OPEN]);
                File f = BBxt.getWindowFile();
                String t = BBxt.getWindowTitle();
                String path = "";
                if (f == null) {
                    String ff = FileUtils.getPWD();
                    path = new File(ff, t).getPath();
                } else {
                    path = new File(f, t).getPath();
                }
                path = TextUtils.trimTrailingChar(path, '*');
                path = TextUtils.removeExtension(path);
                path = path + ".xml";
                buf.append(path);
                buf.append(RibIterator.stats[RibIterator.XML_PATH_CLOSE]);
                BBxt.paste(buf.toString());
            } else {
                BBxt.paste(msg);
            }
        }
    }

    private void doUtilities(ActionEvent e) {
        if (!RmanTool.init) {
            return;
        }
        if (e == null || e.getSource() == null) {
            Cutter.setLog("    Error:RmanTool.doUtilities() - ActionEvent e == null");
            return;
        }
        JComboBox combo = (JComboBox)e.getSource();
        if (combo.getSelectedItem() instanceof KComboItem) {
            KComboItem item = (KComboItem)combo.getSelectedItem();
            if (item == null) {
                Cutter.setLog("    Error:RmanTool.doUtilities() - combo.getSelectedItem() returned null");
                return;
            }
            String msg = item.tiptext;
            if (msg == null) {
                Cutter.setLog("    Error:RmanTool.doUtilities() - item.message is null");
                return;
            }
            if (msg.equalsIgnoreCase("choose_color")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (KDesktop.colorEditAction == null) {
                            KDesktop.colorEditAction = new ColorEditAction("Edit Color...");
                        }
                        KDesktop.colorEditAction.actionPerformed(null);
                    }
                });
            } else if (msg.equalsIgnoreCase("coord_axes")) {
                StringBuffer buf = new StringBuffer();
                buf.append("\tTransformBegin\n");
                buf.append("\t\tScale 1 1 1\n");
                buf.append("\t\tReadArchive \"cutrAxes.rib\"\n");
                buf.append("\tTransformEnd\n");
                BBxt.paste(buf.toString());
            } else {
                Cutter.setLog("    Error:RmanTool.doUtilities() - item.message is >" + msg + "<");
            }
        }
    }

    @Override
    public void renderInfoChanged(RenderInfo info) {
        if (info == null) {
            return;
        }
        String renderStr = RenderInfo.get(3);
        if (!renderButton.getText().equals(renderStr)) {
            renderButton.setText(renderStr);
        }
    }

    @Override
    public String getName() {
        return "RibTabPanel";
    }

    @Override
    public void focusDefaultField() {
        renderButton.grabFocus();
    }

    static {
        try {
            riRes = ResourceBundle.getBundle("UI_Tools.Rman.Resources.RibPopupNamesRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("RibTabPanel: a resource file is missing --> " + mre);
        }
        renderButton = new JButton(RenderInfo.get(3));
    }
}

