/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.RunBat;

import Preferences.Preferences;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.FileSaver;
import Utilities.FileUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import kernal.Tokenizers.Tokenizer;

public class RunBatTool
extends KTools
implements ItemListener,
ActionListener {
    private static final String TOOL_DESCRIPTION = "Use this tool to modify the path\nstatement in the \"run.bat\" file.";
    private static JCheckBox showMe = new JCheckBox("Open run.bat", false);
    private static final String EMPTY_LIST_STR = "empty list";
    private static char BACKSLASH = (char)92;
    protected static JButton editButton = new JButton(" Apply Paths ");
    private static KTitledPanel inputPanel = new KTitledPanel(" Paths ", "RunBatTool.InputPanel.info");
    private static KTitledPanel infoPanel = new KTitledPanel(" About ", "RunBatTool.InfoPanel.info");
    private static KTitledComboBox srcPaths = new KTitledComboBox("", 2, 0, -2);
    private static JButton addPathButton = new JButton(" Add... ");
    private static JButton removePathButton = new JButton("Delete");
    private static JTextArea label = new JTextArea("Use this tool to modify the path\nstatement in the \"run.bat\" file.");
    protected static RunBatTool tool = null;
    OpenFileDialog openFileDialog = OpenFileDialog.getInstance(Cutter.desktop);
    private static File prevDir = null;
    private static File runbat = new File(FileUtils.getPWD(), "run.bat");

    public static RunBatTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new RunBatTool(menuItem);
        return tool;
    }

    protected RunBatTool(JMenuItem menuItem) {
        super("Run Bat Tool", menuItem, Preferences.TOOL_RUNBAT);
        Cutter.DefaultFont df = Cutter.defaultFont;
        --df.size;
        addPathButton.setMargin(new Insets(2, 5, 0, 5));
        removePathButton.setMargin(new Insets(2, 5, 0, 5));
        RunBatTool.srcPaths.combo.setPreferredSize(new Dimension(170, 25));
        label.setOpaque(false);
        label.setEditable(false);
        infoPanel.add(label, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        infoPanel.add(showMe, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        inputPanel.add(srcPaths, new GBC(0, 0, 4, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        srcPaths.addItem(EMPTY_LIST_STR);
        srcPaths.addActionListener(this);
        srcPaths.addItemListener(this);
        inputPanel.add(removePathButton, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 14, 0, new Insets(10, 5, 10, 5)));
        removePathButton.addActionListener(this);
        removePathButton.setEnabled(false);
        inputPanel.add(addPathButton, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 14, 0, new Insets(10, 5, 10, 5)));
        addPathButton.addActionListener(this);
        this.contentPane.add((Component)infoPanel, new GBC(0, 0, 4, 2, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)inputPanel, new GBC(0, 2, 4, 2, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)editButton, new GBC(3, 4, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(5, 2, 10, 6)));
        editButton.addActionListener(this);
        this.setTitle(this.title);
        RunBatTool.addPathsFromBat();
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    private static void addPathsFromBat() {
        Vector<String> list = new Vector<String>();
        Tokenizer tok = new Tokenizer();
        try {
            String line;
            BufferedReader inn = new BufferedReader(new FileReader(new File(FileUtils.getPWD(), "run.bat")), 1024);
            while ((line = inn.readLine()) != null) {
                tok.setBuffer(line);
                tok.setDelimitor(" ");
                String str = tok.getNextStr();
                if (!str.equalsIgnoreCase("path")) continue;
                tok.setDelimitor(";");
                str = tok.getNextStr();
                if (!str.equalsIgnoreCase("%PATH%")) continue;
                str = tok.getNextStr();
                while (!str.equals("")) {
                    if (!str.equals(";")) {
                        list.addElement(str);
                    }
                    str = tok.getNextStr();
                }
            }
        }
        catch (IOException e) {
            return;
        }
        RunBatTool.clearAllPaths();
        if (list.size() > 0) {
            srcPaths.removeItem(EMPTY_LIST_STR);
            for (int n = 0; n < list.size(); ++n) {
                srcPaths.addItem((String)list.elementAt(n));
                srcPaths.setSelectedItem((String)list.elementAt(n));
            }
        }
        if (srcPaths.getItemCount() == 1 && srcPaths.getSelectedItem().equals(EMPTY_LIST_STR)) {
            removePathButton.setEnabled(false);
        } else {
            removePathButton.setEnabled(true);
        }
    }

    private File choosePath() {
        this.openFileDialog.setFileHidingEnabled(false);
        String path = RunBatTool.srcPaths.combo.getItemAt(0);
        File oldFile = this.openFileDialog.getPrevFile();
        if (prevDir == null && new File(path).exists()) {
            prevDir = new File(path);
        }
        if (prevDir != null) {
            this.openFileDialog.setPrevFile(prevDir);
        } else {
            this.openFileDialog.setPrevFile(FileUtils.getPWDFile());
        }
        File[] files = this.openFileDialog.showSelf(null, "Select Directory", 1);
        this.openFileDialog.setPrevFile(oldFile);
        if (files == null || files.length == 0) {
            return null;
        }
        prevDir = files[0];
        return files[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == addPathButton) {
            File file = this.choosePath();
            if (file == null) {
                return;
            }
            if (srcPaths.getItemCount() == 1 && srcPaths.getSelectedItem().equals(EMPTY_LIST_STR)) {
                srcPaths.removeItem(EMPTY_LIST_STR);
            }
            String path = file.getPath();
            srcPaths.addItem(path);
            RunBatTool.srcPaths.combo.setSelectedItem(path);
            removePathButton.setEnabled(true);
        } else if (e.getSource() == removePathButton) {
            if (srcPaths.getItemCount() == 1 && srcPaths.getSelectedItem().equals(EMPTY_LIST_STR)) {
                return;
            }
            String name = srcPaths.getSelectedItem();
            if (name != null || name.length() != 0) {
                srcPaths.removeItem(name);
            }
            if (srcPaths.getItemCount() == 0) {
                srcPaths.addItem(EMPTY_LIST_STR);
                removePathButton.setEnabled(false);
            }
        } else if (e.getSource() == editButton) {
            this.applyPathsToBat();
        }
        if (showMe.isSelected()) {
            KAbstractWindow w = KAbstractDesktop.getWindowWithFile(runbat);
            if (w == null) {
                w = KTextWindow.addWindow(runbat, true, true, true, true);
            }
            if (w != null) {
                KAbstractDesktop.toFront(w);
            }
        }
        this.pack();
    }

    @Override
    public void showSelf() {
        RunBatTool.addPathsFromBat();
        super.showSelf();
    }

    private static void clearAllPaths() {
        String name;
        while (srcPaths.getItemCount() > 1) {
            name = srcPaths.getSelectedItem();
            Cutter.setLog("RunBatTool.clearAllPaths() >" + name + "<");
            if (name == null && name.length() == 0) continue;
            srcPaths.removeItem(name);
        }
        name = srcPaths.getSelectedItem();
        srcPaths.removeItem(name);
        srcPaths.addItem(EMPTY_LIST_STR);
        removePathButton.setEnabled(false);
    }

    @Override
    protected void toolSelectionHappened() {
        addPathButton.grabFocus();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 || srcPaths == null) {
            return;
        }
        String name = srcPaths.getSelectedItem();
    }

    public void applyPathsToBat() {
        StringBuffer buff = new StringBuffer();
        if (srcPaths.getItemCount() == 1 && srcPaths.getSelectedItem().equals(EMPTY_LIST_STR)) {
            buff.append("java -classpath .;cutter.jar Cutter");
        } else {
            buff.append("path %PATH%;");
            for (int n = 0; n < srcPaths.getItemCount(); ++n) {
                String name = RunBatTool.srcPaths.combo.getItemAt(n);
                if (name == null && name.length() == 0) continue;
                buff.append(name).append(";");
            }
            buff.append("\n");
            buff.append("java -classpath .;cutter.jar Cutter");
        }
        Cutter.setLog("RunBatTool editing run.bat ________");
        Cutter.setLog(buff.toString());
        Cutter.setLog("________________________");
        File batfile = new File(FileUtils.getPWD(), "run.bat");
        KAbstractWindow w = KAbstractDesktop.getWindowWithFile(batfile);
        if (w != null && w instanceof KTextWindow) {
            KAbstractDesktop.toFront(w);
            ((KTextWindow)w).setText(buff.toString());
        } else {
            FileSaver writer = new FileSaver(batfile, buff);
            writer.start();
        }
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }
}

