/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Session;

import Preferences.Preferences;
import Session.SessionManager;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KTextArea;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;

public class SessionTool
extends KTools {
    private static KTitledPanel timeDatePanel = new KTitledPanel(" Sessions ");
    private static KTitledPanel fileListPanel = new KTitledPanel(" Files ");
    private static KTextArea datesTextarea = new KTextArea(8, 40);
    private static KTextArea filesTextarea = new KTextArea(8, 40);
    private Karet datesTextareaCaret = new Karet(datesTextarea);
    private Karet filesTextareaCaret = new Karet(filesTextarea);
    private static JButton openButton = new JButton(" Open ");
    private static SessionTool tool = null;
    private static String selectedDate = "";
    private SessionManager.SessionDBItem[] sessionDB = null;

    public static SessionTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new SessionTool(menuItem);
        return tool;
    }

    protected SessionTool(JMenuItem menuItem) {
        super("Session Tool", menuItem, Preferences.TOOL_SESSION);
        openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionTool.this.openItem();
            }
        });
        openButton.setRequestFocusEnabled(false);
        datesTextarea.setBorder(BorderFactory.createEtchedBorder());
        datesTextarea.setEditable(false);
        datesTextarea.setCaret(this.datesTextareaCaret);
        JScrollPane dtScroller = new JScrollPane();
        dtScroller.getViewport().add(datesTextarea);
        timeDatePanel.add(dtScroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 10, 1, new Insets(2, 5, 5, 5)));
        datesTextarea.setText("");
        filesTextarea.setBorder(BorderFactory.createEtchedBorder());
        filesTextarea.setEditable(false);
        filesTextarea.setCaret(this.filesTextareaCaret);
        JScrollPane flScroller = new JScrollPane();
        flScroller.getViewport().add(filesTextarea);
        fileListPanel.add(flScroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 10, 1, new Insets(2, 5, 5, 5)));
        filesTextarea.setText("");
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new GridBagLayout());
        textPanel.add((Component)timeDatePanel, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 5, 3, 5)));
        textPanel.add((Component)fileListPanel, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(3, 5, 5, 5)));
        this.contentPane.add((Component)textPanel, new GBC(0, 0, 2, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(5, 0, 10, 10)));
        this.contentPane.add((Component)openButton, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(5, 0, 15, 17)));
        this.setTitle(this.title);
        this.pack();
        timeDatePanel.setMinimumSize(timeDatePanel.getSize());
        timeDatePanel.setMaximumSize(timeDatePanel.getSize());
        fileListPanel.setMinimumSize(fileListPanel.getSize());
        fileListPanel.setMaximumSize(fileListPanel.getSize());
        this.setInitialPosition();
        this.sessionDB = SessionManager.getInstance().getDBFromDisk();
        if (this.sessionDB == null) {
            Cutter.setLog("    Warning:SessionTool.SessionTool() - sessionDB is null");
        } else {
            for (int n = this.sessionDB.length - 1; n >= 0; --n) {
                SessionManager.SessionDBItem item = this.sessionDB[n];
                int numFiles = item.docs.size();
                datesTextarea.append(item.date + " [files: " + numFiles + "]\n");
            }
        }
        this.setVisible(false);
    }

    private void openItem() {
        String f = filesTextarea.getSelectedText();
        String d = datesTextarea.getSelectedText();
        KTextArea active = null;
        if (f != null && f.trim().length() > 0) {
            active = filesTextarea;
        } else if (d != null && d.trim().length() > 0) {
            active = datesTextarea;
        }
        if (active == null) {
            return;
        }
        if (active == filesTextarea) {
            File file = new File(active.getSelectedText());
            if (file.exists()) {
                BBxt.newDocument(file);
            }
        } else {
            SessionManager.SessionDBItem session = this.sessionDB[this.datesTextareaCaret.index];
            if (session.docs.size() < 1) {
                return;
            }
            for (int n = 0; n < session.docs.size(); ++n) {
                SessionManager.DocDBItem docItem = session.docs.elementAt(n);
                File doc = new File(docItem.closedPath);
                if (!doc.exists()) continue;
                BBxt.newDocument(doc);
            }
        }
    }

    @Override
    protected void toolSelectionHappened() {
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
    }

    private class Karet
    extends DefaultCaret {
        private KTextArea textarea = null;
        public int index = -1;

        public Karet(KTextArea textarea) {
            this.textarea = textarea;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            this.selectWord(this.getMark());
            if (this.textarea == filesTextarea && e.getClickCount() == 2) {
                this.selectWord(this.getMark());
                SessionTool.this.openItem();
            }
        }

        private void selectWord(int offset) {
            try {
                int line = this.textarea.getLineOfOffset(offset);
                int begin = this.textarea.getLineStartOffset(line);
                int end = this.textarea.getLineEndOffset(line);
                this.textarea.setSelectionStart(begin);
                this.textarea.setSelectionEnd(end - 1);
                String selection = this.textarea.getSelectedText();
                KTextArea other = this.textarea == datesTextarea ? filesTextarea : datesTextarea;
                int b = other.getSelectionStart();
                other.setSelectionStart(b);
                other.setSelectionEnd(b);
                if (SessionTool.this.sessionDB == null) {
                    Cutter.setLog("    Error:SessionTool.selectWord() - sessionDB is null!");
                    return;
                }
                if (line > SessionTool.this.sessionDB.length) {
                    Cutter.setLog("    Error:SessionTool.selectWord() - line number exceeds sessionDB length!");
                    return;
                }
                if (line < 0) {
                    Cutter.setLog("    Error:SessionTool.selectWord() - line number is less than zero");
                    return;
                }
                if (selection == null || selection.trim().length() == 0) {
                    return;
                }
                if (this.textarea == datesTextarea) {
                    openButton.setText(" Open Session ");
                    this.index = SessionTool.this.sessionDB.length - (line + 1);
                    SessionManager.SessionDBItem sess = SessionTool.this.sessionDB[this.index];
                    filesTextarea.setText("");
                    if (sess.docs.size() < 1) {
                        Cutter.setLog("size is less than 1");
                        return;
                    }
                    for (int n = 0; n < sess.docs.size(); ++n) {
                        SessionManager.DocDBItem docItem = sess.docs.elementAt(n);
                        filesTextarea.append(docItem.closedPath + "\n");
                    }
                } else {
                    openButton.setText(" Open File ");
                }
            }
            catch (BadLocationException e) {
                Cutter.setLog("SessionTool.Karet" + e.toString());
            }
        }
    }
}

