/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.TabSpacesTool;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTextField.KIntTextField;
import UI_Text.KTextPane.KTextPane;
import UI_Tools.KTools;
import UI_Window.KWindow.KAbstractTextWindow;
import UI_Window.KWindow.KTextWindow;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.text.JTextComponent;

public class TabSpacesTool
extends KTools {
    protected static TabSpacesTool tool = null;
    private KButton setCurrentButton = new KButton("  Set Current  ");
    public KIntTextField currentSizeField = new KIntTextField(2);
    private KButton defaultSizeButton = new KButton("  Set Default  ");
    public KIntTextField defaultSizeField = new KIntTextField(2);

    public static TabSpacesTool init() {
        if (tool != null) {
            return tool;
        }
        tool = new TabSpacesTool();
        return tool;
    }

    protected TabSpacesTool() {
        super("Tab Spaces", JLayeredPane.PALETTE_LAYER);
        this.setCurrentButton.setMargin(new Insets(-1, 5, -1, 5));
        this.setCurrentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSpacesTool.this.setCurrentTabSize();
            }
        });
        this.currentSizeField.setMargin(new Insets(0, 0, 0, 0));
        this.currentSizeField.setMinimumSize(this.currentSizeField.getPreferredSize());
        this.defaultSizeButton.setMargin(new Insets(-1, 5, -1, 5));
        this.defaultSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabSpacesTool.this.setDefaultTabSize();
            }
        });
        this.defaultSizeField.setMargin(new Insets(0, 0, 0, 0));
        this.defaultSizeField.setMinimumSize(this.defaultSizeField.getPreferredSize());
        this.contentPane.add((Component)this.setCurrentButton, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(10, 10, 5, 0)));
        this.contentPane.add((Component)this.currentSizeField, new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(10, 5, 5, 8)));
        this.contentPane.add((Component)this.defaultSizeButton, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 17, 11, new Insets(7, 10, 8, 0)));
        this.contentPane.add((Component)this.defaultSizeField, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 17, 11, new Insets(7, 5, 8, 8)));
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    private void setCurrentTabSize() {
        int tabsize;
        JEditorPane pane = BBxt.getTextPane();
        if (!(pane instanceof KTextPane)) {
            return;
        }
        KTextPane textpane = (KTextPane)pane;
        Integer integer = this.currentSizeField.getInt();
        int defaultsize = Integer.parseInt(Preferences.get(Preferences.TEXT_TAB_SIZE));
        int n = tabsize = integer == null ? defaultsize : integer;
        if (tabsize > 10) {
            tabsize = 10;
            this.currentSizeField.setText("" + tabsize);
        }
        textpane.setTabSize(tabsize);
        KAbstractTextWindow atw = textpane.getFrame();
        if (atw != null && atw instanceof KTextWindow) {
            ((KTextWindow)atw).lineFieldPanel.setTabSizeField(tabsize);
        }
        textpane.getFrame().setTabSize(tabsize);
        textpane.requestFocus();
    }

    private void setDefaultTabSize() {
        int tabsize;
        Integer integer = this.defaultSizeField.getInt();
        int defaultsize = Integer.parseInt(Preferences.get(Preferences.TEXT_TAB_SIZE));
        int n = tabsize = integer == null ? defaultsize : integer;
        if (tabsize > 10) {
            tabsize = 10;
            this.defaultSizeField.setText("" + tabsize);
        }
        Preferences.write(Preferences.TEXT_TAB_SIZE, tabsize);
    }

    @Override
    public void showSelf() {
        this.currentSizeField.setText("" + BBxt.getTabSize());
        this.defaultSizeField.setText("" + BBxt.getDefaultTabSize());
        super.showSelf();
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
        this.currentSizeField.setText("" + BBxt.getTabSize());
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }
}

