/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.TabWindowsTool;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Tools.KTools;
import UI_Window.KWindow.HTMLWindow;
import UI_Window.KWindow.KAbstractWindow;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DesktopManager;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;

public class TabWindowsTool
extends KTools
implements ItemListener,
ActionListener {
    public static String TAB_LAYOUT = "TAB";
    public static int DEFAULT_WIDTH = 150;
    private static int MAX_LABEL_LENGTH = 16;
    protected static TabWindowsTool tool = null;
    private static Color HISTORY_BUTTON_FOREGROUND = new Color(81, 81, 81);
    private static Color BROWSER_BUTTON_FOREGROUND = new Color(37, 37, 197);
    static final int A_TO_Z = 1;
    static final int Z_TO_A = 2;
    private ButtonPanel buttonPanel = new ButtonPanel();
    private JScrollPane scroller = new JScrollPane();

    public static TabWindowsTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new TabWindowsTool(menuItem);
        return tool;
    }

    protected TabWindowsTool(JMenuItem menuItem) {
        super("Tab View Tool", menuItem, Preferences.TOOL_TABWINDOWS);
        this.scroller.getViewport().add(this.buttonPanel);
        this.contentPane.add((Component)this.scroller, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
        this.setTitle(this.title);
        this.setIconifiable(false);
        this.setMaximizable(false);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    public static void deleteAll() {
        TabWindowsTool.tool.buttonPanel.refresh();
        TabWindowsTool.tool.scroller.validate();
    }

    public static void clickButton(String label) {
        TabWindowsTool.tool.buttonPanel.clickButton(label);
    }

    public static void removeButton(String label) {
        TabWindowsTool.tool.buttonPanel.removeButton(label);
    }

    public static boolean isActive() {
        return tool.isVisible();
    }

    @Override
    public void showSelf() {
        Dimension paneSize = KAbstractDesktop.getDesktopSize();
        DesktopManager manager = KAbstractDesktop.getDesktopManager();
        manager.setBoundsForFrame(this, 0, 0, 150, paneSize.height);
        this.menuItem.setText("Tab");
        this.buttonPanel.refresh();
        this.scroller.validate();
        try {
            KAbstractDesktop.desktopPane.tabAllWindows();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: TabWindowstool.showSelf()\n\t" + e.toString());
        }
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        KAbstractDesktop.desktopPane.cascadeAll();
        KDesktop.cascadeItem.setEnabled(true);
        KDesktop.tileItem.setEnabled(true);
        KDesktop.tabbedItem.setEnabled(true);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setLocation(0, 0);
    }

    @Override
    protected void initDynamicDesktopPosition() {
        this.dynamicDesktopPosition = 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pack();
    }

    @Override
    protected void toolSelectionHappened() {
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
        if (!this.isVisible()) {
            return;
        }
        try {
            KAbstractDesktop.desktopPane.tabAllWindows();
            this.buttonPanel.refresh();
            this.scroller.validate();
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    public class ButtonPanel
    extends JPanel {
        private ButtonGroup group = new ButtonGroup();
        private Vector<Component> listOfButtons = new Vector();
        private Vector<Component> listOfInvalids = new Vector();
        private Vector<KAbstractWindow> listOfNewbies = new Vector();
        private KAbstractWindow[] windows;
        private ButtonGroup sortgroup = new ButtonGroup();
        private JToggleButton azButton = new JToggleButton("A-Z");
        private JToggleButton zaButton = new JToggleButton("Z-A");
        private JPanel sortPanel = new JPanel();
        private int sortOrder = 1;

        public ButtonPanel() {
            this.setLayout(new GridBagLayout());
            Font f = this.azButton.getFont();
            this.azButton.setFont(new Font(f.getName(), 1, f.getSize() - 1));
            this.azButton.setMargin(new Insets(-1, 0, -1, 0));
            this.zaButton.setFont(new Font(f.getName(), 1, f.getSize() - 1));
            this.zaButton.setMargin(new Insets(-1, 0, -1, 0));
            this.sortPanel.setLayout(new GridBagLayout());
            this.sortgroup.add(this.azButton);
            this.sortgroup.add(this.zaButton);
            this.azButton.doClick(0);
            this.sortPanel.add((Component)this.azButton, new GBC(0, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 0, 5, 0)));
            this.sortPanel.add((Component)this.zaButton, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(0, 0, 5, 0)));
            JPanel spacer = new JPanel();
            this.azButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.sortAZ();
                    ButtonPanel.this.layoutButtons();
                    ButtonPanel.this.sortOrder = 1;
                }
            });
            this.zaButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.sortZA();
                    ButtonPanel.this.layoutButtons();
                    ButtonPanel.this.sortOrder = 2;
                }
            });
        }

        private void updateButtonList() {
            this.listOfButtons.removeAllElements();
            Component[] comps = this.getComponents();
            if (comps != null) {
                for (int n = 0; n < comps.length; ++n) {
                    if (!(comps[n] instanceof JToggleButton) && !(comps[n] instanceof KButton)) continue;
                    this.listOfButtons.addElement(comps[n]);
                }
            }
        }

        private void _printButtonList() {
            Cutter.setLog("    printButtonList " + this.listOfButtons.size());
            for (int n = 0; n < this.listOfButtons.size(); ++n) {
                WindowButton button = (WindowButton)this.listOfButtons.elementAt(n);
                Cutter.setLog("    Info: WindowButton " + n + " label " + button.label + " path " + button.file.getPath());
            }
        }

        private void sortAZ() {
            int n;
            WindowButton[] tempArray = new WindowButton[this.listOfButtons.size()];
            for (int n2 = 0; n2 < this.listOfButtons.size(); ++n2) {
                if (!(this.listOfButtons.elementAt(n2) instanceof JToggleButton)) continue;
                try {
                    tempArray[n2] = (WindowButton)this.listOfButtons.elementAt(n2);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    if (!Cutter.input.debug) continue;
                    Cutter.setLog("    Exception:TabWindowsTool.sortAZ() " + ex.toString());
                }
            }
            Collator collator = Collator.getInstance(Locale.ENGLISH);
            for (n = 0; n < tempArray.length; ++n) {
                for (int i = n + 1; i < tempArray.length; ++i) {
                    if (tempArray[n] == null || tempArray[i] == null || collator.compare(tempArray[n].label, tempArray[i].label) <= 0) continue;
                    WindowButton tmp = tempArray[n];
                    tempArray[n] = tempArray[i];
                    tempArray[i] = tmp;
                }
            }
            this.listOfButtons.removeAllElements();
            for (n = 0; n < tempArray.length; ++n) {
                this.listOfButtons.addElement(tempArray[n]);
            }
        }

        private void sortZA() {
            int n;
            WindowButton[] tempArray = new WindowButton[this.listOfButtons.size()];
            for (int n2 = 0; n2 < this.listOfButtons.size(); ++n2) {
                if (!(this.listOfButtons.elementAt(n2) instanceof JToggleButton)) continue;
                tempArray[n2] = (WindowButton)this.listOfButtons.elementAt(n2);
            }
            Collator collator = Collator.getInstance(Locale.ENGLISH);
            for (n = 0; n < tempArray.length; ++n) {
                for (int i = n + 1; i < tempArray.length; ++i) {
                    if (tempArray[n] == null || tempArray[i] == null || collator.compare(tempArray[n].label, tempArray[i].label) >= 0) continue;
                    WindowButton tmp = tempArray[n];
                    tempArray[n] = tempArray[i];
                    tempArray[i] = tmp;
                }
            }
            this.listOfButtons.removeAllElements();
            for (n = 0; n < tempArray.length; ++n) {
                this.listOfButtons.addElement(tempArray[n]);
            }
        }

        private void decorateBrowserButton(WindowButton button) {
            String str = HTMLWindow.getUrlTail();
            if (str != null) {
                if (str.length() > MAX_LABEL_LENGTH) {
                    str = str.substring(0, MAX_LABEL_LENGTH);
                }
                button.setText("<html><u>" + str + "</u></html>");
                button.setForeground(BROWSER_BUTTON_FOREGROUND);
            } else {
                button.setText(button.fullLabel);
                button.setForeground(Color.black);
            }
        }

        private void decorateHistoryButton(WindowButton button) {
            button.setForeground(HISTORY_BUTTON_FOREGROUND);
        }

        private void layoutButtons() {
            this.removeAll();
            this.add((Component)this.sortPanel, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
            this.group = null;
            this.group = new ButtonGroup();
            int gridy = 1;
            boolean browserButtonAdded = false;
            for (int n = 0; n < this.listOfButtons.size(); ++n) {
                if (!(this.listOfButtons.elementAt(n) instanceof WindowButton)) continue;
                WindowButton button = (WindowButton)this.listOfButtons.elementAt(n);
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:TabWindowsTool.layoutButtons - full label " + button.fullLabel);
                }
                if (button.fullLabel.equals("Cutter Browser") && !browserButtonAdded) {
                    this.decorateBrowserButton(button);
                    browserButtonAdded = true;
                }
                if (button.fullLabel.startsWith("History: ")) {
                    this.decorateHistoryButton(button);
                }
                button.setHorizontalAlignment(0);
                this.group.add(button);
                this.add((Component)button, new GBC(0, gridy++, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 0, 0, 0)));
            }
            this.add((Component)new JPanel(), new GBC(0, gridy, 1, 1, 1.0, 1.0, 0, 0, 18, 1, new Insets(0, 0, 0, 0)));
            this.validate();
        }

        public void refresh() {
            KAbstractWindow front;
            WindowButton button;
            int n;
            this.windows = KAbstractDesktop.getAllWindows();
            if (this.windows == null || this.windows.length == 0) {
                this.listOfButtons.removeAllElements();
                this.layoutButtons();
                return;
            }
            this.updateButtonList();
            this.listOfInvalids.removeAllElements();
            for (n = 0; n < this.listOfButtons.size(); ++n) {
                if (!(this.listOfButtons.elementAt(n) instanceof WindowButton)) continue;
                button = (WindowButton)this.listOfButtons.elementAt(n);
                boolean isvalid = button.isValid();
                if (button == null || isvalid) continue;
                this.listOfInvalids.addElement(button);
            }
            this.listOfNewbies.removeAllElements();
            for (n = 0; n < this.windows.length; ++n) {
                String title;
                KAbstractWindow window = this.windows[n];
                if (window == null || (title = window.getTitle()) == null || title.length() == 0) continue;
                boolean hasButton = false;
                for (int i = 0; i < this.listOfButtons.size(); ++i) {
                    WindowButton button2;
                    if (!(this.listOfButtons.elementAt(i) instanceof WindowButton) || !(button2 = (WindowButton)this.listOfButtons.elementAt(i)).matches(window)) continue;
                    hasButton = true;
                }
                if (hasButton) continue;
                if (Cutter.input.debug) {
                    Cutter.setLog("    Debug:TabWindowsTool.refresh() - adding window named \"" + this.windows[n].getTitle() + "\"");
                }
                this.listOfNewbies.addElement(this.windows[n]);
            }
            if (this.listOfInvalids != null) {
                for (n = 0; n < this.listOfInvalids.size(); ++n) {
                    button = (WindowButton)this.listOfInvalids.elementAt(n);
                    if (button == null) continue;
                    this.remove(button);
                    this.group.remove(button);
                    String message = button.file == null ? button.label : button.file.getPath();
                }
            }
            this.updateButtonList();
            for (n = 0; n < this.listOfNewbies.size(); ++n) {
                KAbstractWindow w = this.listOfNewbies.elementAt(n);
                if (w == null) continue;
                if (w instanceof HTMLWindow) {
                    this.listOfButtons.addElement(new WindowButton("Cutter Browser", null));
                    continue;
                }
                this.listOfButtons.addElement(new WindowButton(w.getTitle(), w.getFile()));
            }
            if (this.listOfInvalids != null && this.listOfInvalids.size() != 0 || this.listOfNewbies != null && this.listOfNewbies.size() != 0) {
                if (this.sortOrder == 1) {
                    this.sortAZ();
                }
                if (this.sortOrder == 2) {
                    this.sortZA();
                }
                this.layoutButtons();
            }
            if ((front = KAbstractDesktop.getWindowAtPosition(0)) != null && front instanceof HTMLWindow) {
                Enumeration<Component> e = this.listOfButtons.elements();
                if (e == null) {
                    return;
                }
                while (e.hasMoreElements()) {
                    Component obj = e.nextElement();
                    if (!(obj instanceof WindowButton)) continue;
                    WindowButton b = (WindowButton)obj;
                    if (!b.fullLabel.equals("Cutter Browser") || tool == null || !tool.isVisible()) continue;
                    b.doClick(0);
                    b.doClick(0);
                    return;
                }
                return;
            }
            if (front != null) {
                String winTitle = TextUtils.remove(front.getTitle(), '*');
                File winFile = front.getFile();
                for (int n2 = 0; n2 < this.listOfButtons.size(); ++n2) {
                    WindowButton button3 = (WindowButton)this.listOfButtons.elementAt(n2);
                    if (button3 == null || !button3.matches(winTitle) || winTitle.equals("Cutter Browser") && Cutter.htmlWindow != null && !Cutter.htmlWindow.isVisible() || !button3.matches(front)) continue;
                    button3.doClick(0);
                    break;
                }
            }
        }

        private void clickButton(String label) {
            for (int n = 0; n < this.listOfButtons.size(); ++n) {
                WindowButton button = (WindowButton)this.listOfButtons.elementAt(n);
                if (!button.matches(label)) continue;
                WindowButton butt = button;
                if (butt.matches("Cutter Browser")) {
                    this.decorateBrowserButton(butt);
                }
                butt.doClick(0);
                return;
            }
        }

        private void removeButton(String winTitle) {
            for (int n = 0; n < this.listOfButtons.size(); ++n) {
                WindowButton button = (WindowButton)this.listOfButtons.elementAt(n);
                if (!button.matches(winTitle)) continue;
                this.remove(button);
                this.group.remove(button);
                this.listOfButtons.removeElement(button);
                return;
            }
        }
    }

    public class WindowButton
    extends JToggleButton
    implements ActionListener {
        public String label = null;
        public String fullLabel = null;
        private File file = null;

        public WindowButton(String name, File file) {
            this.fullLabel = TextUtils.remove(name, '*');
            this.fullLabel = this.removeUnwantedSuffix(this.fullLabel);
            this.file = file;
            this.label = this.fullLabel.length() > MAX_LABEL_LENGTH ? this.fullLabel.substring(0, MAX_LABEL_LENGTH) : this.fullLabel;
            if (this.fullLabel.startsWith("History: ")) {
                this.label = TextUtils.removeExtension(this.fullLabel);
                this.label = this.label.substring("History: ".length(), this.label.length()).trim();
                this.label = this.label.length() > MAX_LABEL_LENGTH - 6 ? this.label.substring(0, MAX_LABEL_LENGTH - 6) + " [history]" : this.label + " [history]";
            }
            this.setText(this.label);
            this.addActionListener(this);
        }

        private String removeUnwantedSuffix(String str) {
            if ((str = TextUtils.remove(str, '*')).endsWith(" [NOT EDITABLE]")) {
                int len = " [NOT EDITABLE]".length();
                str = str.substring(0, str.length() - len).trim();
            }
            return str;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.file != null) {
                KAbstractWindow win = KAbstractDesktop.getWindowWithFile(this.file);
                if (win != null) {
                    KAbstractDesktop.toFront(win);
                }
            } else if (this.label != null) {
                if (this.label.equals("Cutter Browser")) {
                    if (Cutter.htmlWindow != null) {
                        KAbstractDesktop.toFront(Cutter.htmlWindow, true);
                    }
                } else {
                    KAbstractWindow win = KAbstractDesktop.getWindowWithTitle(this.fullLabel);
                    if (win != null) {
                        KAbstractDesktop.toFront(win);
                    }
                }
            }
        }

        @Override
        public boolean isValid() {
            if (this.file != null) {
                return KAbstractDesktop.getWindowWithFile(this.file) != null;
            }
            return KAbstractDesktop.getWindowWithTitle(this.fullLabel) != null;
        }

        private boolean matches(KAbstractWindow window) {
            if (window == null) {
                return false;
            }
            File f = window.getFile();
            if (f != null && this.file != null) {
                return f.equals(this.file);
            }
            return this.matches(window.getTitle());
        }

        private boolean matches(String winTitle) {
            if (winTitle == null) {
                return false;
            }
            winTitle = TextUtils.remove(winTitle, '*');
            winTitle = this.removeUnwantedSuffix(winTitle);
            return winTitle.equals(this.fullLabel);
        }

        private boolean matches(File winFile) {
            if (winFile == null) {
                return false;
            }
            if (winFile != null && this.file != null) {
                return winFile.getPath().equals(this.file.getPath());
            }
            return false;
        }
    }
}

