/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Texture;

import Preferences.Preferences;
import Processes.ProcListener;
import Processes.ProcessManager;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KTitledComboBox;
import UI_Components.KTitledPanel;
import UI_Components.LabelTextField;
import UI_Desktop.Cutter;
import UI_Script.Rib.RibTokenizer;
import UI_Tools.KTools;
import UI_Tools.Monitor.Monitor;
import UI_Tools.Rman.RenderInfo;
import Utilities.FileSaver;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import Utilities.UnixUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import kernal.Tokenizers.Tokenizer;

public class TextureTool
extends KTools
implements ItemListener,
ActionListener,
ProcListener {
    private static final String EMPTY_LIST_STR = "empty list";
    private static char BACKSLASH = (char)92;
    protected static JButton hideButton = new JButton("Hide");
    protected static JButton makeButton = new JButton(" Make Textures ");
    private static KTitledPanel inputPanel = new KTitledPanel(" Images ", "TextureTool.InputPanel.info");
    private static KTitledPanel optionsPanel = new KTitledPanel(" Options ", "TextureTool.OptionsPanel.info");
    private static KTitledPanel maptypePanel = new KTitledPanel(" Map Type ", "TextureTool.MapTypePanel.info");
    private static KTitledComboBox srcNames = new KTitledComboBox("Name:  ", 2, 0, -2);
    private static KTitledComboBox swrap = new KTitledComboBox("'s' ", 2, 0, -2);
    private static KTitledComboBox twrap = new KTitledComboBox("'t'  ", 2, 0, -2);
    private static KTitledComboBox filter = new KTitledComboBox("filter  ", 2, -20, -2);
    private static KTitledComboBox stwidth = new KTitledComboBox("width ", 2, -4, -2);
    private static KTitledComboBox mapTypes = new KTitledComboBox("", 2, -4, -2);
    private static String texturePath = "";
    private static String cutterPath = "";
    private static String[] typeNames = new String[]{"MakeTexture", "MakeLatLongEnvironment"};
    private static String[] wrapNames = new String[]{"periodic", "black", "clamp"};
    private static String[] filterNames = new String[]{"gaussian", "box", "triangle", "catmull-rom", "sinc"};
    private static String[] widthNames = new String[]{"1", "2", "3", "4", "8", "16"};
    private static LabelTextField srcfield = new LabelTextField("src: ", cutterPath, 2, 7, 15);
    private static LabelTextField destfield = new LabelTextField("dest:", RenderInfo.get(14), 2, 2, 15);
    private static JButton addImageButton = new JButton(" Add... ");
    private static JButton removeImageButton = new JButton("Delete");
    private static JButton editSrcButton = new JButton("Choose...");
    private static JButton editDestButton = new JButton("Choose...");
    private static JCheckBox autoMake = new JCheckBox("overwrite existing texture");
    protected static TextureTool tool = null;

    public static TextureTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new TextureTool(menuItem);
        return tool;
    }

    protected TextureTool(JMenuItem menuItem) {
        super("Texture Tool", menuItem, Preferences.TOOL_RENDERMAN_TEXTURE);
        texturePath = UnixUtils.path(RenderInfo.get(14));
        cutterPath = UnixUtils.parent(texturePath);
        srcfield.setText(cutterPath);
        destfield.setText(texturePath);
        Cutter.DefaultFont df = Cutter.defaultFont;
        --df.size;
        addImageButton.setMargin(new Insets(2, 5, 0, 5));
        removeImageButton.setMargin(new Insets(2, 5, 0, 5));
        editSrcButton.setMargin(new Insets(2, 5, 0, 5));
        editDestButton.setMargin(new Insets(2, 5, 0, 5));
        TextureTool.srcNames.combo.setPreferredSize(new Dimension(100, 25));
        inputPanel.add(srcNames, new GBC(0, 3, 2, 5, 1.0, 1.0, 0, 0, 17, 0, new Insets(0, 5, 0, 0)));
        srcNames.addItem(EMPTY_LIST_STR);
        srcNames.addActionListener(this);
        srcNames.addItemListener(this);
        inputPanel.add(addImageButton, new GBC(2, 0, 1, 5, 0.0, 0.0, 0, 0, 14, 0, new Insets(0, 5, 2, 5)));
        addImageButton.addActionListener(this);
        inputPanel.add(removeImageButton, new GBC(2, 6, 1, 5, 0.0, 0.0, 0, 0, 14, 0, new Insets(2, 5, 5, 5)));
        removeImageButton.addActionListener(this);
        removeImageButton.setEnabled(false);
        inputPanel.add(srcfield, new GBC(0, 12, 3, 5, 1.0, 1.0, 0, 0, 14, 2, new Insets(0, 5, 2, 0)));
        srcfield.setEditable(false);
        srcfield.setColor(Color.darkGray);
        srcfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderInfo.textureData.set(srcNames.getSelectedItem(), 3, srcfield.getText());
            }
        });
        inputPanel.add(destfield, new GBC(0, 17, 3, 5, 1.0, 1.0, 0, 0, 14, 2, new Insets(2, 5, 0, 0)));
        destfield.setEditable(false);
        destfield.setColor(Color.darkGray);
        destfield.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenderInfo.textureData.set(srcNames.getSelectedItem(), 4, srcfield.getText());
            }
        });
        inputPanel.add(autoMake, new GBC(0, 22, 3, 5, 1.0, 1.0, 0, 0, 14, 0, new Insets(2, 5, 2, 5)));
        autoMake.addItemListener(this);
        maptypePanel.add(mapTypes, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 20, 5, 0)));
        mapTypes.addItem(typeNames);
        mapTypes.addItemListener(this);
        optionsPanel.add(swrap, new GBC(1, 2, 3, 1, 0.0, 1.0, 0, 0, 13, 0, new Insets(5, 0, 2, 5)));
        swrap.addItemListener(this);
        optionsPanel.add(filter, new GBC(5, 2, 3, 1, 0.0, 1.0, 0, 0, 13, 0, new Insets(5, 10, 2, 0)));
        filter.addItemListener(this);
        optionsPanel.add(twrap, new GBC(1, 4, 3, 1, 0.0, 1.0, 0, 0, 13, 0, new Insets(2, 0, 5, 5)));
        twrap.addItemListener(this);
        optionsPanel.add(stwidth, new GBC(5, 4, 3, 1, 0.0, 1.0, 0, 0, 13, 0, new Insets(2, 10, 5, 0)));
        stwidth.addItemListener(this);
        swrap.addItem(wrapNames);
        twrap.addItem(wrapNames);
        filter.addItem(filterNames);
        stwidth.addItem(widthNames);
        TextureTool.stwidth.combo.setSelectedIndex(1);
        this.contentPane.add((Component)inputPanel, new GBC(0, 0, 4, 2, 1.0, 0.0, 0, 0, 18, 2, new Insets(5, 5, 2, 5)));
        this.contentPane.add((Component)maptypePanel, new GBC(0, 2, 4, 2, 1.0, 0.0, 0, 0, 18, 2, new Insets(2, 5, 2, 5)));
        this.contentPane.add((Component)optionsPanel, new GBC(0, 4, 4, 2, 1.0, 0.0, 0, 0, 18, 2, new Insets(2, 5, 5, 5)));
        this.contentPane.add((Component)hideButton, new GBC(2, 6, 1, 1, 1.0, 1.0, 0, 0, 17, 0, new Insets(5, 10, 10, 2)));
        this.contentPane.add((Component)makeButton, new GBC(3, 6, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(5, 2, 10, 5)));
        makeButton.addActionListener(this);
        hideButton.addActionListener(this);
        this.setTitle(this.title);
        TextureTool.load();
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
        makeButton.grabFocus();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    private static void load() {
        int maptype = 1;
        StringBuffer output = new StringBuffer();
        try {
            String line;
            File makeTexRibFile = new File(FileUtils.getPWDFile(), "make.rib");
            if (!makeTexRibFile.exists()) {
                Cutter.setLog("    Info:TextureTool.load() - cannot find \"" + makeTexRibFile.getPath() + "\"");
                return;
            }
            Cutter.setLog("    Info:TextureTool.load() - parsing \"make.rib\"");
            BufferedReader inn = new BufferedReader(new FileReader(new File(FileUtils.getPWDFile(), "make.rib")), 1024);
            output.setLength(0);
            while ((line = inn.readLine()) != null) {
                String[] out;
                int w;
                String f;
                boolean overwrite = true;
                RibTokenizer tok = new RibTokenizer();
                tok.setBuffer(line);
                tok.parseComments = true;
                String str = tok.getNextStr();
                if (str.equals("")) {
                    return;
                }
                if (str.charAt(0) == '#') {
                    overwrite = false;
                }
                maptype = str.equals("#MakeTexture") || str.equals("MakeTexture") ? 1 : 2;
                String name = tok.getNextStr();
                if (name.equals("")) {
                    Cutter.setLog("    Error: TextureTools.load() - couldn't read image name");
                    return;
                }
                String tex = tok.getNextStr();
                if (tex.equals("")) {
                    Cutter.setLog("    Error: TextureTools.load() - couldn't read texture name");
                    return;
                }
                String srcDir = UnixUtils.parent(name);
                String destDir = UnixUtils.path(RenderInfo.get(14));
                name = UnixUtils.name(name);
                if (maptype == 1) {
                    String swrap = tok.getNextStr();
                    if (swrap.equals("")) {
                        Cutter.setLog("    Error: TextureTools.load() - couldn't read texture swrap");
                        return;
                    }
                    String twrap = tok.getNextStr();
                    if (twrap.equals("")) {
                        Cutter.setLog("    Error: TextureTools.load() - couldn't read texture twrap");
                        return;
                    }
                    f = tok.getNextStr();
                    if (f.equals("")) {
                        Cutter.setLog("    Error: TextureTools.load() - couldn't read texture filter");
                        return;
                    }
                    str = tok.getNextStr();
                    if (str.equals("")) {
                        Cutter.setLog("    Error: TextureTools.load() - couldn't read texture width");
                        return;
                    }
                    try {
                        w = Integer.parseInt(str);
                    }
                    catch (NumberFormatException e) {
                        Cutter.setLog("    Exception:TextureTools.load() - number format error reading \"make.rib\" ");
                        w = 2;
                    }
                    out = new String[]{"MakeTexture", name, srcDir, destDir, swrap, twrap, f, "" + w};
                    out = TextUtils.removeQuotes(out);
                    TextureTool.adjustGUI(1, out, overwrite);
                    RenderInfo.textureData.add("MakeTexture", name, srcDir, destDir, swrap, twrap, f, w, overwrite);
                    continue;
                }
                f = tok.getNextStr();
                if (f.equals("")) {
                    Cutter.setLog("    Error: TextureTools.load() - couldn't read texture filter");
                    return;
                }
                str = tok.getNextStr();
                if (str.equals("")) {
                    Cutter.setLog("    Error: TextureTools.load() - couldn't read texture width");
                    return;
                }
                try {
                    w = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    Cutter.setLog("Number format error reading \"make.rib\" ");
                    w = 2;
                }
                out = new String[]{"MakeLatLongEnvironment", name, srcDir, destDir, "", "", f, "" + w};
                out = TextUtils.removeQuotes(out);
                TextureTool.adjustGUI(2, out, overwrite);
                RenderInfo.textureData.add("MakeLatLongEnvironment", name, srcDir, destDir, "", "", f, w, overwrite);
            }
        }
        catch (IOException e) {
            Cutter.setLog("    Info:TextureTools.load(): cannot find an existing \"make.rib\"");
            return;
        }
    }

    private static void adjustGUI(int makeID, String[] item, boolean overwrite) {
        srcNames.removeItem(EMPTY_LIST_STR);
        srcNames.addItem(item[1]);
        srcNames.setSelectedItem(item[1]);
        srcfield.setText(item[2].replace(File.separatorChar, '/'));
        destfield.setText(item[3].replace(File.separatorChar, '/'));
        removeImageButton.setEnabled(true);
        filter.setSelectedItem(item[6]);
        stwidth.setSelectedItem(item[7]);
        autoMake.setSelected(overwrite);
        switch (makeID) {
            case 1: {
                swrap.setEnabled(true);
                twrap.setEnabled(true);
                swrap.setSelectedItem(item[4]);
                twrap.setSelectedItem(item[5]);
                break;
            }
            case 2: {
                swrap.setEnabled(false);
                twrap.setEnabled(false);
            }
        }
        mapTypes.setSelectedItem(item[0]);
    }

    private File chooseTiff() {
        OpenFileDialog dialog = OpenFileDialog.getInstance(Cutter.desktop);
        File[] files = dialog.showSelf(new KFileFilter("tif", "Tagged Image File Format"), "Choose Tiff", 2);
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private void add() {
        String name = srcNames.getSelectedItem();
        String srcDir = TextureTool.srcfield.textfield.getText();
        String destDir = TextureTool.destfield.textfield.getText();
        boolean overwrite = autoMake.isSelected();
        String s = swrap.getSelectedItem();
        String t = twrap.getSelectedItem();
        String f = filter.getSelectedItem();
        int w = Integer.parseInt(stwidth.getSelectedItem());
        String type = mapTypes.getSelectedItem();
        RenderInfo.textureData.add(type, name, srcDir, destDir, s, t, f, w, overwrite);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == makeButton) {
            this.doMake();
        } else if (e.getSource() == hideButton) {
            this.showSelf();
        } else if (e.getSource() == addImageButton) {
            File file = this.chooseTiff();
            if (file == null) {
                return;
            }
            if (srcNames.getItemCount() == 1 && srcNames.getSelectedItem().equals(EMPTY_LIST_STR)) {
                srcNames.removeItem(EMPTY_LIST_STR);
            }
            String name = file.getName();
            srcNames.addItem(name);
            TextureTool.srcNames.combo.setSelectedItem(name);
            srcfield.setText(file.getParent().replace(File.separatorChar, '/'));
            removeImageButton.setEnabled(true);
            autoMake.setSelected(false);
            this.add();
        } else if (e.getSource() == removeImageButton) {
            if (srcNames.getItemCount() == 1 && srcNames.getSelectedItem().equals(EMPTY_LIST_STR)) {
                return;
            }
            String name = srcNames.getSelectedItem();
            if (name != null || name.length() != 0) {
                srcNames.removeItem(name);
                RenderInfo.textureData.remove(name);
                srcfield.setText(cutterPath);
            }
            if (srcNames.getItemCount() == 0) {
                srcNames.addItem(EMPTY_LIST_STR);
                removeImageButton.setEnabled(false);
                File makeRibFile = new File(FileUtils.getPWD(), "make.rib");
                FileUtils.writeFile(makeRibFile, "");
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 2 && e.getSource() != autoMake || srcNames == null) {
            return;
        }
        String name = srcNames.getSelectedItem();
        String type = mapTypes.getSelectedItem();
        swrap.setEnabled(type.equalsIgnoreCase("MakeTexture"));
        twrap.setEnabled(type.equalsIgnoreCase("MakeTexture"));
        if (e.getSource() == TextureTool.swrap.combo) {
            RenderInfo.textureData.set(name, 5, swrap.getSelectedItem());
        } else if (e.getSource() == TextureTool.twrap.combo) {
            RenderInfo.textureData.set(name, 6, twrap.getSelectedItem());
        } else if (e.getSource() == TextureTool.filter.combo) {
            RenderInfo.textureData.set(name, 7, filter.getSelectedItem());
        } else if (e.getSource() == TextureTool.stwidth.combo) {
            RenderInfo.textureData.set(name, 8, stwidth.getSelectedItem());
        } else if (e.getSource() == TextureTool.srcNames.combo) {
            String[] item = RenderInfo.textureData.get(srcNames.getSelectedItem());
            if (item == null) {
                return;
            }
            TextureTool.swrap.combo.setSelectedItem(item[5]);
            TextureTool.twrap.combo.setSelectedItem(item[6]);
            TextureTool.filter.combo.setSelectedItem(item[7]);
            TextureTool.swrap.combo.setSelectedItem(item[5]);
            TextureTool.stwidth.combo.setSelectedItem(item[8]);
            srcfield.setText(item[3]);
            destfield.setText(item[4]);
            mapTypes.setSelectedItem(item[0]);
            boolean flag = false;
            if (item[10] == "true") {
                flag = true;
            }
            autoMake.setSelected(flag);
        } else if (e.getSource() == autoMake) {
            RenderInfo.textureData.set(name, 10, autoMake.isSelected() ? "true" : "false");
        } else if (e.getSource() == TextureTool.mapTypes.combo) {
            RenderInfo.textureData.set(name, 0, mapTypes.getSelectedItem());
            RenderInfo.textureData.set(name, 5, swrap.getSelectedItem());
            RenderInfo.textureData.set(name, 6, twrap.getSelectedItem());
        }
    }

    private String[][] confirm(String[][] items) {
        Vector<String[]> list = new Vector<String[]>();
        Vector<String> listOfRemoveNames = new Vector<String>();
        for (int n = 0; n < items.length; ++n) {
            String fullpath = items[n][3] + File.separatorChar + items[n][1];
            File f = new File(fullpath);
            if (f.exists()) {
                String[] item = new String[items[n].length];
                for (int i = 0; i < items[n].length; ++i) {
                    item[i] = items[n][i];
                }
                list.addElement(item);
                continue;
            }
            String name = items[n][1];
            srcNames.removeItem(name);
            listOfRemoveNames.addElement(name);
            RenderInfo.textureData.remove(name);
        }
        String[][] out = new String[list.size()][items[0].length];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (String[])list.elementAt(n);
        }
        if (listOfRemoveNames.size() > 0) {
            StringBuffer msg = new StringBuffer();
            for (int n = 0; n < listOfRemoveNames.size(); ++n) {
                msg.append("    \"" + (String)listOfRemoveNames.elementAt(n) + "\"\n");
            }
            JOptionPane.showMessageDialog(Cutter.desktop, "One or more textures cannot be made because\nCutter is unable to locate their source TIFF files.\n\nThey have been removed from the list of named \nimages, those effected are:-\n" + msg.toString(), "Missing TIFF's Warning", 2);
        }
        return out;
    }

    public void doTDLMake(String[][] items) {
        StringBuffer errorMsg = new StringBuffer();
        StringBuffer buff = new StringBuffer();
        Vector<String> list = new Vector<String>();
        makeButton.setEnabled(false);
        for (int n = 0; n < items.length; ++n) {
            StringBuffer tmp = new StringBuffer();
            String fullTiffName = items[n][3].replace(BACKSLASH, '/') + '/' + items[n][1];
            String fullTxName = UnixUtils.path(RenderInfo.get(14)) + '/' + items[n][2];
            list.removeAllElements();
            if (items[n][0].equalsIgnoreCase("MakeLatLongEnvironment")) {
                list.addElement("-envlatl");
                tmp.append("MakeLatLongEnvironment");
            } else {
                tmp.append("MakeTexture");
            }
            tmp.append(" \"" + fullTiffName + "\" \"" + fullTxName + "\"");
            list.addElement("-smode");
            list.addElement(items[n][5]);
            tmp.append(" \"" + items[n][5] + "\"");
            list.addElement("-tmode");
            list.addElement(items[n][6]);
            tmp.append(" \"" + items[n][6] + "\"");
            list.addElement("-filter");
            list.addElement(items[n][7]);
            tmp.append(" \"" + items[n][7] + "\"");
            list.addElement("-sfilterwidth");
            list.addElement(items[n][8]);
            tmp.append(" " + items[n][8]);
            list.addElement("-tfilterwidth");
            list.addElement(items[n][8]);
            tmp.append(" " + items[n][8]);
            list.addElement(fullTiffName);
            list.addElement(fullTxName);
            String[] params = new String[list.size()];
            Object[] obj = list.toArray();
            for (int i = 0; i < list.size(); ++i) {
                params[i] = (String)obj[i];
            }
            File txfile = new File(UnixUtils.path(RenderInfo.get(14)), items[n][2]);
            if (items[n][10].equals("false") && txfile.exists()) {
                buff.append("#");
                buff.append(tmp);
            } else {
                buff.append(tmp);
            }
            buff.append("\n");
            if ((!items[n][10].equals("false") || txfile.exists()) && !items[n][10].equals("true")) continue;
            errorMsg.setLength(0);
            this.launchProcess("tdlmake", params, errorMsg);
            if (errorMsg.length() <= 0) continue;
            Tokenizer tok = new Tokenizer();
            tok.setBuffer(errorMsg);
            if (tok.charSearch("error", true) == null) continue;
            JOptionPane.showMessageDialog(Cutter.desktop, "The texture \"" + items[n][2] + "\" was not made.\n" + TextUtils.format(errorMsg.toString(), 75, 200, null), "Make Texture Warning", 0);
        }
        makeButton.setEnabled(true);
        File ribFile = new File("make.rib");
        FileSaver ribwriter = new FileSaver(ribFile, buff);
        ribwriter.start();
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
    }

    public void doMake() {
        String[][] items = RenderInfo.textureData.get();
        if (items == null) {
            return;
        }
        items = this.confirm(items);
        destfield.setText(UnixUtils.path(RenderInfo.get(14)));
        if (RenderInfo.activeRendererIs("3delight")) {
            this.doTDLMake(items);
            return;
        }
        StringBuffer buff = new StringBuffer();
        boolean hasContent = false;
        for (int n = 0; n < items.length; ++n) {
            String fullTiffName = '\"' + items[n][3].replace(BACKSLASH, '/') + '/' + items[n][1] + '\"';
            String fullTxName = '\"' + UnixUtils.path(RenderInfo.get(14)) + '/' + items[n][2] + '\"';
            File txfile = new File(UnixUtils.path(RenderInfo.get(14)), items[n][2]);
            String command = "MakeTexture";
            command = items[n][0];
            if (items[n][10].equals("false") && txfile.exists()) {
                command = "#" + command;
            }
            hasContent = true;
            if (command.equalsIgnoreCase("#MakeLatLongEnvironment") || command.equalsIgnoreCase("MakeLatLongEnvironment")) {
                buff.append(command + " " + fullTiffName + " " + fullTxName + " \"" + items[n][7] + "\" " + items[n][8] + " " + items[n][8] + '\n');
                continue;
            }
            buff.append(command + " " + fullTiffName + " " + fullTxName + " \"" + items[n][5] + "\" \"" + items[n][6] + "\" \"" + items[n][7] + "\" " + items[n][8] + " " + items[n][8] + '\n');
        }
        if (hasContent) {
            buff.append('\n');
            File ribFile = new File(FileUtils.getPWDFile(), "make.rib");
            FileSaver ribwriter = new FileSaver(ribFile, buff);
            ribwriter.start();
            Vector<String> list = RenderInfo.getUserFlags(10);
            String[] flags = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                flags[i] = list.elementAt(i);
            }
            String[] arr = new String[flags.length + 2];
            arr[0] = RenderInfo.get(3);
            for (int n = 1; n <= flags.length; ++n) {
                arr[n] = flags[n];
            }
            arr[arr.length - 1] = ribFile.getPath();
            ProcessManager fp = new ProcessManager("RIB Renderer");
            fp.launch(arr, null, false, this, false);
        } else {
            Cutter.setLog("All textures are uptodate - none needed to be made.");
        }
    }

    @Override
    public void processSentString(String procName, String output) {
    }

    @Override
    public void processStarted(String procName, String[] progarray, String procID) {
    }

    @Override
    public void processFinished(String[] progarray) {
        Monitor.finalizePanelText("RIB Renderer", "Completed:\n");
    }

    protected void launchProcess(String cmd, String[] params, StringBuffer out) {
        StringBuffer tmp = new StringBuffer();
        String[] progarray = new String[params.length + 1];
        progarray[0] = cmd.trim();
        for (int n = 0; n < params.length; ++n) {
            progarray[n + 1] = params[n];
        }
        try {
            int c;
            Process child = Runtime.getRuntime().exec(progarray);
            InputStream in = child.getErrorStream();
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                tmp.append(ch);
            }
            in.close();
            child.destroy();
        }
        catch (IOException e) {
            Cutter.setLog("    Error:TextureTools.launchProcess() using command >" + cmd + "<" + e);
            out.append(e.toString() + "  Check the path to your \"textures\" directory is correct.");
            return;
        }
        out.append(tmp);
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }
}

