/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.TransformsTool;

import UI_Components.GBC;
import UI_Components.KComboItem;
import UI_Components.KTitledKComboItemBox;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import UI_Tools.TransformsTool.TransformsTool;
import Utilities.Matrix3D;
import Utilities.NumberUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class MatrixPanel
extends KTitledPanel {
    private static final int NUMBER_STR = 1;
    private static final int TRIG_STR = 2;
    private static int displayMode = 1;
    private static Color trigRect = Color.red;
    private static ResourceBundle presetsBundle;
    private MatrixSubPanel matrixSubPanel = new MatrixSubPanel();
    MatrixField[][] field = new MatrixField[][]{{new MatrixField("1"), new MatrixField("0"), new MatrixField("0"), new MatrixField("0")}, {new MatrixField("0"), new MatrixField("1"), new MatrixField("0"), new MatrixField("0")}, {new MatrixField("0"), new MatrixField("0"), new MatrixField("1"), new MatrixField("0")}, {new MatrixField("0"), new MatrixField("0"), new MatrixField("0"), new MatrixField("1")}};
    private JCheckBox trigCheck = new JCheckBox("math");
    private JRadioButton miRadio = new JRadioButton("mental ray");
    private JRadioButton leftHand = new JRadioButton("lh");
    private JRadioButton rightHand = new JRadioButton("rh");
    private ButtonGroup handedGroup = new ButtonGroup();
    public static int decimalPlaces;

    public MatrixPanel() {
        super(" Matrix ", "TransformsTool.MatrixPanel.info");
        this.field[0][3].setColumns(2);
        this.field[1][3].setColumns(2);
        this.field[2][3].setColumns(2);
        this.field[3][3].setColumns(2);
        this.matrixSubPanel.setLayout(new GridBagLayout());
        this.matrixSubPanel.add((Component)this.field[0][0], new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(5, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[0][1], new GBC(1, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(5, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[0][2], new GBC(2, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(5, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[0][3], new GBC(3, 0, 1, 1, 1.0, 0.0, 1, 0, 12, 1, new Insets(5, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[1][0], new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[1][1], new GBC(1, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[1][2], new GBC(2, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[1][3], new GBC(3, 1, 1, 1, 1.0, 0.0, 1, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[2][0], new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[2][1], new GBC(1, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[2][2], new GBC(2, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[2][3], new GBC(3, 2, 1, 1, 1.0, 0.0, 1, 0, 12, 1, new Insets(0, 0, 0, 0)));
        this.matrixSubPanel.add((Component)this.field[3][0], new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 5, 0)));
        this.matrixSubPanel.add((Component)this.field[3][1], new GBC(1, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 5, 0)));
        this.matrixSubPanel.add((Component)this.field[3][2], new GBC(2, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 0, 5, 0)));
        this.matrixSubPanel.add((Component)this.field[3][3], new GBC(3, 3, 1, 1, 1.0, 0.0, 1, 1, 12, 1, new Insets(0, 0, 5, 0)));
        this.matrixSubPanel.setBackground(new Color(230, 230, 230));
        this.matrixSubPanel.setBorder(BorderFactory.createEtchedBorder());
        this.miRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MatrixPanel.this.miRadio.isSelected()) {
                    TransformsTool.transformType = 2;
                } else {
                    int n = TransformsTool.transformType = MatrixPanel.this.rightHand.isSelected() ? 3 : 4;
                }
                if (TransformsTool.instance != null) {
                    MatrixPanel.this.calculateMatrix(TransformsTool.instance.getTransformations(), null);
                }
            }
        });
        this.rightHand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MatrixPanel.this.rightHand.isSelected()) {
                    TransformsTool.transformType = 3;
                }
                if (TransformsTool.instance != null) {
                    MatrixPanel.this.calculateMatrix(TransformsTool.instance.getTransformations(), null);
                }
            }
        });
        this.leftHand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MatrixPanel.this.leftHand.isSelected()) {
                    TransformsTool.transformType = 4;
                }
                if (TransformsTool.instance != null) {
                    MatrixPanel.this.calculateMatrix(TransformsTool.instance.getTransformations(), null);
                }
            }
        });
        this.handedGroup.add(this.leftHand);
        this.handedGroup.add(this.rightHand);
        this.handedGroup.add(this.miRadio);
        final KTitledKComboItemBox presetPopup = new KTitledKComboItemBox("Presets");
        this.trigCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                displayMode = MatrixPanel.this.trigCheck.isSelected() ? 2 : 1;
                if (TransformsTool.instance != null) {
                    MatrixPanel.this.calculateMatrix(TransformsTool.instance.getTransformations(), null);
                }
            }
        });
        this.add(this.matrixSubPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 5, 0, 5)));
        this.add(this.miRadio, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 2, 0, 2)));
        this.add(this.rightHand, new GBC(1, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 2)));
        this.add(this.leftHand, new GBC(2, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 2, 0, 2)));
        this.add(this.trigCheck, new GBC(3, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 2, 0, 0)));
        this.add(new JSeparator(), new GBC(0, 2, 4, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(0, 5, 5, 5)));
        this.add(presetPopup, new GBC(0, 3, 4, 1, 1.0, 1.0, 0, 0, 12, 0, new Insets(0, 2, 5, 5)));
        String[] nameOfPreset = TextUtils.tokenize(KTools.getResourceString(presetsBundle, "Transforms"));
        String values = KTools.getResourceString(presetsBundle, nameOfPreset[0]);
        for (int n = 0; n < nameOfPreset.length; ++n) {
            String name = KTools.getResourceString(presetsBundle, nameOfPreset[n]);
            KComboItem item = new KComboItem(nameOfPreset[n], name);
            presetPopup.addItem(item);
        }
        presetPopup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KComboItem item = (KComboItem)presetPopup.combo.getSelectedItem();
                String[] tvals = new String[]{"0", "0", "0", "0", "0", "0", "1", "1", "1"};
                String[] t = TextUtils.tokenize(item.tiptext);
                if (t != null && t.length == 9) {
                    for (int n = 0; n < t.length; ++n) {
                        tvals[n] = t[n];
                    }
                }
                double[] tran = new double[9];
                for (int n = 0; n < tvals.length; ++n) {
                    try {
                        tran[n] = NumberUtils.strToDouble(tvals[n]);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        Cutter.setLog("    Exception:MatrixPanel.actionPerformed() \n" + ex.toString());
                        tran[n] = 0.0;
                    }
                }
                if (TransformsTool.instance != null) {
                    TransformsTool.instance.setTransformations(tran);
                }
            }
        });
        this.rightHand.setSelected(true);
    }

    public void calculateMatrix(double[] tran, String tname) {
        Matrix3D mat = new Matrix3D();
        double tx = tran[0];
        double ty = tran[1];
        double tz = tran[2];
        double rx = tran[3];
        double ry = tran[4];
        double rz = tran[5];
        double sx = tran[6];
        double sy = tran[7];
        double sz = tran[8];
        Matrix3D T = new Matrix3D();
        Matrix3D Rx = new Matrix3D();
        Matrix3D Ry = new Matrix3D();
        Matrix3D Rz = new Matrix3D();
        Matrix3D S = new Matrix3D();
        if (TransformsTool.transformType == 1 || TransformsTool.transformType == 2) {
            S.scale(1.0 / sx, 1.0 / sy, 1.0 / sz);
            Rx.rotateX(MatrixPanel.deg2rad(rx));
            Ry.rotateY(MatrixPanel.deg2rad(ry));
            Rz.rotateZ(MatrixPanel.deg2rad(rz));
        } else if (TransformsTool.transformType == 3) {
            S.scale(sx, sy, sz);
            Rx.rotateX(MatrixPanel.deg2rad(-rx));
            Ry.rotateY(MatrixPanel.deg2rad(-ry));
            Rz.rotateZ(MatrixPanel.deg2rad(-rz));
        } else {
            S.scale(sx, sy, sz);
            Rx.rotateX(MatrixPanel.deg2rad(rx));
            Ry.rotateY(MatrixPanel.deg2rad(ry));
            Rz.rotateZ(MatrixPanel.deg2rad(rz));
        }
        boolean scaleApplied = false;
        boolean translateApplied = false;
        if (TransformsTool.transformType == 2) {
            mat.translate(tx * -1.0, ty * -1.0, tz * -1.0);
            mat.postMultiply(Rz);
            mat.postMultiply(Ry);
            mat.postMultiply(Rx);
            mat.postMultiply(S);
        } else if (TransformsTool.transformType == 1) {
            mat.postMultiply(Rz);
            mat.postMultiply(Ry);
            mat.postMultiply(Rx);
            mat.translate(tx * -1.0, ty * -1.0, tz * -1.0);
            mat.postMultiply(S);
        } else {
            mat.postMultiply(S);
            mat.postMultiply(Rx);
            mat.postMultiply(Ry);
            mat.postMultiply(Rz);
            mat.translate(tx, ty, tz);
        }
        String[] m = MatrixPanel.to4x4String(mat);
        if (m == null) {
            return;
        }
        this.matrixSubPanel.trigRect = null;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.field[i][j].hideBorder();
            }
        }
        this.field[0][0].setText(m[0]);
        this.field[0][1].setText(m[1]);
        this.field[0][2].setText(m[2]);
        this.field[0][3].setText(m[3]);
        this.field[1][0].setText(m[4]);
        this.field[1][1].setText(m[5]);
        this.field[1][2].setText(m[6]);
        this.field[1][3].setText(m[7]);
        this.field[2][0].setText(m[8]);
        this.field[2][1].setText(m[9]);
        this.field[2][2].setText(m[10]);
        this.field[2][3].setText(m[11]);
        this.field[3][0].setText(m[12]);
        this.field[3][1].setText(m[13]);
        this.field[3][2].setText(m[14]);
        this.field[3][3].setText(m[15]);
        if (displayMode == 2 && tname != null) {
            if (tname.equals("tx")) {
                this.field[3][0].setText("tx");
                this.field[3][0].showBorder();
            }
            if (tname.equals("ty")) {
                this.field[3][1].setText("ty");
                this.field[3][1].showBorder();
            }
            if (tname.equals("tz")) {
                this.field[3][2].setText("tz");
                this.field[3][2].showBorder();
            }
            if (tname.equals("rx")) {
                this.field[1][1].setText("cos X");
                this.field[1][2].setText("-sin X");
                this.field[2][1].setText("sin X");
                this.field[2][2].setText("cos X");
                Rectangle tl = this.field[1][1].getBounds(null);
                this.matrixSubPanel.trigRect = new Rectangle(tl.x, tl.y, tl.width * 2, tl.height * 2);
            }
            if (tname.equals("ry")) {
                this.field[0][0].setText("cos Y");
                this.field[0][2].setText("sin Y");
                this.field[2][0].setText("-sin Y");
                this.field[2][2].setText("cos Y");
                this.field[0][0].showBorder();
                this.field[0][2].showBorder();
                this.field[2][0].showBorder();
                this.field[2][2].showBorder();
            }
            if (tname.equals("rz")) {
                this.field[0][0].setText("cos Z");
                this.field[0][1].setText("-sin Z");
                this.field[1][0].setText("sin Z");
                this.field[1][1].setText("cos Z");
                Rectangle tl = this.field[0][0].getBounds(null);
                this.matrixSubPanel.trigRect = new Rectangle(tl.x, tl.y, tl.width * 2, tl.height * 2);
            }
            if (tname.equals("sx")) {
                this.field[0][0].setText("sx");
                this.field[0][0].showBorder();
            }
            if (tname.equals("sy")) {
                this.field[1][1].setText("sy");
                this.field[1][1].showBorder();
            }
            if (tname.equals("sz")) {
                this.field[2][2].setText("sz");
                this.field[2][2].showBorder();
            }
        }
    }

    public String matrixFieldsToString(int leadingTabs) {
        StringBuffer buf = new StringBuffer();
        String tabStr = "";
        for (int n = 0; n < leadingTabs; ++n) {
            tabStr = tabStr + "\t";
        }
        buf.append(tabStr + this.field[0][0].getText()).append(" ").append(this.field[0][1].getText()).append(" ").append(this.field[0][2].getText()).append(" ").append(this.field[0][3].getText() + "\n");
        buf.append(tabStr + this.field[1][0].getText()).append(" ").append(this.field[1][1].getText()).append(" ").append(this.field[1][2].getText()).append(" ").append(this.field[1][3].getText() + "\n");
        buf.append(tabStr + this.field[2][0].getText()).append(" ").append(this.field[2][1].getText()).append(" ").append(this.field[2][2].getText()).append(" ").append(this.field[2][3].getText() + "\n");
        buf.append(tabStr + this.field[3][0].getText()).append(" ").append(this.field[3][1].getText()).append(" ").append(this.field[3][2].getText()).append(" ").append(this.field[3][3].getText());
        return buf.toString();
    }

    static double deg2rad(double deg) {
        return Math.PI / 180 * deg;
    }

    public static String[] to4x4String(Matrix3D mat) {
        String[] out = new String[16];
        try {
            String[] tokens = TextUtils.tokenize(mat.toString());
            StringBuffer buf = new StringBuffer();
            for (int n = 0; n < tokens.length; ++n) {
                double d = Double.parseDouble(tokens[n]);
                out[n] = MatrixPanel.clip(d);
            }
        }
        catch (Exception ex) {
            Cutter.setLog("    Exception:MatrixPanel.to4x4String()\n" + ex.toString());
            return null;
        }
        return out;
    }

    public static String clip(double value) {
        String out;
        if (Math.abs(value) < 1.0E-5) {
            return "0";
        }
        if (Math.abs(value) % 2.0 == 0.0 || Math.abs(value) % 2.0 == 1.0) {
            return "" + (int)value;
        }
        long round = Math.round(value);
        double diff = Math.abs(value - (double)round);
        if (diff < 1.0E-5) {
            value = round;
        }
        StringBuffer raw = new StringBuffer("" + value);
        int dot = 0;
        for (int n = 0; n < raw.length(); ++n) {
            if (raw.charAt(n) != '.') continue;
            dot = n + 1;
            break;
        }
        if (raw.length() > dot + decimalPlaces) {
            raw.setLength(dot + decimalPlaces);
        }
        if ((out = raw.toString()).equals("0.0")) {
            return "0";
        }
        if (out.equals("1.0")) {
            return "1";
        }
        return out;
    }

    static {
        try {
            presetsBundle = ResourceBundle.getBundle("UI_Tools.TransformsTool.Resources.MatrixPresetsRsrc");
        }
        catch (MissingResourceException mre) {
            Cutter.setLog("    Error:MatrixPanel.static() - MatrixPresetsRsrc is missing --> " + mre);
        }
        decimalPlaces = 4;
    }

    private class MatrixSubPanel
    extends JPanel {
        public Rectangle trigRect = null;

        private MatrixSubPanel() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.trigRect != null) {
                g.setColor(Color.red);
                g.drawRect(this.trigRect.x, this.trigRect.y, this.trigRect.width, this.trigRect.height);
            }
        }
    }

    private class MatrixField
    extends JTextField {
        private String numberStr;
        private String trigStr;

        public MatrixField(String text) {
            super(7);
            this.numberStr = "";
            this.trigStr = "";
            this.setText(text);
            this.setBackground(new Color(230, 230, 230));
            this.setOpaque(true);
            this.setEditable(false);
            this.setCaretColor(new Color(230, 230, 230));
            this.setSelectionColor(new Color(230, 230, 230));
            this.setBorder(new LineBorder(new Color(230, 230, 230), 0));
            Font f = this.getFont();
            this.setFont(new Font("Monospaced", f.getStyle(), f.getSize() + 2));
        }

        public void showBorder() {
            this.setBorder(new LineBorder(new Color(255, 0, 0), 1));
        }

        public void hideBorder() {
            this.setBorder(new LineBorder(new Color(230, 230, 230), 0));
        }

        public void setDisplayMode(int mode) {
            displayMode = mode;
            if (mode == 1) {
                this.setText(this.numberStr);
            }
        }

        @Override
        public void setText(String str) {
            if (displayMode == 1) {
                this.numberStr = str;
            }
            super.setText(!str.startsWith("-") ? " " + str : str);
        }

        @Override
        public String getText() {
            String str = this.numberStr;
            if (str.startsWith("-") && str.length() > 8) {
                str = str.substring(0, 8);
            } else if (str.length() > 7) {
                str = str.substring(0, 7);
            }
            String tail = "       ";
            if (str.startsWith("-")) {
                return str + tail.substring(0, 8 - str.length());
            }
            return " " + str + tail.substring(0, 7 - str.length());
        }
    }
}

