/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.TransformsTool;

import Preferences.Preferences;
import UI_BBXT.BBxt;
import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KLabel;
import UI_Components.KTextField.KFloatTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.KTools;
import UI_Tools.TransformsTool.MatrixPanel;
import Utilities.ComponentUtils;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import kernal.Tokenizers.Tokenizer;

public class TransformsTool
extends KTools
implements ActionListener,
MouseListener {
    public static final int MI_CAMERA = 1;
    public static final int MI_OBJECT = 2;
    public static final int RIGHT_HANDED = 3;
    public static final int LEFT_HANDED = 4;
    public static int transformType = 3;
    private static KTitledPanel inputPanel = new KTitledPanel(" Transformations ", "TransformsTool.TransformsPanel.info");
    private static JPanel labelPanel = new JPanel();
    private static JPanel valuePanel = new JPanel();
    private static MatrixPanel matrixPanel = new MatrixPanel();
    private static JButton applyButton = new KButton(" Apply ");
    public static TransformsTool instance = null;
    private TValue[] tval = new TValue[]{new TValue("0", "tx"), new TValue("0", "ty"), new TValue("0", "tz"), new TValue("0", "rx"), new TValue("0", "ry"), new TValue("0", "rz"), new TValue("1", "sx"), new TValue("1", "sy"), new TValue("1", "sz")};
    private static JCheckBox cmntCheck = new JCheckBox("add comments");
    private PanelPopup popup = new PanelPopup();

    public static TransformsTool getInstance(JMenuItem menuItem) {
        if (instance == null) {
            instance = new TransformsTool(menuItem);
        }
        return instance;
    }

    private TransformsTool(JMenuItem menuItem) {
        super("Transforms Tool", menuItem, Preferences.TOOL_MATRIX);
        int i;
        labelPanel.setLayout(new GridBagLayout());
        labelPanel.add((Component)new TLabel("Translate X"), new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Translate Y"), new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Translate Z"), new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Rotate X"), new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Rotate Y"), new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Rotate Z"), new GBC(0, 5, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Scale X"), new GBC(0, 6, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Scale Y"), new GBC(0, 7, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        labelPanel.add((Component)new TLabel("Scale Z"), new GBC(0, 8, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(2, 0, 2, 4)));
        valuePanel.setLayout(new GridBagLayout());
        valuePanel.add((Component)this.tval[0], new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[1], new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[2], new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[3], new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[4], new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[5], new GBC(0, 5, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[6], new GBC(0, 6, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[7], new GBC(0, 7, 1, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        valuePanel.add((Component)this.tval[8], new GBC(0, 8, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(1, 0, 1, 0)));
        inputPanel.add(labelPanel, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 1, new Insets(0, 5, 3, 5)));
        inputPanel.add(valuePanel, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 1, new Insets(0, 5, 3, 5)));
        this.tval[0].grabFocus();
        this.lastFocusedComponent = this.tval[0];
        this.lastFocusedComponent.selectAll();
        ComponentUtils cu = new ComponentUtils(inputPanel, "java.awt.Container");
        Component[] comps = cu.getAll();
        if (comps != null) {
            for (i = 0; i < comps.length; ++i) {
                comps[i].addMouseListener(this);
            }
        }
        if ((comps = (cu = new ComponentUtils(inputPanel, "UI_Components.KButton.KInfoButton")).getAll()) != null) {
            for (i = 0; i < comps.length; ++i) {
                comps[i].removeMouseListener(this);
            }
        }
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                matrixPanel;
                int oldval = MatrixPanel.decimalPlaces;
                matrixPanel;
                MatrixPanel.decimalPlaces = 6;
                matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), null);
                TransformsTool.this.copyMatrixToDocument();
                matrixPanel;
                MatrixPanel.decimalPlaces = oldval;
                matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), null);
            }
        });
        JPanel holder = new JPanel();
        holder.setLayout(new GridBagLayout());
        holder.add((Component)matrixPanel, new GBC(0, 0, 2, 1, 1.0, 0.0, 0, 0, 12, 1, new Insets(0, 5, 3, 5)));
        holder.add((Component)cmntCheck, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 5)));
        holder.add((Component)applyButton, new GBC(1, 1, 1, 1, 1.0, 1.0, 0, 0, 14, 0, new Insets(0, 5, 3, 5)));
        this.contentPane.add((Component)inputPanel, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 12, 1, new Insets(5, 5, 3, 0)));
        this.contentPane.add((Component)holder, new GBC(1, 0, 1, 1, 0.0, 1.0, 0, 0, 12, 1, new Insets(5, 0, 3, 5)));
        this.setTitle(this.title);
        this.pack();
        cmntCheck.setSelected(true);
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private double[] parseExistingComment() {
        Document doc = BBxt.getWindowDocument();
        if (doc == null) {
            Cutter.setLog("    Error:TransformsTool.copyMatrixToDocument() - cannot get front windows document!");
            return null;
        }
        int b = BBxt.getSelectionStart();
        int e = BBxt.getSelectionEnd();
        String sel = BBxt.getSelection().trim();
        if (b != e && !sel.equals("transform")) {
            return null;
        }
        String word = BBxt.selectWord();
        int wordBegin = BBxt.getSelectionStart();
        int wordEnd = BBxt.getSelectionEnd();
        if (word != null && (word.equals("transform") || word.equals("ray_transform"))) {
            String str;
            Cutter.setLog("Trans " + wordEnd + " " + (doc.getLength() - wordEnd));
            Segment segment = DocumentUtils.getSegment(doc, wordEnd, doc.getLength() - wordEnd);
            Tokenizer tok = new Tokenizer();
            tok.setBuffer(segment);
            tok.setDelimitor("\n\t ");
            StringBuffer buffer = new StringBuffer();
            Vector<String> list = new Vector<String>();
            while (!(str = tok.getNextStr()).equals("") && (str.equals("#") || str.startsWith("#"))) {
                int lineBegin = tok.getBufferIndex() - str.length();
                int lineEnd = tok.findNewline(tok.getBufferIndex());
                if (lineEnd == -1) {
                    lineEnd = tok.getBufferLength();
                }
                str = new String(tok.getBuffer(lineBegin, lineEnd));
                str = str.trim().substring(1);
                buffer.append(str.trim() + "\n");
                list.addElement(str.trim());
                tok.setBufferIndex(lineEnd);
            }
            int op = 0;
            double[] val = new double[9];
            for (int n = 0; n < list.size(); ++n) {
                str = (String)list.elementAt(n);
                Cutter.setLog("Trans >" + str + "<");
                if (str.startsWith("translate")) {
                    op = 0;
                    str = str.substring(9);
                } else if (str.startsWith("rotate")) {
                    op = 3;
                    str = str.substring(6);
                } else if (str.startsWith("scale")) {
                    op = 6;
                    str = str.substring(5);
                }
                String[] valStr = TextUtils.tokenize(str.trim(), ",");
                if (valStr == null || valStr.length != 3) continue;
                try {
                    val[op + 0] = Double.parseDouble(valStr[0]);
                    val[op + 1] = Double.parseDouble(valStr[1]);
                    val[op + 2] = Double.parseDouble(valStr[2]);
                    continue;
                }
                catch (NumberFormatException er) {
                    Cutter.setLog("    Exception:TransformsTool.parseExistingComment()\n" + er.toString());
                    BBxt.setSelection(b, e);
                    return null;
                }
            }
            BBxt.setSelection(b, e);
            Cutter.setLog("Trans returning val");
            return val;
        }
        BBxt.setSelection(b, e);
        Cutter.setLog("Trans returning null");
        return null;
    }

    private void copyMatrixToDocument() {
        int b = BBxt.getSelectionStart();
        int e = BBxt.getSelectionEnd();
        if (b == -1 || e == -1) {
            Cutter.setLog("    Error:TransformsTool.copyMatrixToDocument() - cannot find a location to paste the matrix text");
            return;
        }
        Document doc = BBxt.getWindowDocument();
        if (doc == null) {
            Cutter.setLog("    Error:TransformsTool.copyMatrixToDocument() - cannot get front windows document!");
            return;
        }
        int leadingTabs = DocumentUtils.countTabStopsAtOffset(doc, BBxt.getSelectionEnd());
        if (b != e) {
            String sel = BBxt.getSelection();
            if (sel.trim().equals("transform")) {
                int beginOffset = 0;
                for (int n = 0; n < sel.length() && Character.isWhitespace(sel.charAt(n)); ++n) {
                    ++beginOffset;
                }
                BBxt.setSelection(b += beginOffset, b);
            } else {
                String matStr = matrixPanel.matrixFieldsToString(leadingTabs);
                String ext = BBxt.getWindowExtension();
                String comment = "";
                if (ext != null && ext.equalsIgnoreCase(".ifd")) {
                    matStr = matStr.replaceAll("[\\s]+", " ");
                    matStr = matStr.trim();
                    comment = cmntCheck.isSelected() ? this.getCommentsForTransforms() : "";
                } else {
                    comment = cmntCheck.isSelected() ? this.getCommentsForTransforms() : "";
                    comment = comment + "\n";
                }
                BBxt.setSelection(b, e);
                if (ext != null && ext.equalsIgnoreCase(".ifd")) {
                    BBxt.paste(matStr + comment);
                } else {
                    BBxt.paste(comment + matStr);
                }
                BBxt.parseAll();
                BBxt.setSelection(b, b);
                return;
            }
        }
        String word = BBxt.selectWord();
        int wordBegin = BBxt.getSelectionStart();
        int wordEnd = BBxt.getSelectionEnd();
        if (word == null || word.length() == 0) {
            String matStr = matrixPanel.matrixFieldsToString(leadingTabs);
            String comment = cmntCheck.isSelected() ? this.getCommentsForTransforms() : "";
            BBxt.paste(comment + "\n" + matStr);
            BBxt.setSelection(wordBegin, wordBegin);
            BBxt.parseAll();
            return;
        }
        e = BBxt.getSelectionEnd();
        String docExt = BBxt.getWindowExtension();
        int spanBegin = e;
        if (word.equals("transform") && docExt != null && docExt.equalsIgnoreCase(".mi")) {
            String str;
            Segment segment = DocumentUtils.getSegment(doc, e, doc.getLength() - e);
            Tokenizer tok = new Tokenizer();
            tok.setBuffer(segment);
            tok.setDelimitor("\n\t ");
            int lastNumberIndex = -1;
            while (!(str = tok.getNextStr()).equals("")) {
                if (str.equals("#") || str.startsWith("#")) {
                    int index = tok.findNewline(tok.getBufferIndex());
                    if (index != -1) continue;
                    break;
                }
                try {
                    double d = Double.parseDouble(str);
                    lastNumberIndex = tok.getBufferIndex();
                }
                catch (NumberFormatException er) {
                    // empty catch block
                    break;
                }
            }
            if (str.equals("")) {
                Cutter.setLog("    Error:TransformsTool.copyMatrixToDocument() - cannot find the end of the matrix values!");
                return;
            }
            int spanEnd = e + lastNumberIndex;
            String matStr = matrixPanel.matrixFieldsToString(leadingTabs);
            String comment = cmntCheck.isSelected() ? this.getCommentsForTransforms() : "";
            BBxt.setSelection(spanBegin, spanEnd);
            BBxt.paste(comment + "\n" + matStr);
            BBxt.setSelection(spanBegin, spanBegin);
            BBxt.parseAll();
        }
    }

    private String getCommentsForTransforms() {
        double[] d = this.getTransformations();
        String str = "\t# translate " + MatrixPanel.clip(d[0]) + ", " + MatrixPanel.clip(d[1]) + ", " + MatrixPanel.clip(d[2]) + "\n\t# rotate    " + MatrixPanel.clip(d[3]) + ", " + MatrixPanel.clip(d[4]) + ", " + MatrixPanel.clip(d[5]) + "\n\t# scale     " + MatrixPanel.clip(d[6]) + ", " + MatrixPanel.clip(d[7]) + ", " + MatrixPanel.clip(d[8]);
        return str;
    }

    public double[] getTransformations() {
        double[] out = new double[9];
        for (int n = 0; n < this.tval.length; ++n) {
            String str = this.tval[n].getText();
            if (str.trim().length() == 0) {
                out[n] = 0.0;
                continue;
            }
            try {
                out[n] = Double.parseDouble(str.trim());
                continue;
            }
            catch (Exception e) {
                out[n] = 0.0;
            }
        }
        return out;
    }

    public void setTransformations(double[] input) {
        for (int n = 0; n < input.length; ++n) {
            this.tval[n].setText("" + MatrixPanel.clip(input[n]));
        }
    }

    @Override
    protected void toolSelectionHappened() {
        Cutter.setLog("    TransformsTool.toolSelectionHappened()");
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.grabFocus();
            this.lastFocusedComponent.selectAll();
        }
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        Cutter.setLog("    Info:TransformsTool.toolDeSelectionHappened");
        this.lastFocusedComponent = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }

    public class TValue
    extends KFloatTextField {
        private String tname;

        public TValue(String text, String t) {
            super(text, 5);
            this.tname = "";
            this.tname = t;
            this.setBackground(new Color(230, 230, 230));
            this.setOpaque(true);
            this.setBorder(new LineBorder(Color.gray, 1));
            this.setCaretColor(Color.black);
            this.setSelectionColor(Color.yellow);
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    if (instance != null) {
                        matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), TValue.this.tname);
                    }
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (instance != null) {
                        matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), TValue.this.tname);
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (instance != null) {
                        matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), TValue.this.tname);
                    }
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (instance != null) {
                        matrixPanel.calculateMatrix(TransformsTool.this.getTransformations(), TValue.this.tname);
                    }
                    TransformsTool.this.lastFocusedComponent = TValue.this;
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            });
        }
    }

    public class PanelPopup
    extends JPopupMenu
    implements PopupMenuListener {
        public JMenuItem parseProcItem = new JMenuItem("Get From Comments");
        public JMenuItem identityProcItem = new JMenuItem("Set Identity Matrix");
        private double[] transData = null;
        private double[] identityData = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0};

        public PanelPopup() {
            this.addPopupMenuListener(this);
            this.add(this.parseProcItem);
            this.add(this.identityProcItem);
            ActionListener action = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (PanelPopup.this.transData != null) {
                        TransformsTool.this.setTransformations(PanelPopup.this.transData);
                    }
                }
            };
            this.parseProcItem.addActionListener(action);
            ActionListener iaction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TransformsTool.this.setTransformations(PanelPopup.this.identityData);
                }
            };
            this.identityProcItem.addActionListener(iaction);
            this.pack();
        }

        private void ___POPUP_LISTENER_METHODS________() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.transData = TransformsTool.this.parseExistingComment();
            this.parseProcItem.setEnabled(this.transData != null);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            super.show(invoker, x + 5, y);
            MenuElement[] element = this.getSubElements();
            for (int n = 0; n < element.length; ++n) {
                JMenuItem item = (JMenuItem)element[n];
                Graphics g = item.getGraphics();
                item.paint(g);
            }
        }
    }

    public class TLabel
    extends KLabel {
        public TLabel(String text) {
            super(text, false);
        }
    }
}

