/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components.DnD;

import UI_Tools.XPM.Components.DnD.XPMTransferable;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMTile;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;

public class XPMDropTarget
implements DropTargetListener {
    private DropTarget dropTarget;
    private XPMTile tile;
    private XPMEditor ed;

    public XPMDropTarget(XPMTile tile) {
        this.tile = tile;
        this.dropTarget = new DropTarget(tile, 3, this, true, null);
        this.dropTarget.setActive(true);
        tile.setDropTarget(this.dropTarget);
        this.ed = (XPMEditor)XPMIconTool.tabbedPane.getSelectedComponent();
    }

    public boolean isActive() {
        return this.dropTarget.isActive();
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            Transferable tr = event.getTransferable();
            XPMColor color = (XPMColor)tr.getTransferData(XPMTransferable.xpmFlavor);
            if (event.isDataFlavorSupported(XPMTransferable.xpmFlavor)) {
                event.acceptDrop(3);
                this.tile.dndDropHappened(color);
                this.ed.dndDropHappened(this.tile, color);
                event.dropComplete(true);
                return;
            }
            event.rejectDrop();
        }
        catch (Exception e) {
            e.printStackTrace();
            event.rejectDrop();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
        try {
            Transferable tr = event.getTransferable();
            XPMColor color = (XPMColor)tr.getTransferData(XPMTransferable.xpmFlavor);
            this.ed = (XPMEditor)XPMIconTool.tabbedPane.getSelectedComponent();
            if (event.getDropAction() == 1) {
                this.ed.dndDragEnterPaint(this.tile, color);
            } else {
                this.ed.dndDragEnter(this.tile, color);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.ed = (XPMEditor)XPMIconTool.tabbedPane.getSelectedComponent();
        this.ed.dndDragExit(this.tile);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

