/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components;

import UI_Components.GBC;
import UI_Components.KTextField.KFloatTextField;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMIconTool;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Floatfield
extends JPanel {
    private KFloatTextField value = new KFloatTextField("1.0", 4);
    private JLabel label = new JLabel();
    public float lastValidValue;

    public Floatfield(String labelStr, float fvalue) {
        this.lastValidValue = fvalue;
        this.setBackground(XPMIconTool.BACKGROUD);
        this.setForeground(AbstractOptions.disabledColor);
        this.value.setBackground(XPMIconTool.BACKGROUD);
        this.value.setForeground(AbstractOptions.disabledColor);
        this.value.setCaretColor(XPMIconTool.CARET_COLOR);
        this.label.setBackground(XPMIconTool.BACKGROUD);
        this.label.setForeground(AbstractOptions.disabledColor);
        this.label.setText(labelStr);
        Font f = this.label.getFont();
        f = new Font(f.getFontName(), 0, f.getSize());
        this.label.setFont(f);
        this.label.setVerticalAlignment(3);
        this.value.setMargin(new Insets(1, 5, 1, 5));
        this.setValue(fvalue);
        super.setLayout(new GridBagLayout());
        this.add((Component)this.label, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(3, 0, 0, 10)));
        this.add((Component)this.value, new GBC(1, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.value.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
            }

            @Override
            public void focusLost(FocusEvent evt) {
            }
        });
        this.value.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Float val = Floatfield.this.value.getFloat();
                if (val != null) {
                    Floatfield.this.lastValidValue = val.floatValue();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                Float val = Floatfield.this.value.getFloat();
                if (val != null) {
                    Floatfield.this.lastValidValue = val.floatValue();
                }
            }
        });
    }

    public void addListener(DocumentListener l) {
        this.value.getDocument().addDocumentListener(l);
    }

    public void setValue(final float v) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Floatfield.this.value == null) {
                    return;
                }
                try {
                    Floatfield.this.value.setText("" + v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public Float getFloat() {
        return this.value.getFloat();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        Color c = flag ? AbstractOptions.enabledColor : AbstractOptions.disabledColor;
        this.label.setForeground(flag ? AbstractOptions.enabledColor : AbstractOptions.disabledColor);
        this.value.setForeground(flag ? AbstractOptions.enabledColor : AbstractOptions.disabledColor);
        Border border = BorderFactory.createLineBorder(c);
        this.value.setBorder(border);
        this.value.setEditable(flag);
    }
}

