/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components;

import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.OverlayShapes.AbstractShape;
import UI_Tools.XPM.Components.Pixel;
import UI_Tools.XPM.XPMCanvas;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMSwatch;
import UI_Tools.XPM.XPMTile;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Overlay
extends JComponent
implements MouseListener,
MouseMotionListener {
    private static int NOCONSTRAINT = 0;
    private static int HCONSTRAINT = 1;
    private static int VCONSTRAINT = 2;
    BufferedImage iconCopy;
    BufferedImage backIconLarge;
    BufferedImage backIconSmall;
    XPMDataBase database;
    XPMCanvas canvas;
    int canvasWidth;
    int canvasHeight;
    int enlargement;
    private AbstractShape shape = null;
    private boolean dragInProgress = false;
    private boolean altDown = false;
    private boolean controlDown = false;
    private boolean metaDown = false;
    private boolean shiftDown = false;
    private int constraint = NOCONSTRAINT;
    private Point mousePressedPnt = null;
    private int mousePressedPntX;
    private int mousePressedPntY;
    private Pixel dndDragHilite = null;
    private AffineTransform _identityMatrix = new AffineTransform();
    private Graphics2D overlayG2;
    private Graphics2D backIconSmallG2;
    private BufferedImage out;

    public Overlay(XPMDataBase database) {
        this.database = database;
        this.canvas = database.canvas;
        this.canvasWidth = this.canvas.getWidth();
        this.canvasHeight = this.canvas.getHeight();
        this.setBounds(0, 0, this.canvasWidth, this.canvasHeight);
        this.setOpaque(true);
        this.enlargement = this.canvas.getTileSize() + this.canvas.getTileGap() * 2;
        ActionListener upAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Overlay.this.keypadDispatch(0, -1);
            }
        };
        ActionListener downAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Overlay.this.keypadDispatch(0, 1);
            }
        };
        ActionListener leftAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Overlay.this.keypadDispatch(-1, 0);
            }
        };
        ActionListener rightAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Overlay.this.keypadDispatch(1, 0);
            }
        };
        KeyStroke up = KeyStroke.getKeyStroke(38, 0, false);
        KeyStroke down = KeyStroke.getKeyStroke(40, 0, false);
        KeyStroke left = KeyStroke.getKeyStroke(37, 0, false);
        KeyStroke right = KeyStroke.getKeyStroke(39, 0, false);
        this.registerKeyboardAction(upAction, "", up, 2);
        this.registerKeyboardAction(downAction, "", down, 2);
        this.registerKeyboardAction(leftAction, "", left, 2);
        this.registerKeyboardAction(rightAction, "", right, 2);
        this._identityMatrix.setToIdentity();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    private void keypadDispatch(int x, int y) {
        if (this.shape == null) {
            return;
        }
        this.shape.keypadMove(x, y);
        this.database.overlay.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.shape == null) {
            return;
        }
        if (e.getClickCount() == 1) {
            this.shape.mouseClicked(new Point(e.getX(), e.getY()));
            this.repaint();
        } else if (e.getClickCount() == 2) {
            this.offscreenAccept();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.shape == null) {
            return;
        }
        this.dragInProgress = true;
        this.altDown = e.isAltDown();
        this.controlDown = e.isControlDown();
        this.metaDown = e.isMetaDown();
        if (!e.isShiftDown()) {
            this.constraint = NOCONSTRAINT;
        }
        if (this.mousePressedPnt != null) {
            int ydelta;
            this.mousePressedPntX = this.mousePressedPnt.x;
            this.mousePressedPntY = this.mousePressedPnt.y;
            int xdelta = Math.abs(e.getX() - this.mousePressedPntX);
            this.constraint = xdelta > (ydelta = Math.abs(e.getY() - this.mousePressedPntY)) ? HCONSTRAINT : VCONSTRAINT;
            this.mousePressedPnt = null;
        }
        if (this.constraint == NOCONSTRAINT) {
            this.shape.mouseDragged(e.getX(), e.getY());
        } else if (this.constraint == HCONSTRAINT) {
            this.shape.mouseDragged(e.getX(), this.mousePressedPntY);
        } else {
            this.shape.mouseDragged(this.mousePressedPntX, e.getY());
        }
        if (this.altDown) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Overlay.this.repaint();
                }
            });
        } else {
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.shape == null) {
            return;
        }
        this.mousePressedPnt = e.isShiftDown() ? new Point(e.getX(), e.getY()) : null;
        this.shape.mousePressed(e.getX(), e.getY());
        this.database.overlay.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.shape == null) {
            return;
        }
        this.dragInProgress = false;
        if (e.getClickCount() == 0) {
            this.shape.mouseReleased();
        }
        this.controlDown = false;
        this.metaDown = false;
        this.constraint = NOCONSTRAINT;
    }

    public void _recopyIcon() {
        this.backIconSmall = Overlay.deepCopy(this.iconCopy);
    }

    public void initIconCopy() {
        this.iconCopy = this.database.icon.getCopy();
        this.backIconSmall = Overlay.deepCopy(this.iconCopy);
    }

    @Override
    public void paint(Graphics g) {
        if (this.iconCopy == null) {
            return;
        }
        this.overlayG2 = (Graphics2D)g;
        if (this.backIconSmall == null || !this.altDown) {
            this.backIconSmall = Overlay.deepCopy(this.iconCopy);
        }
        this.backIconSmallG2 = this.backIconSmall.createGraphics();
        if (this.dndDragHilite != null) {
            this.backIconSmallG2.setStroke(new BasicStroke(1.0f));
            this.backIconSmallG2.setColor(this.dndDragHilite.c);
            this.backIconSmallG2.draw(new Line2D.Double(this.dndDragHilite.x, this.dndDragHilite.y, this.dndDragHilite.x, this.dndDragHilite.y));
        }
        if (this.shape != null) {
            this.shape.paint(this.backIconSmallG2);
        }
        this.backIconLarge = this.convertToLarge(this.backIconSmall);
        this.overlayG2.drawImage((Image)this.backIconLarge, 0, 0, null);
        if (this.shape != null) {
            this.shape.paintControl(this.overlayG2);
        }
    }

    public void setDnDHilited(Pixel pixel) {
        this.dndDragHilite = pixel;
    }

    public void initShape(AbstractShape shape) {
        this.shape = shape;
        this.iconCopy = this.database.icon.getCopy();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public void optionPanelChanged() {
        if (this.shape == null) {
            return;
        }
        this.shape.updateState();
        this.repaint();
    }

    public void forebackPanelChanged() {
        if (this.shape == null) {
            return;
        }
        this.shape.updateState();
        this.repaint();
    }

    public void offscreenFinish() {
        this.database.canvas.syncWithIcon();
        this.canvas.moveOverlayToBack();
        this.shape = null;
    }

    private void offscreenAccept() {
        Object pixel;
        int y;
        Color rgb;
        int iconWidth = this.backIconSmall.getWidth();
        int iconHeight = this.backIconSmall.getHeight();
        Vector<XPMColor> emptied = this.database.swatch.removeUnneededTiles(this.backIconSmall);
        Hashtable<Color, String> swatchLUT = this.database.swatch.getLUT_ByRGB();
        Hashtable<Color, String> notInLUT = new Hashtable<Color, String>();
        Hashtable<Color, String> combinedLUT = new Hashtable<Color, String>();
        XPMColor[][] pixels = new XPMColor[this.backIconSmall.getWidth()][this.backIconSmall.getHeight()];
        for (int x = 0; x < iconWidth; ++x) {
            for (int y2 = 0; y2 < iconHeight; ++y2) {
                String k;
                int col = this.backIconSmall.getRGB(x, y2);
                Color c = new Color(col);
                if (!swatchLUT.containsKey(c)) {
                    k = XPMTile.generateKey(this.database.charsPerPixel, swatchLUT);
                    notInLUT.put(c, k);
                } else {
                    k = swatchLUT.get(c);
                }
                if (k == null) {
                    Cutter.setLog("found null");
                }
                pixels[x][y2] = new XPMColor(k, c);
            }
        }
        int swatchLen = swatchLUT.size();
        int notSwatchLen = notInLUT.size();
        Enumeration<Color> e = swatchLUT.keys();
        while (e.hasMoreElements()) {
            rgb = e.nextElement();
            combinedLUT.put(rgb, swatchLUT.get(rgb));
        }
        e = notInLUT.keys();
        while (e.hasMoreElements()) {
            rgb = e.nextElement();
            combinedLUT.put(rgb, (String)notInLUT.get(rgb));
        }
        int combinedLen = combinedLUT.size();
        if (swatchLen + notSwatchLen != combinedLen) {
            Cutter.setLog("    Error:Overlay.offscreenAccept() - combined LUT is smaller than expected.");
            Cutter.setLog("           swatchLen " + swatchLen + " notSwatchLen " + notSwatchLen + " combinedLUT " + combinedLUT.size());
        }
        XPMColor[] raw_xpm = XPMColor.rgbTableToXPMColorArray(combinedLUT);
        XPMSwatch cfr_ignored_0 = this.database.swatch;
        XPMColor[] sorted = XPMSwatch.sortByRGB(raw_xpm);
        int preCull = sorted.length;
        XPMColor[] culled = sorted;
        int tolerance = 1;
        while (culled.length > 256) {
            Cutter.setLog("continuing to cull");
            XPMSwatch cfr_ignored_1 = this.database.swatch;
            sorted = XPMSwatch.sortByRGB(culled);
            XPMSwatch cfr_ignored_2 = this.database.swatch;
            culled = XPMSwatch.cullBySimilarity(sorted, tolerance++);
            Cutter.setLog("    culled size " + culled.length);
            if (culled.length >= 256) continue;
        }
        this.database.swatch.markAllAsEmpty();
        this.database.swatch.add(culled);
        if (sorted.length == 1) {
            XPMColor rear = new XPMColor(this.database.foreback.getBackgroundKey(), this.database.foreback.getBackgroundColor());
            this.database.swatch.add(rear);
        }
        int numNonEmpty = this.database.swatch.numNonEmptyTiles();
        while (emptied != null && emptied.size() > 0 && numNonEmpty < 256) {
            this.database.swatch.add(emptied.remove(0));
        }
        this.database.swatch.repaint();
        for (int n = 0; n < culled.length; ++n) {
            XPMColor xpm = culled[n];
            if (xpm.cullTableSize() == 0) continue;
            Hashtable culledKeys = xpm.getCullTable();
            for (y = 0; y < iconHeight; ++y) {
                for (int x = 0; x < iconWidth; ++x) {
                    pixel = pixels[x][y];
                    if (!culledKeys.containsKey(((XPMColor)pixel).key)) continue;
                    ((XPMColor)pixel).key = xpm.key;
                    ((XPMColor)pixel).color = xpm.color;
                }
            }
        }
        Hashtable<String, Color> table = this.database.swatch.getLUT_ByKey();
        Hashtable<Color, String> rgbtable = this.database.swatch.getLUT_ByRGB();
        for (int x = 0; x < iconWidth; ++x) {
            for (y = 0; y < iconHeight; ++y) {
                XPMColor xpm = pixels[x][y];
                if (!table.containsKey(xpm.key)) {
                    if (rgbtable.containsKey(xpm.color)) {
                        xpm.key = rgbtable.get(xpm.color);
                    } else {
                        pixel = new Pixel(x, y, xpm.color, xpm.key);
                        this.database.swatch.findNearestColorByRGB((Pixel)pixel);
                        xpm.color = ((Pixel)pixel).c;
                        xpm.key = ((Pixel)pixel).k;
                    }
                }
                this.canvas.setTile(x, y, xpm.key, xpm.color);
            }
        }
        this.database.editor.setDirty(true);
        this.iconCopy = this.database.icon.getCopy();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
    }

    private BufferedImage convertToLarge(BufferedImage in) {
        this.out = new BufferedImage(this.canvasWidth, this.canvasHeight, 2);
        int size = this.enlargement * this.enlargement;
        int[] rgbArray = new int[size];
        for (int X = 0; X < this.canvasWidth; X += this.enlargement) {
            for (int Y = 0; Y < this.canvasHeight; Y += this.enlargement) {
                int col = in.getRGB(X / this.enlargement, Y / this.enlargement);
                for (int n = 0; n < size; ++n) {
                    rgbArray[n] = col;
                }
                this.out.setRGB(X, Y, this.enlargement, this.enlargement, rgbArray, 0, 1);
            }
        }
        return this.out;
    }

    public static BufferedImage deepCopy(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }
}

