/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components.OverlayShapes;

import UI_Tools.XPM.Components.OverlayShapes.AbstractControl;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public abstract class AbstractShape {
    protected XPMDataBase database;
    protected AbstractControl default_control = null;
    protected AbstractControl custom_control = null;
    protected AbstractControl active_control = null;
    protected AbstractOptions optionsPanel = null;
    protected AffineTransform matrix = new AffineTransform();
    protected Point2D.Float overlay_origin = new Point2D.Float();
    protected Point2D.Float origin_mouseOffset = new Point2D.Float(0.0f, 0.0f);
    protected float rotation = 0.0f;
    protected float rotIncr = 0.0f;
    protected float size = 1.0f;
    protected float sizeIncr = 0.0f;
    protected float sizeTweak = 1.0f;
    protected boolean smoothScaling = true;
    protected Color color;
    protected Color backcolor;
    protected boolean anti_aliasing = true;
    protected boolean apply_color_ramp = false;
    protected int iconCanvasScaleFactor;
    protected int redrawAction = AbstractControl.MOVE;
    static String name = "Undefined";
    protected float ydelta;
    protected boolean dragInProgress = false;

    public AbstractShape(XPMDataBase database, AbstractOptions optionPanel) {
        this.database = database;
        this.optionsPanel = optionPanel;
        this.overlay_origin.x = (float)database.canvas.getWidth() / 2.0f;
        this.overlay_origin.y = (float)database.canvas.getHeight() / 2.0f;
        this.iconCanvasScaleFactor = database.canvas.getTileSize() + database.canvas.getTileGap() * 2;
        this.active_control = this.default_control = new BasicControl();
    }

    public String getName() {
        return name;
    }

    public void setCustomControl() {
        this.active_control = this.custom_control;
    }

    public void setDefaultControl() {
        this.active_control = this.default_control;
    }

    public void mousePressed(int mousex, int mousey) {
        this.origin_mouseOffset.x = (float)mousex - this.overlay_origin.x;
        this.origin_mouseOffset.y = this.overlay_origin.y - (float)mousey;
        if (this.active_control != null) {
            Point p = new Point((int)((float)mousex - this.overlay_origin.x), (int)((float)mousey - this.overlay_origin.y));
            p = this.counterRotate(p);
            this.redrawAction = this.active_control.getHotSpotAction(p);
        }
    }

    public void mouseDragged(int mousex, int mousey) {
        this.dragInProgress = true;
        if (this.redrawAction == AbstractControl.MOVE) {
            this.overlay_origin.x = (float)mousex - this.origin_mouseOffset.x;
            this.overlay_origin.y = this.origin_mouseOffset.y + (float)mousey;
            return;
        }
        if (this.redrawAction == AbstractControl.ROTATE) {
            float xdelta = (float)mousex - this.overlay_origin.x;
            float ydelta = (float)mousey - this.overlay_origin.y;
            double ang = Math.atan2(xdelta, ydelta);
            ang = Math.toDegrees(ang) - 90.0;
            this.rotIncr = (float)Math.toRadians(-ang);
            return;
        }
        if (this.redrawAction == AbstractControl.RESIZE) {
            int xdelta = mousex - (int)this.overlay_origin.x;
            this.ydelta = this.overlay_origin.y - (float)mousey;
            Point sizeBoxMin = this.counterRotate(new Point(0, 55));
            Point mouseDown = new Point(xdelta, (int)this.ydelta);
            mouseDown = this.rotate(mouseDown);
            this.sizeIncr = ((float)mouseDown.y - 55.0f) / 55.0f;
            this.sizeIncr *= this.sizeTweak;
            boolean isneg = false;
            if (this.ydelta < 0.0f) {
                isneg = true;
            }
            this.ydelta = (float)Math.sqrt((float)(xdelta * xdelta) + this.ydelta * this.ydelta);
            if (this.sizeIncr < 0.0f) {
                this.ydelta = 0.0f;
            }
        }
    }

    public void mouseReleased() {
        this.dragInProgress = false;
        this.size += this.sizeIncr;
        this.sizeIncr = 0.0f;
        this.rotation = this.rotIncr;
        this.ydelta = 0.0f;
        this.database.overlay.repaint();
    }

    public void mouseClicked(Point mouseDownPnt) {
        if (this.active_control == null) {
            return;
        }
        Point p = new Point((int)(mouseDownPnt.getX() - (double)this.overlay_origin.x), (int)(mouseDownPnt.getY() - (double)this.overlay_origin.y));
        int action = this.active_control.getHotSpotAction(p = this.counterRotate(p));
        if (action == AbstractControl.ROTATE) {
            this.rotation = 0.0f;
            this.rotIncr = 0.0f;
        }
        if (action == AbstractControl.RESIZE) {
            this.size = 1.0f;
            this.sizeIncr = 0.0f;
        }
        this.database.overlay.repaint();
    }

    public void paint(Graphics2D g) {
        this.smoothScaling = true;
        if (this.anti_aliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.matrix.setToIdentity();
        this.matrix.translate(Math.round(this.overlay_origin.x / (float)this.iconCanvasScaleFactor), Math.round(this.overlay_origin.y / (float)this.iconCanvasScaleFactor));
        this.matrix.rotate(this.rotIncr);
        float scaling = this.size + this.sizeIncr;
        this.matrix.scale(scaling, scaling);
        g.setColor(this.color);
        g.setTransform(this.matrix);
    }

    public void paintControl(Graphics2D overlayG2) {
        if (this.active_control == null) {
            return;
        }
        int[] origin = this.getRounded(this.overlay_origin.x, this.overlay_origin.y);
        BufferedImage buffImage = new BufferedImage(1500, 1500, 2);
        Graphics2D buffImageG2 = (Graphics2D)buffImage.getGraphics();
        this.matrix.setToIdentity();
        this.matrix.translate(origin[0], origin[1]);
        buffImageG2.setTransform(this.matrix);
        buffImageG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.active_control.paint(buffImageG2, this.ydelta);
        overlayG2.drawImage((Image)buffImage, 0, 0, null);
    }

    public void keypadMove(int x, int y) {
        this.overlay_origin.x += (float)(x * this.iconCanvasScaleFactor);
        this.overlay_origin.y += (float)(y * this.iconCanvasScaleFactor);
        this.updateState();
    }

    protected Point counterRotate(Point p) {
        double r = -this.rotation;
        double X = p.x;
        double Y = p.y;
        int x = (int)(X * Math.cos(r) - Y * Math.sin(r));
        int y = (int)(X * Math.sin(r) + Y * Math.cos(r));
        return new Point(x, y);
    }

    protected Point rotate(Point p) {
        double r = this.rotation;
        double X = p.x;
        double Y = p.y;
        int x = (int)(X * Math.cos(r) - Y * Math.sin(r));
        int y = (int)(X * Math.sin(r) + Y * Math.cos(r));
        return new Point(x, y);
    }

    public void updateState() {
        this.anti_aliasing = this.optionsPanel.getAliasing();
        this.color = this.database.foreback.getForegroundColor();
        this.backcolor = this.database.foreback.getBackgroundColor();
        this.apply_color_ramp = this.optionsPanel.getColorRamp();
    }

    protected int[] getRounded(float x, float y) {
        int[] out = new int[]{Math.round(x / (float)this.iconCanvasScaleFactor) * this.iconCanvasScaleFactor, Math.round(y / (float)this.iconCanvasScaleFactor) * this.iconCanvasScaleFactor};
        return out;
    }

    public class BasicControl
    extends AbstractControl {
        AffineTransform mat = new AffineTransform();

        @Override
        public void paint(Graphics2D g, float yheight) {
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(1.0f));
            int x = 0;
            int y = 0;
            float length = yheight < 50.0f ? 50.0f : yheight;
            float left = x - 10;
            float right = x + 50;
            float top = (float)y - length;
            float bottom = y + 10;
            this.mat = g.getTransform();
            this.mat.rotate(AbstractShape.this.rotIncr);
            g.setTransform(this.mat);
            g.draw(new Line2D.Double(left, y, right, y));
            g.draw(new Line2D.Double(x, top, x, bottom));
            float box = 15.0f;
            this.sizeControl.setRect((float)x - box / 2.0f, top - box, box, box);
            float dia = 15.0f;
            this.rotControl.setFrame(right, (float)y - dia / 2.0f, dia, dia);
            g.draw(this.sizeControl);
            g.draw(this.rotControl);
        }
    }
}

