/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components.OverlayShapes;

import UI_Tools.XPM.Components.OverlayShapes.AbstractShape;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class BlockShape
extends AbstractShape {
    private Rectangle2D.Double rect = new Rectangle2D.Double(-0.5, -0.5, 1.0, 1.0);
    public Ellipse2D.Double circle = new Ellipse2D.Double(-0.5, -0.5, 1.0, 1.0);
    private boolean solid;
    private float thickness;
    private String geoShape;

    public BlockShape(XPMDataBase database, AbstractOptions optionPanel) {
        super(database, optionPanel);
        name = "BlockShape";
        this.sizeTweak = 10.0f;
        this.updateState();
    }

    @Override
    public void paint(Graphics2D g) {
        super.paint(g);
        if (this.apply_color_ramp) {
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{this.color, this.backcolor};
            Point2D.Float start = new Point2D.Float(0.0f, 0.5f);
            Point2D.Float end = new Point2D.Float(0.0f, -0.5f);
            LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
            g.setPaint(p);
        }
        if (this.solid) {
            if (this.geoShape.equals("rect")) {
                g.fill(this.rect);
            } else {
                g.fill(this.circle);
            }
        } else {
            g.setStroke(new BasicStroke(this.thickness));
            if (this.geoShape.equals("rect")) {
                g.draw(this.rect);
            } else {
                g.draw(this.circle);
            }
        }
    }

    @Override
    public void updateState() {
        super.updateState();
        this.solid = this.optionsPanel.getFill();
        this.geoShape = this.optionsPanel.getGeoShape();
        this.thickness = this.optionsPanel.getThickness();
    }
}

