/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components.OverlayShapes;

import UI_Tools.XPM.Components.OverlayShapes.AbstractControl;
import UI_Tools.XPM.Components.OverlayShapes.AbstractShape;
import UI_Tools.XPM.Components.OverlayShapes.RotationControl;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class LineShape
extends AbstractShape {
    private static int MOVE_LINE_START = 4;
    private static int MOVE_LINE_END = 5;
    private Point2D.Float rot_controlOrigin = new Point2D.Float(192.0f, 192.0f);
    private float thickness;
    public Line2D line;
    private Point2D.Float lineBegin = new Point2D.Float(0.0f, 0.0f);
    private Point2D.Float lineEnd = new Point2D.Float(0.0f, 0.0f);
    private float[] rampBeginEnd = new float[]{0.0f, 1.0f};
    private float scaling;
    private Point2D.Float begin = new Point2D.Float(0.0f, 0.0f);
    private Point2D.Float end = new Point2D.Float(0.0f, 0.0f);
    private Point2D.Float begin_IconSpace = new Point2D.Float(0.0f, 0.0f);
    private Point2D.Float end_IconSpace = new Point2D.Float(0.0f, 0.0f);

    public LineShape(XPMDataBase database, AbstractOptions optionPanel) {
        super(database, optionPanel);
        name = "LineShape";
        this.updateState();
        this.sizeTweak = 1.0f;
        this.default_control = new LineControl();
        this.custom_control = new RotationControl();
        this.active_control = this.default_control;
        this.rot_controlOrigin = new Point2D.Float(database.canvas.getWidth() / 2, database.canvas.getHeight() / 2);
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.anti_aliasing) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.matrix.setToIdentity();
        if (this.redrawAction == AbstractControl.ROTATE) {
            this.matrix.translate(Math.round(this.rot_controlOrigin.x / (float)this.iconCanvasScaleFactor), Math.round(this.rot_controlOrigin.y / (float)this.iconCanvasScaleFactor));
        } else {
            this.matrix.translate(Math.round(this.overlay_origin.x / (float)this.iconCanvasScaleFactor), Math.round(this.overlay_origin.y / (float)this.iconCanvasScaleFactor));
        }
        this.matrix.rotate(this.rotIncr);
        this.scaling = this.size + this.sizeIncr;
        this.matrix.scale(this.scaling, this.scaling);
        g.setTransform(this.matrix);
        if ((double)Math.abs(this.scaling) < 0.1) {
            this.scaling = 0.1f;
        }
        g.setStroke(new BasicStroke(this.thickness * Math.abs(1.0f / this.scaling)));
        this.begin.setLocation(this.lineBegin.x, this.lineBegin.y);
        this.end.setLocation(this.lineEnd.x, this.lineEnd.y);
        if (this.redrawAction == AbstractControl.ROTATE) {
            this.begin.setLocation(-(this.rot_controlOrigin.x - this.overlay_origin.x) + this.lineBegin.x, -(this.rot_controlOrigin.y - this.overlay_origin.y) + this.lineBegin.y);
            this.end.setLocation(-(this.rot_controlOrigin.x - this.overlay_origin.x) + this.lineEnd.x, -(this.rot_controlOrigin.y - this.overlay_origin.y) + this.lineEnd.y);
        }
        this.begin_IconSpace.setLocation(this.begin.x / (float)this.iconCanvasScaleFactor, this.begin.y / (float)this.iconCanvasScaleFactor);
        this.end_IconSpace.setLocation(this.end.x / (float)this.iconCanvasScaleFactor, this.end.y / (float)this.iconCanvasScaleFactor);
        this.line = new Line2D.Float(this.begin_IconSpace, this.end_IconSpace);
        LinearGradientPaint p = this.getGradientPaint(this.begin_IconSpace, this.end_IconSpace);
        g.setPaint(p);
        g.draw(this.line);
    }

    private LinearGradientPaint getGradientPaint(Point2D.Float begin, Point2D.Float end) {
        end.x = begin.x == end.x ? end.x + 0.1f : end.x;
        end.y = begin.y == end.y ? end.y + 0.1f : end.y;
        Color[] colors = new Color[]{this.color, this.color};
        if (this.apply_color_ramp) {
            colors[0] = this.color;
            colors[1] = this.backcolor;
        }
        return new LinearGradientPaint(begin, end, this.rampBeginEnd, colors);
    }

    @Override
    public void mouseDragged(int mousex, int mousey) {
        super.mouseDragged(mousex, mousey);
        if (this.redrawAction == MOVE_LINE_START) {
            this.lineBegin.x = (float)mousex - this.overlay_origin.x;
            this.lineBegin.y = (float)mousey - this.overlay_origin.y;
        }
        if (this.redrawAction == MOVE_LINE_END) {
            this.lineEnd.x = (float)mousex - this.overlay_origin.x;
            this.lineEnd.y = (float)mousey - this.overlay_origin.y;
        }
        if (this.redrawAction == RotationControl.REPOSITION) {
            this.rot_controlOrigin.x = mousex;
            this.rot_controlOrigin.y = mousey;
        }
    }

    @Override
    public void mousePressed(int mousex, int mousey) {
        this.origin_mouseOffset.x = (float)mousex - this.overlay_origin.x;
        this.origin_mouseOffset.y = this.overlay_origin.y - (float)mousey;
        Point p = new Point((int)((float)mousex - this.overlay_origin.x), (int)((float)mousey - this.overlay_origin.y));
        p = this.counterRotate(p);
        if (this.active_control != null && this.active_control == this.custom_control) {
            p = new Point(mousex - (int)this.rot_controlOrigin.x, mousey - (int)this.rot_controlOrigin.y);
        }
        this.redrawAction = this.active_control.getHotSpotAction(p);
    }

    @Override
    public void paintControl(Graphics2D overlayG2) {
        if (this.active_control == null) {
            return;
        }
        int[] origin = this.getRounded(this.overlay_origin.x, this.overlay_origin.y);
        if (this.active_control == this.custom_control) {
            origin[0] = (int)this.rot_controlOrigin.x;
            origin[1] = (int)this.rot_controlOrigin.y;
        }
        BufferedImage buffImage = new BufferedImage(1500, 1500, 2);
        Graphics2D buffImageG2 = (Graphics2D)buffImage.getGraphics();
        this.matrix.setToIdentity();
        this.matrix.translate(origin[0], origin[1]);
        buffImageG2.setTransform(this.matrix);
        buffImageG2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.active_control.paint(buffImageG2, this.ydelta);
        overlayG2.drawImage((Image)buffImage, 0, 0, null);
    }

    @Override
    public void updateState() {
        super.updateState();
        this.thickness = this.optionsPanel.getThickness();
    }

    public void _paint(Graphics2D g) {
        super.paint(g);
        g.setStroke(new BasicStroke(this.thickness));
        float[] dist = new float[]{0.0f, 1.0f};
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(0.0f, 5.0f);
        Color[] colors = new Color[]{this.color, this.color};
        if (this.apply_color_ramp) {
            colors[0] = this.color;
            colors[1] = this.backcolor;
        }
        LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
        g.scale(1.0, -1.0);
        g.setPaint(p);
        g.draw(this.line);
    }

    public class LineControl
    extends AbstractControl {
        AffineTransform mat = new AffineTransform();
        private Rectangle2D.Float beginControl = new Rectangle2D.Float(0.0f, 0.0f, 10.0f, 10.0f);
        private Rectangle2D.Float endControl = new Rectangle2D.Float(0.0f, 0.0f, 10.0f, 10.0f);

        @Override
        public void paint(Graphics2D g, float ignore) {
            g.setColor(Color.red);
            g.setStroke(new BasicStroke(2.0f));
            float box = 10.0f;
            if (LineShape.this.redrawAction == MOVE_LINE_START) {
                this.beginControl.setRect(((LineShape)LineShape.this).lineBegin.x, ((LineShape)LineShape.this).lineBegin.y, box, box);
            } else if (LineShape.this.redrawAction == MOVE_LINE_END) {
                this.endControl.setRect(((LineShape)LineShape.this).lineEnd.x, ((LineShape)LineShape.this).lineEnd.y, box, box);
            }
            g.draw(this.beginControl);
            g.setColor(Color.blue);
            g.draw(this.endControl);
        }

        @Override
        public int getHotSpotAction(Point p) {
            if (this.endControl.contains(p)) {
                return MOVE_LINE_END;
            }
            if (this.beginControl.contains(p)) {
                return MOVE_LINE_START;
            }
            return AbstractControl.MOVE;
        }
    }
}

