/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components.OverlayShapes;

import UI_Tools.XPM.Components.OverlayShapes.AbstractShape;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Point2D;

public class TextShape
extends AbstractShape {
    public String text = "";
    private Font font;
    private Font tmpFont = null;
    private int fontSize = 10;
    private int fontStyle;
    private String fontName = null;
    private boolean italic = false;

    public TextShape(XPMDataBase database, AbstractOptions optionPanel) {
        super(database, optionPanel);
        this.updateState();
        this.color = database.foreback.getForegroundColor();
        this.anti_aliasing = this.optionsPanel.getAliasing();
        name = "TextShape";
        this.sizeTweak = 0.8f;
    }

    @Override
    public void updateState() {
        super.updateState();
        this.text = this.optionsPanel.getText();
        this.fontStyle = this.optionsPanel.getFontStyle();
        this.fontName = this.optionsPanel.getFontName();
        this.italic = this.optionsPanel.getFontItalic();
        this.font = this.italic ? new Font(this.fontName, 2 | this.fontStyle, this.fontSize) : new Font(this.fontName, this.fontStyle, this.fontSize);
    }

    @Override
    public void paint(Graphics2D g) {
        super.paint(g);
        if (this.apply_color_ramp) {
            float[] dist = new float[]{0.0f, 1.0f};
            Color[] colors = new Color[]{this.color, this.backcolor};
            Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
            Point2D.Float end = new Point2D.Float(0.0f, -6.0f);
            LinearGradientPaint p = new LinearGradientPaint(start, end, dist, colors);
            g.setPaint(p);
        }
        g.setFont(this.font);
        g.drawString(this.text, 0, 0);
    }

    @Override
    public void mouseReleased() {
        super.mouseReleased();
        if (this.tmpFont != null) {
            this.font = this.tmpFont;
            this.tmpFont = null;
        }
    }
}

