/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Components;

import UI_Components.Dialog.SaveFileDialog;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Overlay;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMTile;
import Utilities.FileUtils;
import Utilities.JPEGUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class XPMIcon
extends JComponent {
    BufferedImage bufferedImage;
    Dimension dim;
    boolean isSelected = false;
    int underscore = 3;
    XPMDataBase database;

    public XPMIcon(XPMDataBase database) {
        this.database = database;
        this.bufferedImage = new BufferedImage(database.width, database.height + this.underscore, 1);
        for (int x = 0; x < database.width; ++x) {
            for (int y = 0; y < database.height; ++y) {
                int[] rgb = database.getPixelAsRGB(x, y);
                Color c = new Color(rgb[0], rgb[1], rgb[2]);
                this.bufferedImage.setRGB(x, y, c.getRGB());
            }
        }
        this.dim = new Dimension(database.width, database.height + this.underscore);
    }

    public void updateImage() {
        XPMTile[][] tiles = this.database.canvas.getTiles();
        int width = tiles.length;
        int height = tiles[0].length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color c = tiles[x][y].getTileColor();
                this.bufferedImage.setRGB(x, y, c.getRGB());
            }
        }
        this.repaint();
    }

    public void updateImage(XPMTile[][] tiles) {
        int width = tiles.length;
        int height = tiles[0].length;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                Color c = tiles[x][y].getTileColor();
                this.bufferedImage.setRGB(x, y, c.getRGB());
            }
        }
        this.repaint();
    }

    public void _updateImage(BufferedImage offscreen) {
        this.bufferedImage = Overlay.deepCopy(offscreen);
        this.repaint();
    }

    public int[][] getColorsAsInts() {
        if (this.bufferedImage == null) {
            return null;
        }
        int[][] out = new int[this.database.width][this.database.height];
        for (int x = 0; x < this.database.width; ++x) {
            for (int y = 0; y < this.database.height; ++y) {
                int c = this.bufferedImage.getRGB(x, y);
                out[x][y] = this.bufferedImage.getRGB(x, y);
            }
        }
        return out;
    }

    public BufferedImage getCopy() {
        BufferedImage out = new BufferedImage(this.database.width, this.database.height, 1);
        for (int x = 0; x < this.database.width; ++x) {
            for (int y = 0; y < this.database.height; ++y) {
                out.setRGB(x, y, this.bufferedImage.getRGB(x, y));
            }
        }
        return out;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.bufferedImage, 0, 0, null);
        if (this.isSelected) {
            g2.setPaint(XPMIconTool.HILITE);
        } else {
            g2.setPaint(XPMIconTool.BACKGROUD);
        }
        g2.setStroke(new BasicStroke(1.0f));
        for (int n = 0; n < this.underscore; ++n) {
            g2.draw(new Line2D.Double(0.0, this.database.height + n, this.database.width, this.database.height + n));
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void setSelected(boolean flag) {
        this.isSelected = flag;
        this.repaint();
    }

    public boolean exportAs(String formatName) {
        SaveFileDialog saveFileDialog = SaveFileDialog.getInstance(Cutter.desktop, "Export As " + formatName.toUpperCase());
        saveFileDialog.setSelectedFile(null);
        saveFileDialog.setFileFilter(new KFileFilter(formatName, ""));
        int response = saveFileDialog.showSelf("Export As " + formatName.toUpperCase());
        if (response == -2) {
            return false;
        }
        File f = saveFileDialog.getSelectedFile();
        if (f == null) {
            return false;
        }
        Cutter.setLog("input file " + f.getPath());
        String ext = FileUtils.getExtension(f);
        String validExt = "." + formatName;
        if (ext == null || !ext.equalsIgnoreCase(validExt)) {
            File base = f.getParentFile();
            String name = TextUtils.removeExtension(f.getName());
            name = name + validExt;
            f = new File(base, name);
        }
        Cutter.setLog("output file " + f.getPath());
        if (formatName.equals("jpg")) {
            JPEGUtils.saveJPEGFile(this.getCopy(), f);
            return true;
        }
        try {
            ImageIO.write((RenderedImage)this.getCopy(), formatName, f);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }
}

