/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Dialogs;

import UI_Components.Dialog.AbstractDialog;
import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.XPMIcon;
import UI_Tools.XPM.XPMCanvas;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMSwatch;
import UI_Tools.XPM.XPMTile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HSVDialog
extends AbstractDialog {
    private XPMSwatch swatch;
    private XPMCanvas canvas;
    private XPMIcon icon;
    private XPMEditor editor;
    private Slider hue = new Slider("Hue", 0, 100, 0, 0);
    private Slider sat = new Slider("Sat", -100, 100, 0, 1);
    private Slider val = new Slider("Val", -100, 100, 0, 2);
    private JRadioButton selRadio = new JRadioButton("Edit Selection");
    private JRadioButton allRadio = new JRadioButton("Edit All");
    private XPMTile[] swatchTargets = null;

    public HSVDialog(XPMDataBase db, String title, boolean modal) {
        super(Cutter.desktop, title, modal, false);
        this.swatch = db.swatch;
        this.canvas = db.canvas;
        this.icon = db.icon;
        this.editor = db.editor;
        ButtonGroup group = new ButtonGroup();
        group.add(this.selRadio);
        group.add(this.allRadio);
        this.allRadio.setSelected(true);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new GridBagLayout());
        bpanel.add((Component)this.cancelButton, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 12, 11, new Insets(10, 0, 10, 10)));
        bpanel.add((Component)this.okButton, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 12, 11, new Insets(10, 40, 10, 10)));
        this.add((Component)this.hue, new GBC(0, 0, 3, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 20)));
        this.add((Component)this.sat, new GBC(0, 1, 3, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 20)));
        this.add((Component)this.val, new GBC(0, 2, 3, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 20)));
        this.add((Component)this.selRadio, new GBC(0, 3, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(10, 30, 0, 0)));
        this.add((Component)this.allRadio, new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 30, 0, 0)));
        this.add((Component)bpanel, new GBC(0, 5, 1, 1, 1.0, 1.0, 0, 0, 12, 11, new Insets(0, 0, 0, 20)));
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.editor.setDirty(true);
        } else {
            this.swatch.restore();
            this.canvas.syncWithSwatch_ByKey();
            this.canvas.repaint();
            this.icon.updateImage(this.canvas.getTiles());
            this.hue.setDefault();
            this.sat.setDefault();
            this.val.setDefault();
        }
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.selRadio != null && !flag) {
            this.selRadio.setEnabled(true);
        }
        if (flag) {
            this.swatch.backup();
            this.editor.setDirty(true);
            XPMTile[] canvasTiles = this.canvas.getSelectedTiles();
            if (canvasTiles == null || canvasTiles.length == 0) {
                this.selRadio.setEnabled(false);
                this.allRadio.setSelected(true);
            } else {
                this.selRadio.setSelected(true);
                if (canvasTiles != null && canvasTiles.length > 0) {
                    String[] keys = this.canvas.getKeys(canvasTiles);
                    this.swatchTargets = this.swatch.getTilesWithKey(keys);
                }
            }
        }
        super.setVisible(flag);
    }

    public class Slider
    extends JPanel
    implements ChangeListener {
        JSlider slider = null;
        private int ID;
        private int defaultValue = 0;
        boolean adjustInProgress = false;

        public Slider(String title, int min, int max, int def, int id) {
            this.ID = id;
            this.defaultValue = def;
            this.setLayout(new GridBagLayout());
            this.slider = new JSlider(0, min, max, def);
            this.slider.addChangeListener(this);
            this.slider.setMinimumSize(new Dimension(80, 20));
            JLabel label = new JLabel(title, 4);
            label.setMinimumSize(new Dimension(30, 20));
            label.setPreferredSize(new Dimension(30, 20));
            this.add((Component)label, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 1, 18, 0, new Insets(10, 15, 0, 10)));
            this.add((Component)this.slider, new GBC(1, 0, 1, 1, 0.0, 0.0, 1, 1, 18, 0, new Insets(13, 5, 0, 0)));
        }

        public void setDefault() {
            this.slider.setValue(this.defaultValue);
        }

        @Override
        public void stateChanged(ChangeEvent ev) {
            if (!this.slider.getValueIsAdjusting()) {
                HSVDialog.this.icon.updateImage(HSVDialog.this.canvas.getTiles());
                this.adjustInProgress = false;
                HSVDialog.this.swatch.editEnd();
            } else {
                if (!this.adjustInProgress) {
                    HSVDialog.this.swatch.editBegin();
                    this.adjustInProgress = true;
                }
                XPMTile[] targets = null;
                targets = HSVDialog.this.selRadio.isSelected() ? HSVDialog.this.swatchTargets : null;
                float delta = (float)this.slider.getValue() / 100.0f;
                switch (this.ID) {
                    case 0: {
                        HSVDialog.this.swatch.editHSV(delta, 0.0f, 0.0f, targets);
                        break;
                    }
                    case 1: {
                        HSVDialog.this.swatch.editHSV(0.0f, delta, 0.0f, targets);
                        break;
                    }
                    case 2: {
                        HSVDialog.this.swatch.editHSV(0.0f, 0.0f, delta, targets);
                    }
                }
                HSVDialog.this.canvas.syncWithSwatch_ByKey();
            }
        }
    }
}

