/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Components.GBC;
import UI_Components.KTitledPanel;
import UI_Tools.XPM.Components.Checkbox;
import UI_Tools.XPM.Components.OverlayShapes.AbstractShape;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMIconTool;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JPanel;

public abstract class AbstractOptions
extends KTitledPanel {
    public static Color disabledColor = Color.LIGHT_GRAY;
    public static Color enabledColor = Color.white;
    private static int preferredWidth = 150;
    private static int preferredHeight = 150;
    public static Dimension fixedDimension = new Dimension(preferredWidth, preferredHeight);
    public static Rectangle fixedBounds = new Rectangle(0, 0, preferredWidth, preferredHeight);
    protected XPMDataBase database;
    protected AbstractShape shape = null;
    private boolean anti_alias = true;
    protected boolean filled = true;
    protected boolean color_ramp = false;
    protected Float thickness = Float.valueOf(0.2f);
    private Checkbox aliasCB = new Checkbox("Anti-alias", this.anti_alias);
    private Checkbox rampCB = new Checkbox("Color ramp", this.color_ramp);

    public AbstractOptions(String title, XPMDataBase database) {
        this(title, database, true);
    }

    public AbstractOptions(String title, final XPMDataBase database, boolean addDefaultControls) {
        super(title, XPMIconTool.BACKGROUD, disabledColor);
        this.database = database;
        this.mainPanel.setBackground(XPMIconTool.BACKGROUD);
        this.setOpaque(true);
        this.setBounds(fixedBounds);
        if (addDefaultControls) {
            this.add(this.aliasCB, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(-10, 5, 0, 0)));
            this.aliasCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    XPMDataBase db = database;
                    AbstractOptions.this.anti_alias = e.getStateChange() != 2;
                    db.overlay.optionPanelChanged();
                }
            });
            this.add(this.rampCB, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 0, 0)));
            this.rampCB.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    XPMDataBase db = database;
                    AbstractOptions.this.color_ramp = e.getStateChange() != 2;
                    db.overlay.optionPanelChanged();
                }
            });
        }
    }

    public void removeAntiAliasCB() {
        this.remove(this.aliasCB);
    }

    protected abstract void initShape();

    @Override
    public void setEnabled(boolean flag) {
        if (flag) {
            this.setTitleColor(enabledColor);
            this.aliasCB.setForeground(enabledColor);
            this.aliasCB.setEnabled(true);
            this.rampCB.setForeground(enabledColor);
            this.rampCB.setEnabled(true);
            if (this.database.overlay == null) {
                return;
            }
            this.initShape();
            this.database.overlay.initShape(this.shape);
            this.database.canvas.moveOverlayToFront();
            this.database.optionsLayers.moveToFront(this);
        } else {
            this.setTitleColor(disabledColor);
            this.aliasCB.setForeground(disabledColor);
            this.aliasCB.setEnabled(false);
            this.rampCB.setForeground(disabledColor);
            this.rampCB.setEnabled(false);
            if (this.database.canvas != null) {
                this.database.canvas.moveOverlayToBack();
            }
        }
    }

    public abstract String getText();

    public abstract String getFontName();

    public abstract int getFontStyle();

    public abstract boolean getFontItalic();

    public abstract String getGeoShape();

    public abstract float getThickness();

    public boolean getAliasing() {
        return this.anti_alias;
    }

    public boolean getFill() {
        return this.filled;
    }

    public boolean getColorRamp() {
        return this.color_ramp;
    }

    protected class Holder
    extends JPanel {
        public Holder() {
            this.setLayout(new GridBagLayout());
            this.setBackground(XPMIconTool.BACKGROUD);
        }
    }
}

