/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Checkbox;
import UI_Tools.XPM.Components.Floatfield;
import UI_Tools.XPM.Components.OverlayShapes.BlockShape;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BlockOptions
extends AbstractOptions {
    private Checkbox geoCB = new Checkbox("Circle", false);
    private Checkbox fillCB = new Checkbox("Outline", false);
    private String geo = "rect";
    private Floatfield thicknessField = new Floatfield("Thickness", this.thickness.floatValue());

    public BlockOptions(final XPMDataBase database) {
        super("Block Options", database);
        this.add(this.geoCB, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 0, 0)));
        this.geoCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                BlockOptions.this.geo = e.getStateChange() == 2 ? "rect" : "circle";
                db.overlay.optionPanelChanged();
            }
        });
        this.add(this.fillCB, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(-3, 5, 0, 0)));
        this.fillCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                BlockOptions.this.filled = e.getStateChange() == 2;
                BlockOptions.this.thicknessField.setEnabled(!BlockOptions.this.filled);
                db.overlay.optionPanelChanged();
            }
        });
        this.add(this.thicknessField, new GBC(0, 4, 3, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 8, 0, 0)));
        this.thicknessField.setEnabled(false);
        this.thicknessField.addListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                XPMDataBase db = database;
                BlockOptions.this.thickness = BlockOptions.this.thicknessField.getFloat();
                if (db.overlay != null) {
                    db.overlay.optionPanelChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                XPMDataBase db = database;
                BlockOptions.this.thickness = BlockOptions.this.thicknessField.getFloat();
                if (db.overlay != null) {
                    db.overlay.optionPanelChanged();
                }
            }
        });
    }

    @Override
    public float getThickness() {
        if (this.thickness == null) {
            return this.thicknessField.lastValidValue;
        }
        return this.thickness.floatValue();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.geoCB.setEnabled(flag);
        this.geoCB.setForeground(flag ? enabledColor : disabledColor);
        this.fillCB.setEnabled(flag);
        this.fillCB.setForeground(flag ? enabledColor : disabledColor);
        if (!flag) {
            this.thicknessField.setEnabled(false);
        } else {
            this.thicknessField.setEnabled(!this.filled);
        }
    }

    @Override
    protected void initShape() {
        if (this.database.overlay == null) {
            Cutter.setLog("BlockOptions.initShape() - overlay is null");
            return;
        }
        if (this.shape == null) {
            this.shape = new BlockShape(this.database, this);
        }
        this.shape.updateState();
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getFontName() {
        return null;
    }

    @Override
    public int getFontStyle() {
        return -1;
    }

    @Override
    public boolean getFontItalic() {
        return false;
    }

    public int getFontSize() {
        return -1;
    }

    @Override
    public String getGeoShape() {
        return this.geo;
    }
}

