/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMTile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLayeredPane;

public class ForeBack
extends JLayeredPane {
    public ForeBackTile frontTile;
    public ForeBackTile rearTile;
    XPMDataBase database;

    public ForeBack(final XPMDataBase database, int size) {
        this.database = database;
        this.rearTile = new ForeBackTile(database.db_Lightest.color, database.db_Lightest.key, 28);
        this.frontTile = new ForeBackTile(database.db_Darkest.color, database.db_Darkest.key, 28);
        this.rearTile.removeMouseListener(this.rearTile);
        this.rearTile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                XPMDataBase db = database;
                if (e.getClickCount() == 1) {
                    String fkey = ForeBack.this.frontTile.getTileKey();
                    Color fcol = ForeBack.this.frontTile.getTileColor();
                    String rkey = ForeBack.this.rearTile.getTileKey();
                    Color rcol = ForeBack.this.rearTile.getTileColor();
                    ForeBack.this.rearTile.setTileKey(fkey);
                    ForeBack.this.rearTile.setTileColor(fcol);
                    ForeBack.this.frontTile.setTileKey(rkey);
                    ForeBack.this.frontTile.setTileColor(rcol);
                    ForeBack.this.rearTile.repaint();
                    ForeBack.this.frontTile.repaint();
                    db.editor.foreBackChangeHappened();
                }
            }
        });
        this.frontTile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                XPMDataBase db = database;
                if (e.getClickCount() == 2) {
                    db.editor.chooseColor(ForeBack.this.frontTile.getTileColor(), ForeBack.this.frontTile.getTileKey());
                }
                if (e.getClickCount() == 1) {
                    String key = ForeBack.this.frontTile.getTileKey();
                    XPMTile.deSelect(db.swatch);
                    XPMTile.setSelected(db.swatch, key);
                }
            }
        });
        this.setOpaque(true);
        this.setMinimumSize(new Dimension(41, 39));
        this.setPreferredSize(new Dimension(41, 39));
        this.add((Component)this.rearTile, (Object)0);
        this.add((Component)this.frontTile, (Object)1);
        this.rearTile.setBounds(15, 15, 42, 42);
        this.frontTile.setBounds(0, 0, 28, 28);
    }

    public void setForeground(Color c, String key) {
        if (c != null && key != null) {
            this.frontTile.setTileKey(key);
            this.frontTile.setTileColor(c);
            this.database.editor.foreBackChangeHappened();
            this.repaint();
        }
    }

    public void setBackground(Color c, String key) {
        if (c != null && key != null) {
            this.rearTile.setTileKey(key);
            this.rearTile.setTileColor(c);
            this.database.editor.foreBackChangeHappened();
            this.repaint();
        }
    }

    public void restoreForeground(Color c) {
        this.frontTile.setTileColor(c);
    }

    public Color getForegroundColor() {
        return this.frontTile.getTileColor();
    }

    public String getForegroundKey() {
        return this.frontTile.getTileKey();
    }

    public Color getBackgroundColor() {
        return this.rearTile.getTileColor();
    }

    public String getBackgroundKey() {
        return this.rearTile.getTileKey();
    }

    public class ForeBackTile
    extends XPMTile {
        public ForeBackTile(Color floatColor, String key, int tileSize) {
            super(floatColor, key, tileSize);
        }

        @Override
        public void dndDropHappened(XPMColor xpm) {
            this.setTileKey(xpm.key);
            this.setTileColor(xpm.color);
            ForeBack.this.database.editor.foreBackChangeHappened();
        }
    }
}

