/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Checkbox;
import UI_Tools.XPM.Components.Floatfield;
import UI_Tools.XPM.Components.OverlayShapes.LineShape;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LineOptions
extends AbstractOptions {
    private Floatfield thicknessField;
    private Checkbox controlCB;

    public LineOptions(final XPMDataBase database) {
        super("Line Options", database);
        this.thicknessField = new Floatfield("Thickness", this.thickness.floatValue());
        this.controlCB = new Checkbox("Default Controller", false);
        this.add(this.thicknessField, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 8, 0, 0)));
        this.thickness = Float.valueOf(1.0f);
        this.thicknessField.setValue(this.thickness.floatValue());
        this.thicknessField.addListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                XPMDataBase db = database;
                LineOptions.this.thickness = LineOptions.this.thicknessField.getFloat();
                if (db.overlay != null) {
                    db.overlay.optionPanelChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                XPMDataBase db = database;
                LineOptions.this.thickness = LineOptions.this.thicknessField.getFloat();
                if (db.overlay != null) {
                    db.overlay.optionPanelChanged();
                }
            }
        });
        this.add(this.controlCB, new GBC(0, 3, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(5, 5, 0, 0)));
        this.controlCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                if (e.getStateChange() == 2) {
                    LineOptions.this.shape.setCustomControl();
                } else {
                    LineOptions.this.shape.setDefaultControl();
                }
                db.overlay.optionPanelChanged();
            }
        });
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.thicknessField.setEnabled(flag);
        this.controlCB.setEnabled(flag);
        this.controlCB.setForeground(flag ? enabledColor : disabledColor);
    }

    @Override
    protected void initShape() {
        if (this.database.overlay == null) {
            Cutter.setLog("LineOptions.initShape() - overlay is null");
            return;
        }
        if (this.shape == null) {
            this.shape = new LineShape(this.database, this);
        }
        this.shape.updateState();
    }

    @Override
    public float getThickness() {
        if (this.thickness == null) {
            return this.thicknessField.lastValidValue;
        }
        return this.thickness.floatValue();
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public String getFontName() {
        return null;
    }

    @Override
    public int getFontStyle() {
        return -1;
    }

    @Override
    public boolean getFontItalic() {
        return false;
    }

    public int getFontSize() {
        return -1;
    }

    @Override
    public String getGeoShape() {
        return null;
    }
}

