/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Components.GBC;
import UI_Components.KTextArea;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Checkbox;
import UI_Tools.XPM.Components.OverlayShapes.TextShape;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMDataBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TextOptions
extends AbstractOptions {
    private LimitedText textarea = new LimitedText();
    private Checkbox textWeightCB = new Checkbox("Bold", false);
    private String fontName = "Serif";
    private Checkbox fontNameCB = new Checkbox(this.fontName, true);
    private boolean textItalic = false;
    private Checkbox textItalicCB = new Checkbox("Italic", this.textItalic);
    private int textWeight = 0;
    private int textSize = 10;

    public TextOptions(final XPMDataBase database) {
        super("Text Options", database);
        this.textarea.setMargin(new Insets(1, 5, 1, 5));
        this.textarea.setFont(new Font("SansSerif", 0, 18));
        this.textarea.setText("A");
        this.textarea.setMinimumSize(new Dimension(100, 20));
        this.textarea.setPreferredSize(new Dimension(100, 20));
        this.add(this.textarea, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 8, 0, 0)));
        this.add(this.textWeightCB, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(5, 5, 0, 0)));
        this.textWeightCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                TextOptions.this.textWeight = e.getStateChange() == 2 ? 0 : 1;
                db.overlay.optionPanelChanged();
            }
        });
        AbstractOptions.Holder holder = new AbstractOptions.Holder();
        holder.add((Component)this.fontNameCB, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.fontNameCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                TextOptions.this.fontName = e.getStateChange() == 2 ? "SansSerif" : "Serif";
                db.overlay.optionPanelChanged();
            }
        });
        holder.add((Component)this.textItalicCB, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 10, 0, 0)));
        this.textItalicCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                XPMDataBase db = database;
                TextOptions.this.textItalic = e.getStateChange() != 2;
                db.overlay.optionPanelChanged();
            }
        });
        this.add(holder, new GBC(0, 4, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(-3, 5, 0, 0)));
        this.setEnabled(false);
    }

    @Override
    protected void initShape() {
        if (this.database.overlay == null) {
            Cutter.setLog("TextOptions.initShape() - overlay is null");
            return;
        }
        if (this.shape == null) {
            this.shape = new TextShape(this.database, this);
        }
        this.shape.updateState();
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(flag);
        this.textarea.setEnabled(flag);
        this.textWeightCB.setEnabled(flag);
        this.textWeightCB.setForeground(flag ? enabledColor : disabledColor);
        this.fontNameCB.setEnabled(flag);
        this.fontNameCB.setForeground(flag ? enabledColor : disabledColor);
        this.textItalicCB.setEnabled(flag);
        this.textItalicCB.setForeground(flag ? enabledColor : disabledColor);
    }

    @Override
    public String getText() {
        return this.textarea.getText();
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public int getFontStyle() {
        return this.textWeight;
    }

    @Override
    public boolean getFontItalic() {
        return this.textItalic;
    }

    @Override
    public String getGeoShape() {
        return null;
    }

    @Override
    public float getThickness() {
        return -1.0f;
    }

    class LimitedText
    extends KTextArea {
        private LimitedDoc doc;

        public LimitedText() {
            super(1, 5);
            this.doc = new LimitedDoc();
            super.setDocument(this.doc);
        }

        class LimitedDoc
        extends PlainDocument {
            LimitedDoc() {
            }

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (this.getLength() + str.length() <= 6) {
                    super.insertString(offset, str, attr);
                    if (TextOptions.this.database.overlay != null) {
                        TextOptions.this.database.overlay.optionPanelChanged();
                    }
                }
            }

            @Override
            public void remove(int offs, int len) throws BadLocationException {
                super.remove(offs, len);
                if (TextOptions.this.database.overlay != null) {
                    TextOptions.this.database.overlay.optionPanelChanged();
                }
            }
        }
    }
}

