/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM.Panels;

import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMIconTool;
import Utilities.ResourceUtils;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToolRack
extends JPanel {
    private ToolButton canvasTool = new ToolButton("dndInactive.gif", "dndActive.gif", XPMEditor.CANVAS);
    private ToolButton painterTool = new ToolButton("paintInactive.gif", "paintActive.gif", XPMEditor.BLOCKER);
    private ToolButton texterTool = new ToolButton("textInactive.gif", "textActive.gif", XPMEditor.TEXTER);
    private ToolButton gradLineTool = new ToolButton("lineInactive.gif", "lineActive.gif", XPMEditor.LINE);
    private Vector<ToolButton> listOfTools = new Vector();
    private XPMDataBase database;

    public ToolRack(XPMDataBase database) {
        this.database = database;
        this.listOfTools.addElement(this.canvasTool);
        this.listOfTools.addElement(this.painterTool);
        this.listOfTools.addElement(this.texterTool);
        this.listOfTools.addElement(this.gradLineTool);
        this.setBackground(XPMIconTool.BACKGROUD);
        this.setLayout(new FlowLayout(0, 2, 1));
        JPanel spacer = new JPanel();
        spacer.setBackground(XPMIconTool.BACKGROUD);
        spacer.setPreferredSize(new Dimension(10, 24));
        this.add(spacer);
        this.add(this.canvasTool);
        this.add(this.painterTool);
        this.add(this.texterTool);
        this.add(this.gradLineTool);
    }

    public void toolSelectionHappened(ToolButton item, String name, boolean state) {
        if (!state) {
            return;
        }
        this.database.setSelectedTool(name);
        for (int n = 0; n < this.listOfTools.size(); ++n) {
            ToolButton tb = this.listOfTools.elementAt(n);
            if (tb == item || !tb.isSelected()) continue;
            tb.setSelected(false);
        }
        if (name.equals(XPMEditor.CANVAS)) {
            if (this.database.pixelOptions == null || this.database.activeShapeOptions == this.database.pixelOptions) {
                return;
            }
            this.database.activeShapeOptions = this.database.pixelOptions;
            this.database.activeShapeOptions.setEnabled(true);
            this.database.canvas.repaint();
        } else if (name.equals(XPMEditor.BLOCKER)) {
            if (this.database.paintOptions == null) {
                return;
            }
            if (this.database.activeShapeOptions == this.database.paintOptions) {
                return;
            }
            this.database.activeShapeOptions = this.database.paintOptions;
            this.database.activeShapeOptions.setEnabled(true);
        } else if (name.equals(XPMEditor.TEXTER)) {
            if (this.database.txtOptions == null) {
                return;
            }
            if (this.database.activeShapeOptions == this.database.txtOptions) {
                return;
            }
            this.database.activeShapeOptions = this.database.txtOptions;
            this.database.activeShapeOptions.setEnabled(true);
        } else if (name.equals(XPMEditor.LINE)) {
            if (this.database.lineOptions == null) {
                return;
            }
            if (this.database.activeShapeOptions == this.database.lineOptions) {
                return;
            }
            this.database.activeShapeOptions = this.database.lineOptions;
            this.database.activeShapeOptions.setEnabled(true);
        } else if (this.database.activeShapeOptions != null) {
            this.database.activeShapeOptions.setEnabled(false);
        }
    }

    public void selectPaintTool() {
        this.painterTool.setSelected(true);
    }

    public void selectPointerTool() {
        this.canvasTool.setSelected(true);
    }

    public class ToolButton
    extends JToggleButton {
        String path = "/resources/";
        private ImageIcon upIcon;
        private ImageIcon downIcon;
        private String name;

        public ToolButton(String upIconName, String downIconName, String name) {
            this.upIcon = ResourceUtils.getIconResource(this.path + upIconName);
            this.downIcon = ResourceUtils.getIconResource(this.path + downIconName);
            this.name = name;
            this.setIcon(this.upIcon);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            this.setMinimumSize(new Dimension(24, 24));
            this.setPreferredSize(new Dimension(24, 24));
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ((JToggleButton)e.getSource()).setIcon(ToolButton.this.downIcon);
                        ToolButton.this.notifyParent(true);
                    } else {
                        ((JToggleButton)e.getSource()).setIcon(ToolButton.this.upIcon);
                        ToolButton.this.notifyParent(false);
                        boolean none_selected = true;
                        for (int n = 0; n < ToolRack.this.listOfTools.size(); ++n) {
                            if (!((ToolButton)ToolRack.this.listOfTools.elementAt(n)).isSelected()) continue;
                            none_selected = false;
                        }
                        if (none_selected) {
                            ToolRack.this.selectPointerTool();
                        }
                    }
                }
            });
        }

        protected void notifyParent(boolean state) {
            ToolRack.this.toolSelectionHappened(this, this.name, state);
        }
    }
}

