/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMColorChooser;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMTile;
import UI_Tools.XPM.XPMTileManager;
import Utilities.VectorUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class XPMCanvas
extends JLayeredPane
implements XPMTileManager {
    public static Color tileBorderColor = Color.GRAY;
    private Tile[][] tiles = null;
    private int tileSize;
    public XPMDataBase database = null;
    private XPMColorChooser colorChooser = XPMIconTool.colorChooser;
    private Insets insets = new Insets(0, 0, 0, 0);
    private XPMEditor editor = null;
    private Dimension dim = null;
    private JPanel baselayer = new JPanel();
    private Tile[] tiles1D;

    public XPMCanvas(XPMDataBase database, int tileSize) {
        int width = database.width;
        int height = database.height;
        this.tileSize = tileSize;
        this.database = database;
        this.tiles1D = new Tile[width * height];
        this.tiles = new Tile[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                String[] strs = database.getPixelAsString(x, y);
                Color col = strs == null || strs[1] == null ? null : XPMDataBase.hexToFloatColor(strs[1]);
                this.tiles[x][y] = new Tile(col, strs[0], tileSize);
                this.tiles[x][y].setTileXY(x, y);
            }
        }
        this.initTiles1D();
        this.baselayer.setOpaque(true);
        this.baselayer.setLayout(new GridBagLayout());
        this.dim = this.addTiles(this.baselayer);
        this.setPreferredSize(this.dim);
        this.baselayer.setBounds(0, 0, this.dim.width, this.dim.height);
        this.add((Component)this.baselayer, (Object)0);
        this.setEnabled(true);
    }

    private void initTiles1D() {
        int width = this.tiles.length;
        int height = this.tiles[0].length;
        int n = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.tiles1D[n++] = this.tiles[x][y];
            }
        }
    }

    public void moveOverlayToFront() {
        this.moveToBack(this.baselayer);
    }

    public void moveOverlayToBack() {
        this.moveToFront(this.baselayer);
    }

    private Dimension addTiles(JPanel panel) {
        int width = this.database.width;
        int height = this.database.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x == width - 1) {
                    panel.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 1.0, 0.0, 0, 0, 18, 0, this.insets));
                    continue;
                }
                if (x == width - 1 && y == height - 1) {
                    panel.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 1.0, 1.0, 0, 0, 18, 0, this.insets));
                    continue;
                }
                panel.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 0.0, 0.0, 0, 0, 18, 0, this.insets));
            }
        }
        int totalTileWidth = this.tileSize + this.insets.left * 2;
        int totalTileHeight = this.tileSize + this.insets.left * 2;
        panel.setMinimumSize(new Dimension(totalTileWidth * width, totalTileHeight * height));
        panel.setPreferredSize(new Dimension(totalTileWidth * width, totalTileHeight * height));
        return new Dimension(totalTileWidth * width, totalTileHeight * height);
    }

    @Override
    public XPMTile[][] getTiles() {
        return this.tiles;
    }

    public XPMTile[] getTiles1D() {
        return this.tiles1D;
    }

    public void setTile(int x, int y, String key, Color col) {
        this.tiles[x][y].setTileColor(col);
        this.tiles[x][y].setTileKey(key);
    }

    @Override
    public XPMColor[][] getXPMColors() {
        int width = this.database.width;
        int height = this.database.height;
        XPMColor[][] out = new XPMColor[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Tile tile = this.tiles[x][y];
                XPMColor col = new XPMColor();
                col.color = tile.getTileColor();
                col.key = tile.getTileKey();
                out[x][y] = col;
            }
        }
        return out;
    }

    public void setXPMColors(XPMColor[][] cols) {
        int width = this.database.width;
        int height = this.database.height;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.tiles[x][y].setTileColor(cols[x][y].color);
                this.tiles[x][y].setTileKey(cols[x][y].key);
            }
        }
    }

    public Hashtable<String, Color> getTableOfColorsByKey() {
        Hashtable<String, Color> table = new Hashtable<String, Color>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            table.put(tile.getTileKey(), tile.getTileColor());
        }
        return table;
    }

    public Hashtable<Color, String> getTableOfColorsByRGB() {
        Hashtable<Color, String> table = new Hashtable<Color, String>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            table.put(tile.getTileColor(), tile.getTileKey());
        }
        return table;
    }

    public void hiliteOrphanTiles() {
        Hashtable<String, Color> LUT = this.database.swatch.getLUT_ByKey();
        Cutter.setLog("hiliteOrphanTiles_____________________");
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (LUT.containsKey(tile.getTileKey())) continue;
            tile.setSelected();
            Cutter.setLog(">" + tile.getTileKey() + "< " + tile.getTileColor().toString() + " " + tile.getTileAsHex());
        }
    }

    public XPMColor[] getOrphanXPMColors() {
        Vector<XPMColor> out = new Vector<XPMColor>();
        Hashtable<String, Color> LUT = this.database.swatch.getLUT_ByKey();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (LUT.containsKey(tile.getTileKey())) continue;
            out.add(tile.getTileXPM());
        }
        return XPMColor.vectorToArrayCopy(out);
    }

    public XPMTile[] getSelectedTiles() {
        int width = this.database.width;
        int height = this.database.height;
        Vector<Tile> tmp = new Vector<Tile>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                Tile tile = this.tiles[x][y];
                if (!tile.isSelected) continue;
                tmp.addElement(tile);
            }
        }
        XPMTile[] out = new XPMTile[tmp.size()];
        for (int n = 0; n < tmp.size(); ++n) {
            out[n] = (XPMTile)tmp.elementAt(n);
        }
        return out;
    }

    public String[] getKeys(XPMTile[] tiles) {
        if (tiles == null || tiles.length == 0) {
            return null;
        }
        Vector<String> tmp = new Vector<String>();
        for (int n = 0; n < tiles.length; ++n) {
            XPMTile tile = tiles[n];
            tmp.addElement(tile.getTileKey());
        }
        return VectorUtils.toStringArray(tmp);
    }

    @Override
    public int getWidth() {
        return this.dim.width;
    }

    @Override
    public int getHeight() {
        return this.dim.height;
    }

    public int getTileSize() {
        return this.tileSize;
    }

    public int getTileGap() {
        return this.insets.left;
    }

    public void syncWithSwatch_ByKey() {
        Hashtable<String, Color> lut = this.database.swatch.getLUT_ByKey();
        for (int x = 0; x < this.tiles.length; ++x) {
            for (int y = 0; y < this.tiles[0].length; ++y) {
                Tile tile = this.tiles[x][y];
                Color c = lut.get(tile.getTileKey());
                tile.setTileColor(c);
            }
        }
        this.repaint();
    }

    public void syncWithSwatch_ByRGB() {
        Hashtable<Color, XPMColor> lut = this.database.swatch.getLUT_XPM_ByRGB();
        XPMTile[][] canvasTiles = this.database.canvas.getTiles();
        for (int y = 0; y < canvasTiles[0].length; ++y) {
            for (int x = 0; x < canvasTiles.length; ++x) {
                XPMTile canvasTile = canvasTiles[x][y];
                Color convasTileRGB = canvasTile.getTileColor();
                XPMColor xpm = lut.get(convasTileRGB);
                canvasTile.setTileXPM(xpm);
            }
        }
        this.repaint();
    }

    public void syncWithIcon() {
        int width = this.database.width;
        int height = this.database.height;
        int[][] col = this.database.icon.getColorsAsInts();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                this.tiles[x][y].setTileColor(new Color(col[x][y]));
            }
        }
    }

    public void syncWithImage(BufferedImage bi) {
        int width = this.database.width;
        int height = this.database.height;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int col = bi.getRGB(x, y);
                this.tiles[x][y].setTileColor(new Color(col));
            }
        }
    }

    private class Tile
    extends XPMTile {
        public Tile(Color floatColor, String swatchKey, int tileSize) {
            super(floatColor, swatchKey, tileSize);
            this.setEnabled(true);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.isEmpty || this.isSelected || this.isDnDHilited) {
                super.paint(g);
                return;
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2.drawImage((Image)this.buff, 0, 0, null);
            if (tileBorderColor != null) {
                g2.setColor(tileBorderColor);
                g2.setStroke(new BasicStroke(0.25f));
                Rectangle2D.Float sq = new Rectangle2D.Float(0.0f, 0.0f, (float)this.tileSize - 0.25f, (float)this.tileSize - 0.25f);
                g2.draw(sq);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            XPMCanvas.this.database.editor.canvasClickHappened(e, this);
            Cutter.setLog("canvas tile key >" + this.getTileKey() + "< color " + this.getTileColor());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            XPMDataBase db = XPMCanvas.this.database;
            XPMCanvas.this.database.editor.mouseEnteredCanvas();
        }

        public void _mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
        }

        public void _mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
        }
    }
}

