/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import java.awt.Color;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XPMColor
implements Serializable {
    private Hashtable<String, String> culledKeys = new Hashtable();
    private boolean markToBeCulled = false;
    public String key = null;
    public String hex = null;
    public Color color = null;

    public XPMColor() {
    }

    public XPMColor(String k, Color c) {
        this.key = k;
        this.color = c;
    }

    public XPMColor(String k, Color c, String h) {
        this.key = k;
        this.color = c;
        this.hex = h;
    }

    public XPMColor(XPMColor src) {
        this.key = new String(src.key);
        this.hex = src.hex;
        this.color = new Color(src.color.getRGB());
        Enumeration<String> e = src.culledKeys.keys();
        while (e.hasMoreElements()) {
            String s = e.nextElement();
            this.culledKeys.put(s, s);
        }
    }

    public String toString() {
        return this.key + "  " + this.color.toString() + "  " + this.hex;
    }

    public boolean isSameAs(XPMColor xpm) {
        if (xpm.color == null && this.color == null) {
            return true;
        }
        if (xpm.color == null && this.color != null || xpm.color != null && this.color == null) {
            return false;
        }
        if (xpm.key == null && this.key != null || xpm.key != null && this.key == null) {
            return false;
        }
        return xpm.color.getRGB() == this.color.getRGB() && xpm.key == null && this.key == null || xpm.key.equals(this.key);
    }

    public void clearCullTable() {
        this.culledKeys.clear();
    }

    public int cullTableSize() {
        return this.culledKeys.size();
    }

    public void addToCullTable(String s) {
        this.culledKeys.put(s, s);
    }

    public Hashtable getCullTable() {
        return this.culledKeys;
    }

    public void addToCullTable(Hashtable h) {
        if (h.size() == 0) {
            return;
        }
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            this.addToCullTable(s);
        }
    }

    public String cullTableToString() {
        if (this.culledKeys.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        Enumeration<String> e = this.culledKeys.keys();
        while (e.hasMoreElements()) {
            buf.append(e.nextElement());
        }
        return buf.toString();
    }

    public void markToBeCulled(boolean flag) {
        this.markToBeCulled = flag;
    }

    public boolean isMarkedToBeCulled() {
        return this.markToBeCulled;
    }

    public static void divideIntoRGB(XPMColor[] input, XPMColor[] Rout, XPMColor[] Gout, XPMColor[] Bout) {
        int n;
        Vector<XPMColor> R = new Vector<XPMColor>();
        Vector<XPMColor> G = new Vector<XPMColor>();
        Vector<XPMColor> B = new Vector<XPMColor>();
        for (n = 0; n < input.length; ++n) {
            XPMColor item = input[n];
            int r = item.color.getRed();
            int g = item.color.getGreen();
            int b = item.color.getBlue();
            if (r >= g && r >= b) {
                R.addElement(item);
                continue;
            }
            if (g >= r && g >= b) {
                G.addElement(item);
                continue;
            }
            B.addElement(item);
        }
        Rout = new XPMColor[R.size()];
        Gout = new XPMColor[G.size()];
        Bout = new XPMColor[B.size()];
        for (n = 0; n < R.size(); ++n) {
            Rout[n] = (XPMColor)R.elementAt(n);
        }
        for (n = 0; n < G.size(); ++n) {
            Gout[n] = (XPMColor)G.elementAt(n);
        }
        for (n = 0; n < B.size(); ++n) {
            Bout[n] = (XPMColor)B.elementAt(n);
        }
    }

    public static String colorToHex(Color input) {
        if (input == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        short r = (short)input.getRed();
        short g = (short)input.getGreen();
        short b = (short)input.getBlue();
        sb.append("#").append(XPMColor.shortTo2Hex(r)).append(XPMColor.shortTo2Hex(g)).append(XPMColor.shortTo2Hex(b));
        return sb.toString();
    }

    public static String shortTo2Hex(short in) {
        byte b = (byte)(in & 0xFF);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%02x", b));
        return sb.toString();
    }

    public static XPMColor[] hexTableToXPMColorArray(Hashtable table) {
        XPMColor[] out = new XPMColor[table.size()];
        Enumeration e = table.elements();
        int count = 0;
        while (e.hasMoreElements()) {
            out[count++] = (XPMColor)e.nextElement();
        }
        return out;
    }

    public static XPMColor[] rgbTableToXPMColorArray(Hashtable rgbtable) {
        XPMColor[] out = new XPMColor[rgbtable.size()];
        Enumeration e = rgbtable.keys();
        int count = 0;
        while (e.hasMoreElements()) {
            Color swatch_color = (Color)e.nextElement();
            String swatch_key = (String)rgbtable.get(swatch_color);
            String swatch_hex = XPMColor.colorToHex(swatch_color);
            out[count++] = new XPMColor(swatch_key, swatch_color, swatch_hex);
        }
        return out;
    }

    public static XPMColor[] vectorToArrayCopy(Vector<XPMColor> input) {
        XPMColor[] out = new XPMColor[input.size()];
        for (int n = 0; n < input.size(); ++n) {
            XPMColor xpm = input.elementAt(n);
            out[n] = new XPMColor(xpm);
        }
        return out;
    }

    public static Vector<XPMColor> arrayToVectorCopy(XPMColor[] input) {
        Vector<XPMColor> out = new Vector<XPMColor>();
        for (int n = 0; n < input.length; ++n) {
            out.add(new XPMColor(input[n]));
        }
        return out;
    }
}

