/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMTile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class XPMColorChooser
extends JDialog {
    private static final long serialVersionUID = 1L;
    public JColorChooser chooser = new JColorChooser();
    private JButton cancelButton = new JButton("Cancel");
    private JButton okButton = new JButton(" OK ");
    public Color outColor = null;
    private Color inColor = null;
    private Color originalPanelColor = null;
    private XPMDataBase database = null;
    private String key = "";

    public XPMColorChooser() {
        super(Cutter.desktop, "Color Chooser", true);
        this.setVisible(false);
        this.removeSwatchPanel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)this.chooser, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 10, 0, new Insets(2, 2, 2, 2)));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPMColorChooser.this.outColor = null;
                if (XPMColorChooser.this.database != null && XPMColorChooser.this.inColor != null) {
                    XPMTile.setColor(((XPMColorChooser)XPMColorChooser.this).database.swatch, XPMColorChooser.this.inColor, XPMColorChooser.this.key);
                    XPMTile.setColor(((XPMColorChooser)XPMColorChooser.this).database.canvas, XPMColorChooser.this.inColor, XPMColorChooser.this.key);
                    ((XPMColorChooser)XPMColorChooser.this).database.foreback.setForeground(XPMColorChooser.this.inColor, XPMColorChooser.this.key);
                } else if (XPMColorChooser.this.originalPanelColor != null) {
                    ((XPMColorChooser)XPMColorChooser.this).database.foreback.restoreForeground(XPMColorChooser.this.originalPanelColor);
                }
                XPMColorChooser.this.setVisible(false);
            }
        });
        contentPane.add((Component)this.cancelButton, new GBC(4, 1, 1, 1, 1.0, 1.0, 0, 0, 13, 0, new Insets(0, 0, 5, 10)));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPMColorChooser.this.setVisible(false);
            }
        });
        contentPane.add((Component)this.okButton, new GBC(5, 1, 1, 1, 0.0, 0.0, 0, 0, 13, 0, new Insets(0, 0, 5, 10)));
        this.pack();
        this.chooser.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!XPMColorChooser.this.isVisible()) {
                    return;
                }
                XPMColorChooser.this.outColor = XPMColorChooser.this.chooser.getColor();
                if (XPMColorChooser.this.database == null) {
                    return;
                }
                if (XPMColorChooser.this.database == null) {
                    Cutter.setLog("null database");
                }
                if (((XPMColorChooser)XPMColorChooser.this).database.swatch == null) {
                    Cutter.setLog("null database.swatch");
                }
                XPMTile.setColor(((XPMColorChooser)XPMColorChooser.this).database.swatch, XPMColorChooser.this.outColor, XPMColorChooser.this.key);
                XPMTile.setColor(((XPMColorChooser)XPMColorChooser.this).database.canvas, XPMColorChooser.this.outColor, XPMColorChooser.this.key);
                ((XPMColorChooser)XPMColorChooser.this).database.foreback.setForeground(XPMColorChooser.this.outColor, XPMColorChooser.this.key);
            }
        });
    }

    public void showSelf(XPMDataBase database, String key) {
        this.database = database;
        this.key = key;
        this.originalPanelColor = database.foreback.getForeground();
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean flag) {
        if (!flag) {
            this.database = null;
            this.key = null;
        }
        super.setVisible(flag);
    }

    public void setColor(Color color) {
        this.inColor = color;
        this.chooser.setColor(color);
        AbstractColorChooserPanel[] p = this.chooser.getChooserPanels();
        for (int n = 0; n < p.length; ++n) {
            if (p[n] == null) continue;
            p[n].updateChooser();
        }
        JComponent c = this.chooser.getPreviewPanel();
        Graphics g = c.getGraphics();
        g.setColor(color);
        c.update(g);
    }

    private void removeSwatchPanel() {
        AbstractColorChooserPanel[] oldPanel = this.chooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanel = new AbstractColorChooserPanel[oldPanel.length - 1];
        for (int n = 0; n < newPanel.length; ++n) {
            newPanel[n] = oldPanel[n + 1];
        }
        this.chooser.setChooserPanels(newPanel);
    }
}

