/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Overlay;
import UI_Tools.XPM.Components.Pixel;
import UI_Tools.XPM.Components.XPMIcon;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.Panels.BlockOptions;
import UI_Tools.XPM.Panels.ForeBack;
import UI_Tools.XPM.Panels.LineOptions;
import UI_Tools.XPM.Panels.PixelOptions;
import UI_Tools.XPM.Panels.TextOptions;
import UI_Tools.XPM.Panels.ToolRack;
import UI_Tools.XPM.XPMCanvas;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMInput;
import UI_Tools.XPM.XPMSwatch;
import UI_Tools.XPM.XPMTile;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.math.BigInteger;
import java.util.Hashtable;
import javax.swing.JLayeredPane;

public class XPMDataBase
extends XPMInput {
    public static int SHORT_POSITIVE_MAX = 65535;
    public static int INT_POSITIVE_MAX = -1;
    public static int MAX_ICON_DEPTH = 35;
    public static int PAINT = 1;
    public XPMCanvas canvas = null;
    public XPMSwatch swatch = null;
    public XPMEditor editor = null;
    public ForeBack foreback = null;
    public ToolRack toolrack = null;
    public JLayeredPane optionsLayers = new JLayeredPane();
    public PixelOptions pixelOptions = null;
    public TextOptions txtOptions = null;
    public BlockOptions paintOptions = null;
    public LineOptions lineOptions = null;
    public AbstractOptions activeShapeOptions = null;
    public Overlay overlay = null;
    public XPMColor db_Lightest = new XPMColor();
    public XPMColor db_Darkest = new XPMColor();
    private String selectedTool = "";
    public XPMIcon icon = null;
    public File srcFile = null;
    private static int CANVAS_TILE_SIZE = 12;
    private int SWATCH_TILE_SIZE = 10;
    public String name = "untitled";

    public void setSelectedTool(String name) {
        this.selectedTool = name;
    }

    public String getSelectedTool() {
        return this.selectedTool;
    }

    public XPMDataBase(String text) throws Exception {
        super(text);
        this.commonInit(null);
    }

    public XPMDataBase(File file) throws Exception {
        super(file);
        this.commonInit(file);
    }

    private void commonInit(File file) {
        this.srcFile = file;
        this.name = file == null ? "untitled" : this.srcFile.getName();
        this.db_Lightest.key = this.getKeyForLightest(this);
        this.db_Darkest.key = this.getKeyForDarkest(this);
        this.db_Lightest.color = XPMDataBase.hexToFloatColor((String)this.colors.get(this.db_Lightest.key));
        this.db_Darkest.color = XPMDataBase.hexToFloatColor((String)this.colors.get(this.db_Darkest.key));
        this.optionsLayers.setBackground(XPMIconTool.BACKGROUD);
        this.pixelOptions = new PixelOptions(this);
        this.txtOptions = new TextOptions(this);
        this.paintOptions = new BlockOptions(this);
        this.lineOptions = new LineOptions(this);
        this.foreback = new ForeBack(this, 28);
        this.toolrack = new ToolRack(this);
        int tilesize = CANVAS_TILE_SIZE;
        if (this.width == 16) {
            tilesize *= 2;
        } else if (this.width == 64) {
            tilesize /= 2;
        }
        this.canvas = new XPMCanvas(this, tilesize);
        this.overlay = new Overlay(this);
        this.canvas.add((Component)this.overlay, (Object)0);
        this.swatch = new XPMSwatch(this, this.SWATCH_TILE_SIZE);
        this.icon = new XPMIcon(this);
    }

    public static int[] hexToRGB(String str) {
        if (str.length() == 7) {
            Color c = Color.decode(str);
            int[] out = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
            return out;
        }
        BigInteger r = new BigInteger(str.substring(1, 5), 16);
        BigInteger g = new BigInteger(str.substring(5, 9), 16);
        BigInteger b = new BigInteger(str.substring(9), 16);
        float red = (float)r.intValue() / (float)SHORT_POSITIVE_MAX;
        float green = (float)g.intValue() / (float)SHORT_POSITIVE_MAX;
        float blue = (float)b.intValue() / (float)SHORT_POSITIVE_MAX;
        Color c = new Color(red, green, blue);
        int[] out = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        return out;
    }

    public static Color hexToFloatColor(String str) {
        if (str.length() == 7) {
            Color c = Color.decode(str);
            return c;
        }
        BigInteger r = new BigInteger(str.substring(1, 5), 16);
        BigInteger g = new BigInteger(str.substring(5, 9), 16);
        BigInteger b = new BigInteger(str.substring(9), 16);
        float red = (float)r.intValue() / (float)SHORT_POSITIVE_MAX;
        float green = (float)g.intValue() / (float)SHORT_POSITIVE_MAX;
        float blue = (float)b.intValue() / (float)SHORT_POSITIVE_MAX;
        Color c = new Color(red, green, blue);
        return c;
    }

    public String getCanvasAsStr() {
        StringBuffer buf = new StringBuffer();
        XPMTile[][] tiles = this.canvas.getTiles();
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int y = 0; y < numY; ++y) {
            for (int x = 0; x < numX; ++x) {
                XPMTile tile = tiles[x][y];
                if (x == 0) {
                    buf.append("\"");
                }
                buf.append(tile.getTileKey());
                if (x != numX - 1) continue;
                if (y == numY - 1) {
                    buf.append("\"};\n");
                    continue;
                }
                buf.append("\",\n");
            }
        }
        return buf.toString();
    }

    public String getSwatchAsStr() {
        StringBuffer buf = new StringBuffer();
        XPMTile[][] tiles = this.swatch.getTiles();
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int x = 0; x < numX; ++x) {
            for (int y = 0; y < numY; ++y) {
                XPMTile tile = tiles[x][y];
                if (tile.isEmpty()) continue;
                String key = tile.getTileKey();
                buf.append("\"");
                buf.append(key).append(" c ");
                Color c = tile.getTileColor();
                if (c == null) {
                    Cutter.setLog("    Warning:XPMDataBase.getSwatchAsStr() - tile with key \"" + key + "\" has a null color!");
                    continue;
                }
                String hex = XPMColor.colorToHex(c);
                buf.append(hex).append("\",\n");
            }
        }
        String[] lines = TextUtils.tokenize(buf.toString(), "\n");
        lines = TextUtils.sortByAlpha(lines);
        buf.setLength(0);
        for (int n = 0; n < lines.length; ++n) {
            buf.append(lines[n]).append("\n");
        }
        return buf.toString();
    }

    public String getIconInXPMFormat(File f) {
        StringBuffer buf = new StringBuffer();
        buf.append("/* XPM */\n");
        buf.append("static char * image_name[] = {\n");
        int numColors = this.swatch.numNonEmptyTiles();
        String stats = this.width + " " + this.height + " " + numColors + " " + this.charsPerPixel;
        buf.append("\"").append(stats).append("\",\n");
        Hashtable<Color, String> swatchRGB = this.swatch.getLUT_ByRGB();
        Hashtable<String, Color> swatchKEY = this.swatch.getLUT_ByKey();
        XPMTile[] canvas_tiles = this.canvas.getTiles1D();
        for (int n = 0; n < canvas_tiles.length; ++n) {
            XPMTile tile = canvas_tiles[n];
            String tileKey = tile.getTileKey();
            Color tileColor = tile.getTileColor();
            tile.setTileHex(XPMColor.colorToHex(tileColor));
            String tileHex = tile.getTileAsHex();
            if (swatchKEY.containsKey(tileKey)) continue;
            Cutter.setLog("    Info:XPMDataBase.getIconInXPMFormat() - swatch does not contain an entry for:");
            Cutter.setLog("            a canvas tile key >" + tileKey + "< hex: " + tileHex + " " + tileColor.toString());
            String substKey = swatchRGB.get(tileColor);
            if (substKey != null) {
                tile.setTileKey(substKey);
                Cutter.setLog("        found a matching color and will substitute >" + substKey + "< for >" + tileKey);
                continue;
            }
            Pixel db = new Pixel(tileKey, tileColor);
            this.swatch.findNearestColorByRGB(db);
            tile.setTileKey(db.k);
            Cutter.setLog("        could not find an exact match, using nearest color with key >" + db.k + "<");
        }
        buf.append(this.getSwatchAsStr());
        buf.append(this.getCanvasAsStr());
        return buf.toString();
    }
}

