/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Components.GBC;
import UI_Components.KButton.KButton;
import UI_Components.KTextField.KTextField;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Pixel;
import UI_Tools.XPM.Dialogs.HSVDialog;
import UI_Tools.XPM.Panels.AbstractOptions;
import UI_Tools.XPM.XPMAbstract;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMIconShelf;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMTile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class XPMEditor
extends JPanel {
    public static String CANVAS = "canvas_dnd_paint";
    public static String BLOCKER = "block_paint";
    public static String TEXTER = "text_paint";
    public static String LINE = "line_paint";
    public static KeyStroke backspace_keystroke = KeyStroke.getKeyStroke(8, 0, false);
    public XPMDataBase database = null;
    private HSVDialog hsvDialog = null;
    private KTextField pathField = new KTextField("", 34);
    Stack<UndoItem> undoStack = new Stack();
    Stack<UndoItem> redoStack = new Stack();
    UndoButton undoButton = new UndoButton();
    RedoButton redoButton = new RedoButton();

    public XPMEditor(XPMDataBase database) {
        this.setLayout(new GridBagLayout());
        this.setBackground(XPMIconTool.BACKGROUD);
        database.editor = this;
        this.database = database;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                XPMEditor.this.mouseEnteredEditor();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                XPMEditor.this.editorClickHappened(e);
            }
        });
        database.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                XPMEditor.this.iconClickHappened(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    // empty if block
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    // empty if block
                }
            }
        });
        XPMIconShelf.addIcon(this);
        this.add((Component)database.canvas, new GBC(0, 0, 4, 4, 0.0, 0.0, 0, 0, 18, 0, new Insets(7, 7, 0, 15)));
        this.add((Component)this.pathField, new GBC(0, 5, 4, 4, 0.0, 1.0, 0, 0, 18, 2, new Insets(3, 7, 3, 15)));
        this.pathField.setBackground(XPMIconTool.BACKGROUD);
        this.pathField.setEditable(false);
        this.pathField.setForeground(AbstractOptions.disabledColor);
        this.add((Component)database.swatch, new GBC(5, 0, 2, 2, 1.0, 0.0, 0, 0, 18, 0, new Insets(7, 0, 10, 15)));
        JPanel holder = new JPanel();
        holder.setBackground(XPMIconTool.BACKGROUD);
        holder.setLayout(new GridBagLayout());
        holder.add((Component)database.foreback, new GBC(0, 0, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        holder.add((Component)database.toolrack, new GBC(1, 0, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.add((Component)holder, new GBC(5, 2, 2, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 3, 2, 0)));
        database.optionsLayers.setOpaque(true);
        database.optionsLayers.setPreferredSize(AbstractOptions.fixedDimension);
        database.optionsLayers.add((Component)database.pixelOptions, (Object)0);
        database.optionsLayers.add((Component)database.txtOptions, (Object)0);
        database.optionsLayers.add((Component)database.paintOptions, (Object)0);
        database.optionsLayers.add((Component)database.lineOptions, (Object)0);
        JPanel holder2 = new JPanel();
        holder2.setBackground(XPMIconTool.BACKGROUD);
        holder2.setLayout(new GridBagLayout());
        holder2.add((Component)this.undoButton, new GBC(0, 0, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        holder2.add((Component)this.redoButton, new GBC(0, 1, 1, 1, 0.0, 0.0, 0, 0, 18, 0, new Insets(5, 0, 0, 0)));
        this.add((Component)holder2, new GBC(5, 3, 1, 1, 0.0, 1.0, 0, 0, 18, 0, new Insets(20, 0, 0, 0)));
        this.add((Component)database.optionsLayers, new GBC(6, 3, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(10, 15, 0, 0)));
        this.initDefaultTool();
        this.setEnabled(true);
    }

    private void initDefaultTool() {
        this.database.setSelectedTool(CANVAS);
        this.database.toolrack.selectPointerTool();
    }

    public void showHSVDialog() {
        if (this.hsvDialog == null) {
            this.hsvDialog = new HSVDialog(this.database, "HSV Editor", true);
        }
        this.hsvDialog.showSelf();
    }

    public void hiliteOrphanCanvasTiles() {
        this.database.canvas.hiliteOrphanTiles();
    }

    @Override
    public void setVisible(boolean f) {
        this.database.icon.setSelected(f);
        XPMIconShelf.shelf.repaint();
        super.setVisible(f);
    }

    public void dndDropHappened(XPMTile targetTile, XPMColor xpm) {
        targetTile.setTileXPM(xpm);
        targetTile.setTileColor(xpm.color);
        targetTile.repaint();
        if (targetTile.getClass().getName().equals("UI_Tools.XPM.XPMCanvas$Tile")) {
            targetTile.setDeSelected();
            targetTile.setDnDHilited(false);
            this.setDirty(true);
        }
        this.database.overlay.initIconCopy();
    }

    public void dndDragEnterPaint(XPMTile targetTile, XPMColor xpm) {
        if (targetTile.getClass().getName().equals("UI_Tools.XPM.XPMCanvas$Tile")) {
            targetTile.setTileXPM(xpm);
            targetTile.setTileColor(xpm.color);
            targetTile.repaint();
            this.database.overlay.repaint();
        }
    }

    public void dndDragEnter(XPMTile targetTile, XPMColor xpm) {
        if (targetTile.getClass().getName().equals("UI_Tools.XPM.XPMCanvas$Tile")) {
            targetTile.setDnDHilited(true);
            Pixel pixel = new Pixel(targetTile.getTileX(), targetTile.getTileY(), xpm.color);
            this.database.overlay.setDnDHilited(pixel);
            this.database.overlay.repaint();
        }
    }

    public void dndDragExit(XPMTile targetTile) {
        if (targetTile.getClass().getName().equals("UI_Tools.XPM.XPMCanvas$Tile")) {
            targetTile.setDnDHilited(false);
            this.database.overlay.setDnDHilited(null);
            this.database.overlay.repaint();
        }
    }

    public void swatchDeleteHappened(XPMTile[] selectedSwatchTiles) {
        if (selectedSwatchTiles == null || selectedSwatchTiles.length == 0) {
            return;
        }
        this.setDirty(true);
        for (int n = 0; n < selectedSwatchTiles.length; ++n) {
            XPMTile tile = selectedSwatchTiles[n];
            this.database.swatch.deleteTile(tile);
        }
        this.database.swatch.repaint();
        this.database.foreback.setForeground(this.database.foreback.getBackgroundColor(), this.database.foreback.getBackgroundKey());
        this.database.foreback.repaint();
    }

    public void mouseEnteredEditor() {
        if (this.database.getSelectedTool().equals(CANVAS)) {
            XPMAbstract.setPointerCursor();
        }
        if (this.database.getSelectedTool().equals(BLOCKER)) {
            XPMAbstract.setPaintCursor(this.database.foreback.getForegroundColor());
        }
    }

    public void mouseEnteredCanvas() {
        if (this.database.getSelectedTool().equals(CANVAS)) {
            XPMAbstract.setPointerCursor();
        }
        if (this.database.getSelectedTool().equals(BLOCKER)) {
            XPMAbstract.setPaintCursor(this.database.foreback.getForegroundColor());
        }
    }

    public void mouseEnteredSwatch() {
        if (this.database.getSelectedTool().equals(CANVAS)) {
            XPMAbstract.setPointerCursor();
        }
        if (this.database.getSelectedTool().equals(BLOCKER)) {
            XPMAbstract.setPaintCursor(this.database.foreback.getForegroundColor());
        }
    }

    private void editorClickHappened(MouseEvent e) {
        XPMTile.deSelect(this.database.swatch);
        XPMTile.deSelect(this.database.canvas);
    }

    public void canvasClickHappened(MouseEvent e, XPMTile tile) {
        XPMTile.deSelect(this.database.canvas);
        XPMTile.deSelect(this.database.swatch);
        if (e.getClickCount() == 1) {
            if (e.isAltDown() || e.isControlDown() || this.database.getSelectedTool().equals(CANVAS)) {
                XPMTile.setSelected(this.database.swatch, tile.getTileKey());
                XPMTile.setSelected(this.database.canvas, tile.getTileKey());
                this.database.foreback.setForeground(tile.getTileColor(), tile.getTileKey());
                return;
            }
            if (this.database.getSelectedTool().equals(BLOCKER)) {
                tile.setTileColor(this.database.foreback.getForegroundColor());
                tile.setTileKey(this.database.foreback.getForegroundKey());
                this.setDirty(true);
            }
        } else if (e.getClickCount() == 2) {
            // empty if block
        }
    }

    public void iconClickHappened(MouseEvent e) {
        if (e.getClickCount() == 1) {
            XPMIconTool.tabbedPane.bringToFront(XPMIconTool.tabbedPane, this);
        }
    }

    public void foreBackChangeHappened() {
        this.database.overlay.forebackPanelChanged();
    }

    public void swatchClickHappened(MouseEvent e, XPMTile tile) {
        XPMTile.deSelect(this.database.canvas);
        XPMTile.deSelect(this.database.swatch);
        if (e.getClickCount() == 1) {
            if (e.isAltDown() || e.isControlDown() || this.database.getSelectedTool().equals(CANVAS) && !tile.isEmpty()) {
                XPMTile.setSelected(this.database.swatch, tile.getTileKey());
                XPMTile.setSelected(this.database.canvas, tile.getTileKey());
                this.database.foreback.setForeground(tile.getTileColor(), tile.getTileKey());
                return;
            }
            if (!tile.isEmpty()) {
                XPMIconTool.tabbedPane.setEnabled(true);
                XPMTile.deSelect(this.database.swatch);
                XPMTile.setSelected(this.database.swatch, tile.getTileKey());
                this.database.foreback.setForeground(tile.getTileColor(), tile.getTileKey());
                if (this.database.getSelectedTool().equals(BLOCKER)) {
                    this.database.toolrack.selectPaintTool();
                }
                return;
            }
            return;
        }
        if (e.getClickCount() == 2) {
            if (tile.isEmpty()) {
                String newkey = XPMTile.generateKey(this.database);
                if (newkey != null) {
                    Cutter.setLog("    Info:XPMSwatch.mouseClicked() - generated new key \"" + newkey + "\"");
                }
                tile.setEmpty(false);
                tile.prevEmpty = true;
                tile.setTileKey(newkey);
                this.setDirty(true);
            } else {
                tile.prevEmpty = false;
            }
            Color result = this.database.editor.chooseColor(tile.getTileColor(), tile.getTileKey());
            if (result == null && tile.prevEmpty) {
                tile.setEmpty(true);
            } else if (result != null) {
                tile.setTileColor(result);
            }
            this.database.editor.setDirty(true);
        }
    }

    public Color chooseColor(Color initialColor, String swatchKey) {
        XPMIconTool.colorChooser.setColor(initialColor);
        XPMIconTool.colorChooser.showSelf(this.database, swatchKey);
        Color c = XPMIconTool.colorChooser.outColor;
        if (c != null) {
            this.setDirty(true);
        }
        return c;
    }

    @Override
    public String getName() {
        return this.database.name;
    }

    public boolean getDirty() {
        String title = XPMIconTool.getTitleOfSelectedTab();
        return title.endsWith("*");
    }

    public void setDirty(boolean flag) {
        UndoItem prev;
        if (this.database.srcFile != null) {
            this.pathField.setText(this.database.srcFile.getPath());
        }
        String title = XPMIconTool.getTitleOfSelectedTab();
        if (flag && !title.endsWith("*")) {
            XPMIconTool.setTitleOfSelectedTab(title + "*");
        } else if (!flag && title.endsWith("*")) {
            XPMIconTool.setTitleOfSelectedTab(title.substring(0, title.length() - 1));
        }
        XPMTile[][] tiles = this.database.canvas.getTiles();
        this.database.icon.updateImage(tiles);
        if (!flag) {
            return;
        }
        UndoItem item = new UndoItem();
        item.swatchData = this.database.swatch.getXPMColors();
        item.canvasData = this.database.canvas.getXPMColors();
        if (this.undoStack.size() > 0 && (prev = this.undoStack.peek()) != null && prev.isSameAs(item)) {
            return;
        }
        this.undoStack.push(item);
        this.undoButton.setEnabled(true);
    }

    public void undo() {
        if (this.undoStack.size() < 1) {
            return;
        }
        UndoItem item = this.undoStack.pop();
        UndoItem tmp = new UndoItem();
        tmp.swatchData = this.database.swatch.getXPMColors();
        tmp.canvasData = this.database.canvas.getXPMColors();
        if (tmp.isSameAs(item)) {
            this.redoStack.push(item);
            this.redoButton.setEnabled(true);
            if (this.undoStack.size() == 0) {
                this.undoButton.setEnabled(false);
                return;
            }
            item = this.undoStack.pop();
        }
        this.clientUpdate(item);
        this.redoStack.push(item);
        this.redoButton.setEnabled(true);
        if (this.undoStack.size() < 1) {
            this.undoButton.setEnabled(false);
        }
    }

    public void redo() {
        if (this.redoStack.size() < 1) {
            return;
        }
        UndoItem item = this.redoStack.pop();
        UndoItem tmp = new UndoItem();
        tmp.swatchData = this.database.swatch.getXPMColors();
        tmp.canvasData = this.database.canvas.getXPMColors();
        if (tmp.isSameAs(item)) {
            this.undoStack.push(item);
            this.undoButton.setEnabled(true);
            if (this.redoStack.size() == 0) {
                return;
            }
            item = this.redoStack.pop();
        }
        this.clientUpdate(item);
        this.undoStack.push(item);
        this.undoButton.setEnabled(true);
        if (this.redoStack.size() < 1) {
            this.redoButton.setEnabled(false);
        }
    }

    private void clientUpdate(UndoItem item) {
        this.database.swatch.setXPMColors(item.swatchData);
        this.database.canvas.setXPMColors(item.canvasData);
        this.database.swatch.repaint();
        this.database.canvas.repaint();
        this.database.icon.updateImage();
        this.database.overlay.initIconCopy();
        this.database.overlay.repaint();
    }

    public class UndoButton
    extends AbstractButton {
        public UndoButton() {
            super("<");
        }

        @Override
        public void action() {
            XPMEditor.this.undo();
        }
    }

    public class RedoButton
    extends AbstractButton {
        public RedoButton() {
            super(">");
        }

        @Override
        public void action() {
            XPMEditor.this.redo();
        }
    }

    public class UndoItem {
        public XPMColor[][] swatchData = null;
        public XPMColor[][] canvasData = null;

        public boolean isSameAs(UndoItem item) {
            int x;
            int y;
            int width = this.swatchData.length;
            int height = this.swatchData[0].length;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (item.swatchData[x][y].isSameAs(this.swatchData[x][y])) continue;
                    return false;
                }
            }
            width = this.canvasData.length;
            height = this.canvasData[0].length;
            for (y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    if (item.canvasData[x][y].isSameAs(this.canvasData[x][y])) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private abstract class AbstractButton
    extends KButton
    implements ActionListener {
        public AbstractButton(String label) {
            super(label, XPMIconTool.BACKGROUD, AbstractOptions.disabledColor);
            Dimension d = new Dimension(25, 25);
            this.setPreferredSize(d);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setEnabled(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.action();
        }

        @Override
        public void setEnabled(boolean f) {
            super.setEnabled(f);
            this.setForeground(f ? Color.white : AbstractOptions.disabledColor);
        }

        public abstract void action();
    }

    public class _EditorControls
    extends JPanel {
        public _EditorControls() {
            this.setLayout(new GridBagLayout());
            this.setBackground(XPMIconTool.BACKGROUD);
            KButton hsvButton = new KButton("HSV Editor", XPMIconTool.BACKGROUD, Color.white);
            hsvButton.setActionCommand("raise_dialog");
            hsvButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("raise_dialog".equals(e.getActionCommand())) {
                        XPMEditor.this.hsvDialog.showSelf();
                    }
                }
            });
            this.add((Component)hsvButton, new GBC(0, 0, 1, 1, 0.0, 0.0, 1, 1, 18, 0, new Insets(0, 0, 0, 0)));
        }
    }
}

