/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import Preferences.Preferences;
import UI_Components.Dialog.SaveFileDialog;
import UI_Components.GBC;
import UI_Components.KMenu;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Desktop.KDesktop;
import UI_Tools.XPM.XPMAbstract;
import UI_Tools.XPM.XPMColorChooser;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMEditor;
import UI_Tools.XPM.XPMIconShelf;
import Utilities.FileUtils;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class XPMIconTool
extends XPMAbstract {
    public static int WIDTH = 600;
    public static int HEIGHT = 900;
    public static KTabbedPane tabbedPane = new KTabbedPane();
    private static XPMIconTool tool = null;
    private static FileMenu fileMenu = new FileMenu();
    private static EditMenu editMenu = new EditMenu();
    private static XPMIconShelf iconShelf = XPMIconShelf.init(WIDTH);
    private static Vector<XPMDataBase> listOfDataBases = new Vector();
    public static Color BACKGROUD = new Color(68, 68, 68);
    public static Color HILITE = new Color(255, 0, 0);
    public static Color CARET_COLOR = Color.yellow;
    public static XPMColorChooser colorChooser = new XPMColorChooser();

    private static boolean saveAs(XPMEditor editor) {
        SaveFileDialog saveFileDialog = SaveFileDialog.getInstance(Cutter.desktop, "Save As");
        saveFileDialog.setSelectedFile(null);
        saveFileDialog.setFileFilter(new KFileFilter("xpm", "X (Window) PixMap"));
        int response = saveFileDialog.showSelf("Save As");
        if (response == -2) {
            return false;
        }
        File f = saveFileDialog.getSelectedFile();
        if (f != null) {
            XPMIconTool.setTitleOfSelectedTab(TextUtils.removeExtension(f.getName()));
            editor.database.srcFile = f;
            FileUtils.writeFile(f, editor.database.getIconInXPMFormat(null));
            return true;
        }
        return false;
    }

    public static XPMIconTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new XPMIconTool(menuItem, null);
        return tool;
    }

    private XPMEditor addEditor(File infile, int size) {
        XPMDataBase xpm;
        if (infile != null) {
            try {
                xpm = new XPMDataBase(infile);
            }
            catch (Exception e) {
                XPMIconTool.showError("Unknown XPM Format", e.toString(), "");
                return null;
            }
            for (int n = 0; n < listOfDataBases.size(); ++n) {
                File f = XPMIconTool.listOfDataBases.elementAt((int)n).srcFile;
                if (f == null || xpm.srcFile == null || f != xpm.srcFile) continue;
                Cutter.setLog("    Info:XPMIconShelf.addIcon() - opening existing editor for \"" + f.getPath() + "\"");
                return XPMIconTool.listOfDataBases.elementAt((int)n).editor;
            }
        } else {
            StringBuffer buff = new StringBuffer();
            buff.append("static char * image_name[] = {\n");
            buff.append("\"" + size + " " + size + " 2 2\",\n");
            buff.append("\".. c #ffffff\",\n");
            buff.append("\",. c #000000\",\n");
            for (int n = 0; n < size; ++n) {
                buff.append("\"");
                for (int x = 0; x < size; ++x) {
                    buff.append("..");
                }
                if (n < size - 1) {
                    buff.append("\",\n");
                    continue;
                }
                buff.append("\"};\n");
            }
            try {
                xpm = new XPMDataBase(buff.toString());
            }
            catch (Exception e) {
                XPMIconTool.showError("Unknown XPM Format", e.toString(), "");
                return null;
            }
        }
        listOfDataBases.add(xpm);
        String name = "untitled";
        if (infile != null) {
            name = TextUtils.removeExtension(infile.getName());
        }
        XPMEditor editor = new XPMEditor(xpm);
        tabbedPane.addTab(name, editor);
        editor.setDirty(true);
        editor.setDirty(false);
        this.pack();
        return editor;
    }

    public static void showError(String title, String error, String suggestion) {
        JOptionPane.showMessageDialog(KDesktop.desktopPane, error + "\n\n" + suggestion, title, 0);
    }

    protected XPMIconTool(JMenuItem menuItem, String helpDocPath) {
        super("XPM Icon Tool", menuItem, Preferences.TOOL_XPM, helpDocPath);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        this.contentPane.setBackground(BACKGROUD);
        this.contentPane.add((Component)iconShelf, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.contentPane.add((Component)tabbedPane, new GBC(0, 1, 1, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.setTitle(this.TOOL_NAME);
        this.pack();
        this.setInitialPosition();
        String str = Preferences.get(Preferences.TOOL_XPM_FILES_OPEN);
        String[] strs = TextUtils.tokenize(str, '\u0010');
        if (strs != null && strs.length > 0) {
            for (int n = 0; n < strs.length; ++n) {
                File f = new File(strs[n]);
                if (!f.exists()) continue;
                this.addEditor(f, -1);
            }
        }
        this.setVisible(false);
        this.setEnabled(true);
    }

    private String getTitleOfSelectedTab(JTabbedPane tab) {
        JTabbedPane selectedTab;
        Component c = tab.getSelectedComponent();
        if (c instanceof JTabbedPane && (selectedTab = (JTabbedPane)c).getTabCount() > 0) {
            int index = selectedTab.getSelectedIndex();
            return selectedTab.getTitleAt(index);
        }
        return tab.getTitleAt(tab.getSelectedIndex());
    }

    public static String getTitleOfSelectedTab() {
        int index = tabbedPane.getSelectedIndex();
        return tabbedPane.getTitleAt(index);
    }

    public static void setTitleOfSelectedTab(String title) {
        int index = tabbedPane.getSelectedIndex();
        tabbedPane.setTitleAt(index, title);
    }

    @Override
    protected void saveSelf() {
        super.saveSelf();
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < listOfDataBases.size(); ++n) {
            File f = XPMIconTool.listOfDataBases.elementAt((int)n).srcFile;
            if (f == null) continue;
            buf.append(f.getPath()).append('\u0010');
        }
        Preferences.write(Preferences.TOOL_XPM_FILES_OPEN, buf.toString());
    }

    static class FileMenu
    extends KMenu {
        public FileMenu() {
            super("File");
            JMenu newItem = new JMenu("New Icon");
            JMenuItem new32Item = new JMenuItem("32x32 Icon");
            JMenuItem new16Item = new JMenuItem("16x16 Icon");
            newItem.add(new32Item);
            newItem.add(new16Item);
            JMenuItem openItem = new JMenuItem("Open Icon...");
            JMenuItem closeItem = new JMenuItem("Close Icon...");
            JMenuItem saveItem = new JMenuItem("Save Icon");
            JMenuItem saveAsItem = new JMenuItem("Save Icon As...");
            JMenu exportItem = new JMenu("Export");
            JMenuItem pngItem = new JMenuItem("png...");
            JMenuItem gifItem = new JMenuItem("gif...");
            JMenuItem jpgItem = new JMenuItem("jpg...");
            exportItem.add(pngItem);
            exportItem.add(gifItem);
            exportItem.add(jpgItem);
            JMenuItem importItem = new JMenuItem("Import Image");
            this.add(newItem);
            this.add(openItem);
            this.add(closeItem);
            this.addSeparator();
            this.add(saveItem);
            this.add(saveAsItem);
            this.addSeparator();
            this.add(exportItem);
            this.add(importItem);
            new32Item.addActionListener(new NewIconAction(32));
            new16Item.addActionListener(new NewIconAction(64));
            openItem.addActionListener(new OpenIconAction());
            closeItem.addActionListener(new CloseEditorAction());
            saveItem.addActionListener(new SaveAction());
            saveAsItem.addActionListener(new SaveAsAction());
            pngItem.addActionListener(new ExportAction("png"));
            gifItem.addActionListener(new ExportAction("gif"));
            jpgItem.addActionListener(new ExportAction("jpg"));
            importItem.addActionListener(new ImportAction());
        }
    }

    static class EditMenu
    extends KMenu {
        public EditMenu() {
            super("Edit");
            final JMenuItem undoItem = new JMenuItem("Undo");
            final JMenuItem redoItem = new JMenuItem("Redo");
            KMenu sortSwatchItem = new KMenu("Sort Swatch Colors");
            JMenuItem rgbSortItem = new JMenuItem("RGB");
            rgbSortItem.addActionListener(new rgbSortAction());
            rgbSortItem.setEnabled(true);
            sortSwatchItem.add(rgbSortItem);
            JMenuItem hexSortItem = new JMenuItem("HEX");
            hexSortItem.addActionListener(new hexSortAction());
            hexSortItem.setEnabled(true);
            sortSwatchItem.add(hexSortItem);
            JMenuItem hsvShiftItem = new JMenuItem("Shift Swatch Colors");
            JMenuItem notInSwatch = new JMenuItem("Hilite Orphan Canvas Tiles");
            this.add(undoItem);
            this.add(redoItem);
            this.addSeparator();
            this.add(sortSwatchItem);
            this.add(hsvShiftItem);
            this.addSeparator();
            this.add(notInSwatch);
            undoItem.addActionListener(new UndoAction());
            redoItem.addActionListener(new RedoAction());
            undoItem.setEnabled(false);
            redoItem.setEnabled(false);
            sortSwatchItem.setEnabled(true);
            hsvShiftItem.addActionListener(new ColorShiftAction());
            hsvShiftItem.setEnabled(true);
            notInSwatch.addActionListener(new HiliteOrphansAction());
            notInSwatch.setEnabled(true);
            this.addMenuListener(new MenuListener(){

                @Override
                public void menuCanceled(MenuEvent e) {
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                }

                @Override
                public void menuSelected(MenuEvent e) {
                    XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
                    if (ed == null) {
                        return;
                    }
                    boolean flag = ed.undoStack.size() >= 1;
                    undoItem.setEnabled(flag);
                    flag = ed.redoStack.size() >= 1;
                    redoItem.setEnabled(flag);
                }
            });
        }
    }

    private static class HiliteOrphansAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.database.toolrack.selectPointerTool();
            ed.hiliteOrphanCanvasTiles();
        }
    }

    private static class ColorShiftAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.showHSVDialog();
        }
    }

    private static class hexSortAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.database.swatch.sortByHex();
            Cutter.setLog("    Info:XPMIconTool.SortSwatchAction - sorting by hex.");
            ed.database.swatch.repaint();
            ed.setDirty(true);
        }
    }

    private static class rgbSortAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.database.swatch.sortByRGB();
            Cutter.setLog("    Info:XPMIconTool.SortSwatchAction - sorting by rgb.");
            ed.database.swatch.repaint();
            ed.setDirty(true);
        }
    }

    private static class RedoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.redo();
        }
    }

    private static class UndoAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            ed.undo();
        }
    }

    private static class ImportAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files = KAbstractDesktop.openFileChooser(null);
            if (files != null && files.length > 0) {
                for (int n = 0; n < files.length; ++n) {
                    File f = files[n];
                    if (f == null || f.getName().endsWith(".XPM") || f.getName().endsWith(".xpm")) continue;
                    XPMEditor ed = tool.addEditor(f, -1);
                    try {
                        tabbedPane.setSelectedComponent(ed);
                        continue;
                    }
                    catch (Exception ex) {
                        Cutter.setLog("    Exception:XPMIconTool.ImportAction()\n");
                        Cutter.setLog(ex.toString());
                    }
                }
            }
        }
    }

    private static class ExportAction
    extends AbstractAction {
        String ftype;

        public ExportAction(String formatType) {
            this.ftype = formatType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            boolean result = ed.database.icon.exportAs(this.ftype);
            if (result) {
                ed.setDirty(false);
            }
        }
    }

    private static class SaveAsAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            boolean result = XPMIconTool.saveAs(ed);
            if (result) {
                ed.setDirty(false);
            }
        }
    }

    private static class SaveAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean result;
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            if (ed.database.srcFile == null && (result = XPMIconTool.saveAs(ed))) {
                ed.setDirty(false);
            }
            String text = ed.database.getIconInXPMFormat(null);
            FileUtils.writeFile(ed.database.srcFile, text);
            ed.setDirty(false);
        }
    }

    private static class CloseEditorAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = (XPMEditor)tabbedPane.getSelectedComponent();
            if (ed.getDirty()) {
                int response = JOptionPane.showConfirmDialog(KDesktop.desktopPane, "Save Icon");
                switch (response) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case -1: 
                    case 2: {
                        return;
                    }
                }
                if (response == 0) {
                    if (ed.database.srcFile != null) {
                        FileUtils.writeFile(ed.database.srcFile, ed.database.getIconInXPMFormat(null));
                    } else {
                        XPMIconTool.saveAs(ed);
                    }
                }
            }
            listOfDataBases.remove(ed.database);
            XPMIconShelf.removeIcon(ed.database.icon);
            tabbedPane.remove(ed);
        }
    }

    private static class OpenIconAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            File[] files = KAbstractDesktop.openFileChooser(new KFileFilter("xpm", "X (Window) PixMap"));
            if (files != null && files.length > 0) {
                for (int n = 0; n < files.length; ++n) {
                    File f = files[n];
                    if (f == null || !f.getName().endsWith(".XPM") && !f.getName().endsWith(".xpm")) continue;
                    XPMEditor ed = tool.addEditor(f, -1);
                    try {
                        tabbedPane.setSelectedComponent(ed);
                        continue;
                    }
                    catch (Exception ex) {
                        Cutter.setLog("    Exception:XPMIconTool.OpenIconAction()\n");
                        Cutter.setLog(ex.toString());
                    }
                }
            }
        }
    }

    private static class NewIconAction
    extends AbstractAction {
        private int size;

        public NewIconAction(int size) {
            this.size = size;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XPMEditor ed = tool.addEditor(null, this.size);
            try {
                tabbedPane.setSelectedComponent(ed);
            }
            catch (Exception ex) {
                Cutter.setLog("    Exception:XPMIconTool.OpenIconAction()\n");
                Cutter.setLog(ex.toString());
            }
        }
    }
}

