/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Desktop.Cutter;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMParser;
import UI_Tools.XPM.XPMSwatch;
import Utilities.FileUtils;
import Utilities.GraphicsFileUtils;
import Utilities.TextUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class XPMInput {
    public int width;
    public int height;
    public int numColors;
    public int charsPerPixel;
    public Hashtable<String, String> colors = new Hashtable();
    public int hexType;
    public String[][] pixels = null;
    private String inputpath = null;

    public XPMInput(File file) throws Exception {
        String fname = file.getName();
        this.inputpath = file.getPath();
        if (fname.endsWith(".xpm")) {
            String text = FileUtils.read(file.getPath());
            new XPMParser(text, this);
            if (this.width <= 0 || this.height <= 0) {
                throw new Exception("The XPM file \"" + file.getPath() + "\"\n does not contain valid icon data.");
            }
        } else {
            BufferedImage bi = GraphicsFileUtils.readImageFile(file);
            if (bi == null) {
                throw new Exception("The graphics file cannot be read.");
            }
            if (bi.getHeight() != bi.getWidth()) {
                throw new Exception("The graphics image being imported is not square.");
            }
            if (bi.getHeight() > 48) {
                throw new Exception("The graphics image being imported exceeds 48 pixels in size.");
            }
            this.makeXPMDataFromImage(bi);
        }
    }

    private void makeXPMDataFromImage(BufferedImage image) {
        XPMColor[] sorted;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.hexType = 8;
        this.charsPerPixel = 2;
        Hashtable<String, String> hextable = new Hashtable<String, String>();
        XPMColor[][] pixelXPM = new XPMColor[this.width][this.height];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                XPMColor xpm = new XPMColor();
                xpm.color = new Color(image.getRGB(x, y));
                xpm.hex = XPMColor.colorToHex(xpm.color);
                pixelXPM[x][y] = xpm;
                hextable.put(xpm.hex, xpm.hex);
            }
        }
        Stack<String> stackOfHex = new Stack<String>();
        Enumeration e = hextable.keys();
        while (e.hasMoreElements()) {
            stackOfHex.push((String)e.nextElement());
        }
        Hashtable<String, String> keytable = new Hashtable<String, String>();
        for (int n = 0; n < hextable.size(); ++n) {
            String key = XPMInput.generateKey(keytable);
            keytable.put(key, key);
        }
        Stack<String> stackOfKeys = new Stack<String>();
        Enumeration ee = keytable.keys();
        while (ee.hasMoreElements()) {
            stackOfKeys.push((String)ee.nextElement());
        }
        Hashtable<String, String> tempLUT = new Hashtable<String, String>();
        while (!stackOfKeys.empty()) {
            tempLUT.put((String)stackOfHex.pop(), (String)stackOfKeys.pop());
        }
        Hashtable<String, Color> LUT = new Hashtable<String, Color>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                pixelXPM[x][y].key = (String)tempLUT.get(pixelXPM[x][y].hex);
                LUT.put(pixelXPM[x][y].key, pixelXPM[x][y].color);
            }
        }
        Vector<XPMColor> lutAsList = new Vector<XPMColor>();
        Enumeration enu = LUT.keys();
        while (enu.hasMoreElements()) {
            XPMColor xpm = new XPMColor();
            xpm.key = (String)enu.nextElement();
            xpm.color = (Color)LUT.get(xpm.key);
            xpm.hex = XPMColor.colorToHex(xpm.color);
            lutAsList.add(xpm);
        }
        XPMColor[] raw_xpm = XPMColor.vectorToArrayCopy(lutAsList);
        XPMColor[] culled = sorted = XPMSwatch.sortByRGB(raw_xpm);
        int tolerance = 1;
        while (culled.length > 256) {
            Cutter.setLog("    Info:XPMInput.import - continuing to cull");
            sorted = XPMSwatch.sortByRGB(culled);
            culled = XPMSwatch.cullBySimilarity(sorted, tolerance++);
            Cutter.setLog("          culled size " + culled.length);
            if (culled.length >= 256) continue;
        }
        this.pixels = new String[this.width][this.height];
        for (int n = 0; n < culled.length; ++n) {
            XPMColor xpm = culled[n];
            Hashtable culledKeys = xpm.getCullTable();
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    XPMColor pixXPM = pixelXPM[x][y];
                    if (culledKeys.containsKey(pixXPM.key)) {
                        pixXPM.key = xpm.key;
                        pixXPM.color = xpm.color;
                        pixXPM.hex = xpm.hex;
                    }
                    this.pixels[x][y] = pixXPM.key;
                    this.colors.put(pixXPM.key, pixXPM.hex);
                }
            }
        }
        this.numColors = this.colors.size();
    }

    public XPMInput(String text) throws Exception {
        new XPMParser(text, this);
        if (this.width <= 0 || this.height <= 0) {
            throw new Exception("The XPM text does not contain valid icon data.");
        }
    }

    public String[] getPixelAsString(int x, int y) {
        if (x >= this.width || y >= this.height) {
            return null;
        }
        String shortStr = this.pixels[x][y];
        String longStr = "none";
        if (this.colors.get(shortStr) != null) {
            longStr = this.colors.get(shortStr);
        } else {
            Cutter.setLog("    Warning:XPMInput.getPixelAsString() - key \"" + shortStr + "\" is not in the LUT of,");
            if (this.inputpath != null) {
                Cutter.setLog("           \"" + this.inputpath + "\"");
            } else {
                Cutter.setLog("           \" untitled\"");
            }
            shortStr = this.colors.keys().nextElement();
            longStr = this.colors.get(shortStr);
            Cutter.setLog("        Using an existing key \"" + shortStr + "\" with hex \"" + longStr + "\".");
        }
        String[] result = new String[]{shortStr, longStr};
        return result;
    }

    public XPMColor[] getKeyedColors() {
        Hashtable<String, String> tmp = new Hashtable<String, String>();
        Enumeration<String> e = this.colors.keys();
        String[] hexList = new String[this.colors.size()];
        int j = 0;
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            hexList[j] = this.colors.get(key);
            tmp.put(hexList[j], key);
            ++j;
        }
        XPMColor[] out = new XPMColor[hexList.length];
        for (int n = 0; n < hexList.length; ++n) {
            out[n] = new XPMColor();
            out[n].key = (String)tmp.get(hexList[n]);
            out[n].color = XPMDataBase.hexToFloatColor(hexList[n]);
            out[n].hex = hexList[n];
        }
        return out;
    }

    public String getKeyForLightest(XPMDataBase database) {
        String liteKey = null;
        float lightest = 0.0f;
        Enumeration<String> e = this.colors.keys();
        while (e.hasMoreElements()) {
            String hex;
            Color c;
            float[] rgb;
            float gray;
            String key = e.nextElement();
            if (key == null || !((gray = ((rgb = (c = XPMDataBase.hexToFloatColor(hex = this.colors.get(key))).getColorComponents(null))[0] + rgb[1] + rgb[2]) / 3.0f) > lightest)) continue;
            lightest = gray;
            liteKey = key;
        }
        return liteKey;
    }

    public String getKeyForDarkest(XPMDataBase database) {
        String darkKey = null;
        float darkest = 1.0f;
        Enumeration<String> e = this.colors.keys();
        while (e.hasMoreElements()) {
            String hex;
            Color c;
            float[] rgb;
            float gray;
            String key = e.nextElement();
            if (key == null || !((gray = ((rgb = (c = XPMDataBase.hexToFloatColor(hex = this.colors.get(key))).getColorComponents(null))[0] + rgb[1] + rgb[2]) / 3.0f) < darkest)) continue;
            darkest = gray;
            darkKey = key;
        }
        return darkKey;
    }

    private String getColorsAsStr() {
        StringBuffer buf = new StringBuffer();
        Enumeration<String> e = this.colors.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            buf.append("\"");
            buf.append(key).append(" c ");
            buf.append(this.colors.get(key)).append("\",\n");
        }
        return buf.toString();
    }

    private String[] sortColors() {
        String[] strs = new String[this.colors.size()];
        Enumeration<String> e = this.colors.keys();
        int n = 0;
        while (e.hasMoreElements()) {
            strs[n] = e.nextElement();
            ++n;
        }
        return TextUtils.sortByAlpha(strs);
    }

    public int[] getPixelAsRGB(int x, int y) {
        String[] strs = this.getPixelAsString(x, y);
        if (strs == null || strs[1] == null) {
            return null;
        }
        return XPMDataBase.hexToRGB(strs[1]);
    }

    private String getPixelsAsStr() {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.height; ++n) {
            buf.append("\"").append(this.pixelsAtRow(n));
            if (n == this.height - 1) {
                buf.append("\"};\n");
                continue;
            }
            buf.append("\",\n");
        }
        return buf.toString();
    }

    private String pixelsAtRow(int row) {
        StringBuffer buf = new StringBuffer();
        for (int n = 0; n < this.width; ++n) {
            buf.append(this.pixels[row][n]);
        }
        return buf.toString();
    }

    public static String generateKey(Hashtable table) {
        boolean found = false;
        int max = 10000;
        int n = 0;
        while (!found) {
            String newKey = "" + XPMInput.rndChar() + XPMInput.rndChar();
            if (!table.contains(newKey)) {
                return newKey;
            }
            if (++n <= max) continue;
            break;
        }
        return null;
    }

    private static char rndChar() {
        int rnd = (int)(Math.random() * 52.0);
        int base = rnd < 26 ? 65 : 97;
        return (char)(base + rnd % 26);
    }
}

