/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Script.Comment;
import UI_Tools.XPM.XPMInput;
import Utilities.DocumentUtils;
import Utilities.TextUtils;
import java.util.Enumeration;

public class XPMParser {
    public XPMParser(String textIn, XPMInput dataOut) {
        String[] lines = null;
        if (textIn != null && textIn.trim().length() > 0) {
            Comment[] cmnt = new Comment[]{new Comment("/*", "*/"), new Comment("//", "\n")};
            textIn = DocumentUtils.removeComments(textIn, cmnt);
            lines = TextUtils.tokenize(textIn, "\n");
            this.parse(lines, dataOut);
            Enumeration<String> e = dataOut.colors.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (key == null) continue;
                String hex = dataOut.colors.get(key);
                if (hex.length() == 7) {
                    dataOut.hexType = 8;
                    break;
                }
                dataOut.hexType = 16;
                break;
            }
        }
    }

    private boolean parse(String[] lines, XPMInput dataOut) {
        boolean begin = false;
        boolean header = false;
        boolean colors = false;
        int firstColorIndex = 0;
        int lastColorIndex = 0;
        int rowCount = 0;
        for (int n = 0; n < lines.length; ++n) {
            String line = lines[n].trim();
            if (!begin && line.startsWith("static ")) {
                begin = true;
                firstColorIndex = n + 1;
                continue;
            }
            if (!begin) continue;
            if (!header) {
                String[] tokens = TextUtils.tokenize(line, " \",");
                if (tokens.length != 4) {
                    return false;
                }
                dataOut.width = Integer.parseInt(tokens[0]);
                dataOut.height = Integer.parseInt(tokens[1]);
                dataOut.numColors = Integer.parseInt(tokens[2]);
                dataOut.charsPerPixel = Integer.parseInt(tokens[3]);
                lastColorIndex = firstColorIndex + dataOut.numColors;
                dataOut.pixels = new String[dataOut.width][dataOut.height];
                header = true;
                continue;
            }
            if (n <= lastColorIndex) {
                line = this.getContents(line);
                String key = line.substring(0, dataOut.charsPerPixel);
                line = line.substring(dataOut.charsPerPixel);
                int hashIndex = line.indexOf(35);
                dataOut.colors.put(key, line.substring(hashIndex));
                continue;
            }
            if (n <= lastColorIndex) continue;
            line = TextUtils.trimTrailingChar(line, ';').trim();
            line = TextUtils.trimTrailingChar(line, '}').trim();
            line = TextUtils.trimTrailingChar(line, ',').trim();
            line = TextUtils.trimTrailingChar(line, '\"');
            if ((line = TextUtils.trimLeadingChar(line, '\"')).length() != dataOut.charsPerPixel * dataOut.width) {
                return false;
            }
            int column = 0;
            for (int i = 0; i < dataOut.charsPerPixel * dataOut.width; i += dataOut.charsPerPixel) {
                dataOut.pixels[column][rowCount] = line.substring(i, i + dataOut.charsPerPixel);
                ++column;
            }
            ++rowCount;
        }
        return true;
    }

    private String getContents(String line) {
        line = TextUtils.trimTrailingChar(line, ';').trim();
        line = TextUtils.trimTrailingChar(line, '}').trim();
        line = TextUtils.trimTrailingChar(line, ',').trim();
        line = TextUtils.trimTrailingChar(line, '\"').trim();
        line = TextUtils.trimLeadingChar(line, '\"');
        return line;
    }
}

