/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Components.GBC;
import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.Pixel;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMIconTool;
import UI_Tools.XPM.XPMTile;
import UI_Tools.XPM.XPMTileManager;
import Utilities.TextUtils;
import Utilities.VectorUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class XPMSwatch
extends JPanel
implements XPMTileManager {
    private Tile[][] tiles = new Tile[16][16];
    private Tile[] tiles1D = new Tile[256];
    private int tileSize = 10;
    private Insets insets = new Insets(1, 1, 1, 1);
    private XPMDataBase database;
    public int toolAction = 1;
    public static int NO_SORT = 0;
    public static int RGB_SORT = 1;
    public static int HEX_SORT = 2;

    public Hashtable<String, Color> getLUT_ByKey() {
        Hashtable<String, Color> tmp = new Hashtable<String, Color>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                Tile tile = this.tiles[x][y];
                if (tile.isEmpty()) continue;
                tmp.put(tile.getTileKey(), tile.getTileColor());
            }
        }
        return tmp;
    }

    public Hashtable<Color, String> getLUT_ByRGB() {
        Hashtable<Color, String> tmp = new Hashtable<Color, String>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                Tile tile = this.tiles[x][y];
                if (tile.isEmpty()) continue;
                tmp.put(tile.getTileColor(), tile.getTileKey());
            }
        }
        return tmp;
    }

    public Hashtable<Color, XPMColor> getLUT_XPM_ByRGB() {
        Hashtable<Color, XPMColor> tmp = new Hashtable<Color, XPMColor>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                Tile tile = this.tiles[x][y];
                if (tile.isEmpty()) continue;
                tmp.put(tile.getTileColor(), tile.getTileXPM());
            }
        }
        return tmp;
    }

    public Hashtable<String, XPMColor> getLUT_ByHex() {
        Hashtable<String, XPMColor> hexTable = new Hashtable<String, XPMColor>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            XPMColor xpm = tile.getTileXPM();
            hexTable.put(xpm.hex, xpm);
        }
        return hexTable;
    }

    public int numNonEmptyTiles() {
        int count = 0;
        for (int n = 0; n < this.tiles1D.length; ++n) {
            if (this.tiles1D[n].isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public XPMSwatch(XPMDataBase database, int tileSize) {
        this.database = database;
        this.tileSize = tileSize;
        database.swatch = this;
        XPMColor[] raw = database.getKeyedColors();
        XPMColor[] sorted = XPMSwatch.sortByRGB(raw);
        int count = sorted.length;
        int n = 0;
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.tiles[x][y] = n < count ? new Tile(sorted[n].color, sorted[n].key, tileSize) : new Tile(null, null, tileSize);
                this.tiles[x][y].setTileXY(x, y);
                ++n;
            }
        }
        this.initTiles1D();
        this.setLayout(new GridBagLayout());
        this.setBackground(XPMIconTool.BACKGROUD);
        JPanel tilesContainer = new JPanel();
        tilesContainer.setLayout(new GridBagLayout());
        this.addTiles(tilesContainer);
        this.add((Component)tilesContainer, new GBC(0, 0, 5, 1, 0.0, 0.0, 1, 0, 18, 0, new Insets(2, 2, 2, 2)));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ((XPMSwatch)XPMSwatch.this).database.editor.mouseEnteredSwatch();
            }
        });
        Dimension upperPanel = tilesContainer.getPreferredSize();
        Dimension lowerPanel = database.foreback.getPreferredSize();
        ActionListener deleteAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XPMTile[] tiles = XPMTile.getSelected(XPMSwatch.this);
                ((XPMSwatch)XPMSwatch.this).database.editor.swatchDeleteHappened(tiles);
            }
        };
        KeyStroke keystroke = KeyStroke.getKeyStroke(8, 0, false);
        this.registerKeyboardAction(deleteAction, "", keystroke, 2);
        this.setEnabled(true);
    }

    @Override
    public XPMTile[][] getTiles() {
        return this.tiles;
    }

    @Override
    public XPMColor[][] getXPMColors() {
        XPMColor[][] out = new XPMColor[16][16];
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                Tile tile = this.tiles[x][y];
                XPMColor col = new XPMColor();
                col.color = tile.getTileColor();
                col.key = tile.getTileKey();
                out[x][y] = col;
            }
        }
        return out;
    }

    public void setXPMColors(XPMColor[][] cols) {
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                this.tiles[x][y].setTileColor(cols[x][y].color);
                this.tiles[x][y].setTileKey(cols[x][y].key);
            }
        }
    }

    public boolean add(XPMColor[] cols) {
        int count = 0;
        for (int n = 0; n < cols.length; ++n) {
            if (++count >= 256) {
                return false;
            }
            if (!this.tiles1D[n].isEmpty()) continue;
            this.tiles1D[n].setTileColor(cols[n].color);
            this.tiles1D[n].setTileKey(cols[n].key);
        }
        return true;
    }

    public boolean add(XPMColor xpm) {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            if (!this.tiles1D[n].isEmpty()) continue;
            this.tiles1D[n].setTileColor(xpm.color);
            this.tiles1D[n].setTileKey(xpm.key);
            return true;
        }
        return false;
    }

    public int updateHexValues() {
        int numX = this.tiles.length;
        int numY = this.tiles[0].length;
        int count = 0;
        for (int y = 0; y < numY; ++y) {
            for (int x = 0; x < numX; ++x) {
                Tile tile = this.tiles[x][y];
                if (tile.isEmpty()) continue;
                String key = tile.getTileKey();
                Color c = tile.getTileColor();
                if (c == null) continue;
                tile.setTileHex(XPMColor.colorToHex(c));
                ++count;
            }
        }
        return count;
    }

    public static XPMColor[] cullBySimilarity(XPMColor[] input, int min) {
        if (input.length == 0) {
            return null;
        }
        Cutter.setLog("    Debug:XPMSwatch.cullBySimilarity() input size " + input.length + " tolerance " + min);
        Vector<XPMColor> srclist = new Vector<XPMColor>();
        Vector outlist = new Vector();
        for (int n = 0; n < input.length; ++n) {
            input[n].markToBeCulled(false);
            input[n].clearCullTable();
            srclist.add(input[n]);
        }
        for (int n = 0; n < srclist.size(); ++n) {
            XPMColor xpm = (XPMColor)srclist.elementAt(n);
            XPMSwatch.cull(srclist, xpm, min);
        }
        Iterator iter = srclist.iterator();
        int numremoved = 0;
        while (iter.hasNext()) {
            XPMColor xpm = (XPMColor)iter.next();
            if (!xpm.isMarkedToBeCulled()) continue;
            ++numremoved;
            iter.remove();
        }
        Cutter.setLog("    Debug:XPMSwatch.cullBySimilarity() numremoved " + numremoved);
        Cutter.setLog("    Debug:XPMSwatch.cullBySimilarity() output size " + srclist.size());
        return XPMColor.vectorToArrayCopy(srclist);
    }

    private static void cull(Vector<XPMColor> list, XPMColor xpm, int min) {
        int rtotal = xpm.color.getRed();
        int gtotal = xpm.color.getGreen();
        int btotal = xpm.color.getBlue();
        int count = 1;
        for (int n = 0; n < list.size(); ++n) {
            XPMColor curr = list.elementAt(n);
            if (curr == xpm || curr.isMarkedToBeCulled()) continue;
            int rdiff = xpm.color.getRed() - curr.color.getRed();
            int gdiff = xpm.color.getGreen() - curr.color.getGreen();
            int bdiff = xpm.color.getBlue() - curr.color.getBlue();
            if (Math.abs(rdiff) > min || Math.abs(gdiff) > min || Math.abs(bdiff) > min) continue;
            rtotal += curr.color.getRed();
            gtotal += curr.color.getGreen();
            btotal += curr.color.getBlue();
            ++count;
            xpm.addToCullTable(curr.key);
            xpm.addToCullTable(curr.getCullTable());
            curr.markToBeCulled(true);
        }
        if (count > 0) {
            int r = rtotal / count;
            int g = gtotal / count;
            int b = btotal / count;
            xpm.color = new Color(r, g, b);
        }
    }

    public void __uniquify(int sortMode) {
        int n;
        if (sortMode == NO_SORT) {
            return;
        }
        Hashtable<Color, String> lut = this.getLUT_ByRGB();
        XPMColor[] raw_xpm = XPMColor.rgbTableToXPMColorArray(lut);
        XPMColor[] sorted = sortMode == RGB_SORT ? XPMSwatch.sortByRGB(raw_xpm) : this.sortByHex(raw_xpm);
        int preCull = sorted.length;
        Cutter.setLog("uniquify preCull " + preCull);
        sorted = XPMSwatch.cullBySimilarity(sorted, 2);
        int postCull = sorted.length;
        Cutter.setLog("uniquify postCull " + postCull);
        XPMTile[] canvasTiles = this.database.canvas.getTiles1D();
        int numCanvasUpdates = 0;
        if (preCull != postCull) {
            for (n = 0; n < sorted.length; ++n) {
                XPMColor xpm = sorted[n];
                if (xpm.cullTableSize() == 0) continue;
                Hashtable culledKeys = xpm.getCullTable();
                for (int m = 0; m < canvasTiles.length; ++m) {
                    XPMTile canvasTile = canvasTiles[m];
                    if (!culledKeys.containsKey(canvasTile.getTileKey())) continue;
                    canvasTile.setTileKey(xpm.key);
                    canvasTile.setTileColor(xpm.color);
                    ++numCanvasUpdates;
                }
            }
            Cutter.setLog("numCanvasUpdates " + numCanvasUpdates);
        }
        for (n = 0; n < this.tiles1D.length; ++n) {
            this.tiles1D[n].setEmpty(true);
        }
        Hashtable<Color, XPMColor> rgbSwatchTable = new Hashtable<Color, XPMColor>();
        int index = 0;
        int lastIndex = sorted.length - 1;
        for (int y = 0; y < this.tiles[0].length; ++y) {
            for (int x = 0; x < this.tiles.length && index <= lastIndex; ++index, ++x) {
                Tile tile = this.tiles[x][y];
                tile.setEmpty(false);
                tile.setTileColor(sorted[index].color);
                tile.setTileKey(sorted[index].key);
                tile.setTileHex(sorted[index].hex);
                rgbSwatchTable.put(sorted[index].color, sorted[index]);
            }
        }
        this.repaint();
        Hashtable<String, Color> LUT = this.getLUT_ByKey();
        Enumeration<String> e = LUT.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Cutter.setLog(key);
        }
        Cutter.setLog("----------------------------------");
        Hashtable<String, Color> LuT = this.database.canvas.getTableOfColorsByKey();
        e = LuT.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Cutter.setLog(key);
        }
    }

    public XPMTile[] getEmptyTiles() {
        Vector<Tile> list = new Vector<Tile>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            if (!this.tiles1D[n].isEmpty()) continue;
            list.add(this.tiles1D[n]);
        }
        XPMTile[] out = new XPMTile[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (XPMTile)list.elementAt(n);
        }
        return out;
    }

    public XPMTile[] getUsedTiles() {
        Vector<Tile> list = new Vector<Tile>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            if (this.tiles1D[n].isEmpty()) continue;
            list.add(this.tiles1D[n]);
        }
        XPMTile[] out = new XPMTile[list.size()];
        for (int n = 0; n < list.size(); ++n) {
            out[n] = (XPMTile)list.elementAt(n);
        }
        return out;
    }

    public void markAllAsEmpty() {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            tile.setTileColor(null);
        }
        this.repaint();
        this.database.editor.setDirty(true);
    }

    public Vector<XPMColor> removeUnneededTiles(BufferedImage bi) {
        Vector<XPMColor> out = new Vector<XPMColor>();
        Vector<Color> biColors = new Vector<Color>();
        for (int x = 0; x < bi.getWidth(); ++x) {
            for (int y = 0; y < bi.getHeight(); ++y) {
                biColors.add(new Color(bi.getRGB(x, y)));
            }
        }
        int count = 0;
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty() || biColors.contains(tile.getTileColor())) continue;
            out.add(tile.getTileXPM());
            tile.setTileColor(null);
            ++count;
        }
        this.repaint();
        this.database.editor.setDirty(true);
        return out;
    }

    public boolean deleteTile(XPMTile tile) {
        if (tile.getTileColor() == Color.black || tile.getTileColor() == Color.white) {
            return false;
        }
        if (this.numNonEmptyTiles() <= 2) {
            return false;
        }
        if (tile.isEmpty()) {
            return false;
        }
        String key = tile.getTileKey();
        String substKey = this.database.foreback.rearTile.getTileKey();
        Color substColor = this.database.foreback.rearTile.getTileColor();
        if (substKey.equals(key)) {
            XPMIconTool.showError("Cannot Delete Color", "Deleting a color from the swatch will clear the\nmatching pixels in the icon to the background\ncolor. However, the background color MUST be\ndifferent to the color being deleted.", "Choose a different background color and try again.");
            return false;
        }
        XPMTile[] canvasTiles = XPMTile.getTiles(this.database.canvas, key);
        for (int n = 0; n < canvasTiles.length; ++n) {
            canvasTiles[n].setTileKey(substKey);
            canvasTiles[n].setTileColor(substColor);
        }
        tile.setTileColor(null);
        tile.setTileKey(null);
        return true;
    }

    private void initTiles1D() {
        int width = this.tiles.length;
        int height = this.tiles[0].length;
        int n = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                this.tiles1D[n++] = this.tiles[x][y];
            }
        }
    }

    public XPMTile[] getTilesWithKey(String[] keys) {
        Vector<Tile> tmp = new Vector<Tile>();
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            for (int j = 0; j < keys.length; ++j) {
                if (!tile.getTileKey().equals(keys[j])) continue;
                tmp.addElement(tile);
            }
        }
        XPMTile[] out = new XPMTile[tmp.size()];
        for (int n = 0; n < tmp.size(); ++n) {
            out[n] = (XPMTile)tmp.elementAt(n);
        }
        return out;
    }

    public void findNearestColorByRGB(Pixel pixel) {
        Tile nearestTile = this.tiles1D[0];
        double min = 100000.0;
        for (int n = 1; n < this.tiles1D.length; ++n) {
            int deltaB;
            int deltaG;
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            Color tc = tile.getTileColor();
            int deltaR = pixel.c.getRed() - tc.getRed();
            double dist = Math.sqrt(deltaR * deltaR + (deltaG = pixel.c.getGreen() - tc.getBlue()) * deltaG + (deltaB = pixel.c.getBlue() - tc.getBlue()) * deltaB);
            if (!(dist < min)) continue;
            nearestTile = tile;
            min = dist;
        }
        pixel.c = nearestTile.getTileColor();
        pixel.k = nearestTile.getTileKey();
        pixel.dist = min;
        pixel.tile = nearestTile;
    }

    public void findNearestColorByHSV(Pixel pixel) {
        Tile nearestTile = this.tiles1D[0];
        double min = 100000.0;
        float[] hsvTile = new float[3];
        float[] hsvPixel = new float[3];
        for (int n = 1; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            Color tc = tile.getTileColor();
            Color.RGBtoHSB(tc.getRed(), tc.getGreen(), tc.getBlue(), hsvTile);
            Color.RGBtoHSB(pixel.c.getRed(), pixel.c.getGreen(), pixel.c.getBlue(), hsvPixel);
            float deltaH = hsvPixel[0] - hsvTile[0];
            float deltaS = hsvPixel[1] - hsvTile[1];
            float deltaV = hsvPixel[2] - hsvTile[2];
            double dist = Math.sqrt(deltaH * deltaH + deltaS * deltaS + deltaV * deltaV);
            if (!(dist < min)) continue;
            nearestTile = tile;
            min = dist;
        }
        Color original = pixel.c;
        pixel.c = nearestTile.getTileColor();
        pixel.k = nearestTile.getTileKey();
        pixel.dist = min;
        pixel.tile = nearestTile;
    }

    private void addTiles(JPanel container) {
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                if (x == 15) {
                    container.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 1.0, 0.0, 0, 0, 18, 0, this.insets));
                    continue;
                }
                if (x == 15 && y == 15) {
                    container.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 1.0, 1.0, 0, 0, 18, 0, this.insets));
                    continue;
                }
                container.add((Component)this.tiles[x][y], new GBC(x, y, 1, 1, 0.0, 0.0, 0, 0, 18, 0, this.insets));
            }
        }
        int totalWidth = this.tileSize + 2;
        int totalHeight = this.tileSize + 2;
    }

    public void backup() {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            tile.backup();
        }
    }

    public void restore() {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            tile.restore();
        }
    }

    public void editHSV(float hdelta, float sdelta, float vdelta, XPMTile[] targets) {
        float[] hsv = new float[3];
        if (targets == null) {
            targets = this.tiles1D;
        }
        for (int n = 0; n < targets.length; ++n) {
            XPMTile tile = targets[n];
            if (tile.isEmpty()) continue;
            Color c = tile.getPreEditColor();
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsv);
            hsv[0] = hsv[0] + hdelta;
            hsv[1] = hsv[1] + sdelta;
            hsv[2] = hsv[2] + vdelta;
            hsv[0] = hsv[0] > 1.0f ? hsv[0] - 1.0f : hsv[0];
            hsv[0] = hsv[0] < 0.0f ? Math.abs(hsv[0]) : hsv[0];
            hsv[1] = hsv[1] > 1.0f ? 1.0f : hsv[1];
            hsv[1] = hsv[1] < 0.0f ? 0.0f : hsv[1];
            hsv[2] = hsv[2] > 1.0f ? 1.0f : hsv[2];
            hsv[2] = hsv[2] < 0.0f ? 0.0f : hsv[2];
            int index = Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]);
            tile.setTileColor(Color.getHSBColor(hsv[0], hsv[1], hsv[2]));
        }
    }

    public void editBegin() {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            tile.editBegin();
        }
    }

    public void editEnd() {
        for (int n = 0; n < this.tiles1D.length; ++n) {
            Tile tile = this.tiles1D[n];
            if (tile.isEmpty()) continue;
            tile.editApply();
        }
    }

    public void sortByHex() {
        this.updateHexValues();
        Hashtable<String, XPMColor> hexTable = this.getLUT_ByHex();
        XPMColor[] list = XPMColor.hexTableToXPMColorArray(hexTable);
        list = this.sortByHex(list);
        this.database.swatch.markAllAsEmpty();
        this.database.swatch.add(list);
    }

    public void sortByRGB() {
        Hashtable<Color, String> rgbTable = this.getLUT_ByRGB();
        XPMColor[] list = XPMColor.rgbTableToXPMColorArray(rgbTable);
        list = XPMSwatch.sortByRGB(list);
        this.database.swatch.markAllAsEmpty();
        this.database.swatch.add(list);
    }

    public static XPMColor[] sortByRGB(XPMColor[] input) {
        int n;
        int n2;
        int n3;
        XPMColor item;
        int n4;
        Vector<XPMColor> reds = new Vector<XPMColor>();
        Vector<XPMColor> greens = new Vector<XPMColor>();
        Vector<XPMColor> blues = new Vector<XPMColor>();
        for (int n5 = 0; n5 < input.length; ++n5) {
            XPMColor item2 = input[n5];
            int r = item2.color.getRed();
            int g = item2.color.getGreen();
            int b = item2.color.getBlue();
            if (r >= g && r >= b) {
                reds.addElement(item2);
                continue;
            }
            if (g >= r && g >= b) {
                greens.addElement(item2);
                continue;
            }
            blues.addElement(item2);
        }
        Hashtable<String, XPMColor> rtable = new Hashtable<String, XPMColor>();
        Hashtable<String, XPMColor> gtable = new Hashtable<String, XPMColor>();
        Hashtable<String, XPMColor> btable = new Hashtable<String, XPMColor>();
        String[] rHex = new String[reds.size()];
        String[] gHex = new String[greens.size()];
        String[] bHex = new String[blues.size()];
        for (n4 = 0; n4 < reds.size(); ++n4) {
            item = (XPMColor)reds.elementAt(n4);
            rtable.put(item.hex, item);
            rHex[n4] = item.hex;
        }
        for (n4 = 0; n4 < greens.size(); ++n4) {
            item = (XPMColor)greens.elementAt(n4);
            gtable.put(item.hex, item);
            gHex[n4] = item.hex;
        }
        for (n4 = 0; n4 < blues.size(); ++n4) {
            item = (XPMColor)blues.elementAt(n4);
            btable.put(item.hex, item);
            bHex[n4] = item.hex;
        }
        rHex = TextUtils.sortByAlpha(rHex);
        gHex = TextUtils.sortByAlpha(gHex);
        bHex = TextUtils.sortByAlpha(bHex);
        Vector<XPMColor> redSorted = new Vector<XPMColor>();
        Vector<XPMColor> greenSorted = new Vector<XPMColor>();
        Vector<XPMColor> blueSorted = new Vector<XPMColor>();
        for (n3 = 0; n3 < rHex.length; ++n3) {
            redSorted.addElement((XPMColor)rtable.get(rHex[n3]));
        }
        for (n3 = 0; n3 < gHex.length; ++n3) {
            greenSorted.addElement((XPMColor)gtable.get(gHex[n3]));
        }
        for (n3 = 0; n3 < bHex.length; ++n3) {
            blueSorted.addElement((XPMColor)btable.get(bHex[n3]));
        }
        Hashtable<String, XPMColor> bluesSatTable = new Hashtable<String, XPMColor>();
        String[] bluesSatKeys = new String[blueSorted.size()];
        for (n2 = 0; n2 < blueSorted.size(); ++n2) {
            XPMColor item3 = (XPMColor)blueSorted.elementAt(n2);
            float[] hsv = new float[3];
            Color.RGBtoHSB(item3.color.getRed(), item3.color.getGreen(), item3.color.getBlue(), hsv);
            bluesSatKeys[n2] = "" + hsv[1] + hsv[0] + hsv[2];
            bluesSatTable.put(bluesSatKeys[n2], item3);
        }
        bluesSatKeys = TextUtils.sortByAlpha(bluesSatKeys);
        blueSorted = new Vector();
        for (n2 = 0; n2 < bluesSatKeys.length; ++n2) {
            blueSorted.addElement((XPMColor)bluesSatTable.get(bluesSatKeys[n2]));
        }
        XPMColor[] out = new XPMColor[input.length];
        int count = 0;
        for (n = 0; n < blueSorted.size(); ++n) {
            out[count++] = (XPMColor)blueSorted.elementAt(n);
        }
        for (n = 0; n < greenSorted.size(); ++n) {
            out[count++] = (XPMColor)greenSorted.elementAt(n);
        }
        for (n = 0; n < redSorted.size(); ++n) {
            out[count++] = (XPMColor)redSorted.elementAt(n);
        }
        return out;
    }

    private XPMColor[] sortByHex(XPMColor[] input) {
        if (input == null || input.length <= 0) {
            return null;
        }
        Hashtable<String, XPMColor> unsortedXPMColors = new Hashtable<String, XPMColor>();
        Vector<String> unsortedHexList = new Vector<String>();
        for (int n = 0; n < input.length; ++n) {
            if (input[n].key == null || input[n].color == null) continue;
            String swatch_key = input[n].key;
            Color swatch_color = input[n].color;
            String swatch_hex = input[n].hex;
            if (swatch_hex == null) {
                swatch_hex = XPMColor.colorToHex(swatch_color);
            }
            unsortedHexList.addElement(swatch_hex);
            unsortedXPMColors.put(swatch_hex, input[n]);
        }
        String[] hexArray = VectorUtils.toStringArray(unsortedHexList);
        hexArray = TextUtils.sortByAlpha(hexArray);
        Vector<XPMColor> sorted = new Vector<XPMColor>();
        for (int n = 0; n < hexArray.length; ++n) {
            XPMColor xpm = (XPMColor)unsortedXPMColors.get(hexArray[n]);
            if (xpm == null) continue;
            sorted.addElement(xpm);
        }
        XPMColor[] out = new XPMColor[sorted.size()];
        for (int n = 0; n < sorted.size(); ++n) {
            out[n] = (XPMColor)sorted.elementAt(n);
        }
        return out;
    }

    public class Tile
    extends XPMTile {
        BufferedImage buff;

        public Tile(Color floatColor, String swatchKey, int tileSize) {
            super(floatColor, swatchKey, tileSize);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            if (!this.isEmpty()) {
                Cutter.setLog("    Info:XPMSwatch key >" + this.getTileKey() + "< color " + this.getTileColor().toString());
            }
            ((XPMSwatch)XPMSwatch.this).database.editor.swatchClickHappened(e, this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            ((XPMSwatch)XPMSwatch.this).database.editor.mouseEnteredSwatch();
        }
    }
}

