/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.XPM;

import UI_Desktop.Cutter;
import UI_Tools.XPM.Components.DnD.XPMDropTarget;
import UI_Tools.XPM.Components.DnD.XPMTransferable;
import UI_Tools.XPM.XPMColor;
import UI_Tools.XPM.XPMDataBase;
import UI_Tools.XPM.XPMTileManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;

public class XPMTile
extends JComponent
implements MouseMotionListener,
MouseListener,
DragGestureListener {
    BufferedImage buff;
    Dimension dim;
    int tileSize;
    protected boolean isEmpty = false;
    boolean prevEmpty = false;
    protected boolean isSelected = false;
    protected boolean isDnDHilited = false;
    private XPMColor xpm = new XPMColor();
    private XPMColor preEditXpm = null;
    private XPMColor backupXpm = null;
    XPMDropTarget xpmDropTarget;
    private int x = -1;
    private int y = -1;

    public XPMTile(Color floatColor, String key, int tileSize) {
        this.xpm.key = key;
        this.tileSize = tileSize;
        this.buff = new BufferedImage(tileSize, tileSize, 1);
        if (floatColor == null || this.xpm.key == null) {
            this.isEmpty = true;
        } else {
            this.xpm.color = floatColor;
            for (int x = 0; x < tileSize; ++x) {
                for (int y = 0; y < tileSize; ++y) {
                    this.buff.setRGB(x, y, this.xpm.color.getRGB());
                }
            }
        }
        this.dim = new Dimension(tileSize, tileSize);
        this.setMinimumSize(this.dim);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.xpmDropTarget = new XPMDropTarget(this);
        DragSource dragSource = new DragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.setEnabled(true);
    }

    @Override
    public void setEnabled(boolean flag) {
        super.setEnabled(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isEmpty) {
            g2.setPaint(Color.gray);
            g2.draw(new Line2D.Double(0.0, 0.0, this.tileSize, this.tileSize));
            g2.draw(new Line2D.Double(this.tileSize, 0.0, 0.0, this.tileSize));
            Rectangle square = new Rectangle(0, 0, this.tileSize - 1, this.tileSize - 1);
            g2.draw(square);
        } else if (this.isSelected) {
            Rectangle square = new Rectangle(0, 0, this.tileSize - 1, this.tileSize - 1);
            Rectangle2D.Float sq = new Rectangle2D.Float(0.0f, 0.0f, (float)this.tileSize - 0.5f, (float)this.tileSize - 0.5f);
            Color c = this.getTileColor();
            float[] hsv = new float[3];
            Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsv);
            float hue = hsv[0] + 0.5f;
            if (hue > 1.0f) {
                hue -= 1.0f;
            }
            g2.setPaint(new Color(Color.HSBtoRGB(hue, 1.0f, 1.0f)));
            g2.setStroke(new BasicStroke(1.0f));
            g2.drawImage((Image)this.buff, 0, 0, null);
            g2.draw(sq);
        } else if (this.isDnDHilited) {
            Rectangle2D.Float square = new Rectangle2D.Float(0.0f, 0.0f, (float)this.tileSize - 1.0f, (float)this.tileSize - 1.0f);
            g2.setPaint(Color.red);
            g2.setStroke(new BasicStroke(0.5f));
            g2.drawImage((Image)this.buff, 0, 0, null);
            g2.draw(square);
        } else {
            g2.drawImage((Image)this.buff, 0, 0, null);
        }
    }

    public void setDnDHilited(boolean flag) {
        this.isDnDHilited = flag;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dim;
    }

    public String getTileKey() {
        return this.xpm.key;
    }

    public void setEmpty(boolean flag) {
        this.isEmpty = flag;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void editBegin() {
        this.preEditXpm = new XPMColor(this.xpm);
    }

    public void editUndo() {
        this.xpm = new XPMColor(this.preEditXpm);
        this.repaint();
    }

    public void editApply() {
        this.preEditXpm = null;
        this.repaint();
    }

    public Color getPreEditColor() {
        return this.preEditXpm.color;
    }

    public void backup() {
        this.backupXpm = new XPMColor(this.xpm);
    }

    public void restore() {
        this.xpm = new XPMColor(this.backupXpm);
        this.setTileColor(this.xpm.color);
    }

    public void setTileXY(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getTileX() {
        return this.x;
    }

    public int getTileY() {
        return this.y;
    }

    public Color getTileColor() {
        return this.xpm.color;
    }

    public String getTileAsHex() {
        return null;
    }

    public XPMColor getTileXPM() {
        return new XPMColor(this.xpm);
    }

    public void setTileXPM(XPMColor in) {
        this.xpm = new XPMColor(in);
        this.isEmpty = this.xpm.color == null;
    }

    public void setTileKey(String newkey) {
        this.xpm.key = newkey;
    }

    public void setTileHex(String s) {
        this.xpm.hex = s;
    }

    public void setTileColor(Color c) {
        if (c == null) {
            this.isEmpty = true;
        } else {
            this.xpm.color = c;
            for (int x = 0; x < this.tileSize; ++x) {
                for (int y = 0; y < this.tileSize; ++y) {
                    this.buff.setRGB(x, y, this.xpm.color.getRGB());
                }
            }
            this.isEmpty = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void dndDropHappened(XPMColor xpm) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        Cursor cursor = null;
        XPMTile tile = (XPMTile)event.getComponent();
        XPMColor xpm_color = tile.getTileXPM();
        if (event.getDragAction() == 1) {
            cursor = DragSource.DefaultCopyDrop;
        }
        event.startDrag(cursor, new XPMTransferable(xpm_color));
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        Cutter.setLog("dropActionChanged");
    }

    public static XPMTile getNonEmpty(XPMTileManager parent) {
        XPMTile[][] tiles = parent.getTiles();
        if (tiles == null) {
            return null;
        }
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int x = 0; x < numX; ++x) {
            for (int y = 0; y < numY; ++y) {
                if (tiles[x][y].isEmpty) continue;
                return tiles[x][y];
            }
        }
        return null;
    }

    public static void deSelect(XPMTileManager parent) {
        XPMTile[][] tiles = parent.getTiles();
        if (tiles == null) {
            return;
        }
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int x = 0; x < numX; ++x) {
            for (int y = 0; y < numY; ++y) {
                tiles[x][y].isSelected = false;
            }
        }
        if (parent instanceof JPanel) {
            ((JPanel)((Object)parent)).repaint();
        } else if (parent instanceof JLayeredPane) {
            ((JLayeredPane)((Object)parent)).repaint();
        }
    }

    public static void setColor(XPMTileManager parent, Color c, String key) {
        if (c == null || key == null || key.equals("")) {
            return;
        }
        XPMTile[] tiles = XPMTile.getTiles(parent, key);
        for (int n = 0; n < tiles.length; ++n) {
            tiles[n].setTileColor(c);
        }
        if (parent instanceof JPanel) {
            ((JPanel)((Object)parent)).repaint();
        } else if (parent instanceof JLayeredPane) {
            ((JLayeredPane)((Object)parent)).repaint();
        }
    }

    public static XPMTile[] getTiles(XPMTileManager parent, String key) {
        XPMTile[][] tiles = parent.getTiles();
        Vector<XPMTile> tmp = new Vector<XPMTile>();
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int x = 0; x < numX; ++x) {
            for (int y = 0; y < numY; ++y) {
                if (tiles[x][y] == null || tiles[x][y].xpm.key == null || !tiles[x][y].xpm.key.equals(key)) continue;
                tmp.addElement(tiles[x][y]);
            }
        }
        XPMTile[] out = new XPMTile[tmp.size()];
        for (int n = 0; n < tmp.size(); ++n) {
            out[n] = (XPMTile)tmp.elementAt(n);
        }
        return out;
    }

    public static XPMTile[] getSelected(XPMTileManager parent) {
        XPMTile[][] tiles = parent.getTiles();
        Vector<XPMTile> tmp = new Vector<XPMTile>();
        int numX = tiles.length;
        int numY = tiles[0].length;
        for (int x = 0; x < numX; ++x) {
            for (int y = 0; y < numY; ++y) {
                if (tiles[x][y] == null || tiles[x][y].xpm.key == null || !tiles[x][y].isSelected) continue;
                tmp.addElement(tiles[x][y]);
            }
        }
        XPMTile[] out = new XPMTile[tmp.size()];
        for (int n = 0; n < tmp.size(); ++n) {
            out[n] = (XPMTile)tmp.elementAt(n);
        }
        return out;
    }

    public static void setSelected(XPMTileManager parent, String key) {
        XPMTile[] tiles = XPMTile.getTiles(parent, key);
        for (int n = 0; n < tiles.length; ++n) {
            tiles[n].isSelected = true;
        }
        if (parent instanceof JPanel) {
            ((JPanel)((Object)parent)).repaint();
        } else if (parent instanceof JLayeredPane) {
            ((JLayeredPane)((Object)parent)).repaint();
        }
    }

    public void setSelected() {
        this.isSelected = true;
        this.repaint();
    }

    public void setDeSelected() {
        this.isSelected = false;
        this.repaint();
    }

    public static String generateKey(int keySize, Hashtable<Color, String> swatchLUT) {
        boolean found = false;
        int max = 10000;
        int n = 0;
        while (!found) {
            String newKey = keySize == 1 ? "" + XPMTile.rndChar() : "" + XPMTile.rndChar() + XPMTile.rndChar();
            if (!swatchLUT.contains(newKey)) {
                return newKey;
            }
            if (++n <= max) continue;
            return null;
        }
        return null;
    }

    public static String generateKey(XPMDataBase database) {
        Hashtable table = database.colors;
        int keySize = database.charsPerPixel;
        boolean found = false;
        int max = 10000;
        int n = 0;
        while (!found) {
            String newKey = keySize == 1 ? "" + XPMTile.rndChar() : "" + XPMTile.rndChar() + XPMTile.rndChar();
            if (!table.contains(newKey)) {
                return newKey;
            }
            if (++n <= max) continue;
            return null;
        }
        return null;
    }

    private static char rndChar() {
        int rnd = (int)(Math.random() * 52.0);
        int base = rnd < 26 ? 65 : 97;
        return (char)(base + rnd % 26);
    }
}

