/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import UI_Desktop.Cutter;
import UI_Tools.Zipper.ZipReport;
import Utilities.FileUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Vector;

public class FileQuery {
    public static boolean _trim = false;
    private Vector<String> listOfPaths = new Vector();
    private String[] rawPaths = null;
    private File root;
    public static final char WACKY_ICON_CHAR = '\r';
    public static final String WACKY_ICON_NAME = "Icon\r";

    public FileQuery(File dir) {
        this.root = dir;
    }

    public String[] getAllPaths() {
        this.listOfPaths.removeAllElements();
        this.getStructureOf(this.root);
        this.rawPaths = this.vectorToArray(this.listOfPaths);
        return this.rawPaths;
    }

    private String[] vectorToArray(Vector v) {
        String[] out = new String[v.size()];
        for (int n = 0; n < v.size(); ++n) {
            out[n] = (String)v.elementAt(n);
        }
        return out;
    }

    private void getStructureOf(File dir) {
        this.listOfPaths.addElement(dir.getPath());
        if (dir.isFile()) {
            return;
        }
        String[] files = dir.list();
        if (files == null) {
            return;
        }
        for (int n = 0; n < files.length; ++n) {
            File f = new File(dir, files[n]);
            if (f == null || !f.isDirectory() && !f.isFile()) continue;
            this.getStructureOf(f);
        }
    }

    public long getTotalSize() {
        String[] paths = this.getAllPaths();
        long total = 0L;
        for (int n = 0; n < paths.length; ++n) {
            File f = new File(paths[n]);
            if (!f.exists()) continue;
            total += f.length();
        }
        return total;
    }

    public String[] trim(String[] rawpaths, File baseDir, String[] filters, int size, ZipReport report) {
        return this.trim(rawpaths, baseDir, null, filters, size, report);
    }

    public String[] trim(String[] rawpaths, File baseDir, String[] folders, String[] filters, int size, ZipReport report) {
        int n;
        int baselength;
        String p = baseDir.getPath();
        int n2 = baselength = p.endsWith(File.separator) ? p.length() : p.length() + 1;
        if (_trim) {
            Cutter.setLog("FileQuery.trim() - baseDir >" + baseDir.getPath() + "<");
            Cutter.setLog("FileQuery.trim() - baselength = " + baselength);
            Cutter.setLog("FileQuery.trim() - File.separator = " + File.separator);
        }
        Vector<String> vector = new Vector<String>();
        Vector<String> listOfAccepted = new Vector<String>();
        int rejected = 0;
        boolean doReject = false;
        for (n = 0; n < rawpaths.length; ++n) {
            String path = rawpaths[n];
            File file = new File(path);
            if (file.isDirectory() && folders != null) {
                for (int i = 0; i < folders.length; ++i) {
                    if (file.getName().equalsIgnoreCase(folders[i])) {
                        if (report != null) {
                            report.append("Rejected [directory]: " + path.substring(baselength));
                        }
                        ++rejected;
                        continue;
                    }
                    listOfAccepted.addElement("Accepted: " + path.substring(baselength));
                    vector.addElement(path.substring(baselength));
                }
                continue;
            }
            String name = file.getName();
            doReject = false;
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    if (!name.toLowerCase().endsWith(filters[i].toLowerCase())) continue;
                    if (report != null) {
                        report.append("Rejected [" + filters[i] + "]: " + path.substring(baselength));
                    }
                    ++rejected;
                    doReject = true;
                }
            }
            if (folders != null) {
                File temp = new File(path.substring(baselength));
                boolean found = false;
                for (int i = 0; i < folders.length; ++i) {
                    if (!FileUtils.isaSubDirOf(temp, folders[i], false)) continue;
                    if (report != null) {
                        report.append("Rejected [directory]: " + path.substring(baselength));
                    }
                    ++rejected;
                    found = true;
                }
                if (found) continue;
            }
            if (folders != null && file.getParentFile().getName().equals(folders)) {
                if (report != null) {
                    report.append("Rejected [directory2]: " + path.substring(baselength));
                }
                ++rejected;
                continue;
            }
            if (size > 0 && file.length() > (long)size) {
                if (report != null) {
                    report.append("Rejected [" + file.length() / 1024L + " > " + size / 1024 + " Kb]: " + path.substring(baselength));
                }
                ++rejected;
                continue;
            }
            if (name.trim().length() == 0 || name.charAt(0) == '.') {
                if (report != null) {
                    report.append("Rejected [hidden]: " + path.substring(baselength));
                }
                ++rejected;
                continue;
            }
            if (name.equals(WACKY_ICON_NAME)) {
                if (report != null) {
                    report.append("Rejected [Icon]: " + path.substring(baselength));
                }
                ++rejected;
                continue;
            }
            if (doReject) continue;
            listOfAccepted.addElement("Accepted: " + path.substring(baselength));
            vector.addElement(path.substring(baselength));
        }
        if (report != null) {
            report.append("");
            for (n = 0; n < listOfAccepted.size(); ++n) {
                String item = (String)listOfAccepted.elementAt(n);
                report.append(item);
            }
            report.append("");
            report.append(vector.size() + " ACCEPTABLE items.");
            report.append(rejected + " REJECTED items.");
        }
        return this.vectorToArray(vector);
    }

    public void delete() {
        this.getAllPaths();
        if (this.rawPaths == null) {
            return;
        }
        for (int n = this.rawPaths.length - 1; n >= 0; --n) {
            File f = new File(this.rawPaths[n]);
            f.delete();
        }
    }

    static {
        try {
            Field[] fields = new Field[]{FileQuery.class.getDeclaredField("_trim")};
            Cutter.addDebug(FileQuery.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: FileQuery.static - " + ex.toString());
        }
    }
}

