/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KProgressPanel;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Zipper.ZipInput;
import UI_Tools.Zipper.ZipReport;
import Utilities.KFileFilter;
import Utilities.RibInZipUtils;
import Utilities.ZipUtils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UnzipTabPanel
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    private static final String panelName = "UnZip";
    public DirPanel dirPanel = new DirPanel(" Source Zip ", "UnzipPanel.DirectoryPanel.info");
    private JButton unzipButton = new JButton("UnZip");
    private KProgressPanel progress = new KProgressPanel(" Progress ");
    private JButton catalogButton = new JButton("View Catalog");

    public UnzipTabPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dirPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.progress, new GBC(0, 1, 4, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.catalogButton, new GBC(1, 2, 1, 1, 0.0, 1.0, 1, 1, 17, 0, new Insets(5, 5, 5, 8)));
        this.add((Component)this.unzipButton, new GBC(3, 2, 1, 1, 1.0, 1.0, 1, 1, 13, 0, new Insets(5, 5, 5, 8)));
        this.catalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UnzipTabPanel.this.dirPanel.getPath().trim().length() == 0) {
                    return;
                }
                File zipfile = new File(UnzipTabPanel.this.dirPanel.getPath());
                ZipReport report = new ZipReport(new File(zipfile.getParent(), zipfile.getName() + ".txt"), null, null);
                String[] zipentries = ZipUtils.getAllZipEntries(zipfile);
                if (zipentries == null) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The zip file you wish to view the catelog of,\n" + UnzipTabPanel.this.dirPanel.getPath() + "\n\ndoes not exist!", "Non - Existent Zipfile", 0);
                    return;
                }
                for (int n = 0; n < zipentries.length; ++n) {
                    report.append(zipentries[n]);
                }
                report.append(zipentries.length + " items");
                report.displayInWindow();
            }
        });
        this.unzipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String topDir;
                ZipInput zipinput;
                File zipfile = new File(UnzipTabPanel.this.dirPanel.getPath());
                if (UnzipTabPanel.this.dirPanel.getPath().trim().length() == 0) {
                    return;
                }
                if (!zipfile.exists()) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The path to the zip file you wish to un-zip,\n" + UnzipTabPanel.this.dirPanel.getPath() + "\n\ndoes not exist!", "Non - Existent Zipfile", 0);
                    return;
                }
                ZipReport report = new ZipReport(new File(zipfile.getParent(), zipfile.getName() + ".txt"), null, null);
                try {
                    zipinput = new ZipInput(zipfile, UnzipTabPanel.this.progress, report);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The zip file,\n" + UnzipTabPanel.this.dirPanel.getPath() + "\n\n does not contain any entries!", "Empty Zip File", 0);
                    Cutter.setLog("    Exception: UnzipPanel.actionPerformed\n" + ex.toString());
                    return;
                }
                try {
                    topDir = zipinput.getRootDirPath();
                    Cutter.setLog("UnzipPanel topDir \"" + topDir + "\"");
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The path to the zip file you wish to un-zip,\n" + UnzipTabPanel.this.dirPanel.getPath() + "\n\ndoes not exist!", "Non - Existent Zipfile 3", 0);
                    return;
                }
                File dir = new File(zipfile.getParent(), topDir);
                int n = 0;
                while (dir.exists()) {
                    dir = new File(zipfile.getParent(), topDir + "." + ++n);
                }
                Cutter.setLog("zipfile.getParent() >" + zipfile.getParent() + "<");
                if (!RibInZipUtils.isPixarRibInZip(zipfile)) {
                    Cutter.setLog("unzipButton.addActionListener making >" + dir.getPath() + "<");
                    if (!dir.mkdir()) {
                        Cutter.setLog("unzipButton.addActionListener making >" + dir.getPath() + "<");
                        return;
                    }
                }
                zipinput.restore(dir.getPath());
                zipinput.start();
            }
        });
        this.defaultFocusedField = this.dirPanel.field;
    }

    private void updateUnZipButton() {
    }

    @Override
    public void writeToPrefs() {
        this.dirPanel.saveSelf();
    }

    @Override
    public void readFromPrefs() {
    }

    @Override
    public String getName() {
        return panelName;
    }

    public class DirPanel
    extends KTitledPanel {
        private static final long serialVersionUID = 1L;
        private JButton button;
        public KSerialTextField field;
        private boolean pathChecking;
        private Checker checker;
        private File prevDir;

        public DirPanel(String title, String info) {
            super(title, info);
            this.button = new JButton("Browse...");
            this.field = null;
            this.pathChecking = true;
            this.checker = new Checker();
            this.prevDir = Cutter.getParentDir();
            String postfix = title.trim().replaceAll(" ", "");
            this.field = new KSerialTextField("UnzipTabPanel" + postfix, "", 20);
            this.add(this.field, new GBC(0, 0, 4, 1, 1.0, 0.0, 1, 1, 12, 0, new Insets(5, 5, 5, 5)));
            this.add(this.button, new GBC(3, 1, 1, 1, 1.0, 1.0, 1, 1, 14, 0, new Insets(0, 5, 5, 5)));
            this.field.getDocument().addDocumentListener(this.checker);
            this.field.usesModelDialog = true;
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenFileDialog chooser = OpenFileDialog.getInstance(Cutter.desktop);
                    File[] files = chooser.showSelf(new KFileFilter("zip", "Zip File"), "Select a Zip File", 2);
                    if (files != null && files.length > 0) {
                        DirPanel.this.field.setText(files[0].getPath());
                        UnzipTabPanel.this.updateUnZipButton();
                    }
                }
            });
        }

        public void check() {
            UnzipTabPanel.this.updateUnZipButton();
        }

        @Override
        public void setEnabled(boolean flag) {
            this.button.setEnabled(flag);
            this.field.setEnabled(flag);
        }

        public String getPath() {
            return this.field.getText().trim();
        }

        public void setPath(String p) {
            this.field.setText(p);
        }

        public void saveSelf() {
            this.field.saveSelf();
        }

        private class Checker
        implements DocumentListener {
            @Override
            public void changedUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }
        }
    }
}

