/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import UI_Components.KProgressPanel;
import UI_Desktop.Cutter;
import UI_Tools.Zipper.ZipReport;
import Utilities.FileUtils;
import Utilities.RibInZipUtils;
import Utilities.TextUtils;
import Utilities.ZipUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipInput
extends Thread {
    private File zipfile;
    private byte[] buff = new byte[1024];
    private String head;
    private KProgressPanel progress = null;
    private int numEntries = 0;
    private ZipReport report;

    public ZipInput(File zipfile, KProgressPanel progress, ZipReport report) throws Exception {
        this.zipfile = zipfile;
        this.progress = progress;
        this.report = report;
        String[] entries = ZipUtils.getAllZipEntries(zipfile);
        if (entries == null) {
            throw new Exception("ZipInput constructor null zip entries for \"" + zipfile.getPath() + "\"");
        }
        this.numEntries = entries.length;
        if (progress != null) {
            progress.initBar(this.numEntries);
        }
        if (report != null) {
            report.append("RESTORED " + entries.length + " items\n");
            for (int n = 0; n < entries.length; ++n) {
                report.append(entries[n]);
            }
        }
    }

    public String getRootDirPath() throws Exception {
        ZipEntry zipentry = ZipUtils.getFirstZipEntry(this.zipfile);
        if (zipentry != null && zipentry.isDirectory()) {
            Cutter.setLog("getRootDirPath is " + zipentry.getName() + " is a directory");
            String name = zipentry.getName();
            return FileUtils.removeTrailingSeparator(name, '/', '\\');
        }
        Cutter.setLog("getRootDirPath is " + zipentry.getName() + " is NOT a directory");
        String name = this.zipfile.getName();
        return TextUtils.removeExtension(name);
    }

    public void restore(String head) {
        this.head = head;
    }

    @Override
    public void run() {
        this.unZipFile(false);
    }

    public File unZipFile(boolean quiet) {
        if (!this.zipfile.exists()) {
            Cutter.setLog("ZipInput.run() doesn't exist: " + this.zipfile.getPath());
            return null;
        }
        boolean isPixarZip = RibInZipUtils.isPixarRibInZip(this.zipfile);
        String unzipLocation = "\nTo \"" + this.head + "\"";
        if (this.report != null) {
            this.report.append(unzipLocation);
        }
        try {
            File headFile;
            FileInputStream stream = new FileInputStream(this.zipfile);
            ZipInputStream in = new ZipInputStream(stream);
            if (isPixarZip) {
                File tmp = new File(this.head);
                this.head = tmp.getParent();
            }
            if (!(headFile = new File(this.head)).exists() && !isPixarZip) {
                headFile.mkdir();
            }
            int n = 0;
            while (true) {
                File parentFile;
                ZipEntry zipentry;
                if (this.progress != null) {
                    this.progress.updateBar(n++);
                }
                if ((zipentry = in.getNextEntry()) == null) break;
                String tail = zipentry.getName();
                String newtail = FileUtils.getPathFromRoot(tail);
                if (newtail == null) {
                    newtail = tail;
                }
                if (isPixarZip) {
                    File tmp = new File(newtail);
                    if (tail.startsWith("renderman")) {
                        newtail = tmp.getName();
                    } else {
                        in.closeEntry();
                        continue;
                    }
                }
                if (zipentry.isDirectory()) {
                    FileUtils.makeDirectories(new File(this.head, newtail));
                    in.closeEntry();
                    continue;
                }
                File f = new File(this.head, newtail);
                if (f != null && (parentFile = f.getParentFile()) != null && !parentFile.exists()) {
                    FileUtils.makeDirectories(parentFile);
                }
                ZipUtils.saveZipEntryToFile(in, new File(this.head), new File(newtail));
                in.closeEntry();
                if (this.progress == null) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            in.close();
            stream.close();
        }
        catch (Exception e) {
            Cutter.setLog("    Exception:ZipInput.run() " + e.toString());
            return null;
        }
        if (this.progress != null) {
            this.progress.setMax();
        }
        if (this.report != null) {
            this.report.displayInWindow(this.progress);
        }
        return this.zipfile;
    }
}

