/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import UI_Components.KProgressPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Tools.Zipper.ZipReport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;

public class ZipOutput
extends Thread {
    public static boolean _run = false;
    private File zipfile;
    private byte[] buff = new byte[1024];
    private KProgressPanel progress = null;
    private String relativePath;
    private File inputFile;
    private File baseDir;
    private String[] relativePaths;
    private ZipReport report;

    public ZipOutput(File targetDir, String[] paths, KProgressPanel progress, ZipReport report) {
        this(targetDir, null, paths, progress, report);
    }

    public ZipOutput(File targetDir, File outZip, String[] paths, KProgressPanel progress, ZipReport report) {
        this.zipfile = outZip == null ? new File(targetDir.getPath() + ".zip") : outZip;
        this.progress = progress;
        this.baseDir = targetDir.getParentFile();
        if (Cutter.input.debug) {
            Cutter.setLog("ZipOutput.ZipOutput() input paths");
            Cutter.setLog(paths);
            Cutter.setLog("--------------------");
        }
        this.relativePaths = paths;
        this.report = report;
        if (progress != null) {
            progress.initBar(0);
        }
    }

    @Override
    public void run() {
        FileOutputStream filestream;
        try {
            filestream = new FileOutputStream(this.zipfile);
        }
        catch (Exception e) {
            Cutter.setLog("    Exception: ZipOutput.run()\n\t" + e.toString());
            return;
        }
        this.writeZipDataTo(filestream, false);
    }

    public void writeZipDataTo(OutputStream outstream, boolean quiet) {
        long totalSize = 0L;
        try {
            ZipOutputStream zipstream = new ZipOutputStream(outstream);
            if (this.progress != null) {
                this.progress.initBar(this.relativePaths.length > 0 ? this.relativePaths.length - 1 : 0);
            }
            for (int i = 0; i < this.relativePaths.length; ++i) {
                int numBytes;
                String name;
                File entry;
                if (this.progress != null) {
                    this.progress.updateBar(i + 1);
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.relativePath = this.relativePaths[i];
                if (_run) {
                    Cutter.setLog("ZipOutput.run() relativePath[" + i + "] = >" + this.relativePath + "<");
                }
                if ((entry = new File(this.relativePath)).isDirectory()) {
                    ZipEntry zipentry = new ZipEntry(!this.relativePath.endsWith("/") ? this.relativePath + "/" : this.relativePath);
                    zipstream.putNextEntry(zipentry);
                    zipstream.closeEntry();
                    continue;
                }
                this.inputFile = new File(this.baseDir, this.relativePath);
                if (this.inputFile.isDirectory() || (name = this.inputFile.getName()).trim().length() == 0 || name.charAt(0) == '.') continue;
                totalSize += this.inputFile.length();
                FileInputStream inputstream = new FileInputStream(this.inputFile);
                ZipEntry zipentry = new ZipEntry(this.relativePath);
                zipstream.putNextEntry(zipentry);
                while ((numBytes = inputstream.read(this.buff, 0, this.buff.length)) != -1) {
                    zipstream.write(this.buff, 0, numBytes);
                }
                zipstream.closeEntry();
                inputstream.close();
            }
            zipstream.close();
            outstream.close();
        }
        catch (IOException e) {
            this.zipfile.delete();
            Cutter.setLog("    Exception:ZipOutput.writeZipFile() base " + this.baseDir.getPath());
            Cutter.setLog("    Exception:ZipOut.run() base file " + this.relativePaths[0]);
            if (!quiet) {
                JOptionPane.showMessageDialog(KAbstractDesktop.desktopPane, "The directory \"" + this.zipfile.getName() + "\" cannot be found\nCheck the path and try again.\n\n", "Zip Output Error", 0);
            }
            Cutter.setLog("    Exception:ZipOutput.writeZipFile()\n" + e.toString());
            return;
        }
        if (this.report != null) {
            long out = this.getSize();
            this.report.append("ZIPPED " + this.relativePaths.length + " items\n");
            this.report.append("Input Folder Size:\t" + totalSize / 1024L + " Kb");
            this.report.append("Output Zip Size:\t" + out / 1024L + " Kb");
            this.report.append("Reduction in bytes:\t" + (totalSize - out) / 1024L + " Kb");
        }
        if (this.progress != null) {
            this.progress.updateBar(this.relativePaths.length);
        }
        if (this.report != null) {
            this.report.displayInWindow(this.progress);
        }
    }

    public long getSize() {
        return this.zipfile.exists() ? this.zipfile.length() : 0L;
    }

    public File duplicateTo(File destDir) {
        if (this.zipfile == null || !destDir.isDirectory()) {
            System.out.println("zipfile is null");
            return null;
        }
        File file = new File(destDir, this.zipfile.getName());
        try {
            int numBytes;
            FileInputStream inputstream = new FileInputStream(this.zipfile);
            FileOutputStream outputstream = new FileOutputStream(file);
            while ((numBytes = inputstream.read(this.buff, 0, this.buff.length)) != -1) {
                outputstream.write(this.buff, 0, numBytes);
            }
            inputstream.close();
            outputstream.close();
        }
        catch (IOException e) {
            System.out.println(e);
            return null;
        }
        return file;
    }

    static {
        try {
            Field[] fields = new Field[]{ZipOutput.class.getDeclaredField("_run")};
            Cutter.addDebug(ZipOutput.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ZipOutput.static - " + ex.toString());
        }
    }
}

