/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import UI_BBXT.BBxt;
import UI_Components.KProgressPanel;
import UI_Desktop.Cutter;
import UI_Desktop.Desktop.KAbstractDesktop;
import UI_Window.KWindow.KAbstractWindow;
import UI_Window.KWindow.KTextWindow;
import Utilities.DateTimeUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class ZipReport {
    private StringBuffer buff = new StringBuffer();
    private File outfile;

    public ZipReport(File outfile, String[] folders, String[] filters) {
        int n;
        StringBuffer buf;
        String name = outfile.getName();
        String[] dt = DateTimeUtils.getDateTime();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            name = name.substring(0, index);
        }
        this.append("============================================================");
        this.append("CATELOG OF:\t\t" + name);
        this.append("DATE:\t\t\t" + dt[0].trim() + dt[1]);
        this.append("GENERATED BY:\t\"Cutter\" Zipper Tool");
        this.append("EXCLUSION BY EXTENSION AND FOLDER:");
        if (filters != null && filters.length > 0) {
            buf = new StringBuffer("     ");
            for (n = 0; n < filters.length; ++n) {
                buf.append(filters[n]).append(" ");
            }
            this.append("   Files with the following extension(s) have been rejected");
            this.append(buf.toString());
        }
        if (folders != null && folders.length > 0) {
            buf = new StringBuffer("     ");
            for (n = 0; n < folders.length; ++n) {
                buf.append(folders[n]).append(", ");
            }
            this.append("   Files within the following folder(s) have been rejected");
            this.append(buf.toString());
        }
        this.append("============================================================\n");
        this.outfile = outfile;
    }

    public synchronized void append(String msg) {
        this.buff.append(msg + "\n");
    }

    public void print() {
        System.out.println(this.buff.toString());
    }

    public String getText() {
        return this.buff.toString();
    }

    public void save() {
        try {
            FileWriter fw = new FileWriter(this.outfile);
            fw.write(this.buff.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void displayInWindow() {
        this.displayInWindow(null);
    }

    public synchronized void displayInWindow(final KProgressPanel progress) {
        KAbstractWindow window = KAbstractDesktop.getWindowWithTitle("Report");
        if (window == null) {
            KTextWindow.addWindow("Report");
            window = KAbstractDesktop.getWindowWithTitle("Report");
            if (window == null) {
                return;
            }
        }
        window.lockTitle(true);
        KAbstractDesktop.toFront(window);
        BBxt.selectAll();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BBxt.paste(ZipReport.this.getText());
                    if (progress != null) {
                        progress.updateBar(0);
                    }
                }
            });
        }
        catch (Exception e) {
            Cutter.setLog("ZipReport.displayInWindow(): " + e.toString());
        }
    }
}

