/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import Preferences.Preferences;
import UI_Components.Dialog.OpenFileDialog;
import UI_Components.GBC;
import UI_Components.KLabelledField;
import UI_Components.KProgressPanel;
import UI_Components.KTextField.KLabelledNumberField;
import UI_Components.KTextField.KSerialTextField;
import UI_Components.KTitledPanel;
import UI_Desktop.Cutter;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Zipper.FileQuery;
import UI_Tools.Zipper.ZipOutput;
import UI_Tools.Zipper.ZipReport;
import Utilities.KFileFilter;
import Utilities.TextUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ZipTabPanel
extends PrefsPanel {
    private static final long serialVersionUID = 1L;
    public static boolean _zip_button = false;
    private static final String panelName = "Zip";
    public DirPanel dirPanel = new DirPanel(" Source Directory ", "ZipPanel.DirectoryPanel.info");
    private FileFilterPanel filterPanel = new FileFilterPanel(" Exclude ", "ZipPanel.FilterPanel.info");
    private JButton zipButton = new JButton("Zip");
    private JButton catalogButton = new JButton("View Catalog");
    private KProgressPanel progress = new KProgressPanel(" Progress ");

    public ZipTabPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.dirPanel, new GBC(0, 0, 4, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.filterPanel, new GBC(0, 1, 4, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.progress, new GBC(0, 2, 4, 1, 1.0, 0.0, 1, 1, 17, 2, new Insets(5, 5, 5, 5)));
        this.add((Component)this.catalogButton, new GBC(1, 3, 1, 1, 0.0, 1.0, 1, 1, 17, 0, new Insets(5, 7, 5, 8)));
        this.add((Component)this.zipButton, new GBC(3, 3, 1, 1, 1.0, 1.0, 1, 1, 13, 0, new Insets(5, 5, 5, 8)));
        this.catalogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ZipTabPanel.this.dirPanel.getPath().trim().length() == 0) {
                    return;
                }
                File targetDir = new File(ZipTabPanel.this.dirPanel.getPath());
                FileQuery querry = new FileQuery(targetDir);
                String[] rawPaths = querry.getAllPaths();
                String[] filters = ZipTabPanel.this.filterPanel.getFilters();
                String[] folders = ZipTabPanel.this.filterPanel.getFolders();
                float max = ZipTabPanel.this.filterPanel.getMaxFileSize();
                ZipReport report = new ZipReport(new File(targetDir.getParent(), targetDir.getName() + ".txt"), folders, filters);
                if (folders == null) {
                    folders = new String[]{"dummy"};
                }
                String[] trimmedPaths = querry.trim(rawPaths, targetDir.getParentFile(), folders, filters, (int)(max * 1024000.0f), report);
                report.displayInWindow();
            }
        });
        this.zipButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File targetDir = new File(ZipTabPanel.this.dirPanel.getPath());
                if (_zip_button) {
                    Cutter.setLog("ZipPanel.ZipPanel() - targetDir >" + targetDir.getPath() + "<");
                }
                if (ZipTabPanel.this.dirPanel.getPath().trim().length() == 0) {
                    return;
                }
                FileQuery querry = new FileQuery(targetDir);
                String[] rawPaths = querry.getAllPaths();
                if (Cutter.input.debug) {
                    Cutter.setLog("ZipPanel.zipButton() - rawPaths from FileQuerry_________");
                    Cutter.setLog(rawPaths);
                    Cutter.setLog("--------------------------\n");
                }
                String[] filters = ZipTabPanel.this.filterPanel.getFilters();
                String[] folders = ZipTabPanel.this.filterPanel.getFolders();
                float max = ZipTabPanel.this.filterPanel.getMaxFileSize();
                if (folders == null) {
                    folders = new String[]{"dummy"};
                }
                ZipReport report = new ZipReport(new File(targetDir.getParent(), targetDir.getName() + ".txt"), folders, filters);
                String[] trimmedPaths = querry.trim(rawPaths, targetDir.getParentFile(), folders, filters, (int)(max * 1024000.0f), report);
                if (Cutter.input.debug) {
                    Cutter.setLog("Zipping will trim these excluded file extensions:");
                    Cutter.setLog(filters);
                    Cutter.setLog("\nZipPanel.zipButton() - trimmedPaths from FileQuerry_________");
                    Cutter.setLog(trimmedPaths);
                    Cutter.setLog("--------------------------\n");
                }
                for (int n = 0; n < trimmedPaths.length; ++n) {
                    trimmedPaths[n] = trimmedPaths[n].replace('\\', '/');
                }
                ZipOutput zipout = new ZipOutput(targetDir, trimmedPaths, ZipTabPanel.this.progress, report);
                zipout.start();
            }
        });
        this.updateCatalogButton();
        this.defaultFocusedField = this.dirPanel.field;
    }

    private void updateCatalogButton() {
        if (this.dirPanel == null) {
            return;
        }
        String path = this.dirPanel.getPath();
        if (path == null || path.trim().length() == 0 || this.catalogButton == null) {
            return;
        }
        if (new File(path).exists()) {
            this.catalogButton.setEnabled(true);
        } else {
            this.catalogButton.setEnabled(false);
        }
    }

    private void updateZipButton() {
    }

    @Override
    public void writeToPrefs() {
        this.dirPanel.saveSelf();
        Preferences.write(Preferences.TOOL_ZIPPER_ZIP_MAX_FILE_SIZE, "" + this.filterPanel.getMaxFileSize());
        String filters = this.filterPanel.filters.field.getText();
        Preferences.write(Preferences.TOOL_ZIPPER_ZIP_EXT_FILTERS, filters);
        String folders = this.filterPanel.folders.field.getText();
        Preferences.write(Preferences.TOOL_ZIPPER_ZIP_FOLDERS_FILTER, folders);
    }

    @Override
    public void readFromPrefs() {
    }

    @Override
    public String getName() {
        return panelName;
    }

    static {
        try {
            Field[] fields = new Field[]{ZipTabPanel.class.getDeclaredField("_zip_button")};
            Cutter.addDebug(ZipTabPanel.class, fields);
        }
        catch (NoSuchFieldException ex) {
            Cutter.setLog("Error: ZipPanel.static - " + ex.toString());
        }
    }

    public class FileFilterPanel
    extends KTitledPanel {
        public KLabelledNumberField maxFileSize;
        public KLabelledField filters;
        public KLabelledField folders;
        public JLabel note1;
        public JLabel note2;
        public JLabel note3;

        public FileFilterPanel(String title, String info) {
            super(title, info);
            this.maxFileSize = new KLabelledNumberField("Files larger than", 4, "2.5");
            this.filters = new KLabelledField("Ext matching     ", 10, "");
            this.folders = new KLabelledField("Folders named ", 10, "");
            this.note1 = new JLabel("Separate the names of extensions with");
            this.note2 = new JLabel("a space. The names of folders should");
            this.note3 = new JLabel("separated with a comma.");
            this.filters.field.setText(Preferences.get(Preferences.TOOL_ZIPPER_ZIP_EXT_FILTERS));
            this.folders.field.setText(Preferences.get(Preferences.TOOL_ZIPPER_ZIP_FOLDERS_FILTER));
            this.maxFileSize.field.setText(Preferences.get(Preferences.TOOL_ZIPPER_ZIP_MAX_FILE_SIZE));
            this.filters.field.usesModelDialog = true;
            this.folders.field.usesModelDialog = true;
            this.add(this.maxFileSize, new GBC(0, 0, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 3, 2, 2)));
            this.add(this.filters, new GBC(0, 1, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 5, 2)));
            this.add(this.folders, new GBC(0, 2, 1, 1, 1.0, 0.0, 0, 0, 18, 0, new Insets(0, 5, 2, 2)));
            Font f = Cutter.defaultFont.font;
            Font plain = new Font(f.getName(), f.getStyle(), f.getSize());
            this.note1.setFont(plain);
            this.note2.setFont(plain);
            this.note3.setFont(plain);
            this.add(this.note1, new GBC(0, 3, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(2, 10, 2, 2)));
            this.add(this.note2, new GBC(0, 4, 1, 1, 1.0, 0.0, 0, 0, 18, 2, new Insets(2, 10, 2, 2)));
            this.add(this.note3, new GBC(0, 5, 1, 1, 1.0, 1.0, 0, 0, 18, 2, new Insets(2, 10, 2, 2)));
        }

        @Override
        public void setEnabled(boolean flag) {
            this.filters.label.setEnabled(flag);
            this.filters.field.setEnabled(flag);
            this.maxFileSize.setEnabled(flag);
        }

        public String[] getFilters() {
            return this.getFilters(this.filters.field.getText());
        }

        public String[] getFilters(String filterStr) {
            if (filterStr.trim().length() == 0) {
                return null;
            }
            StringTokenizer tok = new StringTokenizer(filterStr);
            Vector<String> v = new Vector<String>();
            while (tok.hasMoreTokens()) {
                v.addElement(tok.nextToken());
            }
            String[] out = new String[v.size()];
            for (int n = 0; n < v.size(); ++n) {
                out[n] = (String)v.elementAt(n);
            }
            return out;
        }

        public String[] getFolders() {
            return this.getFolders(this.folders.field.getText());
        }

        public String[] getFolders(String input) {
            String[] s = TextUtils.tokenize(input, ",", true);
            if (s != null && s.length > 0) {
                for (int n = 0; n < s.length; ++n) {
                    s[n] = s[n].trim();
                }
            }
            return s;
        }

        public float getMaxFileSize() {
            return this.getMaxFileSize(this.maxFileSize.field.getText());
        }

        public float getMaxFileSize(String input) {
            if (input == null || input.trim().length() == 0) {
                return 0.0f;
            }
            return Float.parseFloat(input);
        }
    }

    public class DirPanel
    extends KTitledPanel {
        private JButton button;
        public KSerialTextField field;
        private boolean pathChecking;
        private Checker checker;
        private File prevDir;

        public DirPanel(String title, String info) {
            super(title, info);
            this.button = new JButton("Browse...");
            this.field = null;
            this.pathChecking = true;
            this.checker = new Checker();
            this.prevDir = null;
            String postfix = title.trim().replaceAll(" ", "");
            this.field = new KSerialTextField("ZipTabPanel" + postfix, "", 20);
            this.add(this.field, new GBC(0, 0, 4, 1, 1.0, 0.0, 1, 1, 12, 0, new Insets(5, 5, 5, 5)));
            this.add(this.button, new GBC(3, 1, 1, 1, 1.0, 1.0, 1, 1, 14, 0, new Insets(0, 5, 5, 5)));
            this.field.getDocument().addDocumentListener(this.checker);
            this.field.usesModelDialog = true;
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OpenFileDialog chooser = OpenFileDialog.getInstance(Cutter.desktop);
                    chooser.setFileHidingEnabled(true);
                    File[] files = chooser.showSelf(new KFileFilter("zip", "Zip File"), "Select Directory", 1);
                    if (files != null && files.length > 0) {
                        DirPanel.this.field.setText(files[0].getPath());
                        ZipTabPanel.this.updateZipButton();
                        ZipTabPanel.this.updateCatalogButton();
                    }
                }
            });
        }

        public void check() {
            ZipTabPanel.this.updateZipButton();
            ZipTabPanel.this.updateCatalogButton();
        }

        @Override
        public void setEnabled(boolean flag) {
            this.button.setEnabled(flag);
            this.field.setEnabled(flag);
        }

        public String getPath() {
            return this.field.getText().trim();
        }

        public void setPath(String p) {
            this.field.setText(p);
        }

        public void saveSelf() {
            this.field.saveSelf();
        }

        private class Checker
        implements DocumentListener {
            @Override
            public void changedUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DirPanel.this.check();
            }
        }
    }
}

