/*
 * Decompiled with CFR 0.152.
 */
package UI_Tools.Zipper;

import Preferences.Preferences;
import UI_Components.GBC;
import UI_Components.KTabbedPane.KTabGroup;
import UI_Components.KTabbedPane.KTabbedPane;
import UI_Tools.KTools;
import UI_Tools.Preferences.PrefsPanels.PrefsPanel;
import UI_Tools.Zipper.UnzipTabPanel;
import UI_Tools.Zipper.ZipTabPanel;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class ZipperTool
extends KTools {
    public static final int MB = 1024000;
    public static final String[] DEFAULT_EXT_FILTERS = new String[]{".tif", ".tiff", ".psd", ".tx", ".tex"};
    public static KTabbedPane tabbedPane = new KTabbedPane();
    private static ZipperTool tool = null;
    public static final String UNKNOWNTAB = "unknown";
    public static final String ZIP_TAB = "Zip";
    public static final String UNZIP_TAB = "UnZip";
    private static ZipTabPanel zipTabPanel = null;
    private static UnzipTabPanel unzipTabPanel = null;
    private KTabGroup tabGroup;

    public static ZipperTool init(JMenuItem menuItem) {
        if (tool != null) {
            return tool;
        }
        tool = new ZipperTool(menuItem, null);
        return tool;
    }

    @Override
    public void showSelf() {
        super.showSelf();
        this.toolSelectionHappened();
    }

    private ZipperTool(JMenuItem menuItem, String helpDocPath) {
        super("Zipper Tool", menuItem, Preferences.TOOL_ZIPPER, helpDocPath);
        zipTabPanel = new ZipTabPanel();
        unzipTabPanel = new UnzipTabPanel();
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
            }
        });
        tabbedPane.addTab(ZIP_TAB, zipTabPanel);
        tabbedPane.addTab(UNZIP_TAB, unzipTabPanel);
        tabbedPane.setName("ZipperTool tabbedPane");
        this.tabGroup = new KTabGroup(this, tabbedPane);
        this.contentPane.add((Component)tabbedPane, new GBC(0, 0, 6, 1, 1.0, 1.0, 0, 0, 18, 0, new Insets(0, 0, 0, 0)));
        this.setTitle(this.TOOL_NAME);
        this.pack();
        this.setInitialPosition();
        this.setVisible(false);
    }

    @Override
    protected void toolSelectionHappened() {
        PrefsPanel pp = tabbedPane.getVisiblePrefsPanel();
        pp.focusDefaultField();
    }

    @Override
    protected void toolDeSelectionHappened(JTextComponent compLostFocus) {
        PrefsPanel pp = tabbedPane.getVisiblePrefsPanel();
        pp.defaultFocusedField = compLostFocus;
    }

    @Override
    protected void adjustUI(String docExt) {
    }

    @Override
    protected void adjustUI(int tabIndex) {
    }

    @Override
    protected void saveSelf() {
        zipTabPanel.writeToPrefs();
        unzipTabPanel.writeToPrefs();
        super.saveSelf();
    }

    @Override
    public JMenu getMenuWithName(String name) {
        return null;
    }
}

